/*
 * Decompiled with CFR 0.152.
 */
package LAB;

import LAB.Staff;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StaffControl {
    private Staff controlled;
    private Staff other;
    private ButtonGroup shapegroup = new ButtonGroup();
    private ButtonGroup positiongroup = new ButtonGroup();
    private JCheckBox angle1 = new JCheckBox("90");
    private JCheckBox angle22 = new JCheckBox("-45");
    private JCheckBox angle2 = new JCheckBox("45");
    private JCheckBox angle3 = new JCheckBox("0");
    private JCheckBox angle4 = new JCheckBox("Spin");
    JCheckBox circle = new JCheckBox("circle");
    JCheckBox square = new JCheckBox("square");
    JCheckBox vertline = new JCheckBox("line -");
    JCheckBox horizline = new JCheckBox("line !");
    JCheckBox hypocycloid = new JCheckBox("hypocycloid");
    JCheckBox quarters = new JCheckBox("quarters");
    JCheckBox stepped = new JCheckBox("stepped");
    JCheckBox translated = new JCheckBox("translated");
    JCheckBox figureeight = new JCheckBox("Figure of Eight");
    JCheckBox lissajous = new JCheckBox("Lissajous Curve");
    JCheckBox realhypo = new JCheckBox("Real Hypocycloid");
    JCheckBox clockwise = new JCheckBox("clockwise");
    JCheckBox counterclockwise = new JCheckBox("counterclockwise");
    JCheckBox handclockwise = new JCheckBox("clockwise");
    JCheckBox handcounterclockwise = new JCheckBox("counterclockwise");
    JSlider handSpeedSlide;
    JSlider staffSpeedSlide;
    JSlider circleSizer;

    public StaffControl(Staff staff, Staff other) {
        this.controlled = staff;
        this.other = other;
    }

    public JTabbedPane createGui() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(10, 1));
        panel.setPreferredSize(new Dimension(200, 700));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayout(5, 1));
        panel2.setPreferredSize(new Dimension(200, 700));
        JLabel staffgroup = new JLabel("Staff Direction");
        JPanel staffpanel = this.createStaffDirectionGroup(staffgroup);
        JLabel handgroup = new JLabel("Hand Direction");
        JPanel handpanel = this.createHandDirectionGroup(handgroup);
        JPanel square = this.createSquarePanel();
        JPanel cross = this.createCrossPanel();
        JPanel smallcross = this.createSmallCrossPanel();
        JPanel startingpositions = this.createStartingPosition();
        JPanel circleS = this.createCircleSize();
        JPanel handSpeed = this.createHandSpeed();
        JPanel speed = this.createStaffSpeed();
        JPanel buttons = this.createButtons();
        JPanel shapes = this.createShapes();
        JPanel complexShapes = this.createComplexShapes();
        JPanel antiiso = this.createAntiISO();
        JPanel rtypes = this.createRTypesButtons();
        JPanel load = this.createLoader();
        panel2.add(shapes);
        panel2.add(antiiso);
        panel2.add(rtypes);
        panel2.add(load);
        panel2.add(complexShapes);
        panel.add(staffpanel);
        panel.add(handpanel);
        panel.add(smallcross);
        panel.add(square);
        panel.add(cross);
        panel.add(speed);
        panel.add(handSpeed);
        panel.add(startingpositions);
        panel.add(circleS);
        panel.add(buttons);
        JTabbedPane pane = new JTabbedPane();
        pane.addTab("Controls", panel);
        pane.addTab("More", panel2);
        return pane;
    }

    private JPanel createLoader() {
        JPanel load = new JPanel();
        load.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "Load / Save"));
        load.setLayout(new GridLayout(3, 1));
        final JTextField enter = new JTextField();
        JButton loader = new JButton("Load");
        JButton saveProps = new JButton("Save File");
        saveProps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Properties staffProperties = new Properties();
                String text = new String();
                staffProperties.put("controlled.angle", "" + ((StaffControl)StaffControl.this).controlled.angle);
                staffProperties.put("controlled.angleIncrement", "" + ((StaffControl)StaffControl.this).controlled.angleIncrement);
                staffProperties.put("controlled.angleModifier", "" + ((StaffControl)StaffControl.this).controlled.angleModifier);
                staffProperties.put("controlled.circleAngle", "" + ((StaffControl)StaffControl.this).controlled.circleAngle);
                staffProperties.put("controlled.circleAngleIncrement", "" + ((StaffControl)StaffControl.this).controlled.circleAngleIncrement);
                staffProperties.put("controlled.circleAngleModifier", "" + ((StaffControl)StaffControl.this).controlled.circleAngleModifier);
                staffProperties.put("controlled.circleModifier", "" + ((StaffControl)StaffControl.this).controlled.circleModifier);
                staffProperties.put("controlled.direction", "" + ((StaffControl)StaffControl.this).controlled.direction);
                staffProperties.put("controlled.handDirection", "" + ((StaffControl)StaffControl.this).controlled.handDirection);
                staffProperties.put("controlled.handSpeed", "" + ((StaffControl)StaffControl.this).controlled.handSpeed);
                staffProperties.put("controlled.height", "" + ((StaffControl)StaffControl.this).controlled.height);
                staffProperties.put("controlled.length", "" + ((StaffControl)StaffControl.this).controlled.length);
                staffProperties.put("controlled.shape", "" + ((StaffControl)StaffControl.this).controlled.shape);
                staffProperties.put("controlled.speed", "" + ((StaffControl)StaffControl.this).controlled.speed);
                staffProperties.put("controlled.x", "" + ((StaffControl)StaffControl.this).controlled.x);
                staffProperties.put("controlled.xadj", "" + ((StaffControl)StaffControl.this).controlled.xadj);
                staffProperties.put("controlled.y", "" + ((StaffControl)StaffControl.this).controlled.y);
                staffProperties.put("controlled.yadj", "" + ((StaffControl)StaffControl.this).controlled.yadj);
                text = String.valueOf(text) + "0,";
                text = String.valueOf(text) + ((StaffControl)StaffControl.this).controlled.angleIncrement + ",";
                text = String.valueOf(text) + ((StaffControl)StaffControl.this).controlled.angleModifier + ",";
                text = String.valueOf(text) + "0,";
                text = String.valueOf(text) + ((StaffControl)StaffControl.this).controlled.circleAngleIncrement + ",";
                text = String.valueOf(text) + ((StaffControl)StaffControl.this).controlled.circleAngleModifier + ",";
                text = String.valueOf(text) + ((StaffControl)StaffControl.this).controlled.circleModifier + ",";
                text = String.valueOf(text) + ((StaffControl)StaffControl.this).controlled.direction + ",";
                text = String.valueOf(text) + ((StaffControl)StaffControl.this).controlled.handDirection + ",";
                text = String.valueOf(text) + ((StaffControl)StaffControl.this).controlled.handSpeed + ",";
                text = String.valueOf(text) + ((StaffControl)StaffControl.this).controlled.height + ",";
                text = String.valueOf(text) + ((StaffControl)StaffControl.this).controlled.length + ",";
                text = String.valueOf(text) + ((StaffControl)StaffControl.this).controlled.shape + ",";
                text = String.valueOf(text) + ((StaffControl)StaffControl.this).controlled.speed + ",";
                text = String.valueOf(text) + "0,";
                text = String.valueOf(text) + ((StaffControl)StaffControl.this).controlled.xadj + ",";
                text = String.valueOf(text) + "0,";
                text = String.valueOf(text) + ((StaffControl)StaffControl.this).controlled.yadj + ",";
                File save = new File("./staffProperties.properties");
                try {
                    if (!save.exists()) {
                        save.createNewFile();
                    }
                    staffProperties.store(new FileWriter(save), "controlled staff properties");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                enter.setText(text);
            }
        });
        loader.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String phrase = enter.getText();
                StaffControl.this.parseStaffText(phrase);
            }
        });
        load.add(saveProps);
        load.add(enter);
        load.add(loader);
        return load;
    }

    void parseStaffText(String phrase) {
        StringTokenizer tokenizer = new StringTokenizer(phrase, ",");
        String angle = tokenizer.nextToken();
        this.controlled.angle = Double.parseDouble(angle);
        String angleIncrement = tokenizer.nextToken();
        this.controlled.angleIncrement = Double.parseDouble(angleIncrement);
        String angleModifier = tokenizer.nextToken();
        this.controlled.angleModifier = Double.parseDouble(angleModifier);
        this.controlled.angle += this.controlled.angleModifier;
        String circleAngle = tokenizer.nextToken();
        this.controlled.circleAngle = Double.parseDouble(circleAngle);
        String circleAngleIncrement = tokenizer.nextToken();
        this.controlled.circleAngleIncrement = Double.parseDouble(circleAngleIncrement);
        String circleAngleModifier = tokenizer.nextToken();
        this.controlled.circleAngleModifier = Double.parseDouble(circleAngleModifier);
        this.controlled.circleAngle += this.controlled.circleAngleModifier;
        String circleModifier = tokenizer.nextToken();
        this.controlled.circleModifier = Double.parseDouble(circleModifier);
        this.circleSizer.setValue((int)this.controlled.circleModifier * 10);
        String direction = tokenizer.nextToken();
        this.controlled.direction = Double.parseDouble(direction);
        if (this.controlled.direction == -1.0) {
            this.clockwise.setSelected(false);
            this.counterclockwise.setSelected(true);
        } else {
            this.clockwise.setSelected(true);
            this.counterclockwise.setSelected(false);
        }
        String handDirection = tokenizer.nextToken();
        this.controlled.handDirection = Double.parseDouble(handDirection);
        if (this.controlled.direction == -1.0) {
            this.handclockwise.setSelected(false);
            this.handcounterclockwise.setSelected(true);
        } else {
            this.handclockwise.setSelected(true);
            this.handcounterclockwise.setSelected(false);
        }
        String handSpeed = tokenizer.nextToken();
        this.controlled.handSpeed = Double.parseDouble(handSpeed);
        this.handSpeedSlide.setValue((int)this.controlled.handSpeed * 10);
        String height = tokenizer.nextToken();
        this.controlled.height = Double.parseDouble(height);
        String length = tokenizer.nextToken();
        this.controlled.length = Double.parseDouble(length);
        String shape = tokenizer.nextToken();
        this.controlled.shape = Integer.parseInt(shape);
        if (this.controlled.shape == 1) {
            this.circle.setSelected(true);
        }
        if (this.controlled.shape == 2) {
            this.square.setSelected(true);
        }
        if (this.controlled.shape == 3) {
            this.vertline.setSelected(true);
        }
        if (this.controlled.shape == 4) {
            this.horizline.setSelected(true);
        }
        if (this.controlled.shape == 5) {
            this.hypocycloid.setSelected(true);
        }
        if (this.controlled.shape == 14) {
            this.quarters.setSelected(true);
        }
        if (this.controlled.shape == 15) {
            this.stepped.setSelected(true);
        }
        if (this.controlled.shape == 16) {
            this.translated.setSelected(true);
        }
        if (this.controlled.shape == 18) {
            this.figureeight.setSelected(true);
        }
        if (this.controlled.shape == 19) {
            this.lissajous.setSelected(true);
        }
        if (this.controlled.shape == 17) {
            this.realhypo.setSelected(true);
        }
        String speed = tokenizer.nextToken();
        this.controlled.speed = Double.parseDouble(speed);
        this.staffSpeedSlide.setValue((int)this.controlled.speed * 10);
        String x = tokenizer.nextToken();
        this.controlled.x = Double.parseDouble(x);
        String xadj = tokenizer.nextToken();
        this.controlled.xadj = Double.parseDouble(xadj);
        String y = tokenizer.nextToken();
        this.controlled.y = Double.parseDouble(y);
        String yadj = tokenizer.nextToken();
        this.controlled.yadj = Double.parseDouble(yadj);
    }

    private JPanel createRTypesButtons() {
        JPanel rtypes = new JPanel();
        rtypes.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "R-Types"));
        rtypes.setLayout(new GridLayout(5, 1));
        ButtonGroup anglegroup = new ButtonGroup();
        anglegroup.add(this.angle1);
        anglegroup.add(this.angle22);
        anglegroup.add(this.angle2);
        anglegroup.add(this.angle3);
        anglegroup.add(this.angle4);
        this.angle4.setSelected(true);
        rtypes.add(this.angle1);
        rtypes.add(this.angle22);
        rtypes.add(this.angle2);
        rtypes.add(this.angle3);
        rtypes.add(this.angle4);
        this.angle1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.angleIncrement = 0.0;
                ((StaffControl)StaffControl.this).controlled.angle = 1.5707963267948966;
                ((StaffControl)StaffControl.this).controlled.angle = 1.5707963267948966;
                ((StaffControl)StaffControl.this).controlled.angleModifier = 1.5707963267948966;
            }
        });
        this.angle2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.angleIncrement = 0.0;
                ((StaffControl)StaffControl.this).controlled.angle = 0.7853981633974483;
                ((StaffControl)StaffControl.this).controlled.angleModifier = 0.7853981633974483;
            }
        });
        this.angle22.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.angleIncrement = 0.0;
                ((StaffControl)StaffControl.this).controlled.angle = 2.356194490192345;
                ((StaffControl)StaffControl.this).controlled.angleModifier = 2.356194490192345;
            }
        });
        this.angle3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.angleIncrement = 0.0;
                ((StaffControl)StaffControl.this).controlled.angle = 0.0;
                ((StaffControl)StaffControl.this).controlled.angleModifier = 0.0;
            }
        });
        this.angle4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Staff staff = StaffControl.this.controlled;
                StaffControl.this.controlled.getClass();
                staff.angleIncrement = 0.025;
                ((StaffControl)StaffControl.this).controlled.angle = (double)((StaffControl)StaffControl.this).controlled.defaultTrails;
                ((StaffControl)StaffControl.this).controlled.angleModifier = (double)((StaffControl)StaffControl.this).controlled.defaultTrails;
            }
        });
        return rtypes;
    }

    private JPanel createShapes() {
        JPanel shapes = new JPanel();
        shapes.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "Shapes"));
        shapes.setLayout(new GridLayout(5, 1));
        this.shapegroup.add(this.circle);
        this.shapegroup.add(this.square);
        this.shapegroup.add(this.vertline);
        this.shapegroup.add(this.horizline);
        this.shapegroup.add(this.hypocycloid);
        this.circle.setSelected(true);
        shapes.add(this.circle);
        shapes.add(this.square);
        shapes.add(this.vertline);
        shapes.add(this.horizline);
        shapes.add(this.hypocycloid);
        this.circle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 1;
            }
        });
        this.square.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 2;
            }
        });
        this.vertline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 3;
            }
        });
        this.horizline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 4;
            }
        });
        this.hypocycloid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 5;
            }
        });
        return shapes;
    }

    private JPanel createComplexShapes() {
        JPanel shapes = new JPanel();
        shapes.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "More Shapes"));
        shapes.setLayout(new GridLayout(6, 1));
        this.shapegroup.add(this.quarters);
        this.shapegroup.add(this.stepped);
        this.shapegroup.add(this.lissajous);
        shapes.add(this.quarters);
        shapes.add(this.stepped);
        shapes.add(this.lissajous);
        this.quarters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 14;
            }
        });
        this.stepped.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 15;
            }
        });
        this.translated.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 16;
            }
        });
        this.figureeight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 18;
            }
        });
        this.lissajous.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 19;
            }
        });
        this.realhypo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 17;
            }
        });
        return shapes;
    }

    private JPanel createAntiISO() {
        JPanel antiiso = new JPanel();
        antiiso.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "Anti + Iso"));
        antiiso.setLayout(new GridLayout(2, 1));
        JPanel one = new JPanel();
        JPanel two = new JPanel();
        one.setLayout(new GridLayout(2, 2));
        two.setLayout(new GridLayout(2, 2));
        antiiso.add(one);
        antiiso.add(two);
        JCheckBox antiiso1 = new JCheckBox("H 1/2 T");
        JCheckBox antiiso2 = new JCheckBox("H 1/2 B");
        JCheckBox antiiso3 = new JCheckBox("V 1/2 L");
        JCheckBox antiiso4 = new JCheckBox("V 1/2 R");
        JCheckBox antiiso5 = new JCheckBox("top left");
        JCheckBox antiiso6 = new JCheckBox("top right");
        JCheckBox antiiso7 = new JCheckBox("bot left");
        JCheckBox antiiso8 = new JCheckBox("bot right");
        this.shapegroup.add(antiiso1);
        this.shapegroup.add(antiiso2);
        this.shapegroup.add(antiiso3);
        this.shapegroup.add(antiiso4);
        this.shapegroup.add(antiiso5);
        this.shapegroup.add(antiiso6);
        this.shapegroup.add(antiiso7);
        this.shapegroup.add(antiiso8);
        one.add(antiiso1);
        one.add(antiiso2);
        one.add(antiiso3);
        one.add(antiiso4);
        two.add(antiiso5);
        two.add(antiiso6);
        two.add(antiiso7);
        two.add(antiiso8);
        antiiso1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 6;
            }
        });
        antiiso2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 7;
            }
        });
        antiiso3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 8;
            }
        });
        antiiso4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 9;
            }
        });
        antiiso5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 10;
            }
        });
        antiiso6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 11;
            }
        });
        antiiso7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 12;
            }
        });
        antiiso8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.shape = 13;
            }
        });
        return antiiso;
    }

    private JPanel createButtons() {
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(3, 1));
        JButton sync = new JButton("SYNC");
        JButton reset = new JButton("RESET");
        buttons.add(reset);
        buttons.add(sync);
        JPanel underbuttons = new JPanel();
        buttons.add(underbuttons);
        underbuttons.setLayout(new GridLayout(1, 2));
        JButton stop = new JButton("Stop");
        JButton trails = new JButton("Trails");
        underbuttons.add(stop);
        underbuttons.add(trails);
        reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                StaffControl.this.controlled.reset();
            }
        });
        sync.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                StaffControl.this.controlled.sync(StaffControl.this.other);
            }
        });
        stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                StaffControl.this.controlled.stop();
            }
        });
        trails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                StaffControl.this.controlled.setTrails();
            }
        });
        return buttons;
    }

    private JPanel createHandSpeed() {
        JPanel handSpeed = new JPanel();
        int MIN = 0;
        int MAX = 30;
        int INIT = 10;
        this.handSpeedSlide = new JSlider(0, MIN, MAX, INIT);
        this.handSpeedSlide.setSnapToTicks(true);
        this.handSpeedSlide.setMajorTickSpacing(5);
        this.handSpeedSlide.setMinorTickSpacing(0);
        this.handSpeedSlide.setPaintTicks(true);
        this.handSpeedSlide.setPaintLabels(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("0"));
        labelTable.put(new Integer(5), new JLabel("0.5"));
        labelTable.put(new Integer(10), new JLabel("1"));
        labelTable.put(new Integer(15), new JLabel("1.5"));
        labelTable.put(new Integer(20), new JLabel("2"));
        labelTable.put(new Integer(25), new JLabel("2.5"));
        labelTable.put(new Integer(30), new JLabel("3"));
        this.handSpeedSlide.setLabelTable(labelTable);
        handSpeed.add(this.handSpeedSlide);
        handSpeed.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Hand Speed"));
        this.handSpeedSlide.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    double size = source.getValue();
                    ((StaffControl)StaffControl.this).controlled.handSpeed = size /= 10.0;
                }
            }
        });
        return handSpeed;
    }

    private JPanel createStaffSpeed() {
        JPanel handSpeed = new JPanel();
        int MIN = 0;
        int MAX = 30;
        int INIT = 10;
        this.staffSpeedSlide = new JSlider(0, MIN, MAX, INIT);
        this.staffSpeedSlide.setSnapToTicks(true);
        this.staffSpeedSlide.setMajorTickSpacing(5);
        this.staffSpeedSlide.setMinorTickSpacing(0);
        this.staffSpeedSlide.setPaintTicks(true);
        this.staffSpeedSlide.setPaintLabels(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("0"));
        labelTable.put(new Integer(5), new JLabel("0.5"));
        labelTable.put(new Integer(10), new JLabel("1"));
        labelTable.put(new Integer(15), new JLabel("1.5"));
        labelTable.put(new Integer(20), new JLabel("2"));
        labelTable.put(new Integer(25), new JLabel("2.5"));
        labelTable.put(new Integer(30), new JLabel("3"));
        this.staffSpeedSlide.setLabelTable(labelTable);
        handSpeed.add(this.staffSpeedSlide);
        handSpeed.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Staff Speed"));
        this.staffSpeedSlide.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    double size = source.getValue();
                    ((StaffControl)StaffControl.this).controlled.speed = size /= 10.0;
                }
            }
        });
        return handSpeed;
    }

    private JPanel createCircleSize() {
        JPanel circleS = new JPanel();
        int MIN = 0;
        int MAX = 30;
        int INIT = 10;
        this.circleSizer = new JSlider(0, MIN, MAX, INIT);
        this.circleSizer.setSnapToTicks(true);
        this.circleSizer.setMajorTickSpacing(5);
        this.circleSizer.setMinorTickSpacing(0);
        this.circleSizer.setPaintTicks(true);
        this.circleSizer.setPaintLabels(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("0"));
        labelTable.put(new Integer(5), new JLabel("0.5"));
        labelTable.put(new Integer(10), new JLabel("1"));
        labelTable.put(new Integer(15), new JLabel("1.5"));
        labelTable.put(new Integer(20), new JLabel("2"));
        labelTable.put(new Integer(25), new JLabel("2.5"));
        labelTable.put(new Integer(30), new JLabel("3"));
        this.circleSizer.setLabelTable(labelTable);
        circleS.add(this.circleSizer);
        circleS.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Circle Size"));
        this.circleSizer.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    double size = source.getValue();
                    ((StaffControl)StaffControl.this).controlled.circleModifier = size /= 10.0;
                }
            }
        });
        return circleS;
    }

    private JPanel createSquarePanel() {
        JPanel square = new JPanel();
        square.setLayout(new GridLayout(2, 2));
        JButton circle1 = new JButton("O");
        JButton circle2 = new JButton("O");
        JButton circle3 = new JButton("O");
        JButton circle4 = new JButton("O");
        square.add(circle1);
        square.add(circle2);
        square.add(circle3);
        square.add(circle4);
        circle1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.xadj = 145.0;
                ((StaffControl)StaffControl.this).controlled.yadj = 245.0;
            }
        });
        circle2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.xadj = 350.0;
                ((StaffControl)StaffControl.this).controlled.yadj = 245.0;
            }
        });
        circle3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.xadj = 145.0;
                ((StaffControl)StaffControl.this).controlled.yadj = 450.0;
            }
        });
        circle4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.xadj = 350.0;
                ((StaffControl)StaffControl.this).controlled.yadj = 450.0;
            }
        });
        return square;
    }

    private JPanel createCrossPanel() {
        JPanel cross = new JPanel();
        cross.setLayout(new GridLayout(3, 3));
        JButton cross1 = new JButton("O");
        JButton cross2 = new JButton("O");
        JButton cross3 = new JButton("O");
        JButton cross4 = new JButton("O");
        JButton cross5 = new JButton("O");
        JPanel empty1 = new JPanel();
        JPanel empty2 = new JPanel();
        JPanel empty3 = new JPanel();
        JPanel empty4 = new JPanel();
        cross.add(empty1);
        cross.add(cross1);
        cross.add(empty2);
        cross.add(cross2);
        cross.add(cross3);
        cross.add(cross4);
        cross.add(empty3);
        cross.add(cross5);
        cross.add(empty4);
        cross3.setSelected(true);
        cross1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.xadj = 250.0;
                ((StaffControl)StaffControl.this).controlled.yadj = 145.0;
            }
        });
        cross2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.xadj = 45.0;
                ((StaffControl)StaffControl.this).controlled.yadj = 345.0;
            }
        });
        cross3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.xadj = 250.0;
                ((StaffControl)StaffControl.this).controlled.yadj = 345.0;
            }
        });
        cross4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.xadj = 450.0;
                ((StaffControl)StaffControl.this).controlled.yadj = 345.0;
            }
        });
        cross5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.xadj = 250.0;
                ((StaffControl)StaffControl.this).controlled.yadj = 550.0;
            }
        });
        return cross;
    }

    private JPanel createSmallCrossPanel() {
        JPanel smallcross = new JPanel();
        smallcross.setLayout(new GridLayout(3, 1));
        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        JPanel p3 = new JPanel();
        p1.setLayout(new GridLayout(1, 3));
        p2.setLayout(new GridLayout(1, 4));
        p3.setLayout(new GridLayout(1, 3));
        smallcross.add(p1);
        smallcross.add(p2);
        smallcross.add(p3);
        JButton smallcross1 = new JButton("O");
        JButton smallcross2 = new JButton("O");
        JButton smallcross3 = new JButton("O");
        JButton smallcross4 = new JButton("O");
        JPanel emptyy1 = new JPanel();
        JPanel emptyy2 = new JPanel();
        JPanel emptyy3 = new JPanel();
        JPanel emptyy4 = new JPanel();
        JPanel emptyy5 = new JPanel();
        JPanel emptyy6 = new JPanel();
        this.positiongroup.add(smallcross1);
        this.positiongroup.add(smallcross2);
        this.positiongroup.add(smallcross3);
        this.positiongroup.add(smallcross4);
        p1.add(emptyy1);
        p1.add(smallcross1);
        p1.add(emptyy2);
        p2.add(emptyy3);
        p2.add(smallcross2);
        p2.add(smallcross3);
        p2.add(emptyy4);
        p3.add(emptyy5);
        p3.add(smallcross4);
        p3.add(emptyy6);
        smallcross1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.xadj = 250.0;
                ((StaffControl)StaffControl.this).controlled.yadj = 245.0;
            }
        });
        smallcross2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.xadj = 145.0;
                ((StaffControl)StaffControl.this).controlled.yadj = 345.0;
            }
        });
        smallcross3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.xadj = 350.0;
                ((StaffControl)StaffControl.this).controlled.yadj = 345.0;
            }
        });
        smallcross4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.xadj = 250.0;
                ((StaffControl)StaffControl.this).controlled.yadj = 450.0;
            }
        });
        return smallcross;
    }

    private JPanel createHandDirectionGroup(JLabel handgroup) {
        ButtonGroup handradio = new ButtonGroup();
        this.handclockwise.setSelected(true);
        this.handcounterclockwise.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Object obj = event.getSource();
                if (obj instanceof JCheckBox) {
                    JCheckBox box = (JCheckBox)obj;
                    String name = box.getText();
                    ((StaffControl)StaffControl.this).controlled.handDirection = name.equals("clockwise") ? 1.0 : -1.0;
                }
            }
        });
        this.handclockwise.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Object obj = event.getSource();
                if (obj instanceof JCheckBox) {
                    JCheckBox box = (JCheckBox)obj;
                    String name = box.getText();
                    ((StaffControl)StaffControl.this).controlled.handDirection = name.equals("clockwise") ? 1.0 : -1.0;
                }
            }
        });
        handradio.add(this.handclockwise);
        handradio.add(this.handcounterclockwise);
        JPanel handpanel = new JPanel();
        handpanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Hand Direction"));
        handpanel.setLayout(new GridLayout(2, 1));
        handpanel.add(this.handclockwise);
        handpanel.add(this.handcounterclockwise);
        return handpanel;
    }

    private JPanel createStaffDirectionGroup(JLabel staffgroup) {
        ButtonGroup staffradio = new ButtonGroup();
        this.clockwise.setSelected(true);
        this.counterclockwise.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Object obj = event.getSource();
                if (obj instanceof JCheckBox) {
                    JCheckBox box = (JCheckBox)obj;
                    String name = box.getText();
                    ((StaffControl)StaffControl.this).controlled.direction = name.equals("clockwise") ? 1.0 : -1.0;
                }
            }
        });
        this.clockwise.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Object obj = event.getSource();
                if (obj instanceof JCheckBox) {
                    JCheckBox box = (JCheckBox)obj;
                    String name = box.getText();
                    ((StaffControl)StaffControl.this).controlled.direction = name.equals("clockwise") ? 1.0 : -1.0;
                }
            }
        });
        staffradio.add(this.clockwise);
        staffradio.add(this.counterclockwise);
        JPanel staffpanel = new JPanel();
        staffpanel.setLayout(new GridLayout(2, 1));
        staffpanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Staff Direction"));
        staffpanel.add(this.clockwise);
        staffpanel.add(this.counterclockwise);
        return staffpanel;
    }

    private JPanel createStartingPosition() {
        JPanel startingpositions = new JPanel();
        startingpositions.setLayout(new GridLayout(4, 1));
        JButton perpendicular = new JButton("Turn Staff 90");
        JButton fourtyfive = new JButton("Turn Staff 45");
        perpendicular.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.angle += 1.5707963267948966;
                ((StaffControl)StaffControl.this).controlled.angleModifier += 1.5707963267948966;
            }
        });
        fourtyfive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.angle += 0.7853981633974483;
                ((StaffControl)StaffControl.this).controlled.angleModifier += 0.7853981633974483;
            }
        });
        JButton quarter1 = new JButton("Position: + 90");
        JButton quarter2 = new JButton("Position: + 45");
        quarter1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.circleAngle += ((StaffControl)StaffControl.this).controlled.handDirection * 1.5707963267948966;
                ((StaffControl)StaffControl.this).controlled.circleAngleModifier += ((StaffControl)StaffControl.this).controlled.handDirection * 1.5707963267948966;
            }
        });
        quarter2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((StaffControl)StaffControl.this).controlled.circleAngle += ((StaffControl)StaffControl.this).controlled.handDirection * 0.7853981633974483;
                ((StaffControl)StaffControl.this).controlled.circleAngleModifier += ((StaffControl)StaffControl.this).controlled.handDirection * 0.7853981633974483;
            }
        });
        startingpositions.add(perpendicular);
        startingpositions.add(fourtyfive);
        startingpositions.add(quarter1);
        startingpositions.add(quarter2);
        return startingpositions;
    }
}

