/*
 * Decompiled with CFR 0.152.
 */
package LAB;

import LAB.LABCanvas;
import LAB.RepaintTimerTask;
import LAB.Staff;
import LAB.StaffControl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;

public class LABpure
extends JFrame {
    private static final long serialVersionUID = 5963272828244291572L;
    LABCanvas canvas;
    Staff left;
    Staff right;
    StaffControl leftControl;
    StaffControl rightControl;
    int speed = 20;

    public static void main(String[] args) {
        GraphicsEnvironment graphEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphDevice = graphEnv.getDefaultScreenDevice();
        GraphicsConfiguration graphicConf = graphDevice.getDefaultConfiguration();
        LABpure frame = new LABpure(graphicConf);
        frame.setPreferredSize(new Dimension(1200, 750));
        frame.setFocusTraversalKeysEnabled(false);
        frame.setTitle("LAB INFINITE");
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public LABpure(GraphicsConfiguration graphicConf) {
        super(graphicConf);
        this.initGUI();
        this.init();
    }

    public LABpure() {
        this.initGUI();
        this.init();
    }

    public void initGUI() {
        this.setPreferredSize(new Dimension(1200, 750));
        BorderLayout biff = new BorderLayout();
        this.setLayout(biff);
        this.canvas = new LABCanvas();
        this.left = this.canvas.left;
        this.right = this.canvas.right;
        this.leftControl = new StaffControl(this.left, this.right);
        this.rightControl = new StaffControl(this.right, this.left);
        JPanel both = new JPanel();
        both.setLayout(new GridLayout(1, 2));
        JTabbedPane leftPanel = this.leftControl.createGui();
        JTabbedPane rightPanel = this.rightControl.createGui();
        leftPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "LEFT"));
        rightPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "RIGHT"));
        both.add(leftPanel);
        both.add(rightPanel);
        this.canvas.setPreferredSize(new Dimension(760, 750));
        this.canvas.setBackground(Color.WHITE);
        JScrollPane canvasScroll = new JScrollPane(this.canvas, 22, 32);
        canvasScroll.setPreferredSize(new Dimension(700, 750));
        JTabbedPane canvasPane = new JTabbedPane();
        canvasPane.addTab("LAB", null, canvasScroll, "Canvas");
        this.getContentPane().add((Component)both, "East");
        this.getContentPane().add((Component)canvasPane, "West");
        JMenuBar menubar = this.createMenubar();
        this.setJMenuBar(menubar);
    }

    private JMenuBar createMenubar() {
        JMenuBar menubar = new JMenuBar();
        JMenu presets = new JMenu("Presets");
        menubar.add(presets);
        JMenuItem BFlyAntiSpinSide = new JMenuItem("Mirror Anti-Spin Split-Time");
        JMenuItem BFlyAntiSpinDown = new JMenuItem("Mirror Anti-Spin Same-Time");
        JMenuItem ParAntiSpinSide = new JMenuItem("Parallel Anti-Spin Split-Time");
        JMenuItem ParAntiSpinDown = new JMenuItem("Parallel Anti-Spin Same-Time");
        JMenuItem MirrorHybridSplit = new JMenuItem("Mirror Hybrid Split-Time");
        JMenuItem MirrorHybridSame = new JMenuItem("Mirror Hybrid Same-Time");
        JMenuItem ParHybridSplit = new JMenuItem("Parallel Hybrid Split-Time");
        JMenuItem ParHybridSame = new JMenuItem("Parallel Hybrid Same-Time");
        presets.add(BFlyAntiSpinSide);
        presets.add(BFlyAntiSpinDown);
        presets.add(ParAntiSpinSide);
        presets.add(ParAntiSpinDown);
        presets.add(new JSeparator());
        presets.add(MirrorHybridSplit);
        presets.add(MirrorHybridSame);
        presets.add(ParHybridSplit);
        presets.add(ParHybridSame);
        BFlyAntiSpinSide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0,";
                String righty = "0,0.025,0.0,0,0.025,0.0,1.0,-1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0,";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        BFlyAntiSpinDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,0.0,0,0.025,0.0,1.0,-1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0,";
                String righty = "0,0.025,3.141592653589793,0,0.025,-3.141592653589793,1.0,1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0,";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        ParAntiSpinSide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0,";
                String righty = "0,0.025,3.141592653589793,0,0.025,-3.141592653589793,1.0,1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0,";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        ParAntiSpinDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,0,0.025,1.0,1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,0,0.025,1.0,1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        MirrorHybridSplit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,0.0,0,0.025,3.141592653589793,1.0,-1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        MirrorHybridSame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,0.0,0,0.025,0.0,1.0,-1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0,";
                String righty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        ParHybridSplit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        ParHybridSame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,0.0,0,0.025,3.141592653589793,1.0,1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        JMenuItem MirrorIsoSame = new JMenuItem("Mirror Isolation Split-Time");
        JMenuItem MirrorIsoSplit = new JMenuItem("Mirror Isolation Same-Time");
        JMenuItem ParIsoSame = new JMenuItem("Parallel Isolation Split-Time");
        JMenuItem ParIsoSplit = new JMenuItem("Parallel Isolation Same-Time");
        MirrorIsoSame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,3.141592653589793,0,0.025,3.141592653589793,1.0,-1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        MirrorIsoSplit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,6.283185307179586,0,0.025,0.0,1.0,-1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0,";
                String righty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        ParIsoSplit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0,";
                String righty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0,";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        ParIsoSame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,3.141592653589793,0,0.025,3.141592653589793,1.0,1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0,";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        JMenuItem QuarterMirrorIso = new JMenuItem("Quarter-Time Mirror Isolation");
        JMenuItem QuarterParIso = new JMenuItem("Quarter-Time Parallel Isolation");
        JMenuItem QuarterMirrorAnti = new JMenuItem("Quarter-Time Mirror Anti-Spin");
        JMenuItem QuarterParAnti = new JMenuItem("Quarter-Time Parallel Anti-Spin");
        JMenuItem QuarterMirrorHybrid = new JMenuItem("Quarter-Time Mirror Hybrid");
        JMenuItem QuarterParHybrid = new JMenuItem("Quarter-Time Parallel Hybrid");
        presets.add(new JSeparator());
        presets.add(MirrorIsoSame);
        presets.add(MirrorIsoSplit);
        presets.add(ParIsoSame);
        presets.add(ParIsoSplit);
        presets.add(new JSeparator());
        presets.add(QuarterMirrorIso);
        presets.add(QuarterParIso);
        presets.add(QuarterMirrorAnti);
        presets.add(QuarterParAnti);
        presets.add(QuarterMirrorHybrid);
        presets.add(QuarterParHybrid);
        QuarterParIso.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,1.5707963267948966,0,0.025,1.5707963267948966,1.0,1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        QuarterMirrorIso.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,1.5707963267948966,0,0.025,1.5707963267948966,1.0,1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,0.0,0,0.025,0.0,1.0,-1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        QuarterParAnti.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,4.71238898038469,0,0.025,1.5707963267948966,1.0,-1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,0.0,0,0.025,0.0,1.0,-1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0,";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        QuarterMirrorAnti.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,4.71238898038469,0,0.025,1.5707963267948966,1.0,-1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        QuarterMirrorHybrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,4.71238898038469,0,0.025,1.5707963267948966,1.0,-1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,0.0,0,0.025,0.0,1.0,-1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0,";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        QuarterParHybrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,4.71238898038469,0,0.025,1.5707963267948966,1.0,-1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        JMenu speedy = new JMenu("Speed");
        JMenu images = new JMenu("Trails");
        JMenuItem fast = new JMenuItem("Fast");
        JMenuItem medium = new JMenuItem("Medium (default)");
        JMenuItem slow = new JMenuItem("Slow");
        speedy.add(fast);
        speedy.add(medium);
        speedy.add(slow);
        fast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LABpure.this.speed = 5;
                LABpure.this.init();
            }
        });
        medium.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LABpure.this.speed = 20;
                LABpure.this.init();
            }
        });
        slow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LABpure.this.speed = 100;
                LABpure.this.init();
            }
        });
        JMenuItem trails = new JMenuItem("Trails");
        JMenuItem notrails = new JMenuItem("No Trails");
        JMenuItem grid = new JMenuItem("Grid");
        JMenuItem nogrid = new JMenuItem("No Grid");
        JMenuItem helpers = new JMenuItem("Helpers");
        JMenuItem nohelpers = new JMenuItem("No Helpers");
        JMenuItem wicktrails = new JMenuItem("Wick Trails");
        JMenuItem nowicktrails = new JMenuItem("No Wick Trails");
        images.add(trails);
        images.add(notrails);
        images.add(grid);
        images.add(nogrid);
        images.add(helpers);
        images.add(nohelpers);
        images.add(wicktrails);
        images.add(nowicktrails);
        trails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LABpure.this.canvas.trails = true;
            }
        });
        notrails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LABpure.this.canvas.trails = false;
            }
        });
        grid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LABpure.this.canvas.gridon = true;
            }
        });
        nogrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LABpure.this.canvas.gridon = false;
            }
        });
        helpers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LABpure.this.canvas.helpers = true;
            }
        });
        nohelpers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LABpure.this.canvas.helpers = false;
            }
        });
        wicktrails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LABpure.this.canvas.wicktrails = true;
            }
        });
        nowicktrails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LABpure.this.canvas.wicktrails = false;
            }
        });
        menubar.add(speedy);
        menubar.add(images);
        JMenu megs = new JMenu("Megs Faves");
        JMenuItem meg1 = new JMenuItem("Meg");
        JMenuItem meg2 = new JMenuItem("MCP");
        JMenuItem meg3 = new JMenuItem("Megatron");
        JMenuItem meg4 = new JMenuItem("Moisty");
        megs.add(meg1);
        megs.add(meg2);
        megs.add(meg3);
        megs.add(meg4);
        meg1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,0.0,0,0.025,0.0,1.0,1.0,-1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,4.71238898038469,0,0.025,0.0,1.0,-1.0,1.0,1.0,9.0,205.0,1,1.0,0,250.0,0,345.0";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        meg2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.0,0.0,0,0.025,0.0,1.0,1.0,-1.0,1.0,9.0,205.0,4,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,4.71238898038469,0,0.025,0.0,1.0,-1.0,1.0,1.0,9.0,205.0,3,1.0,0,250.0,0,345.0";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        meg3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,1.5707963267948966,0,0.025,0.0,1.0,1.0,1.0,1.0,9.0,205.0,14,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,0.0,0,0.025,1.5707963267948966,1.0,1.0,1.0,1.0,9.0,205.0,14,1.0,0,250.0,0,345.0";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        meg4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String lefty = "0,0.025,1.5707963267948966,0,0.025,0.0,1.0,1.0,1.0,1.0,9.0,205.0,15,1.0,0,250.0,0,345.0";
                String righty = "0,0.025,1.5707963267948966,0,0.025,3.141592653589793,1.0,1.0,1.0,1.0,9.0,205.0,15,1.0,0,250.0,0,345.0,";
                LABpure.this.leftControl.parseStaffText(lefty);
                LABpure.this.rightControl.parseStaffText(righty);
            }
        });
        menubar.add(megs);
        return menubar;
    }

    public void init() {
        Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)new RepaintTimerTask(this.canvas), 100L, (long)this.speed);
    }
}

