/*
 * Decompiled with CFR 0.152.
 */
package LAB;

import LAB.Staff;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class LABCanvas
extends JPanel {
    private static final long serialVersionUID = -7408624679627703103L;
    BufferedImage staff;
    BufferedImage grid;
    BufferedImage wick;
    BufferedImage iso;
    BufferedImage anti;
    AffineTransform leftStaff;
    AffineTransform rightStaff;
    double angle = 0.0;
    BufferedImage scrnBuf;
    Graphics2D sG;
    boolean trails = false;
    boolean helpers = false;
    boolean gridon = true;
    boolean wicktrails = false;
    public Staff left = new Staff();
    public Staff right = new Staff();

    public LABCanvas() {
        this.init();
    }

    public void init() {
        GraphicsEnvironment graphEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphDevice = graphEnv.getDefaultScreenDevice();
        GraphicsConfiguration graphicConf = graphDevice.getDefaultConfiguration();
        this.setFocusTraversalKeysEnabled(false);
        this.scrnBuf = graphicConf.createCompatibleImage(750, 750);
        this.sG = this.scrnBuf.createGraphics();
        this.sG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            this.staff = ImageIO.read(new File("./images/stick1.png"));
            this.grid = ImageIO.read(new File("./images/grid.png"));
            this.wick = ImageIO.read(new File("./images/wicks.png"));
            this.iso = ImageIO.read(new File("./images/iso1.png"));
            this.anti = ImageIO.read(new File("./images/anti1.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.right.x = 250.0;
        this.right.xadj = 250.0;
        this.right.y = 450.0;
        this.right.yadj = 450.0;
        this.leftStaff = this.left.getAffineTransform();
        this.rightStaff = this.right.getAffineTransform();
    }

    public void update() {
        this.left.update();
        this.leftStaff = this.left.getAffineTransform();
        this.right.update();
        this.rightStaff = this.right.getAffineTransform();
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.sG.setColor(Color.white);
        if (this.trails) {
            this.sG.setComposite(AlphaComposite.getInstance(3, 0.2f));
        }
        if (!this.wicktrails) {
            this.sG.fillRect(0, 0, 750, 750);
        }
        if (this.trails) {
            this.sG.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        if (this.gridon) {
            this.sG.drawImage(this.grid, null, 0, 0);
        }
        if (!this.wicktrails) {
            this.sG.drawImage(this.staff, new AffineTransformOp(this.leftStaff, 2), (int)this.left.getX(), (int)this.left.getY());
            this.sG.drawImage(this.staff, new AffineTransformOp(this.rightStaff, 2), (int)this.right.getX(), (int)this.right.getY());
        }
        if (this.helpers) {
            this.sG.drawImage(this.iso, null, (int)(this.left.xadj - 2.0 - this.left.length / 2.0), (int)(this.left.yadj + 2.0 - this.left.length));
            this.sG.drawImage(this.anti, null, (int)(this.right.xadj - 2.0 - this.left.length / 2.0), (int)(this.right.yadj + 2.0 - this.right.length));
        }
        if (this.wicktrails) {
            this.sG.drawImage(this.wick, new AffineTransformOp(this.leftStaff, 2), (int)this.left.getX(), (int)this.left.getY());
            this.sG.drawImage(this.wick, new AffineTransformOp(this.rightStaff, 2), (int)this.right.getX(), (int)this.right.getY());
        }
        if (this.wicktrails) {
            this.sG.setComposite(AlphaComposite.getInstance(3, 0.2f));
        }
        g.drawImage(this.scrnBuf, 0, 0, this);
        if (this.wicktrails) {
            this.sG.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }
}

