/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Android;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

final class UnsafeUtil {
    private static final Logger logger = Logger.getLogger(UnsafeUtil.class.getName());
    private static final Unsafe UNSAFE = UnsafeUtil.getUnsafe();
    private static final Class<?> MEMORY_CLASS = Android.getMemoryClass();
    private static final boolean IS_ANDROID_64 = UnsafeUtil.determineAndroidSupportByAddressSize(Long.TYPE);
    private static final boolean IS_ANDROID_32 = UnsafeUtil.determineAndroidSupportByAddressSize(Integer.TYPE);
    private static final MemoryAccessor MEMORY_ACCESSOR = UnsafeUtil.getMemoryAccessor();
    private static final boolean HAS_UNSAFE_BYTEBUFFER_OPERATIONS = UnsafeUtil.supportsUnsafeByteBufferOperations();
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.supportsUnsafeArrayOperations();
    static final long BYTE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(byte[].class);
    private static final long BOOLEAN_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(boolean[].class);
    private static final long BOOLEAN_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(boolean[].class);
    private static final long INT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(int[].class);
    private static final long INT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(int[].class);
    private static final long LONG_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(long[].class);
    private static final long LONG_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(long[].class);
    private static final long FLOAT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(float[].class);
    private static final long FLOAT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(float[].class);
    private static final long DOUBLE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(double[].class);
    private static final long DOUBLE_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(double[].class);
    private static final long OBJECT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(Object[].class);
    private static final long OBJECT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(Object[].class);
    private static final long BUFFER_ADDRESS_OFFSET = UnsafeUtil.fieldOffset(UnsafeUtil.bufferAddressField());
    private static final int STRIDE = 8;
    private static final int STRIDE_ALIGNMENT_MASK = 7;
    private static final int BYTE_ARRAY_ALIGNMENT = (int)(BYTE_ARRAY_BASE_OFFSET & 7L);
    static final boolean IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private UnsafeUtil() {
    }

    static boolean hasUnsafeArrayOperations() {
        return HAS_UNSAFE_ARRAY_OPERATIONS;
    }

    static boolean hasUnsafeByteBufferOperations() {
        return HAS_UNSAFE_BYTEBUFFER_OPERATIONS;
    }

    static boolean isAndroid64() {
        return IS_ANDROID_64;
    }

    static <T> T allocateInstance(Class<T> clazz) {
        try {
            return (T)UNSAFE.allocateInstance(clazz);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(instantiationException);
        }
    }

    static long objectFieldOffset(Field field) {
        return MEMORY_ACCESSOR.objectFieldOffset(field);
    }

    private static int arrayBaseOffset(Class<?> clazz) {
        return HAS_UNSAFE_ARRAY_OPERATIONS ? MEMORY_ACCESSOR.arrayBaseOffset(clazz) : -1;
    }

    private static int arrayIndexScale(Class<?> clazz) {
        return HAS_UNSAFE_ARRAY_OPERATIONS ? MEMORY_ACCESSOR.arrayIndexScale(clazz) : -1;
    }

    static byte getByte(Object object, long l) {
        return MEMORY_ACCESSOR.getByte(object, l);
    }

    static void putByte(Object object, long l, byte by) {
        MEMORY_ACCESSOR.putByte(object, l, by);
    }

    static int getInt(Object object, long l) {
        return MEMORY_ACCESSOR.getInt(object, l);
    }

    static void putInt(Object object, long l, int n) {
        MEMORY_ACCESSOR.putInt(object, l, n);
    }

    static long getLong(Object object, long l) {
        return MEMORY_ACCESSOR.getLong(object, l);
    }

    static void putLong(Object object, long l, long l2) {
        MEMORY_ACCESSOR.putLong(object, l, l2);
    }

    static boolean getBoolean(Object object, long l) {
        return MEMORY_ACCESSOR.getBoolean(object, l);
    }

    static void putBoolean(Object object, long l, boolean bl) {
        MEMORY_ACCESSOR.putBoolean(object, l, bl);
    }

    static float getFloat(Object object, long l) {
        return MEMORY_ACCESSOR.getFloat(object, l);
    }

    static void putFloat(Object object, long l, float f) {
        MEMORY_ACCESSOR.putFloat(object, l, f);
    }

    static double getDouble(Object object, long l) {
        return MEMORY_ACCESSOR.getDouble(object, l);
    }

    static void putDouble(Object object, long l, double d) {
        MEMORY_ACCESSOR.putDouble(object, l, d);
    }

    static Object getObject(Object object, long l) {
        return MEMORY_ACCESSOR.getObject(object, l);
    }

    static void putObject(Object object, long l, Object object2) {
        MEMORY_ACCESSOR.putObject(object, l, object2);
    }

    static byte getByte(byte[] byArray, long l) {
        return MEMORY_ACCESSOR.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + l);
    }

    static void putByte(byte[] byArray, long l, byte by) {
        MEMORY_ACCESSOR.putByte(byArray, BYTE_ARRAY_BASE_OFFSET + l, by);
    }

    static int getInt(int[] nArray, long l) {
        return MEMORY_ACCESSOR.getInt(nArray, INT_ARRAY_BASE_OFFSET + l * INT_ARRAY_INDEX_SCALE);
    }

    static void putInt(int[] nArray, long l, int n) {
        MEMORY_ACCESSOR.putInt(nArray, INT_ARRAY_BASE_OFFSET + l * INT_ARRAY_INDEX_SCALE, n);
    }

    static long getLong(long[] lArray, long l) {
        return MEMORY_ACCESSOR.getLong(lArray, LONG_ARRAY_BASE_OFFSET + l * LONG_ARRAY_INDEX_SCALE);
    }

    static void putLong(long[] lArray, long l, long l2) {
        MEMORY_ACCESSOR.putLong(lArray, LONG_ARRAY_BASE_OFFSET + l * LONG_ARRAY_INDEX_SCALE, l2);
    }

    static boolean getBoolean(boolean[] blArray, long l) {
        return MEMORY_ACCESSOR.getBoolean(blArray, BOOLEAN_ARRAY_BASE_OFFSET + l * BOOLEAN_ARRAY_INDEX_SCALE);
    }

    static void putBoolean(boolean[] blArray, long l, boolean bl) {
        MEMORY_ACCESSOR.putBoolean(blArray, BOOLEAN_ARRAY_BASE_OFFSET + l * BOOLEAN_ARRAY_INDEX_SCALE, bl);
    }

    static float getFloat(float[] fArray, long l) {
        return MEMORY_ACCESSOR.getFloat(fArray, FLOAT_ARRAY_BASE_OFFSET + l * FLOAT_ARRAY_INDEX_SCALE);
    }

    static void putFloat(float[] fArray, long l, float f) {
        MEMORY_ACCESSOR.putFloat(fArray, FLOAT_ARRAY_BASE_OFFSET + l * FLOAT_ARRAY_INDEX_SCALE, f);
    }

    static double getDouble(double[] dArray, long l) {
        return MEMORY_ACCESSOR.getDouble(dArray, DOUBLE_ARRAY_BASE_OFFSET + l * DOUBLE_ARRAY_INDEX_SCALE);
    }

    static void putDouble(double[] dArray, long l, double d) {
        MEMORY_ACCESSOR.putDouble(dArray, DOUBLE_ARRAY_BASE_OFFSET + l * DOUBLE_ARRAY_INDEX_SCALE, d);
    }

    static Object getObject(Object[] objectArray, long l) {
        return MEMORY_ACCESSOR.getObject(objectArray, OBJECT_ARRAY_BASE_OFFSET + l * OBJECT_ARRAY_INDEX_SCALE);
    }

    static void putObject(Object[] objectArray, long l, Object object) {
        MEMORY_ACCESSOR.putObject(objectArray, OBJECT_ARRAY_BASE_OFFSET + l * OBJECT_ARRAY_INDEX_SCALE, object);
    }

    static void copyMemory(byte[] byArray, long l, long l2, long l3) {
        MEMORY_ACCESSOR.copyMemory(byArray, l, l2, l3);
    }

    static void copyMemory(long l, byte[] byArray, long l2, long l3) {
        MEMORY_ACCESSOR.copyMemory(l, byArray, l2, l3);
    }

    static void copyMemory(byte[] byArray, long l, byte[] byArray2, long l2, long l3) {
        System.arraycopy(byArray, (int)l, byArray2, (int)l2, (int)l3);
    }

    static byte getByte(long l) {
        return MEMORY_ACCESSOR.getByte(l);
    }

    static void putByte(long l, byte by) {
        MEMORY_ACCESSOR.putByte(l, by);
    }

    static int getInt(long l) {
        return MEMORY_ACCESSOR.getInt(l);
    }

    static void putInt(long l, int n) {
        MEMORY_ACCESSOR.putInt(l, n);
    }

    static long getLong(long l) {
        return MEMORY_ACCESSOR.getLong(l);
    }

    static void putLong(long l, long l2) {
        MEMORY_ACCESSOR.putLong(l, l2);
    }

    static long addressOffset(ByteBuffer byteBuffer) {
        return MEMORY_ACCESSOR.getLong(byteBuffer, BUFFER_ADDRESS_OFFSET);
    }

    static Object getStaticObject(Field field) {
        return MEMORY_ACCESSOR.getStaticObject(field);
    }

    static Unsafe getUnsafe() {
        Unsafe unsafe = null;
        try {
            unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Class<Unsafe> clazz = Unsafe.class;
                    for (Field field : clazz.getDeclaredFields()) {
                        field.setAccessible(true);
                        Object object = field.get(null);
                        if (!clazz.isInstance(object)) continue;
                        return (Unsafe)clazz.cast(object);
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return unsafe;
    }

    private static MemoryAccessor getMemoryAccessor() {
        if (UNSAFE == null) {
            return null;
        }
        if (Android.isOnAndroidDevice()) {
            if (IS_ANDROID_64) {
                return new Android64MemoryAccessor(UNSAFE);
            }
            if (IS_ANDROID_32) {
                return new Android32MemoryAccessor(UNSAFE);
            }
            return null;
        }
        return new JvmMemoryAccessor(UNSAFE);
    }

    private static boolean supportsUnsafeArrayOperations() {
        if (UNSAFE == null) {
            return false;
        }
        try {
            Class<?> clazz = UNSAFE.getClass();
            clazz.getMethod("objectFieldOffset", Field.class);
            clazz.getMethod("arrayBaseOffset", Class.class);
            clazz.getMethod("arrayIndexScale", Class.class);
            clazz.getMethod("getInt", Object.class, Long.TYPE);
            clazz.getMethod("putInt", Object.class, Long.TYPE, Integer.TYPE);
            clazz.getMethod("getLong", Object.class, Long.TYPE);
            clazz.getMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
            clazz.getMethod("getObject", Object.class, Long.TYPE);
            clazz.getMethod("putObject", Object.class, Long.TYPE, Object.class);
            if (Android.isOnAndroidDevice()) {
                return true;
            }
            clazz.getMethod("getByte", Object.class, Long.TYPE);
            clazz.getMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
            clazz.getMethod("getBoolean", Object.class, Long.TYPE);
            clazz.getMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
            clazz.getMethod("getFloat", Object.class, Long.TYPE);
            clazz.getMethod("putFloat", Object.class, Long.TYPE, Float.TYPE);
            clazz.getMethod("getDouble", Object.class, Long.TYPE);
            clazz.getMethod("putDouble", Object.class, Long.TYPE, Double.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "platform method missing - proto runtime falling back to safer methods: " + throwable);
            return false;
        }
    }

    private static boolean supportsUnsafeByteBufferOperations() {
        if (UNSAFE == null) {
            return false;
        }
        try {
            Class<?> clazz = UNSAFE.getClass();
            clazz.getMethod("objectFieldOffset", Field.class);
            clazz.getMethod("getLong", Object.class, Long.TYPE);
            if (UnsafeUtil.bufferAddressField() == null) {
                return false;
            }
            if (Android.isOnAndroidDevice()) {
                return true;
            }
            clazz.getMethod("getByte", Long.TYPE);
            clazz.getMethod("putByte", Long.TYPE, Byte.TYPE);
            clazz.getMethod("getInt", Long.TYPE);
            clazz.getMethod("putInt", Long.TYPE, Integer.TYPE);
            clazz.getMethod("getLong", Long.TYPE);
            clazz.getMethod("putLong", Long.TYPE, Long.TYPE);
            clazz.getMethod("copyMemory", Long.TYPE, Long.TYPE, Long.TYPE);
            clazz.getMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "platform method missing - proto runtime falling back to safer methods: " + throwable);
            return false;
        }
    }

    private static boolean determineAndroidSupportByAddressSize(Class<?> clazz) {
        if (!Android.isOnAndroidDevice()) {
            return false;
        }
        try {
            Class<?> clazz2 = MEMORY_CLASS;
            clazz2.getMethod("peekLong", clazz, Boolean.TYPE);
            clazz2.getMethod("pokeLong", clazz, Long.TYPE, Boolean.TYPE);
            clazz2.getMethod("pokeInt", clazz, Integer.TYPE, Boolean.TYPE);
            clazz2.getMethod("peekInt", clazz, Boolean.TYPE);
            clazz2.getMethod("pokeByte", clazz, Byte.TYPE);
            clazz2.getMethod("peekByte", clazz);
            clazz2.getMethod("pokeByteArray", clazz, byte[].class, Integer.TYPE, Integer.TYPE);
            clazz2.getMethod("peekByteArray", clazz, byte[].class, Integer.TYPE, Integer.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static Field bufferAddressField() {
        Field field;
        if (Android.isOnAndroidDevice() && (field = UnsafeUtil.field(Buffer.class, "effectiveDirectAddress")) != null) {
            return field;
        }
        field = UnsafeUtil.field(Buffer.class, "address");
        return field != null && field.getType() == Long.TYPE ? field : null;
    }

    private static int firstDifferingByteIndexNativeEndian(long l, long l2) {
        int n = IS_BIG_ENDIAN ? Long.numberOfLeadingZeros(l ^ l2) : Long.numberOfTrailingZeros(l ^ l2);
        return n >> 3;
    }

    static int mismatch(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (n < 0 || n2 < 0 || n3 < 0 || n + n3 > byArray.length || n2 + n3 > byArray2.length) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = 0;
        if (HAS_UNSAFE_ARRAY_OPERATIONS) {
            int n5 = BYTE_ARRAY_ALIGNMENT + n & 7;
            while (n4 < n3 && (n5 & 7) != 0) {
                if (byArray[n + n4] != byArray2[n2 + n4]) {
                    return n4;
                }
                ++n4;
                ++n5;
            }
            int n6 = (n3 - n4 & 0xFFFFFFF8) + n4;
            while (n4 < n6) {
                long l;
                long l2 = UnsafeUtil.getLong((Object)byArray, BYTE_ARRAY_BASE_OFFSET + (long)n + (long)n4);
                if (l2 != (l = UnsafeUtil.getLong((Object)byArray2, BYTE_ARRAY_BASE_OFFSET + (long)n2 + (long)n4))) {
                    return n4 + UnsafeUtil.firstDifferingByteIndexNativeEndian(l2, l);
                }
                n4 += 8;
            }
        }
        while (n4 < n3) {
            if (byArray[n + n4] != byArray2[n2 + n4]) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    private static long fieldOffset(Field field) {
        return field == null || MEMORY_ACCESSOR == null ? -1L : MEMORY_ACCESSOR.objectFieldOffset(field);
    }

    private static Field field(Class<?> clazz, String string) {
        Field field;
        try {
            field = clazz.getDeclaredField(string);
        }
        catch (Throwable throwable) {
            field = null;
        }
        return field;
    }

    private static byte getByteBigEndian(Object object, long l) {
        return (byte)(UnsafeUtil.getInt(object, l & 0xFFFFFFFFFFFFFFFCL) >>> (int)(((l ^ 0xFFFFFFFFFFFFFFFFL) & 3L) << 3) & 0xFF);
    }

    private static byte getByteLittleEndian(Object object, long l) {
        return (byte)(UnsafeUtil.getInt(object, l & 0xFFFFFFFFFFFFFFFCL) >>> (int)((l & 3L) << 3) & 0xFF);
    }

    private static void putByteBigEndian(Object object, long l, byte by) {
        int n = UnsafeUtil.getInt(object, l & 0xFFFFFFFFFFFFFFFCL);
        int n2 = (~((int)l) & 3) << 3;
        int n3 = n & ~(255 << n2) | (0xFF & by) << n2;
        UnsafeUtil.putInt(object, l & 0xFFFFFFFFFFFFFFFCL, n3);
    }

    private static void putByteLittleEndian(Object object, long l, byte by) {
        int n = UnsafeUtil.getInt(object, l & 0xFFFFFFFFFFFFFFFCL);
        int n2 = ((int)l & 3) << 3;
        int n3 = n & ~(255 << n2) | (0xFF & by) << n2;
        UnsafeUtil.putInt(object, l & 0xFFFFFFFFFFFFFFFCL, n3);
    }

    private static boolean getBooleanBigEndian(Object object, long l) {
        return UnsafeUtil.getByteBigEndian(object, l) != 0;
    }

    private static boolean getBooleanLittleEndian(Object object, long l) {
        return UnsafeUtil.getByteLittleEndian(object, l) != 0;
    }

    private static void putBooleanBigEndian(Object object, long l, boolean bl) {
        UnsafeUtil.putByteBigEndian(object, l, (byte)(bl ? 1 : 0));
    }

    private static void putBooleanLittleEndian(Object object, long l, boolean bl) {
        UnsafeUtil.putByteLittleEndian(object, l, (byte)(bl ? 1 : 0));
    }

    private static final class Android32MemoryAccessor
    extends MemoryAccessor {
        private static final long SMALL_ADDRESS_MASK = -1L;

        private static int smallAddress(long l) {
            return (int)(0xFFFFFFFFFFFFFFFFL & l);
        }

        Android32MemoryAccessor(Unsafe unsafe) {
            super(unsafe);
        }

        @Override
        public byte getByte(long l) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putByte(long l, byte by) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getInt(long l) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putInt(long l, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLong(long l) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong(long l, long l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte getByte(Object object, long l) {
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.getByteBigEndian(object, l);
            }
            return UnsafeUtil.getByteLittleEndian(object, l);
        }

        @Override
        public void putByte(Object object, long l, byte by) {
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.putByteBigEndian(object, l, by);
            } else {
                UnsafeUtil.putByteLittleEndian(object, l, by);
            }
        }

        @Override
        public boolean getBoolean(Object object, long l) {
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.getBooleanBigEndian(object, l);
            }
            return UnsafeUtil.getBooleanLittleEndian(object, l);
        }

        @Override
        public void putBoolean(Object object, long l, boolean bl) {
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.putBooleanBigEndian(object, l, bl);
            } else {
                UnsafeUtil.putBooleanLittleEndian(object, l, bl);
            }
        }

        @Override
        public float getFloat(Object object, long l) {
            return Float.intBitsToFloat(this.getInt(object, l));
        }

        @Override
        public void putFloat(Object object, long l, float f) {
            this.putInt(object, l, Float.floatToIntBits(f));
        }

        @Override
        public double getDouble(Object object, long l) {
            return Double.longBitsToDouble(this.getLong(object, l));
        }

        @Override
        public void putDouble(Object object, long l, double d) {
            this.putLong(object, l, Double.doubleToLongBits(d));
        }

        @Override
        public void copyMemory(long l, byte[] byArray, long l2, long l3) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyMemory(byte[] byArray, long l, long l2, long l3) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getStaticObject(Field field) {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }
    }

    private static final class Android64MemoryAccessor
    extends MemoryAccessor {
        Android64MemoryAccessor(Unsafe unsafe) {
            super(unsafe);
        }

        @Override
        public byte getByte(long l) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putByte(long l, byte by) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getInt(long l) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putInt(long l, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLong(long l) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong(long l, long l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte getByte(Object object, long l) {
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.getByteBigEndian(object, l);
            }
            return UnsafeUtil.getByteLittleEndian(object, l);
        }

        @Override
        public void putByte(Object object, long l, byte by) {
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.putByteBigEndian(object, l, by);
            } else {
                UnsafeUtil.putByteLittleEndian(object, l, by);
            }
        }

        @Override
        public boolean getBoolean(Object object, long l) {
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.getBooleanBigEndian(object, l);
            }
            return UnsafeUtil.getBooleanLittleEndian(object, l);
        }

        @Override
        public void putBoolean(Object object, long l, boolean bl) {
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.putBooleanBigEndian(object, l, bl);
            } else {
                UnsafeUtil.putBooleanLittleEndian(object, l, bl);
            }
        }

        @Override
        public float getFloat(Object object, long l) {
            return Float.intBitsToFloat(this.getInt(object, l));
        }

        @Override
        public void putFloat(Object object, long l, float f) {
            this.putInt(object, l, Float.floatToIntBits(f));
        }

        @Override
        public double getDouble(Object object, long l) {
            return Double.longBitsToDouble(this.getLong(object, l));
        }

        @Override
        public void putDouble(Object object, long l, double d) {
            this.putLong(object, l, Double.doubleToLongBits(d));
        }

        @Override
        public void copyMemory(long l, byte[] byArray, long l2, long l3) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyMemory(byte[] byArray, long l, long l2, long l3) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getStaticObject(Field field) {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }
    }

    private static final class JvmMemoryAccessor
    extends MemoryAccessor {
        JvmMemoryAccessor(Unsafe unsafe) {
            super(unsafe);
        }

        @Override
        public byte getByte(long l) {
            return this.unsafe.getByte(l);
        }

        @Override
        public void putByte(long l, byte by) {
            this.unsafe.putByte(l, by);
        }

        @Override
        public int getInt(long l) {
            return this.unsafe.getInt(l);
        }

        @Override
        public void putInt(long l, int n) {
            this.unsafe.putInt(l, n);
        }

        @Override
        public long getLong(long l) {
            return this.unsafe.getLong(l);
        }

        @Override
        public void putLong(long l, long l2) {
            this.unsafe.putLong(l, l2);
        }

        @Override
        public byte getByte(Object object, long l) {
            return this.unsafe.getByte(object, l);
        }

        @Override
        public void putByte(Object object, long l, byte by) {
            this.unsafe.putByte(object, l, by);
        }

        @Override
        public boolean getBoolean(Object object, long l) {
            return this.unsafe.getBoolean(object, l);
        }

        @Override
        public void putBoolean(Object object, long l, boolean bl) {
            this.unsafe.putBoolean(object, l, bl);
        }

        @Override
        public float getFloat(Object object, long l) {
            return this.unsafe.getFloat(object, l);
        }

        @Override
        public void putFloat(Object object, long l, float f) {
            this.unsafe.putFloat(object, l, f);
        }

        @Override
        public double getDouble(Object object, long l) {
            return this.unsafe.getDouble(object, l);
        }

        @Override
        public void putDouble(Object object, long l, double d) {
            this.unsafe.putDouble(object, l, d);
        }

        @Override
        public void copyMemory(long l, byte[] byArray, long l2, long l3) {
            this.unsafe.copyMemory(null, l, byArray, BYTE_ARRAY_BASE_OFFSET + l2, l3);
        }

        @Override
        public void copyMemory(byte[] byArray, long l, long l2, long l3) {
            this.unsafe.copyMemory(byArray, BYTE_ARRAY_BASE_OFFSET + l, null, l2, l3);
        }

        @Override
        public Object getStaticObject(Field field) {
            return this.getObject(this.unsafe.staticFieldBase(field), this.unsafe.staticFieldOffset(field));
        }
    }

    private static abstract class MemoryAccessor {
        Unsafe unsafe;

        MemoryAccessor(Unsafe unsafe) {
            this.unsafe = unsafe;
        }

        public final long objectFieldOffset(Field field) {
            return this.unsafe.objectFieldOffset(field);
        }

        public abstract byte getByte(Object var1, long var2);

        public abstract void putByte(Object var1, long var2, byte var4);

        public final int getInt(Object object, long l) {
            return this.unsafe.getInt(object, l);
        }

        public final void putInt(Object object, long l, int n) {
            this.unsafe.putInt(object, l, n);
        }

        public final long getLong(Object object, long l) {
            return this.unsafe.getLong(object, l);
        }

        public final void putLong(Object object, long l, long l2) {
            this.unsafe.putLong(object, l, l2);
        }

        public abstract boolean getBoolean(Object var1, long var2);

        public abstract void putBoolean(Object var1, long var2, boolean var4);

        public abstract float getFloat(Object var1, long var2);

        public abstract void putFloat(Object var1, long var2, float var4);

        public abstract double getDouble(Object var1, long var2);

        public abstract void putDouble(Object var1, long var2, double var4);

        public final Object getObject(Object object, long l) {
            return this.unsafe.getObject(object, l);
        }

        public final void putObject(Object object, long l, Object object2) {
            this.unsafe.putObject(object, l, object2);
        }

        public final int arrayBaseOffset(Class<?> clazz) {
            return this.unsafe.arrayBaseOffset(clazz);
        }

        public final int arrayIndexScale(Class<?> clazz) {
            return this.unsafe.arrayIndexScale(clazz);
        }

        public abstract byte getByte(long var1);

        public abstract void putByte(long var1, byte var3);

        public abstract int getInt(long var1);

        public abstract void putInt(long var1, int var3);

        public abstract long getLong(long var1);

        public abstract void putLong(long var1, long var3);

        public abstract Object getStaticObject(Field var1);

        public abstract void copyMemory(long var1, byte[] var3, long var4, long var6);

        public abstract void copyMemory(byte[] var1, long var2, long var4, long var6);
    }
}

