/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionSchema;
import com.google.protobuf.FieldInfo;
import com.google.protobuf.FieldSet;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.IntArrayList;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyFieldLite;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.LongArrayList;
import com.google.protobuf.MapFieldSchema;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Schema;
import com.google.protobuf.UnknownFieldSchema;
import com.google.protobuf.UnknownFieldSetLiteSchema;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.Writer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

final class SchemaUtil {
    private static final Class<?> GENERATED_MESSAGE_CLASS = SchemaUtil.getGeneratedMessageClass();
    private static final UnknownFieldSchema<?, ?> PROTO2_UNKNOWN_FIELD_SET_SCHEMA = SchemaUtil.getUnknownFieldSetSchema(false);
    private static final UnknownFieldSchema<?, ?> PROTO3_UNKNOWN_FIELD_SET_SCHEMA = SchemaUtil.getUnknownFieldSetSchema(true);
    private static final UnknownFieldSchema<?, ?> UNKNOWN_FIELD_SET_LITE_SCHEMA = new UnknownFieldSetLiteSchema();
    private static final int DEFAULT_LOOK_UP_START_NUMBER = 40;

    private SchemaUtil() {
    }

    public static void requireGeneratedMessage(Class<?> clazz) {
        if (!GeneratedMessageLite.class.isAssignableFrom(clazz) && GENERATED_MESSAGE_CLASS != null && !GENERATED_MESSAGE_CLASS.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Message classes must extend GeneratedMessage or GeneratedMessageLite");
        }
    }

    public static void writeDouble(int n, double d, Writer writer) throws IOException {
        if (Double.compare(d, 0.0) != 0) {
            writer.writeDouble(n, d);
        }
    }

    public static void writeFloat(int n, float f, Writer writer) throws IOException {
        if (Float.compare(f, 0.0f) != 0) {
            writer.writeFloat(n, f);
        }
    }

    public static void writeInt64(int n, long l, Writer writer) throws IOException {
        if (l != 0L) {
            writer.writeInt64(n, l);
        }
    }

    public static void writeUInt64(int n, long l, Writer writer) throws IOException {
        if (l != 0L) {
            writer.writeUInt64(n, l);
        }
    }

    public static void writeSInt64(int n, long l, Writer writer) throws IOException {
        if (l != 0L) {
            writer.writeSInt64(n, l);
        }
    }

    public static void writeFixed64(int n, long l, Writer writer) throws IOException {
        if (l != 0L) {
            writer.writeFixed64(n, l);
        }
    }

    public static void writeSFixed64(int n, long l, Writer writer) throws IOException {
        if (l != 0L) {
            writer.writeSFixed64(n, l);
        }
    }

    public static void writeInt32(int n, int n2, Writer writer) throws IOException {
        if (n2 != 0) {
            writer.writeInt32(n, n2);
        }
    }

    public static void writeUInt32(int n, int n2, Writer writer) throws IOException {
        if (n2 != 0) {
            writer.writeUInt32(n, n2);
        }
    }

    public static void writeSInt32(int n, int n2, Writer writer) throws IOException {
        if (n2 != 0) {
            writer.writeSInt32(n, n2);
        }
    }

    public static void writeFixed32(int n, int n2, Writer writer) throws IOException {
        if (n2 != 0) {
            writer.writeFixed32(n, n2);
        }
    }

    public static void writeSFixed32(int n, int n2, Writer writer) throws IOException {
        if (n2 != 0) {
            writer.writeSFixed32(n, n2);
        }
    }

    public static void writeEnum(int n, int n2, Writer writer) throws IOException {
        if (n2 != 0) {
            writer.writeEnum(n, n2);
        }
    }

    public static void writeBool(int n, boolean bl, Writer writer) throws IOException {
        if (bl) {
            writer.writeBool(n, true);
        }
    }

    public static void writeString(int n, Object object, Writer writer) throws IOException {
        if (object instanceof String) {
            SchemaUtil.writeStringInternal(n, (String)object, writer);
        } else {
            SchemaUtil.writeBytes(n, (ByteString)object, writer);
        }
    }

    private static void writeStringInternal(int n, String string, Writer writer) throws IOException {
        if (string != null && !string.isEmpty()) {
            writer.writeString(n, string);
        }
    }

    public static void writeBytes(int n, ByteString byteString, Writer writer) throws IOException {
        if (byteString != null && !byteString.isEmpty()) {
            writer.writeBytes(n, byteString);
        }
    }

    public static void writeMessage(int n, Object object, Writer writer) throws IOException {
        if (object != null) {
            writer.writeMessage(n, object);
        }
    }

    public static void writeDoubleList(int n, List<Double> list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeDoubleList(n, list, bl);
        }
    }

    public static void writeFloatList(int n, List<Float> list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeFloatList(n, list, bl);
        }
    }

    public static void writeInt64List(int n, List<Long> list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeInt64List(n, list, bl);
        }
    }

    public static void writeUInt64List(int n, List<Long> list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeUInt64List(n, list, bl);
        }
    }

    public static void writeSInt64List(int n, List<Long> list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeSInt64List(n, list, bl);
        }
    }

    public static void writeFixed64List(int n, List<Long> list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeFixed64List(n, list, bl);
        }
    }

    public static void writeSFixed64List(int n, List<Long> list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeSFixed64List(n, list, bl);
        }
    }

    public static void writeInt32List(int n, List<Integer> list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeInt32List(n, list, bl);
        }
    }

    public static void writeUInt32List(int n, List<Integer> list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeUInt32List(n, list, bl);
        }
    }

    public static void writeSInt32List(int n, List<Integer> list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeSInt32List(n, list, bl);
        }
    }

    public static void writeFixed32List(int n, List<Integer> list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeFixed32List(n, list, bl);
        }
    }

    public static void writeSFixed32List(int n, List<Integer> list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeSFixed32List(n, list, bl);
        }
    }

    public static void writeEnumList(int n, List<Integer> list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeEnumList(n, list, bl);
        }
    }

    public static void writeBoolList(int n, List<Boolean> list, Writer writer, boolean bl) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeBoolList(n, list, bl);
        }
    }

    public static void writeStringList(int n, List<String> list, Writer writer) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeStringList(n, list);
        }
    }

    public static void writeBytesList(int n, List<ByteString> list, Writer writer) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeBytesList(n, list);
        }
    }

    public static void writeMessageList(int n, List<?> list, Writer writer) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeMessageList(n, list);
        }
    }

    public static void writeMessageList(int n, List<?> list, Writer writer, Schema schema) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeMessageList(n, list, schema);
        }
    }

    public static void writeLazyFieldList(int n, List<?> list, Writer writer) throws IOException {
        if (list != null && !list.isEmpty()) {
            for (Object obj : list) {
                ((LazyFieldLite)obj).writeTo(writer, n);
            }
        }
    }

    public static void writeGroupList(int n, List<?> list, Writer writer) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeGroupList(n, list);
        }
    }

    public static void writeGroupList(int n, List<?> list, Writer writer, Schema schema) throws IOException {
        if (list != null && !list.isEmpty()) {
            writer.writeGroupList(n, list, schema);
        }
    }

    static int computeSizeInt64ListNoTag(List<Long> list) {
        int n = list.size();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        if (list instanceof LongArrayList) {
            LongArrayList longArrayList = (LongArrayList)list;
            for (int i = 0; i < n; ++i) {
                n2 += CodedOutputStream.computeInt64SizeNoTag(longArrayList.getLong(i));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                n2 += CodedOutputStream.computeInt64SizeNoTag(list.get(i));
            }
        }
        return n2;
    }

    static int computeSizeInt64List(int n, List<Long> list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeInt64ListNoTag(list);
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + list.size() * CodedOutputStream.computeTagSize(n);
    }

    static int computeSizeUInt64ListNoTag(List<Long> list) {
        int n = list.size();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        if (list instanceof LongArrayList) {
            LongArrayList longArrayList = (LongArrayList)list;
            for (int i = 0; i < n; ++i) {
                n2 += CodedOutputStream.computeUInt64SizeNoTag(longArrayList.getLong(i));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                n2 += CodedOutputStream.computeUInt64SizeNoTag(list.get(i));
            }
        }
        return n2;
    }

    static int computeSizeUInt64List(int n, List<Long> list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeUInt64ListNoTag(list);
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(n);
    }

    static int computeSizeSInt64ListNoTag(List<Long> list) {
        int n = list.size();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        if (list instanceof LongArrayList) {
            LongArrayList longArrayList = (LongArrayList)list;
            for (int i = 0; i < n; ++i) {
                n2 += CodedOutputStream.computeSInt64SizeNoTag(longArrayList.getLong(i));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                n2 += CodedOutputStream.computeSInt64SizeNoTag(list.get(i));
            }
        }
        return n2;
    }

    static int computeSizeSInt64List(int n, List<Long> list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeSInt64ListNoTag(list);
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(n);
    }

    static int computeSizeEnumListNoTag(List<Integer> list) {
        int n = list.size();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            for (int i = 0; i < n; ++i) {
                n2 += CodedOutputStream.computeEnumSizeNoTag(intArrayList.getInt(i));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                n2 += CodedOutputStream.computeEnumSizeNoTag(list.get(i));
            }
        }
        return n2;
    }

    static int computeSizeEnumList(int n, List<Integer> list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeEnumListNoTag(list);
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(n);
    }

    static int computeSizeInt32ListNoTag(List<Integer> list) {
        int n = list.size();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            for (int i = 0; i < n; ++i) {
                n2 += CodedOutputStream.computeInt32SizeNoTag(intArrayList.getInt(i));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                n2 += CodedOutputStream.computeInt32SizeNoTag(list.get(i));
            }
        }
        return n2;
    }

    static int computeSizeInt32List(int n, List<Integer> list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeInt32ListNoTag(list);
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(n);
    }

    static int computeSizeUInt32ListNoTag(List<Integer> list) {
        int n = list.size();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            for (int i = 0; i < n; ++i) {
                n2 += CodedOutputStream.computeUInt32SizeNoTag(intArrayList.getInt(i));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                n2 += CodedOutputStream.computeUInt32SizeNoTag(list.get(i));
            }
        }
        return n2;
    }

    static int computeSizeUInt32List(int n, List<Integer> list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeUInt32ListNoTag(list);
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(n);
    }

    static int computeSizeSInt32ListNoTag(List<Integer> list) {
        int n = list.size();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            for (int i = 0; i < n; ++i) {
                n2 += CodedOutputStream.computeSInt32SizeNoTag(intArrayList.getInt(i));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                n2 += CodedOutputStream.computeSInt32SizeNoTag(list.get(i));
            }
        }
        return n2;
    }

    static int computeSizeSInt32List(int n, List<Integer> list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeSInt32ListNoTag(list);
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(n);
    }

    static int computeSizeFixed32ListNoTag(List<?> list) {
        return list.size() * 4;
    }

    static int computeSizeFixed32List(int n, List<?> list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        if (bl) {
            int n3 = n2 * 4;
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n2 * CodedOutputStream.computeFixed32Size(n, 0);
    }

    static int computeSizeFixed64ListNoTag(List<?> list) {
        return list.size() * 8;
    }

    static int computeSizeFixed64List(int n, List<?> list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        if (bl) {
            int n3 = n2 * 8;
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n2 * CodedOutputStream.computeFixed64Size(n, 0L);
    }

    static int computeSizeBoolListNoTag(List<?> list) {
        return list.size();
    }

    static int computeSizeBoolList(int n, List<?> list, boolean bl) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        if (bl) {
            return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLengthDelimitedFieldSize(n2);
        }
        return n2 * CodedOutputStream.computeBoolSize(n, true);
    }

    static int computeSizeStringList(int n, List<?> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = n2 * CodedOutputStream.computeTagSize(n);
        if (list instanceof LazyStringList) {
            LazyStringList lazyStringList = (LazyStringList)list;
            for (int i = 0; i < n2; ++i) {
                Object object = lazyStringList.getRaw(i);
                if (object instanceof ByteString) {
                    n3 += CodedOutputStream.computeBytesSizeNoTag((ByteString)object);
                    continue;
                }
                n3 += CodedOutputStream.computeStringSizeNoTag((String)object);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                Object obj = list.get(i);
                if (obj instanceof ByteString) {
                    n3 += CodedOutputStream.computeBytesSizeNoTag((ByteString)obj);
                    continue;
                }
                n3 += CodedOutputStream.computeStringSizeNoTag((String)obj);
            }
        }
        return n3;
    }

    static int computeSizeMessage(int n, Object object, Schema schema) {
        if (object instanceof LazyFieldLite) {
            return CodedOutputStream.computeLazyFieldSize(n, (LazyFieldLite)object);
        }
        return CodedOutputStream.computeMessageSize(n, (MessageLite)object, schema);
    }

    static int computeSizeMessageList(int n, List<?> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = n2 * CodedOutputStream.computeTagSize(n);
        for (int i = 0; i < n2; ++i) {
            Object obj = list.get(i);
            if (obj instanceof LazyFieldLite) {
                n3 += CodedOutputStream.computeLazyFieldSizeNoTag((LazyFieldLite)obj);
                continue;
            }
            n3 += CodedOutputStream.computeMessageSizeNoTag((MessageLite)obj);
        }
        return n3;
    }

    static int computeSizeMessageList(int n, List<?> list, Schema schema) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = n2 * CodedOutputStream.computeTagSize(n);
        for (int i = 0; i < n2; ++i) {
            Object obj = list.get(i);
            if (obj instanceof LazyFieldLite) {
                n3 += CodedOutputStream.computeLazyFieldSizeNoTag((LazyFieldLite)obj);
                continue;
            }
            n3 += CodedOutputStream.computeMessageSizeNoTag((MessageLite)obj, schema);
        }
        return n3;
    }

    static int computeSizeByteStringList(int n, List<ByteString> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = n2 * CodedOutputStream.computeTagSize(n);
        for (int i = 0; i < list.size(); ++i) {
            n3 += CodedOutputStream.computeBytesSizeNoTag(list.get(i));
        }
        return n3;
    }

    static int computeSizeGroupList(int n, List<MessageLite> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += CodedOutputStream.computeGroupSize(n, list.get(i));
        }
        return n3;
    }

    static int computeSizeGroupList(int n, List<MessageLite> list, Schema schema) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += CodedOutputStream.computeGroupSize(n, list.get(i), schema);
        }
        return n3;
    }

    public static boolean shouldUseTableSwitch(FieldInfo[] fieldInfoArray) {
        if (fieldInfoArray.length == 0) {
            return false;
        }
        int n = fieldInfoArray[0].getFieldNumber();
        int n2 = fieldInfoArray[fieldInfoArray.length - 1].getFieldNumber();
        return SchemaUtil.shouldUseTableSwitch(n, n2, fieldInfoArray.length);
    }

    public static boolean shouldUseTableSwitch(int n, int n2, int n3) {
        if (n2 < 40) {
            return true;
        }
        long l = (long)n2 - (long)n + 1L;
        long l2 = 3L;
        long l3 = 3L + 2L * (long)n3;
        long l4 = 3L + (long)n3;
        return l + 3L * l2 <= l3 + 3L * l4;
    }

    public static UnknownFieldSchema<?, ?> proto2UnknownFieldSetSchema() {
        return PROTO2_UNKNOWN_FIELD_SET_SCHEMA;
    }

    public static UnknownFieldSchema<?, ?> proto3UnknownFieldSetSchema() {
        return PROTO3_UNKNOWN_FIELD_SET_SCHEMA;
    }

    public static UnknownFieldSchema<?, ?> unknownFieldSetLiteSchema() {
        return UNKNOWN_FIELD_SET_LITE_SCHEMA;
    }

    private static UnknownFieldSchema<?, ?> getUnknownFieldSetSchema(boolean bl) {
        try {
            Class<?> clazz = SchemaUtil.getUnknownFieldSetSchemaClass();
            if (clazz == null) {
                return null;
            }
            return (UnknownFieldSchema)clazz.getConstructor(Boolean.TYPE).newInstance(bl);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class<?> getGeneratedMessageClass() {
        try {
            return Class.forName("com.google.protobuf.GeneratedMessageV3");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class<?> getUnknownFieldSetSchemaClass() {
        try {
            return Class.forName("com.google.protobuf.UnknownFieldSetSchema");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static Object getMapDefaultEntry(Class<?> clazz, String string) {
        try {
            Class<?> clazz2 = Class.forName(clazz.getName() + "$" + SchemaUtil.toCamelCase(string, true) + "DefaultEntryHolder");
            Field[] fieldArray = clazz2.getDeclaredFields();
            if (fieldArray.length != 1) {
                throw new IllegalStateException("Unable to look up map field default entry holder class for " + string + " in " + clazz.getName());
            }
            return UnsafeUtil.getStaticObject(fieldArray[0]);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static String toCamelCase(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('a' <= c && c <= 'z') {
                if (bl) {
                    stringBuilder.append((char)(c + -32));
                } else {
                    stringBuilder.append(c);
                }
                bl = false;
                continue;
            }
            if ('A' <= c && c <= 'Z') {
                if (i == 0 && !bl) {
                    stringBuilder.append((char)(c - -32));
                } else {
                    stringBuilder.append(c);
                }
                bl = false;
                continue;
            }
            if ('0' <= c && c <= '9') {
                stringBuilder.append(c);
                bl = true;
                continue;
            }
            bl = true;
        }
        return stringBuilder.toString();
    }

    static boolean safeEquals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    static <T> void mergeMap(MapFieldSchema mapFieldSchema, T t, T t2, long l) {
        Object object = mapFieldSchema.mergeFrom(UnsafeUtil.getObject(t, l), UnsafeUtil.getObject(t2, l));
        UnsafeUtil.putObject(t, l, object);
    }

    static <T, FT extends FieldSet.FieldDescriptorLite<FT>> void mergeExtensions(ExtensionSchema<FT> extensionSchema, T t, T t2) {
        FieldSet<FT> fieldSet = extensionSchema.getExtensions(t2);
        if (!fieldSet.isEmpty()) {
            FieldSet<FT> fieldSet2 = extensionSchema.getMutableExtensions(t);
            fieldSet2.mergeFrom(fieldSet);
        }
    }

    static <T, UT, UB> void mergeUnknownFields(UnknownFieldSchema<UT, UB> unknownFieldSchema, T t, T t2) {
        UT UT = unknownFieldSchema.getFromMessage(t);
        UT UT2 = unknownFieldSchema.getFromMessage(t2);
        UT UT3 = unknownFieldSchema.merge(UT, UT2);
        unknownFieldSchema.setToMessage(t, UT3);
    }

    static <UT, UB> UB filterUnknownEnumList(int n, List<Integer> list, Internal.EnumLiteMap<?> enumLiteMap, UB UB, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        if (enumLiteMap == null) {
            return UB;
        }
        if (list instanceof RandomAccess) {
            int n2 = 0;
            int n3 = list.size();
            for (int i = 0; i < n3; ++i) {
                int n4 = list.get(i);
                if (enumLiteMap.findValueByNumber(n4) != null) {
                    if (i != n2) {
                        list.set(n2, n4);
                    }
                    ++n2;
                    continue;
                }
                UB = SchemaUtil.storeUnknownEnum(n, n4, UB, unknownFieldSchema);
            }
            if (n2 != n3) {
                list.subList(n2, n3).clear();
            }
        } else {
            Iterator<Integer> iterator = list.iterator();
            while (iterator.hasNext()) {
                int n5 = iterator.next();
                if (enumLiteMap.findValueByNumber(n5) != null) continue;
                UB = SchemaUtil.storeUnknownEnum(n, n5, UB, unknownFieldSchema);
                iterator.remove();
            }
        }
        return UB;
    }

    static <UT, UB> UB filterUnknownEnumList(int n, List<Integer> list, Internal.EnumVerifier enumVerifier, UB UB, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        if (enumVerifier == null) {
            return UB;
        }
        if (list instanceof RandomAccess) {
            int n2 = 0;
            int n3 = list.size();
            for (int i = 0; i < n3; ++i) {
                int n4 = list.get(i);
                if (enumVerifier.isInRange(n4)) {
                    if (i != n2) {
                        list.set(n2, n4);
                    }
                    ++n2;
                    continue;
                }
                UB = SchemaUtil.storeUnknownEnum(n, n4, UB, unknownFieldSchema);
            }
            if (n2 != n3) {
                list.subList(n2, n3).clear();
            }
        } else {
            Iterator<Integer> iterator = list.iterator();
            while (iterator.hasNext()) {
                int n5 = iterator.next();
                if (enumVerifier.isInRange(n5)) continue;
                UB = SchemaUtil.storeUnknownEnum(n, n5, UB, unknownFieldSchema);
                iterator.remove();
            }
        }
        return UB;
    }

    static <UT, UB> UB storeUnknownEnum(int n, int n2, UB UB, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        if (UB == null) {
            UB = unknownFieldSchema.newBuilder();
        }
        unknownFieldSchema.addVarint(UB, n, n2);
        return UB;
    }
}

