/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.MessageInfo;
import com.google.protobuf.MessageLite;
import com.google.protobuf.ProtoSyntax;

final class RawMessageInfo
implements MessageInfo {
    private final MessageLite defaultInstance;
    private final String info;
    private final Object[] objects;
    private final int flags;

    RawMessageInfo(MessageLite messageLite, String string, Object[] objectArray) {
        this.defaultInstance = messageLite;
        this.info = string;
        this.objects = objectArray;
        int n = 0;
        char c = string.charAt(n++);
        if (c < '\ud800') {
            this.flags = c;
        } else {
            int n2 = c & 0x1FFF;
            int n3 = 13;
            while ((c = string.charAt(n++)) >= '\ud800') {
                n2 |= (c & 0x1FFF) << n3;
                n3 += 13;
            }
            this.flags = n2 | c << n3;
        }
    }

    String getStringInfo() {
        return this.info;
    }

    Object[] getObjects() {
        return this.objects;
    }

    @Override
    public MessageLite getDefaultInstance() {
        return this.defaultInstance;
    }

    @Override
    public ProtoSyntax getSyntax() {
        return (this.flags & 1) == 1 ? ProtoSyntax.PROTO2 : ProtoSyntax.PROTO3;
    }

    @Override
    public boolean isMessageSetWireFormat() {
        return (this.flags & 2) == 2;
    }
}

