/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Internal;
import com.google.protobuf.ManifestSchemaFactory;
import com.google.protobuf.MessageSchema;
import com.google.protobuf.Reader;
import com.google.protobuf.Schema;
import com.google.protobuf.SchemaFactory;
import com.google.protobuf.Writer;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class Protobuf {
    private static final Protobuf INSTANCE = new Protobuf();
    private final SchemaFactory schemaFactory;
    private final ConcurrentMap<Class<?>, Schema<?>> schemaCache = new ConcurrentHashMap();

    public static Protobuf getInstance() {
        return INSTANCE;
    }

    public <T> void writeTo(T t, Writer writer) throws IOException {
        this.schemaFor(t).writeTo(t, writer);
    }

    public <T> void mergeFrom(T t, Reader reader) throws IOException {
        this.mergeFrom(t, reader, ExtensionRegistryLite.getEmptyRegistry());
    }

    public <T> void mergeFrom(T t, Reader reader, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        this.schemaFor(t).mergeFrom(t, reader, extensionRegistryLite);
    }

    public <T> void makeImmutable(T t) {
        this.schemaFor(t).makeImmutable(t);
    }

    public <T> boolean isInitialized(T t) {
        return this.schemaFor(t).isInitialized(t);
    }

    public <T> Schema<T> schemaFor(Class<T> clazz) {
        Schema<?> schema;
        Internal.checkNotNull(clazz, "messageType");
        Schema<Object> schema2 = (Schema<T>)this.schemaCache.get(clazz);
        if (schema2 == null && (schema = this.registerSchema(clazz, schema2 = this.schemaFactory.createSchema(clazz))) != null) {
            schema2 = schema;
        }
        return schema2;
    }

    public <T> Schema<T> schemaFor(T t) {
        return this.schemaFor((T)t.getClass());
    }

    public Schema<?> registerSchema(Class<?> clazz, Schema<?> schema) {
        Internal.checkNotNull(clazz, "messageType");
        Internal.checkNotNull(schema, "schema");
        return this.schemaCache.putIfAbsent(clazz, schema);
    }

    public Schema<?> registerSchemaOverride(Class<?> clazz, Schema<?> schema) {
        Internal.checkNotNull(clazz, "messageType");
        Internal.checkNotNull(schema, "schema");
        return this.schemaCache.put(clazz, schema);
    }

    private Protobuf() {
        this.schemaFactory = new ManifestSchemaFactory();
    }

    int getTotalSchemaSize() {
        int n = 0;
        for (Schema schema : this.schemaCache.values()) {
            if (!(schema instanceof MessageSchema)) continue;
            n += ((MessageSchema)schema).getSchemaSize();
        }
        return n;
    }
}

