/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.TextFormatEscaper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

final class MessageLiteToString {
    private static final String LIST_SUFFIX = "List";
    private static final String BUILDER_LIST_SUFFIX = "OrBuilderList";
    private static final String MAP_SUFFIX = "Map";
    private static final String BYTES_SUFFIX = "Bytes";

    MessageLiteToString() {
    }

    static String toString(MessageLite messageLite, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# ").append(string);
        MessageLiteToString.reflectivePrintWithIndent(messageLite, stringBuilder, 0);
        return stringBuilder.toString();
    }

    private static void reflectivePrintWithIndent(MessageLite messageLite, StringBuilder stringBuilder, int n) {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        HashMap<String, Method> hashMap2 = new HashMap<String, Method>();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Method object2 : messageLite.getClass().getDeclaredMethods()) {
            hashMap2.put(object2.getName(), object2);
            if (object2.getParameterTypes().length != 0) continue;
            hashMap.put(object2.getName(), object2);
            if (!object2.getName().startsWith("get")) continue;
            treeSet.add(object2.getName());
        }
        for (String string : treeSet) {
            Method method;
            Object object;
            String string2;
            String string3 = string2 = string.startsWith("get") ? string.substring(3) : string;
            if (string2.endsWith(LIST_SUFFIX) && !string2.endsWith(BUILDER_LIST_SUFFIX) && !string2.equals(LIST_SUFFIX)) {
                String string4 = string2.substring(0, 1).toLowerCase() + string2.substring(1, string2.length() - LIST_SUFFIX.length());
                object = (Method)hashMap.get(string);
                if (object != null && ((Method)object).getReturnType().equals(List.class)) {
                    MessageLiteToString.printField(stringBuilder, n, MessageLiteToString.camelCaseToSnakeCase(string4), GeneratedMessageLite.invokeOrDie((Method)object, messageLite, new Object[0]));
                    continue;
                }
            }
            if (string2.endsWith(MAP_SUFFIX) && !string2.equals(MAP_SUFFIX)) {
                String string5 = string2.substring(0, 1).toLowerCase() + string2.substring(1, string2.length() - MAP_SUFFIX.length());
                object = (Method)hashMap.get(string);
                if (object != null && ((Method)object).getReturnType().equals(Map.class) && !((AccessibleObject)object).isAnnotationPresent(Deprecated.class) && Modifier.isPublic(((Method)object).getModifiers())) {
                    MessageLiteToString.printField(stringBuilder, n, MessageLiteToString.camelCaseToSnakeCase(string5), GeneratedMessageLite.invokeOrDie((Method)object, messageLite, new Object[0]));
                    continue;
                }
            }
            if ((method = (Method)hashMap2.get("set" + string2)) == null || string2.endsWith(BYTES_SUFFIX) && hashMap.containsKey("get" + string2.substring(0, string2.length() - BYTES_SUFFIX.length()))) continue;
            object = string2.substring(0, 1).toLowerCase() + string2.substring(1);
            Method method2 = (Method)hashMap.get("get" + string2);
            Method method3 = (Method)hashMap.get("has" + string2);
            if (method2 == null) continue;
            Object object2 = GeneratedMessageLite.invokeOrDie(method2, messageLite, new Object[0]);
            boolean bl = method3 == null ? !MessageLiteToString.isDefaultValue(object2) : (Boolean)GeneratedMessageLite.invokeOrDie(method3, messageLite, new Object[0]);
            boolean bl2 = bl;
            if (!bl2) continue;
            MessageLiteToString.printField(stringBuilder, n, MessageLiteToString.camelCaseToSnakeCase((String)object), object2);
        }
        if (messageLite instanceof GeneratedMessageLite.ExtendableMessage) {
            Iterator<Map.Entry<GeneratedMessageLite.ExtensionDescriptor, Object>> iterator = ((GeneratedMessageLite.ExtendableMessage)messageLite).extensions.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                MessageLiteToString.printField(stringBuilder, n, "[" + ((GeneratedMessageLite.ExtensionDescriptor)entry.getKey()).getNumber() + "]", entry.getValue());
            }
        }
        if (((GeneratedMessageLite)messageLite).unknownFields != null) {
            ((GeneratedMessageLite)messageLite).unknownFields.printWithIndent(stringBuilder, n);
        }
    }

    private static boolean isDefaultValue(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object == false;
        }
        if (object instanceof Integer) {
            return (Integer)object == 0;
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue() == 0.0f;
        }
        if (object instanceof Double) {
            return (Double)object == 0.0;
        }
        if (object instanceof String) {
            return object.equals("");
        }
        if (object instanceof ByteString) {
            return object.equals(ByteString.EMPTY);
        }
        if (object instanceof MessageLite) {
            return object == ((MessageLite)object).getDefaultInstanceForType();
        }
        if (object instanceof Enum) {
            return ((Enum)object).ordinal() == 0;
        }
        return false;
    }

    static final void printField(StringBuilder stringBuilder, int n, String string, Object object) {
        int n2;
        if (object instanceof List) {
            List list = (List)object;
            for (Object e : list) {
                MessageLiteToString.printField(stringBuilder, n, string, e);
            }
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                MessageLiteToString.printField(stringBuilder, n, string, entry);
            }
            return;
        }
        stringBuilder.append('\n');
        for (n2 = 0; n2 < n; ++n2) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(string);
        if (object instanceof String) {
            stringBuilder.append(": \"").append(TextFormatEscaper.escapeText((String)object)).append('\"');
        } else if (object instanceof ByteString) {
            stringBuilder.append(": \"").append(TextFormatEscaper.escapeBytes((ByteString)object)).append('\"');
        } else if (object instanceof GeneratedMessageLite) {
            stringBuilder.append(" {");
            MessageLiteToString.reflectivePrintWithIndent((GeneratedMessageLite)object, stringBuilder, n + 2);
            stringBuilder.append("\n");
            for (n2 = 0; n2 < n; ++n2) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("}");
        } else if (object instanceof Map.Entry) {
            stringBuilder.append(" {");
            Map.Entry entry = (Map.Entry)object;
            MessageLiteToString.printField(stringBuilder, n + 2, "key", entry.getKey());
            MessageLiteToString.printField(stringBuilder, n + 2, "value", entry.getValue());
            stringBuilder.append("\n");
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("}");
        } else {
            stringBuilder.append(": ").append(object.toString());
        }
    }

    private static final String camelCaseToSnakeCase(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                stringBuilder.append("_");
            }
            stringBuilder.append(Character.toLowerCase(c));
        }
        return stringBuilder.toString();
    }
}

