/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyField;
import com.google.protobuf.MessageLite;
import com.google.protobuf.SmallSortedMap;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldSet<T extends FieldDescriptorLite<T>> {
    private static final int DEFAULT_FIELD_MAP_ARRAY_SIZE = 16;
    private final SmallSortedMap<T, Object> fields;
    private boolean isImmutable;
    private boolean hasLazyField;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(true);

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(boolean bl) {
        this(SmallSortedMap.newFieldMap(0));
        this.makeImmutable();
    }

    private FieldSet(SmallSortedMap<T, Object> smallSortedMap) {
        this.fields = smallSortedMap;
        this.makeImmutable();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet<T>();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    public static <T extends FieldDescriptorLite<T>> Builder<T> newBuilder() {
        return new Builder();
    }

    boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FieldSet)) {
            return false;
        }
        FieldSet fieldSet = (FieldSet)object;
        return this.fields.equals(fieldSet.fields);
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public FieldSet<T> clone() {
        FieldSet<FieldDescriptorLite> fieldSet = FieldSet.newFieldSet();
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            fieldSet.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            fieldSet.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        fieldSet.hasLazyField = this.hasLazyField;
        return fieldSet;
    }

    public void clear() {
        this.fields.clear();
        this.hasLazyField = false;
    }

    public Map<T, Object> getAllFields() {
        if (this.hasLazyField) {
            SmallSortedMap<T, Object> smallSortedMap = FieldSet.cloneAllFieldsMap(this.fields, false);
            if (this.fields.isImmutable()) {
                smallSortedMap.makeImmutable();
            }
            return smallSortedMap;
        }
        return this.fields.isImmutable() ? this.fields : Collections.unmodifiableMap(this.fields);
    }

    private static <T extends FieldDescriptorLite<T>> SmallSortedMap<T, Object> cloneAllFieldsMap(SmallSortedMap<T, Object> smallSortedMap, boolean bl) {
        SmallSortedMap smallSortedMap2 = SmallSortedMap.newFieldMap(16);
        for (int i = 0; i < smallSortedMap.getNumArrayEntries(); ++i) {
            FieldSet.cloneFieldEntry(smallSortedMap2, smallSortedMap.getArrayEntryAt(i), bl);
        }
        for (Map.Entry<T, Object> entry : smallSortedMap.getOverflowEntries()) {
            FieldSet.cloneFieldEntry(smallSortedMap2, entry, bl);
        }
        return smallSortedMap2;
    }

    private static <T extends FieldDescriptorLite<T>> void cloneFieldEntry(Map<T, Object> map, Map.Entry<T, Object> entry, boolean bl) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        Object object = entry.getValue();
        if (object instanceof LazyField) {
            map.put(fieldDescriptorLite, ((LazyField)object).getValue());
        } else if (bl && object instanceof List) {
            map.put(fieldDescriptorLite, new ArrayList((List)object));
        } else {
            map.put(fieldDescriptorLite, object);
        }
    }

    public Iterator<Map.Entry<T, Object>> iterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    Iterator<Map.Entry<T, Object>> descendingIterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.descendingEntrySet().iterator());
        }
        return this.fields.descendingEntrySet().iterator();
    }

    public boolean hasField(T t) {
        if (t.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.get(t) != null;
    }

    public Object getField(T t) {
        Object object = this.fields.get(t);
        if (object instanceof LazyField) {
            return ((LazyField)object).getValue();
        }
        return object;
    }

    public void setField(T t, Object arrayList) {
        if (t.isRepeated()) {
            if (!(arrayList instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList arrayList2 = new ArrayList();
            arrayList2.addAll(arrayList);
            for (Object e : arrayList2) {
                this.verifyType(t.getLiteType(), e);
            }
            arrayList = arrayList2;
        } else {
            this.verifyType(t.getLiteType(), arrayList);
        }
        if (arrayList instanceof LazyField) {
            this.hasLazyField = true;
        }
        this.fields.put(t, (Object)arrayList);
    }

    public void clearField(T t) {
        this.fields.remove(t);
        if (this.fields.isEmpty()) {
            this.hasLazyField = false;
        }
    }

    public int getRepeatedFieldCount(T t) {
        if (!t.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object = this.getField(t);
        if (object == null) {
            return 0;
        }
        return ((List)object).size();
    }

    public Object getRepeatedField(T t, int n) {
        if (!t.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object = this.getField(t);
        if (object == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((List)object).get(n);
    }

    public void setRepeatedField(T t, int n, Object object) {
        if (!t.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object2 = this.getField(t);
        if (object2 == null) {
            throw new IndexOutOfBoundsException();
        }
        this.verifyType(t.getLiteType(), object);
        ((List)object2).set(n, object);
    }

    public void addRepeatedField(T t, Object object) {
        ArrayList<Object> arrayList;
        if (!t.isRepeated()) {
            throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
        }
        this.verifyType(t.getLiteType(), object);
        Object object2 = this.getField(t);
        if (object2 == null) {
            arrayList = new ArrayList<Object>();
            this.fields.put(t, (Object)arrayList);
        } else {
            arrayList = (ArrayList<Object>)object2;
        }
        arrayList.add(object);
    }

    private void verifyType(WireFormat.FieldType fieldType, Object object) {
        if (!FieldSet.isValidType(fieldType, object)) {
            throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
        }
    }

    private static boolean isValidType(WireFormat.FieldType fieldType, Object object) {
        Internal.checkNotNull(object);
        switch (fieldType.getJavaType()) {
            case INT: {
                return object instanceof Integer;
            }
            case LONG: {
                return object instanceof Long;
            }
            case FLOAT: {
                return object instanceof Float;
            }
            case DOUBLE: {
                return object instanceof Double;
            }
            case BOOLEAN: {
                return object instanceof Boolean;
            }
            case STRING: {
                return object instanceof String;
            }
            case BYTE_STRING: {
                return object instanceof ByteString || object instanceof byte[];
            }
            case ENUM: {
                return object instanceof Integer || object instanceof Internal.EnumLite;
            }
            case MESSAGE: {
                return object instanceof MessageLite || object instanceof LazyField;
            }
        }
        return false;
    }

    public boolean isInitialized() {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i))) continue;
            return false;
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            if (FieldSet.isInitialized(entry)) continue;
            return false;
        }
        return true;
    }

    private static <T extends FieldDescriptorLite<T>> boolean isInitialized(Map.Entry<T, Object> entry) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            if (fieldDescriptorLite.isRepeated()) {
                for (MessageLite messageLite : (List)entry.getValue()) {
                    if (messageLite.isInitialized()) continue;
                    return false;
                }
            } else {
                Object object = entry.getValue();
                if (object instanceof MessageLite) {
                    if (!((MessageLite)object).isInitialized()) {
                        return false;
                    }
                } else {
                    if (object instanceof LazyField) {
                        return true;
                    }
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
            }
        }
        return true;
    }

    static int getWireFormatForFieldType(WireFormat.FieldType fieldType, boolean bl) {
        if (bl) {
            return 2;
        }
        return fieldType.getWireType();
    }

    public void mergeFrom(FieldSet<T> fieldSet) {
        for (int i = 0; i < fieldSet.fields.getNumArrayEntries(); ++i) {
            this.mergeFromField(fieldSet.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<T, Object> entry : fieldSet.fields.getOverflowEntries()) {
            this.mergeFromField(entry);
        }
    }

    private static Object cloneIfMutable(Object object) {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return byArray2;
        }
        return object;
    }

    private void mergeFromField(Map.Entry<T, Object> entry) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        Object object = entry.getValue();
        if (object instanceof LazyField) {
            object = ((LazyField)object).getValue();
        }
        if (fieldDescriptorLite.isRepeated()) {
            ArrayList arrayList = this.getField(fieldDescriptorLite);
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            for (Object e : (List)object) {
                ((List)arrayList).add(FieldSet.cloneIfMutable(e));
            }
            this.fields.put((T)fieldDescriptorLite, (Object)arrayList);
        } else if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            Object object2 = this.getField(fieldDescriptorLite);
            if (object2 == null) {
                this.fields.put((T)fieldDescriptorLite, FieldSet.cloneIfMutable(object));
            } else {
                object2 = fieldDescriptorLite.internalMergeFrom(((MessageLite)object2).toBuilder(), (MessageLite)object).build();
                this.fields.put((T)fieldDescriptorLite, object2);
            }
        } else {
            this.fields.put((T)fieldDescriptorLite, FieldSet.cloneIfMutable(object));
        }
    }

    public static Object readPrimitiveField(CodedInputStream codedInputStream, WireFormat.FieldType fieldType, boolean bl) throws IOException {
        if (bl) {
            return WireFormat.readPrimitiveField(codedInputStream, fieldType, WireFormat.Utf8Validation.STRICT);
        }
        return WireFormat.readPrimitiveField(codedInputStream, fieldType, WireFormat.Utf8Validation.LOOSE);
    }

    public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), codedOutputStream);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), codedOutputStream);
        }
    }

    public void writeMessageSetTo(CodedOutputStream codedOutputStream) throws IOException {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            this.writeMessageSetTo(this.fields.getArrayEntryAt(i), codedOutputStream);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            this.writeMessageSetTo(entry, codedOutputStream);
        }
    }

    private void writeMessageSetTo(Map.Entry<T, Object> entry, CodedOutputStream codedOutputStream) throws IOException {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !fieldDescriptorLite.isRepeated() && !fieldDescriptorLite.isPacked()) {
            Object object = entry.getValue();
            if (object instanceof LazyField) {
                object = ((LazyField)object).getValue();
            }
            codedOutputStream.writeMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)object);
        } else {
            FieldSet.writeField(fieldDescriptorLite, entry.getValue(), codedOutputStream);
        }
    }

    static void writeElement(CodedOutputStream codedOutputStream, WireFormat.FieldType fieldType, int n, Object object) throws IOException {
        if (fieldType == WireFormat.FieldType.GROUP) {
            codedOutputStream.writeGroup(n, (MessageLite)object);
        } else {
            codedOutputStream.writeTag(n, FieldSet.getWireFormatForFieldType(fieldType, false));
            FieldSet.writeElementNoTag(codedOutputStream, fieldType, object);
        }
    }

    static void writeElementNoTag(CodedOutputStream codedOutputStream, WireFormat.FieldType fieldType, Object object) throws IOException {
        switch (fieldType) {
            case DOUBLE: {
                codedOutputStream.writeDoubleNoTag((Double)object);
                break;
            }
            case FLOAT: {
                codedOutputStream.writeFloatNoTag(((Float)object).floatValue());
                break;
            }
            case INT64: {
                codedOutputStream.writeInt64NoTag((Long)object);
                break;
            }
            case UINT64: {
                codedOutputStream.writeUInt64NoTag((Long)object);
                break;
            }
            case INT32: {
                codedOutputStream.writeInt32NoTag((Integer)object);
                break;
            }
            case FIXED64: {
                codedOutputStream.writeFixed64NoTag((Long)object);
                break;
            }
            case FIXED32: {
                codedOutputStream.writeFixed32NoTag((Integer)object);
                break;
            }
            case BOOL: {
                codedOutputStream.writeBoolNoTag((Boolean)object);
                break;
            }
            case GROUP: {
                codedOutputStream.writeGroupNoTag((MessageLite)object);
                break;
            }
            case MESSAGE: {
                codedOutputStream.writeMessageNoTag((MessageLite)object);
                break;
            }
            case STRING: {
                if (object instanceof ByteString) {
                    codedOutputStream.writeBytesNoTag((ByteString)object);
                    break;
                }
                codedOutputStream.writeStringNoTag((String)object);
                break;
            }
            case BYTES: {
                if (object instanceof ByteString) {
                    codedOutputStream.writeBytesNoTag((ByteString)object);
                    break;
                }
                codedOutputStream.writeByteArrayNoTag((byte[])object);
                break;
            }
            case UINT32: {
                codedOutputStream.writeUInt32NoTag((Integer)object);
                break;
            }
            case SFIXED32: {
                codedOutputStream.writeSFixed32NoTag((Integer)object);
                break;
            }
            case SFIXED64: {
                codedOutputStream.writeSFixed64NoTag((Long)object);
                break;
            }
            case SINT32: {
                codedOutputStream.writeSInt32NoTag((Integer)object);
                break;
            }
            case SINT64: {
                codedOutputStream.writeSInt64NoTag((Long)object);
                break;
            }
            case ENUM: {
                if (object instanceof Internal.EnumLite) {
                    codedOutputStream.writeEnumNoTag(((Internal.EnumLite)object).getNumber());
                    break;
                }
                codedOutputStream.writeEnumNoTag((Integer)object);
            }
        }
    }

    public static void writeField(FieldDescriptorLite<?> fieldDescriptorLite, Object object, CodedOutputStream codedOutputStream) throws IOException {
        WireFormat.FieldType fieldType = fieldDescriptorLite.getLiteType();
        int n = fieldDescriptorLite.getNumber();
        if (fieldDescriptorLite.isRepeated()) {
            List list = (List)object;
            if (fieldDescriptorLite.isPacked()) {
                codedOutputStream.writeTag(n, 2);
                int n2 = 0;
                for (Object e : list) {
                    n2 += FieldSet.computeElementSizeNoTag(fieldType, e);
                }
                codedOutputStream.writeRawVarint32(n2);
                for (Object e : list) {
                    FieldSet.writeElementNoTag(codedOutputStream, fieldType, e);
                }
            } else {
                for (Object e : list) {
                    FieldSet.writeElement(codedOutputStream, fieldType, n, e);
                }
            }
        } else if (object instanceof LazyField) {
            FieldSet.writeElement(codedOutputStream, fieldType, n, ((LazyField)object).getValue());
        } else {
            FieldSet.writeElement(codedOutputStream, fieldType, n, object);
        }
    }

    public int getSerializedSize() {
        int n = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            n += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            n += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return n;
    }

    public int getMessageSetSerializedSize() {
        int n = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            n += this.getMessageSetSerializedSize(this.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            n += this.getMessageSetSerializedSize(entry);
        }
        return n;
    }

    private int getMessageSetSerializedSize(Map.Entry<T, Object> entry) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        Object object = entry.getValue();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !fieldDescriptorLite.isRepeated() && !fieldDescriptorLite.isPacked()) {
            if (object instanceof LazyField) {
                return CodedOutputStream.computeLazyFieldMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (LazyField)object);
            }
            return CodedOutputStream.computeMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)object);
        }
        return FieldSet.computeFieldSize(fieldDescriptorLite, object);
    }

    static int computeElementSize(WireFormat.FieldType fieldType, int n, Object object) {
        int n2 = CodedOutputStream.computeTagSize(n);
        if (fieldType == WireFormat.FieldType.GROUP) {
            n2 *= 2;
        }
        return n2 + FieldSet.computeElementSizeNoTag(fieldType, object);
    }

    static int computeElementSizeNoTag(WireFormat.FieldType fieldType, Object object) {
        switch (fieldType) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((Double)object);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)object).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)object);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)object);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)object);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)object);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)object);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)object);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)object);
            }
            case BYTES: {
                if (object instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)object);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])object);
            }
            case STRING: {
                if (object instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)object);
                }
                return CodedOutputStream.computeStringSizeNoTag((String)object);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)object);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)object);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)object);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)object);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)object);
            }
            case MESSAGE: {
                if (object instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)object);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)object);
            }
            case ENUM: {
                if (object instanceof Internal.EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)object).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)object);
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public static int computeFieldSize(FieldDescriptorLite<?> fieldDescriptorLite, Object object) {
        WireFormat.FieldType fieldType = fieldDescriptorLite.getLiteType();
        int n = fieldDescriptorLite.getNumber();
        if (fieldDescriptorLite.isRepeated()) {
            if (fieldDescriptorLite.isPacked()) {
                int n2 = 0;
                for (Object e : (List)object) {
                    n2 += FieldSet.computeElementSizeNoTag(fieldType, e);
                }
                return n2 + CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeRawVarint32Size(n2);
            }
            int n3 = 0;
            for (Object e : (List)object) {
                n3 += FieldSet.computeElementSize(fieldType, n, e);
            }
            return n3;
        }
        return FieldSet.computeElementSize(fieldType, n, object);
    }

    static final class Builder<T extends FieldDescriptorLite<T>> {
        private SmallSortedMap<T, Object> fields;
        private boolean hasLazyField;
        private boolean isMutable;
        private boolean hasNestedBuilders;

        private Builder() {
            this(SmallSortedMap.newFieldMap(16));
        }

        private Builder(SmallSortedMap<T, Object> smallSortedMap) {
            this.fields = smallSortedMap;
            this.isMutable = true;
        }

        public FieldSet<T> build() {
            if (this.fields.isEmpty()) {
                return FieldSet.emptySet();
            }
            this.isMutable = false;
            SmallSortedMap smallSortedMap = this.fields;
            if (this.hasNestedBuilders) {
                smallSortedMap = FieldSet.cloneAllFieldsMap(this.fields, false);
                Builder.replaceBuilders(smallSortedMap);
            }
            FieldSet fieldSet = new FieldSet(smallSortedMap);
            fieldSet.hasLazyField = this.hasLazyField;
            return fieldSet;
        }

        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(SmallSortedMap<T, Object> smallSortedMap) {
            for (int i = 0; i < smallSortedMap.getNumArrayEntries(); ++i) {
                Builder.replaceBuilders(smallSortedMap.getArrayEntryAt(i));
            }
            for (Map.Entry<T, Object> entry : smallSortedMap.getOverflowEntries()) {
                Builder.replaceBuilders(entry);
            }
        }

        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(Map.Entry<T, Object> entry) {
            entry.setValue(Builder.replaceBuilders((FieldDescriptorLite)entry.getKey(), entry.getValue()));
        }

        private static <T extends FieldDescriptorLite<T>> Object replaceBuilders(T t, Object object) {
            if (object == null) {
                return object;
            }
            if (t.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
                if (t.isRepeated()) {
                    if (!(object instanceof List)) {
                        throw new IllegalStateException("Repeated field should contains a List but actually contains type: " + object.getClass());
                    }
                    ArrayList<Object> arrayList = (ArrayList<Object>)object;
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Object e = arrayList.get(i);
                        Object object2 = Builder.replaceBuilder(e);
                        if (object2 == e) continue;
                        if (arrayList == object) {
                            arrayList = new ArrayList<Object>(arrayList);
                        }
                        arrayList.set(i, object2);
                    }
                    return arrayList;
                }
                return Builder.replaceBuilder(object);
            }
            return object;
        }

        private static Object replaceBuilder(Object object) {
            return object instanceof MessageLite.Builder ? ((MessageLite.Builder)object).build() : object;
        }

        public static <T extends FieldDescriptorLite<T>> Builder<T> fromFieldSet(FieldSet<T> fieldSet) {
            Builder<T> builder = new Builder<T>(FieldSet.cloneAllFieldsMap(((FieldSet)fieldSet).fields, true));
            builder.hasLazyField = ((FieldSet)fieldSet).hasLazyField;
            return builder;
        }

        public Map<T, Object> getAllFields() {
            if (this.hasLazyField) {
                SmallSortedMap smallSortedMap = FieldSet.cloneAllFieldsMap(this.fields, false);
                if (this.fields.isImmutable()) {
                    smallSortedMap.makeImmutable();
                } else {
                    Builder.replaceBuilders(smallSortedMap);
                }
                return smallSortedMap;
            }
            return this.fields.isImmutable() ? this.fields : Collections.unmodifiableMap(this.fields);
        }

        public boolean hasField(T t) {
            if (t.isRepeated()) {
                throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
            }
            return this.fields.get(t) != null;
        }

        public Object getField(T t) {
            Object object = this.getFieldAllowBuilders(t);
            return Builder.replaceBuilders(t, object);
        }

        Object getFieldAllowBuilders(T t) {
            Object object = this.fields.get(t);
            if (object instanceof LazyField) {
                return ((LazyField)object).getValue();
            }
            return object;
        }

        private void ensureIsMutable() {
            if (!this.isMutable) {
                this.fields = FieldSet.cloneAllFieldsMap(this.fields, true);
                this.isMutable = true;
            }
        }

        public void setField(T t, Object arrayList) {
            this.ensureIsMutable();
            if (t.isRepeated()) {
                if (!(arrayList instanceof List)) {
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
                ArrayList arrayList2 = new ArrayList();
                arrayList2.addAll(arrayList);
                for (Object e : arrayList2) {
                    Builder.verifyType(t.getLiteType(), e);
                    this.hasNestedBuilders = this.hasNestedBuilders || e instanceof MessageLite.Builder;
                }
                arrayList = arrayList2;
            } else {
                Builder.verifyType(t.getLiteType(), arrayList);
            }
            if (arrayList instanceof LazyField) {
                this.hasLazyField = true;
            }
            this.hasNestedBuilders = this.hasNestedBuilders || arrayList instanceof MessageLite.Builder;
            this.fields.put(t, (Object)arrayList);
        }

        public void clearField(T t) {
            this.ensureIsMutable();
            this.fields.remove(t);
            if (this.fields.isEmpty()) {
                this.hasLazyField = false;
            }
        }

        public int getRepeatedFieldCount(T t) {
            if (!t.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            Object object = this.getField(t);
            if (object == null) {
                return 0;
            }
            return ((List)object).size();
        }

        public Object getRepeatedField(T t, int n) {
            if (this.hasNestedBuilders) {
                this.ensureIsMutable();
            }
            Object object = this.getRepeatedFieldAllowBuilders(t, n);
            return Builder.replaceBuilder(object);
        }

        Object getRepeatedFieldAllowBuilders(T t, int n) {
            if (!t.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            Object object = this.getFieldAllowBuilders(t);
            if (object == null) {
                throw new IndexOutOfBoundsException();
            }
            return ((List)object).get(n);
        }

        public void setRepeatedField(T t, int n, Object object) {
            this.ensureIsMutable();
            if (!t.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            this.hasNestedBuilders = this.hasNestedBuilders || object instanceof MessageLite.Builder;
            Object object2 = this.getField(t);
            if (object2 == null) {
                throw new IndexOutOfBoundsException();
            }
            Builder.verifyType(t.getLiteType(), object);
            ((List)object2).set(n, object);
        }

        public void addRepeatedField(T t, Object object) {
            ArrayList<Object> arrayList;
            this.ensureIsMutable();
            if (!t.isRepeated()) {
                throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
            }
            this.hasNestedBuilders = this.hasNestedBuilders || object instanceof MessageLite.Builder;
            Builder.verifyType(t.getLiteType(), object);
            Object object2 = this.getField(t);
            if (object2 == null) {
                arrayList = new ArrayList<Object>();
                this.fields.put(t, (Object)arrayList);
            } else {
                arrayList = (ArrayList<Object>)object2;
            }
            arrayList.add(object);
        }

        private static void verifyType(WireFormat.FieldType fieldType, Object object) {
            if (!FieldSet.isValidType(fieldType, object)) {
                if (fieldType.getJavaType() == WireFormat.JavaType.MESSAGE && object instanceof MessageLite.Builder) {
                    return;
                }
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
        }

        public boolean isInitialized() {
            for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
                if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i))) continue;
                return false;
            }
            for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
                if (FieldSet.isInitialized(entry)) continue;
                return false;
            }
            return true;
        }

        public void mergeFrom(FieldSet<T> fieldSet) {
            this.ensureIsMutable();
            for (int i = 0; i < ((FieldSet)fieldSet).fields.getNumArrayEntries(); ++i) {
                this.mergeFromField(((FieldSet)fieldSet).fields.getArrayEntryAt(i));
            }
            for (Map.Entry entry : ((FieldSet)fieldSet).fields.getOverflowEntries()) {
                this.mergeFromField(entry);
            }
        }

        private void mergeFromField(Map.Entry<T, Object> entry) {
            FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
            Object object = entry.getValue();
            if (object instanceof LazyField) {
                object = ((LazyField)object).getValue();
            }
            if (fieldDescriptorLite.isRepeated()) {
                ArrayList arrayList = this.getField(fieldDescriptorLite);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                for (Object e : (List)object) {
                    ((List)arrayList).add(FieldSet.cloneIfMutable(e));
                }
                this.fields.put((T)fieldDescriptorLite, (Object)arrayList);
            } else if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
                Object object2 = this.getField(fieldDescriptorLite);
                if (object2 == null) {
                    this.fields.put((T)fieldDescriptorLite, FieldSet.cloneIfMutable(object));
                } else if (object2 instanceof MessageLite.Builder) {
                    fieldDescriptorLite.internalMergeFrom((MessageLite.Builder)object2, (MessageLite)object);
                } else {
                    object2 = fieldDescriptorLite.internalMergeFrom(((MessageLite)object2).toBuilder(), (MessageLite)object).build();
                    this.fields.put((T)fieldDescriptorLite, object2);
                }
            } else {
                this.fields.put((T)fieldDescriptorLite, FieldSet.cloneIfMutable(object));
            }
        }
    }

    public static interface FieldDescriptorLite<T extends FieldDescriptorLite<T>>
    extends Comparable<T> {
        public int getNumber();

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isRepeated();

        public boolean isPacked();

        public Internal.EnumLiteMap<?> getEnumType();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);
    }
}

