/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.FieldType;
import com.google.protobuf.Internal;
import com.google.protobuf.OneofInfo;
import java.lang.reflect.Field;

final class FieldInfo
implements Comparable<FieldInfo> {
    private final Field field;
    private final FieldType type;
    private final Class<?> messageClass;
    private final int fieldNumber;
    private final Field presenceField;
    private final int presenceMask;
    private final boolean required;
    private final boolean enforceUtf8;
    private final OneofInfo oneof;
    private final Field cachedSizeField;
    private final Class<?> oneofStoredType;
    private final Object mapDefaultEntry;
    private final Internal.EnumVerifier enumVerifier;

    public static FieldInfo forField(Field field, int n, FieldType fieldType, boolean bl) {
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull(fieldType, "fieldType");
        if (fieldType == FieldType.MESSAGE_LIST || fieldType == FieldType.GROUP_LIST) {
            throw new IllegalStateException("Shouldn't be called for repeated message fields.");
        }
        return new FieldInfo(field, n, fieldType, null, null, 0, false, bl, null, null, null, null, null);
    }

    public static FieldInfo forPackedField(Field field, int n, FieldType fieldType, Field field2) {
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull(fieldType, "fieldType");
        if (fieldType == FieldType.MESSAGE_LIST || fieldType == FieldType.GROUP_LIST) {
            throw new IllegalStateException("Shouldn't be called for repeated message fields.");
        }
        return new FieldInfo(field, n, fieldType, null, null, 0, false, false, null, null, null, null, field2);
    }

    public static FieldInfo forRepeatedMessageField(Field field, int n, FieldType fieldType, Class<?> clazz) {
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull(fieldType, "fieldType");
        Internal.checkNotNull(clazz, "messageClass");
        return new FieldInfo(field, n, fieldType, clazz, null, 0, false, false, null, null, null, null, null);
    }

    public static FieldInfo forFieldWithEnumVerifier(Field field, int n, FieldType fieldType, Internal.EnumVerifier enumVerifier) {
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(field, "field");
        return new FieldInfo(field, n, fieldType, null, null, 0, false, false, null, null, null, enumVerifier, null);
    }

    public static FieldInfo forPackedFieldWithEnumVerifier(Field field, int n, FieldType fieldType, Internal.EnumVerifier enumVerifier, Field field2) {
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(field, "field");
        return new FieldInfo(field, n, fieldType, null, null, 0, false, false, null, null, null, enumVerifier, field2);
    }

    public static FieldInfo forProto2OptionalField(Field field, int n, FieldType fieldType, Field field2, int n2, boolean bl, Internal.EnumVerifier enumVerifier) {
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull(fieldType, "fieldType");
        Internal.checkNotNull(field2, "presenceField");
        if (field2 != null && !FieldInfo.isExactlyOneBitSet(n2)) {
            throw new IllegalArgumentException("presenceMask must have exactly one bit set: " + n2);
        }
        return new FieldInfo(field, n, fieldType, null, field2, n2, false, bl, null, null, null, enumVerifier, null);
    }

    public static FieldInfo forOneofMemberField(int n, FieldType fieldType, OneofInfo oneofInfo, Class<?> clazz, boolean bl, Internal.EnumVerifier enumVerifier) {
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(fieldType, "fieldType");
        Internal.checkNotNull(oneofInfo, "oneof");
        Internal.checkNotNull(clazz, "oneofStoredType");
        if (!fieldType.isScalar()) {
            throw new IllegalArgumentException("Oneof is only supported for scalar fields. Field " + n + " is of type " + (Object)((Object)fieldType));
        }
        return new FieldInfo(null, n, fieldType, null, null, 0, false, bl, oneofInfo, clazz, null, enumVerifier, null);
    }

    private static void checkFieldNumber(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("fieldNumber must be positive: " + n);
        }
    }

    public static FieldInfo forProto2RequiredField(Field field, int n, FieldType fieldType, Field field2, int n2, boolean bl, Internal.EnumVerifier enumVerifier) {
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(field, "field");
        Internal.checkNotNull(fieldType, "fieldType");
        Internal.checkNotNull(field2, "presenceField");
        if (field2 != null && !FieldInfo.isExactlyOneBitSet(n2)) {
            throw new IllegalArgumentException("presenceMask must have exactly one bit set: " + n2);
        }
        return new FieldInfo(field, n, fieldType, null, field2, n2, true, bl, null, null, null, enumVerifier, null);
    }

    public static FieldInfo forMapField(Field field, int n, Object object, Internal.EnumVerifier enumVerifier) {
        Internal.checkNotNull(object, "mapDefaultEntry");
        FieldInfo.checkFieldNumber(n);
        Internal.checkNotNull(field, "field");
        return new FieldInfo(field, n, FieldType.MAP, null, null, 0, false, true, null, null, object, enumVerifier, null);
    }

    private FieldInfo(Field field, int n, FieldType fieldType, Class<?> clazz, Field field2, int n2, boolean bl, boolean bl2, OneofInfo oneofInfo, Class<?> clazz2, Object object, Internal.EnumVerifier enumVerifier, Field field3) {
        this.field = field;
        this.type = fieldType;
        this.messageClass = clazz;
        this.fieldNumber = n;
        this.presenceField = field2;
        this.presenceMask = n2;
        this.required = bl;
        this.enforceUtf8 = bl2;
        this.oneof = oneofInfo;
        this.oneofStoredType = clazz2;
        this.mapDefaultEntry = object;
        this.enumVerifier = enumVerifier;
        this.cachedSizeField = field3;
    }

    public int getFieldNumber() {
        return this.fieldNumber;
    }

    public Field getField() {
        return this.field;
    }

    public FieldType getType() {
        return this.type;
    }

    public OneofInfo getOneof() {
        return this.oneof;
    }

    public Class<?> getOneofStoredType() {
        return this.oneofStoredType;
    }

    public Internal.EnumVerifier getEnumVerifier() {
        return this.enumVerifier;
    }

    @Override
    public int compareTo(FieldInfo fieldInfo) {
        return this.fieldNumber - fieldInfo.fieldNumber;
    }

    public Class<?> getListElementType() {
        return this.messageClass;
    }

    public Field getPresenceField() {
        return this.presenceField;
    }

    public Object getMapDefaultEntry() {
        return this.mapDefaultEntry;
    }

    public int getPresenceMask() {
        return this.presenceMask;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isEnforceUtf8() {
        return this.enforceUtf8;
    }

    public Field getCachedSizeField() {
        return this.cachedSizeField;
    }

    public Class<?> getMessageFieldClass() {
        switch (this.type) {
            case MESSAGE: 
            case GROUP: {
                return this.field != null ? this.field.getType() : this.oneofStoredType;
            }
            case MESSAGE_LIST: 
            case GROUP_LIST: {
                return this.messageClass;
            }
        }
        return null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static boolean isExactlyOneBitSet(int n) {
        return n != 0 && (n & n - 1) == 0;
    }

    public static final class Builder {
        private Field field;
        private FieldType type;
        private int fieldNumber;
        private Field presenceField;
        private int presenceMask;
        private boolean required;
        private boolean enforceUtf8;
        private OneofInfo oneof;
        private Class<?> oneofStoredType;
        private Object mapDefaultEntry;
        private Internal.EnumVerifier enumVerifier;
        private Field cachedSizeField;

        private Builder() {
        }

        public Builder withField(Field field) {
            if (this.oneof != null) {
                throw new IllegalStateException("Cannot set field when building a oneof.");
            }
            this.field = field;
            return this;
        }

        public Builder withType(FieldType fieldType) {
            this.type = fieldType;
            return this;
        }

        public Builder withFieldNumber(int n) {
            this.fieldNumber = n;
            return this;
        }

        public Builder withPresence(Field field, int n) {
            this.presenceField = Internal.checkNotNull(field, "presenceField");
            this.presenceMask = n;
            return this;
        }

        public Builder withOneof(OneofInfo oneofInfo, Class<?> clazz) {
            if (this.field != null || this.presenceField != null) {
                throw new IllegalStateException("Cannot set oneof when field or presenceField have been provided");
            }
            this.oneof = oneofInfo;
            this.oneofStoredType = clazz;
            return this;
        }

        public Builder withRequired(boolean bl) {
            this.required = bl;
            return this;
        }

        public Builder withMapDefaultEntry(Object object) {
            this.mapDefaultEntry = object;
            return this;
        }

        public Builder withEnforceUtf8(boolean bl) {
            this.enforceUtf8 = bl;
            return this;
        }

        public Builder withEnumVerifier(Internal.EnumVerifier enumVerifier) {
            this.enumVerifier = enumVerifier;
            return this;
        }

        public Builder withCachedSizeField(Field field) {
            this.cachedSizeField = field;
            return this;
        }

        public FieldInfo build() {
            if (this.oneof != null) {
                return FieldInfo.forOneofMemberField(this.fieldNumber, this.type, this.oneof, this.oneofStoredType, this.enforceUtf8, this.enumVerifier);
            }
            if (this.mapDefaultEntry != null) {
                return FieldInfo.forMapField(this.field, this.fieldNumber, this.mapDefaultEntry, this.enumVerifier);
            }
            if (this.presenceField != null) {
                if (this.required) {
                    return FieldInfo.forProto2RequiredField(this.field, this.fieldNumber, this.type, this.presenceField, this.presenceMask, this.enforceUtf8, this.enumVerifier);
                }
                return FieldInfo.forProto2OptionalField(this.field, this.fieldNumber, this.type, this.presenceField, this.presenceMask, this.enforceUtf8, this.enumVerifier);
            }
            if (this.enumVerifier != null) {
                if (this.cachedSizeField == null) {
                    return FieldInfo.forFieldWithEnumVerifier(this.field, this.fieldNumber, this.type, this.enumVerifier);
                }
                return FieldInfo.forPackedFieldWithEnumVerifier(this.field, this.fieldNumber, this.type, this.enumVerifier, this.cachedSizeField);
            }
            if (this.cachedSizeField == null) {
                return FieldInfo.forField(this.field, this.fieldNumber, this.type, this.enforceUtf8);
            }
            return FieldInfo.forPackedField(this.field, this.fieldNumber, this.type, this.cachedSizeField);
        }
    }
}

