/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.BinaryReader;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.ExtensionSchema;
import com.google.protobuf.FieldSet;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Protobuf;
import com.google.protobuf.Reader;
import com.google.protobuf.SchemaUtil;
import com.google.protobuf.UnknownFieldSchema;
import com.google.protobuf.WireFormat;
import com.google.protobuf.Writer;
import java.io.IOException;
import java.lang.constant.Constable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class ExtensionSchemaLite
extends ExtensionSchema<GeneratedMessageLite.ExtensionDescriptor> {
    ExtensionSchemaLite() {
    }

    @Override
    boolean hasExtensions(MessageLite messageLite) {
        return messageLite instanceof GeneratedMessageLite.ExtendableMessage;
    }

    @Override
    FieldSet<GeneratedMessageLite.ExtensionDescriptor> getExtensions(Object object) {
        return ((GeneratedMessageLite.ExtendableMessage)object).extensions;
    }

    @Override
    void setExtensions(Object object, FieldSet<GeneratedMessageLite.ExtensionDescriptor> fieldSet) {
        ((GeneratedMessageLite.ExtendableMessage)object).extensions = fieldSet;
    }

    @Override
    FieldSet<GeneratedMessageLite.ExtensionDescriptor> getMutableExtensions(Object object) {
        return ((GeneratedMessageLite.ExtendableMessage)object).ensureExtensionsAreMutable();
    }

    @Override
    void makeImmutable(Object object) {
        this.getExtensions(object).makeImmutable();
    }

    @Override
    <UT, UB> UB parseExtension(Reader reader, Object object, ExtensionRegistryLite extensionRegistryLite, FieldSet<GeneratedMessageLite.ExtensionDescriptor> fieldSet, UB UB, UnknownFieldSchema<UT, UB> unknownFieldSchema) throws IOException {
        GeneratedMessageLite.GeneratedExtension generatedExtension = (GeneratedMessageLite.GeneratedExtension)object;
        int n = generatedExtension.getNumber();
        if (generatedExtension.descriptor.isRepeated() && generatedExtension.descriptor.isPacked()) {
            ArrayList<Constable> arrayList = null;
            switch (generatedExtension.getLiteType()) {
                case DOUBLE: {
                    ArrayList<Double> arrayList2 = new ArrayList<Double>();
                    reader.readDoubleList(arrayList2);
                    arrayList = arrayList2;
                    break;
                }
                case FLOAT: {
                    ArrayList<Float> arrayList3 = new ArrayList<Float>();
                    reader.readFloatList(arrayList3);
                    arrayList = arrayList3;
                    break;
                }
                case INT64: {
                    ArrayList<Long> arrayList4 = new ArrayList<Long>();
                    reader.readInt64List(arrayList4);
                    arrayList = arrayList4;
                    break;
                }
                case UINT64: {
                    ArrayList<Long> arrayList5 = new ArrayList<Long>();
                    reader.readUInt64List(arrayList5);
                    arrayList = arrayList5;
                    break;
                }
                case INT32: {
                    ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
                    reader.readInt32List(arrayList6);
                    arrayList = arrayList6;
                    break;
                }
                case FIXED64: {
                    ArrayList<Long> arrayList7 = new ArrayList<Long>();
                    reader.readFixed64List(arrayList7);
                    arrayList = arrayList7;
                    break;
                }
                case FIXED32: {
                    ArrayList<Integer> arrayList8 = new ArrayList<Integer>();
                    reader.readFixed32List(arrayList8);
                    arrayList = arrayList8;
                    break;
                }
                case BOOL: {
                    ArrayList<Boolean> arrayList9 = new ArrayList<Boolean>();
                    reader.readBoolList(arrayList9);
                    arrayList = arrayList9;
                    break;
                }
                case UINT32: {
                    ArrayList<Integer> arrayList10 = new ArrayList<Integer>();
                    reader.readUInt32List(arrayList10);
                    arrayList = arrayList10;
                    break;
                }
                case SFIXED32: {
                    ArrayList<Integer> arrayList11 = new ArrayList<Integer>();
                    reader.readSFixed32List(arrayList11);
                    arrayList = arrayList11;
                    break;
                }
                case SFIXED64: {
                    ArrayList<Long> arrayList12 = new ArrayList<Long>();
                    reader.readSFixed64List(arrayList12);
                    arrayList = arrayList12;
                    break;
                }
                case SINT32: {
                    ArrayList<Integer> arrayList13 = new ArrayList<Integer>();
                    reader.readSInt32List(arrayList13);
                    arrayList = arrayList13;
                    break;
                }
                case SINT64: {
                    ArrayList<Long> arrayList14 = new ArrayList<Long>();
                    reader.readSInt64List(arrayList14);
                    arrayList = arrayList14;
                    break;
                }
                case ENUM: {
                    ArrayList<Integer> arrayList15 = new ArrayList<Integer>();
                    reader.readEnumList(arrayList15);
                    UB = SchemaUtil.filterUnknownEnumList(n, arrayList15, generatedExtension.descriptor.getEnumType(), UB, unknownFieldSchema);
                    arrayList = arrayList15;
                    break;
                }
                default: {
                    throw new IllegalStateException("Type cannot be packed: " + (Object)((Object)generatedExtension.descriptor.getLiteType()));
                }
            }
            fieldSet.setField(generatedExtension.descriptor, arrayList);
        } else {
            Object object2 = null;
            if (generatedExtension.getLiteType() == WireFormat.FieldType.ENUM) {
                int n2 = reader.readInt32();
                Object obj = generatedExtension.descriptor.getEnumType().findValueByNumber(n2);
                if (obj == null) {
                    return SchemaUtil.storeUnknownEnum(n, n2, UB, unknownFieldSchema);
                }
                object2 = n2;
            } else {
                switch (generatedExtension.getLiteType()) {
                    case DOUBLE: {
                        object2 = reader.readDouble();
                        break;
                    }
                    case FLOAT: {
                        object2 = Float.valueOf(reader.readFloat());
                        break;
                    }
                    case INT64: {
                        object2 = reader.readInt64();
                        break;
                    }
                    case UINT64: {
                        object2 = reader.readUInt64();
                        break;
                    }
                    case INT32: {
                        object2 = reader.readInt32();
                        break;
                    }
                    case FIXED64: {
                        object2 = reader.readFixed64();
                        break;
                    }
                    case FIXED32: {
                        object2 = reader.readFixed32();
                        break;
                    }
                    case BOOL: {
                        object2 = reader.readBool();
                        break;
                    }
                    case BYTES: {
                        object2 = reader.readBytes();
                        break;
                    }
                    case UINT32: {
                        object2 = reader.readUInt32();
                        break;
                    }
                    case SFIXED32: {
                        object2 = reader.readSFixed32();
                        break;
                    }
                    case SFIXED64: {
                        object2 = reader.readSFixed64();
                        break;
                    }
                    case SINT32: {
                        object2 = reader.readSInt32();
                        break;
                    }
                    case SINT64: {
                        object2 = reader.readSInt64();
                        break;
                    }
                    case STRING: {
                        object2 = reader.readString();
                        break;
                    }
                    case GROUP: {
                        object2 = reader.readGroup(generatedExtension.getMessageDefaultInstance().getClass(), extensionRegistryLite);
                        break;
                    }
                    case MESSAGE: {
                        object2 = reader.readMessage(generatedExtension.getMessageDefaultInstance().getClass(), extensionRegistryLite);
                        break;
                    }
                    case ENUM: {
                        throw new IllegalStateException("Shouldn't reach here.");
                    }
                }
            }
            if (generatedExtension.isRepeated()) {
                fieldSet.addRepeatedField(generatedExtension.descriptor, object2);
            } else {
                switch (generatedExtension.getLiteType()) {
                    case GROUP: 
                    case MESSAGE: {
                        Object object3 = fieldSet.getField(generatedExtension.descriptor);
                        if (object3 == null) break;
                        object2 = Internal.mergeMessage(object3, object2);
                        break;
                    }
                }
                fieldSet.setField(generatedExtension.descriptor, object2);
            }
        }
        return UB;
    }

    @Override
    int extensionNumber(Map.Entry<?, ?> entry) {
        GeneratedMessageLite.ExtensionDescriptor extensionDescriptor = (GeneratedMessageLite.ExtensionDescriptor)entry.getKey();
        return extensionDescriptor.getNumber();
    }

    @Override
    void serializeExtension(Writer writer, Map.Entry<?, ?> entry) throws IOException {
        block42: {
            GeneratedMessageLite.ExtensionDescriptor extensionDescriptor;
            block41: {
                extensionDescriptor = (GeneratedMessageLite.ExtensionDescriptor)entry.getKey();
                if (!extensionDescriptor.isRepeated()) break block41;
                switch (extensionDescriptor.getLiteType()) {
                    case DOUBLE: {
                        SchemaUtil.writeDoubleList(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, extensionDescriptor.isPacked());
                        break;
                    }
                    case FLOAT: {
                        SchemaUtil.writeFloatList(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, extensionDescriptor.isPacked());
                        break;
                    }
                    case INT64: {
                        SchemaUtil.writeInt64List(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, extensionDescriptor.isPacked());
                        break;
                    }
                    case UINT64: {
                        SchemaUtil.writeUInt64List(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, extensionDescriptor.isPacked());
                        break;
                    }
                    case INT32: {
                        SchemaUtil.writeInt32List(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, extensionDescriptor.isPacked());
                        break;
                    }
                    case FIXED64: {
                        SchemaUtil.writeFixed64List(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, extensionDescriptor.isPacked());
                        break;
                    }
                    case FIXED32: {
                        SchemaUtil.writeFixed32List(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, extensionDescriptor.isPacked());
                        break;
                    }
                    case BOOL: {
                        SchemaUtil.writeBoolList(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, extensionDescriptor.isPacked());
                        break;
                    }
                    case BYTES: {
                        SchemaUtil.writeBytesList(extensionDescriptor.getNumber(), (List)entry.getValue(), writer);
                        break;
                    }
                    case UINT32: {
                        SchemaUtil.writeUInt32List(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, extensionDescriptor.isPacked());
                        break;
                    }
                    case SFIXED32: {
                        SchemaUtil.writeSFixed32List(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, extensionDescriptor.isPacked());
                        break;
                    }
                    case SFIXED64: {
                        SchemaUtil.writeSFixed64List(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, extensionDescriptor.isPacked());
                        break;
                    }
                    case SINT32: {
                        SchemaUtil.writeSInt32List(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, extensionDescriptor.isPacked());
                        break;
                    }
                    case SINT64: {
                        SchemaUtil.writeSInt64List(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, extensionDescriptor.isPacked());
                        break;
                    }
                    case ENUM: {
                        SchemaUtil.writeInt32List(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, extensionDescriptor.isPacked());
                        break;
                    }
                    case STRING: {
                        SchemaUtil.writeStringList(extensionDescriptor.getNumber(), (List)entry.getValue(), writer);
                        break;
                    }
                    case GROUP: {
                        List list = (List)entry.getValue();
                        if (list != null && !list.isEmpty()) {
                            SchemaUtil.writeGroupList(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, Protobuf.getInstance().schemaFor(list.get(0).getClass()));
                            break;
                        }
                        break block42;
                    }
                    case MESSAGE: {
                        List list = (List)entry.getValue();
                        if (list == null || list.isEmpty()) break;
                        SchemaUtil.writeMessageList(extensionDescriptor.getNumber(), (List)entry.getValue(), writer, Protobuf.getInstance().schemaFor(list.get(0).getClass()));
                    }
                }
                break block42;
            }
            switch (extensionDescriptor.getLiteType()) {
                case DOUBLE: {
                    writer.writeDouble(extensionDescriptor.getNumber(), (Double)entry.getValue());
                    break;
                }
                case FLOAT: {
                    writer.writeFloat(extensionDescriptor.getNumber(), ((Float)entry.getValue()).floatValue());
                    break;
                }
                case INT64: {
                    writer.writeInt64(extensionDescriptor.getNumber(), (Long)entry.getValue());
                    break;
                }
                case UINT64: {
                    writer.writeUInt64(extensionDescriptor.getNumber(), (Long)entry.getValue());
                    break;
                }
                case INT32: {
                    writer.writeInt32(extensionDescriptor.getNumber(), (Integer)entry.getValue());
                    break;
                }
                case FIXED64: {
                    writer.writeFixed64(extensionDescriptor.getNumber(), (Long)entry.getValue());
                    break;
                }
                case FIXED32: {
                    writer.writeFixed32(extensionDescriptor.getNumber(), (Integer)entry.getValue());
                    break;
                }
                case BOOL: {
                    writer.writeBool(extensionDescriptor.getNumber(), (Boolean)entry.getValue());
                    break;
                }
                case BYTES: {
                    writer.writeBytes(extensionDescriptor.getNumber(), (ByteString)entry.getValue());
                    break;
                }
                case UINT32: {
                    writer.writeUInt32(extensionDescriptor.getNumber(), (Integer)entry.getValue());
                    break;
                }
                case SFIXED32: {
                    writer.writeSFixed32(extensionDescriptor.getNumber(), (Integer)entry.getValue());
                    break;
                }
                case SFIXED64: {
                    writer.writeSFixed64(extensionDescriptor.getNumber(), (Long)entry.getValue());
                    break;
                }
                case SINT32: {
                    writer.writeSInt32(extensionDescriptor.getNumber(), (Integer)entry.getValue());
                    break;
                }
                case SINT64: {
                    writer.writeSInt64(extensionDescriptor.getNumber(), (Long)entry.getValue());
                    break;
                }
                case ENUM: {
                    writer.writeInt32(extensionDescriptor.getNumber(), (Integer)entry.getValue());
                    break;
                }
                case STRING: {
                    writer.writeString(extensionDescriptor.getNumber(), (String)entry.getValue());
                    break;
                }
                case GROUP: {
                    writer.writeGroup(extensionDescriptor.getNumber(), entry.getValue(), Protobuf.getInstance().schemaFor(entry.getValue().getClass()));
                    break;
                }
                case MESSAGE: {
                    writer.writeMessage(extensionDescriptor.getNumber(), entry.getValue(), Protobuf.getInstance().schemaFor(entry.getValue().getClass()));
                }
            }
        }
    }

    @Override
    Object findExtensionByNumber(ExtensionRegistryLite extensionRegistryLite, MessageLite messageLite, int n) {
        return extensionRegistryLite.findLiteExtensionByNumber(messageLite, n);
    }

    @Override
    void parseLengthPrefixedMessageSetItem(Reader reader, Object object, ExtensionRegistryLite extensionRegistryLite, FieldSet<GeneratedMessageLite.ExtensionDescriptor> fieldSet) throws IOException {
        GeneratedMessageLite.GeneratedExtension generatedExtension = (GeneratedMessageLite.GeneratedExtension)object;
        Object obj = reader.readMessage(generatedExtension.getMessageDefaultInstance().getClass(), extensionRegistryLite);
        fieldSet.setField(generatedExtension.descriptor, obj);
    }

    @Override
    void parseMessageSetItem(ByteString byteString, Object object, ExtensionRegistryLite extensionRegistryLite, FieldSet<GeneratedMessageLite.ExtensionDescriptor> fieldSet) throws IOException {
        GeneratedMessageLite.GeneratedExtension generatedExtension = (GeneratedMessageLite.GeneratedExtension)object;
        MessageLite messageLite = generatedExtension.getMessageDefaultInstance().newBuilderForType().buildPartial();
        BinaryReader binaryReader = BinaryReader.newInstance(ByteBuffer.wrap(byteString.toByteArray()), true);
        Protobuf.getInstance().mergeFrom(messageLite, binaryReader, extensionRegistryLite);
        fieldSet.setField(generatedExtension.descriptor, messageLite);
        if (binaryReader.getFieldNumber() != Integer.MAX_VALUE) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
    }
}

