/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.MapEntryLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Schema;
import com.google.protobuf.Writer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class CodedOutputStreamWriter
implements Writer {
    private final CodedOutputStream output;

    public static CodedOutputStreamWriter forCodedOutput(CodedOutputStream codedOutputStream) {
        if (codedOutputStream.wrapper != null) {
            return codedOutputStream.wrapper;
        }
        return new CodedOutputStreamWriter(codedOutputStream);
    }

    private CodedOutputStreamWriter(CodedOutputStream codedOutputStream) {
        this.output = Internal.checkNotNull(codedOutputStream, "output");
        this.output.wrapper = this;
    }

    @Override
    public Writer.FieldOrder fieldOrder() {
        return Writer.FieldOrder.ASCENDING;
    }

    public int getTotalBytesWritten() {
        return this.output.getTotalBytesWritten();
    }

    @Override
    public void writeSFixed32(int n, int n2) throws IOException {
        this.output.writeSFixed32(n, n2);
    }

    @Override
    public void writeInt64(int n, long l) throws IOException {
        this.output.writeInt64(n, l);
    }

    @Override
    public void writeSFixed64(int n, long l) throws IOException {
        this.output.writeSFixed64(n, l);
    }

    @Override
    public void writeFloat(int n, float f) throws IOException {
        this.output.writeFloat(n, f);
    }

    @Override
    public void writeDouble(int n, double d) throws IOException {
        this.output.writeDouble(n, d);
    }

    @Override
    public void writeEnum(int n, int n2) throws IOException {
        this.output.writeEnum(n, n2);
    }

    @Override
    public void writeUInt64(int n, long l) throws IOException {
        this.output.writeUInt64(n, l);
    }

    @Override
    public void writeInt32(int n, int n2) throws IOException {
        this.output.writeInt32(n, n2);
    }

    @Override
    public void writeFixed64(int n, long l) throws IOException {
        this.output.writeFixed64(n, l);
    }

    @Override
    public void writeFixed32(int n, int n2) throws IOException {
        this.output.writeFixed32(n, n2);
    }

    @Override
    public void writeBool(int n, boolean bl) throws IOException {
        this.output.writeBool(n, bl);
    }

    @Override
    public void writeString(int n, String string) throws IOException {
        this.output.writeString(n, string);
    }

    @Override
    public void writeBytes(int n, ByteString byteString) throws IOException {
        this.output.writeBytes(n, byteString);
    }

    @Override
    public void writeUInt32(int n, int n2) throws IOException {
        this.output.writeUInt32(n, n2);
    }

    @Override
    public void writeSInt32(int n, int n2) throws IOException {
        this.output.writeSInt32(n, n2);
    }

    @Override
    public void writeSInt64(int n, long l) throws IOException {
        this.output.writeSInt64(n, l);
    }

    @Override
    public void writeMessage(int n, Object object) throws IOException {
        this.output.writeMessage(n, (MessageLite)object);
    }

    @Override
    public void writeMessage(int n, Object object, Schema schema) throws IOException {
        this.output.writeMessage(n, (MessageLite)object, schema);
    }

    @Override
    public void writeGroup(int n, Object object) throws IOException {
        this.output.writeGroup(n, (MessageLite)object);
    }

    @Override
    public void writeGroup(int n, Object object, Schema schema) throws IOException {
        this.output.writeGroup(n, (MessageLite)object, schema);
    }

    @Override
    public void writeStartGroup(int n) throws IOException {
        this.output.writeTag(n, 3);
    }

    @Override
    public void writeEndGroup(int n) throws IOException {
        this.output.writeTag(n, 4);
    }

    @Override
    public final void writeMessageSetItem(int n, Object object) throws IOException {
        if (object instanceof ByteString) {
            this.output.writeRawMessageSetExtension(n, (ByteString)object);
        } else {
            this.output.writeMessageSetExtension(n, (MessageLite)object);
        }
    }

    @Override
    public void writeInt32List(int n, List<Integer> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.output.writeTag(n, 2);
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                n3 += CodedOutputStream.computeInt32SizeNoTag(list.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeInt32NoTag(list.get(n2));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeInt32(n, list.get(i));
            }
        }
    }

    @Override
    public void writeFixed32List(int n, List<Integer> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.output.writeTag(n, 2);
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                n3 += CodedOutputStream.computeFixed32SizeNoTag(list.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeFixed32NoTag(list.get(n2));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeFixed32(n, list.get(i));
            }
        }
    }

    @Override
    public void writeInt64List(int n, List<Long> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.output.writeTag(n, 2);
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                n3 += CodedOutputStream.computeInt64SizeNoTag(list.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeInt64NoTag(list.get(n2));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeInt64(n, list.get(i));
            }
        }
    }

    @Override
    public void writeUInt64List(int n, List<Long> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.output.writeTag(n, 2);
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                n3 += CodedOutputStream.computeUInt64SizeNoTag(list.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeUInt64NoTag(list.get(n2));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeUInt64(n, list.get(i));
            }
        }
    }

    @Override
    public void writeFixed64List(int n, List<Long> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.output.writeTag(n, 2);
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                n3 += CodedOutputStream.computeFixed64SizeNoTag(list.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeFixed64NoTag(list.get(n2));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeFixed64(n, list.get(i));
            }
        }
    }

    @Override
    public void writeFloatList(int n, List<Float> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.output.writeTag(n, 2);
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                n3 += CodedOutputStream.computeFloatSizeNoTag(list.get(n2).floatValue());
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeFloatNoTag(list.get(n2).floatValue());
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeFloat(n, list.get(i).floatValue());
            }
        }
    }

    @Override
    public void writeDoubleList(int n, List<Double> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.output.writeTag(n, 2);
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                n3 += CodedOutputStream.computeDoubleSizeNoTag(list.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeDoubleNoTag(list.get(n2));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeDouble(n, list.get(i));
            }
        }
    }

    @Override
    public void writeEnumList(int n, List<Integer> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.output.writeTag(n, 2);
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                n3 += CodedOutputStream.computeEnumSizeNoTag(list.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeEnumNoTag(list.get(n2));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeEnum(n, list.get(i));
            }
        }
    }

    @Override
    public void writeBoolList(int n, List<Boolean> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.output.writeTag(n, 2);
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                n3 += CodedOutputStream.computeBoolSizeNoTag(list.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeBoolNoTag(list.get(n2));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeBool(n, list.get(i));
            }
        }
    }

    @Override
    public void writeStringList(int n, List<String> list) throws IOException {
        if (list instanceof LazyStringList) {
            LazyStringList lazyStringList = (LazyStringList)list;
            for (int i = 0; i < list.size(); ++i) {
                this.writeLazyString(n, lazyStringList.getRaw(i));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeString(n, list.get(i));
            }
        }
    }

    private void writeLazyString(int n, Object object) throws IOException {
        if (object instanceof String) {
            this.output.writeString(n, (String)object);
        } else {
            this.output.writeBytes(n, (ByteString)object);
        }
    }

    @Override
    public void writeBytesList(int n, List<ByteString> list) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            this.output.writeBytes(n, list.get(i));
        }
    }

    @Override
    public void writeUInt32List(int n, List<Integer> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.output.writeTag(n, 2);
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                n3 += CodedOutputStream.computeUInt32SizeNoTag(list.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeUInt32NoTag(list.get(n2));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeUInt32(n, list.get(i));
            }
        }
    }

    @Override
    public void writeSFixed32List(int n, List<Integer> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.output.writeTag(n, 2);
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                n3 += CodedOutputStream.computeSFixed32SizeNoTag(list.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeSFixed32NoTag(list.get(n2));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeSFixed32(n, list.get(i));
            }
        }
    }

    @Override
    public void writeSFixed64List(int n, List<Long> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.output.writeTag(n, 2);
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                n3 += CodedOutputStream.computeSFixed64SizeNoTag(list.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeSFixed64NoTag(list.get(n2));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeSFixed64(n, list.get(i));
            }
        }
    }

    @Override
    public void writeSInt32List(int n, List<Integer> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.output.writeTag(n, 2);
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                n3 += CodedOutputStream.computeSInt32SizeNoTag(list.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeSInt32NoTag(list.get(n2));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeSInt32(n, list.get(i));
            }
        }
    }

    @Override
    public void writeSInt64List(int n, List<Long> list, boolean bl) throws IOException {
        if (bl) {
            int n2;
            this.output.writeTag(n, 2);
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                n3 += CodedOutputStream.computeSInt64SizeNoTag(list.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.output.writeSInt64NoTag(list.get(n2));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.output.writeSInt64(n, list.get(i));
            }
        }
    }

    @Override
    public void writeMessageList(int n, List<?> list) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            this.writeMessage(n, list.get(i));
        }
    }

    @Override
    public void writeMessageList(int n, List<?> list, Schema schema) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            this.writeMessage(n, list.get(i), schema);
        }
    }

    @Override
    public void writeGroupList(int n, List<?> list) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            this.writeGroup(n, list.get(i));
        }
    }

    @Override
    public void writeGroupList(int n, List<?> list, Schema schema) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            this.writeGroup(n, list.get(i), schema);
        }
    }

    @Override
    public <K, V> void writeMap(int n, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map) throws IOException {
        if (this.output.isSerializationDeterministic()) {
            this.writeDeterministicMap(n, metadata, map);
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.output.writeTag(n, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, entry.getKey(), entry.getValue()));
            MapEntryLite.writeTo(this.output, metadata, entry.getKey(), entry.getValue());
        }
    }

    private <K, V> void writeDeterministicMap(int n, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map) throws IOException {
        switch (metadata.keyType) {
            case BOOL: {
                V v = map.get(Boolean.FALSE);
                if (v != null) {
                    this.writeDeterministicBooleanMapEntry(n, false, v, metadata);
                }
                if ((v = map.get(Boolean.TRUE)) == null) break;
                this.writeDeterministicBooleanMapEntry(n, true, v, metadata);
                break;
            }
            case FIXED32: 
            case INT32: 
            case SFIXED32: 
            case SINT32: 
            case UINT32: {
                this.writeDeterministicIntegerMap(n, metadata, map);
                break;
            }
            case FIXED64: 
            case INT64: 
            case SFIXED64: 
            case SINT64: 
            case UINT64: {
                this.writeDeterministicLongMap(n, metadata, map);
                break;
            }
            case STRING: {
                this.writeDeterministicStringMap(n, metadata, map);
                break;
            }
            default: {
                throw new IllegalArgumentException("does not support key type: " + (Object)((Object)metadata.keyType));
            }
        }
    }

    private <V> void writeDeterministicBooleanMapEntry(int n, boolean bl, V v, MapEntryLite.Metadata<Boolean, V> metadata) throws IOException {
        this.output.writeTag(n, 2);
        this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, bl, v));
        MapEntryLite.writeTo(this.output, metadata, bl, v);
    }

    private <V> void writeDeterministicIntegerMap(int n, MapEntryLite.Metadata<Integer, V> metadata, Map<Integer, V> map) throws IOException {
        int[] nArray = new int[map.size()];
        int n2 = 0;
        Iterator<Integer> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int n3 = iterator.next();
            nArray[n2++] = n3;
        }
        Arrays.sort(nArray);
        for (Object object : (Iterator<Integer>)nArray) {
            V v = map.get((int)object);
            this.output.writeTag(n, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, (int)object, v));
            MapEntryLite.writeTo(this.output, metadata, (int)object, v);
        }
    }

    private <V> void writeDeterministicLongMap(int n, MapEntryLite.Metadata<Long, V> metadata, Map<Long, V> map) throws IOException {
        long[] lArray = new long[map.size()];
        int n2 = 0;
        Iterator<Long> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            long l = iterator.next();
            lArray[n2++] = l;
        }
        Arrays.sort(lArray);
        for (Object object : (Iterator<Long>)lArray) {
            V v = map.get((long)object);
            this.output.writeTag(n, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, (long)object, v));
            MapEntryLite.writeTo(this.output, metadata, (long)object, v);
        }
    }

    private <V> void writeDeterministicStringMap(int n, MapEntryLite.Metadata<String, V> metadata, Map<String, V> map) throws IOException {
        Object[] objectArray = new String[map.size()];
        int n2 = 0;
        for (String string : map.keySet()) {
            objectArray[n2++] = string;
        }
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            V v = map.get(object);
            this.output.writeTag(n, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, object, v));
            MapEntryLite.writeTo(this.output, metadata, object, v);
        }
    }
}

