/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.Android;
import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStreamWriter;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyFieldLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Schema;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.Utf8;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CodedOutputStream
extends ByteOutput {
    private static final Logger logger = Logger.getLogger(CodedOutputStream.class.getName());
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.hasUnsafeArrayOperations();
    CodedOutputStreamWriter wrapper;
    @Deprecated
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private boolean serializationDeterministic;

    static int computePreferredBufferSize(int n) {
        if (n > 4096) {
            return 4096;
        }
        return n;
    }

    public static CodedOutputStream newInstance(OutputStream outputStream) {
        return CodedOutputStream.newInstance(outputStream, 4096);
    }

    public static CodedOutputStream newInstance(OutputStream outputStream, int n) {
        return new OutputStreamEncoder(outputStream, n);
    }

    public static CodedOutputStream newInstance(byte[] byArray) {
        return CodedOutputStream.newInstance(byArray, 0, byArray.length);
    }

    public static CodedOutputStream newInstance(byte[] byArray, int n, int n2) {
        return new ArrayEncoder(byArray, n, n2);
    }

    public static CodedOutputStream newInstance(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new HeapNioEncoder(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            return UnsafeDirectNioEncoder.isSupported() ? CodedOutputStream.newUnsafeInstance(byteBuffer) : CodedOutputStream.newSafeInstance(byteBuffer);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    static CodedOutputStream newUnsafeInstance(ByteBuffer byteBuffer) {
        return new UnsafeDirectNioEncoder(byteBuffer);
    }

    static CodedOutputStream newSafeInstance(ByteBuffer byteBuffer) {
        return new SafeDirectNioEncoder(byteBuffer);
    }

    public void useDeterministicSerialization() {
        this.serializationDeterministic = true;
    }

    boolean isSerializationDeterministic() {
        return this.serializationDeterministic;
    }

    @Deprecated
    public static CodedOutputStream newInstance(ByteBuffer byteBuffer, int n) {
        return CodedOutputStream.newInstance(byteBuffer);
    }

    static CodedOutputStream newInstance(ByteOutput byteOutput, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("bufferSize must be positive");
        }
        return new ByteOutputEncoder(byteOutput, n);
    }

    private CodedOutputStream() {
    }

    public abstract void writeTag(int var1, int var2) throws IOException;

    public abstract void writeInt32(int var1, int var2) throws IOException;

    public abstract void writeUInt32(int var1, int var2) throws IOException;

    public final void writeSInt32(int n, int n2) throws IOException {
        this.writeUInt32(n, CodedOutputStream.encodeZigZag32(n2));
    }

    public abstract void writeFixed32(int var1, int var2) throws IOException;

    public final void writeSFixed32(int n, int n2) throws IOException {
        this.writeFixed32(n, n2);
    }

    public final void writeInt64(int n, long l) throws IOException {
        this.writeUInt64(n, l);
    }

    public abstract void writeUInt64(int var1, long var2) throws IOException;

    public final void writeSInt64(int n, long l) throws IOException {
        this.writeUInt64(n, CodedOutputStream.encodeZigZag64(l));
    }

    public abstract void writeFixed64(int var1, long var2) throws IOException;

    public final void writeSFixed64(int n, long l) throws IOException {
        this.writeFixed64(n, l);
    }

    public final void writeFloat(int n, float f) throws IOException {
        this.writeFixed32(n, Float.floatToRawIntBits(f));
    }

    public final void writeDouble(int n, double d) throws IOException {
        this.writeFixed64(n, Double.doubleToRawLongBits(d));
    }

    public abstract void writeBool(int var1, boolean var2) throws IOException;

    public final void writeEnum(int n, int n2) throws IOException {
        this.writeInt32(n, n2);
    }

    public abstract void writeString(int var1, String var2) throws IOException;

    public abstract void writeBytes(int var1, ByteString var2) throws IOException;

    public abstract void writeByteArray(int var1, byte[] var2) throws IOException;

    public abstract void writeByteArray(int var1, byte[] var2, int var3, int var4) throws IOException;

    public abstract void writeByteBuffer(int var1, ByteBuffer var2) throws IOException;

    public final void writeRawByte(byte by) throws IOException {
        this.write(by);
    }

    public final void writeRawByte(int n) throws IOException {
        this.write((byte)n);
    }

    public final void writeRawBytes(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public final void writeRawBytes(byte[] byArray, int n, int n2) throws IOException {
        this.write(byArray, n, n2);
    }

    public final void writeRawBytes(ByteString byteString) throws IOException {
        byteString.writeTo(this);
    }

    public abstract void writeRawBytes(ByteBuffer var1) throws IOException;

    public abstract void writeMessage(int var1, MessageLite var2) throws IOException;

    abstract void writeMessage(int var1, MessageLite var2, Schema var3) throws IOException;

    public abstract void writeMessageSetExtension(int var1, MessageLite var2) throws IOException;

    public abstract void writeRawMessageSetExtension(int var1, ByteString var2) throws IOException;

    public abstract void writeInt32NoTag(int var1) throws IOException;

    public abstract void writeUInt32NoTag(int var1) throws IOException;

    public final void writeSInt32NoTag(int n) throws IOException {
        this.writeUInt32NoTag(CodedOutputStream.encodeZigZag32(n));
    }

    public abstract void writeFixed32NoTag(int var1) throws IOException;

    public final void writeSFixed32NoTag(int n) throws IOException {
        this.writeFixed32NoTag(n);
    }

    public final void writeInt64NoTag(long l) throws IOException {
        this.writeUInt64NoTag(l);
    }

    public abstract void writeUInt64NoTag(long var1) throws IOException;

    public final void writeSInt64NoTag(long l) throws IOException {
        this.writeUInt64NoTag(CodedOutputStream.encodeZigZag64(l));
    }

    public abstract void writeFixed64NoTag(long var1) throws IOException;

    public final void writeSFixed64NoTag(long l) throws IOException {
        this.writeFixed64NoTag(l);
    }

    public final void writeFloatNoTag(float f) throws IOException {
        this.writeFixed32NoTag(Float.floatToRawIntBits(f));
    }

    public final void writeDoubleNoTag(double d) throws IOException {
        this.writeFixed64NoTag(Double.doubleToRawLongBits(d));
    }

    public final void writeBoolNoTag(boolean bl) throws IOException {
        this.write((byte)(bl ? 1 : 0));
    }

    public final void writeEnumNoTag(int n) throws IOException {
        this.writeInt32NoTag(n);
    }

    public abstract void writeStringNoTag(String var1) throws IOException;

    public abstract void writeBytesNoTag(ByteString var1) throws IOException;

    public final void writeByteArrayNoTag(byte[] byArray) throws IOException {
        this.writeByteArrayNoTag(byArray, 0, byArray.length);
    }

    public abstract void writeMessageNoTag(MessageLite var1) throws IOException;

    abstract void writeMessageNoTag(MessageLite var1, Schema var2) throws IOException;

    @Override
    public abstract void write(byte var1) throws IOException;

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void writeLazy(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void write(ByteBuffer var1) throws IOException;

    @Override
    public abstract void writeLazy(ByteBuffer var1) throws IOException;

    public static int computeInt32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeInt32SizeNoTag(n2);
    }

    public static int computeUInt32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeUInt32SizeNoTag(n2);
    }

    public static int computeSInt32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSInt32SizeNoTag(n2);
    }

    public static int computeFixed32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeFixed32SizeNoTag(n2);
    }

    public static int computeSFixed32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSFixed32SizeNoTag(n2);
    }

    public static int computeInt64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeInt64SizeNoTag(l);
    }

    public static int computeUInt64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeUInt64SizeNoTag(l);
    }

    public static int computeSInt64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSInt64SizeNoTag(l);
    }

    public static int computeFixed64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeFixed64SizeNoTag(l);
    }

    public static int computeSFixed64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSFixed64SizeNoTag(l);
    }

    public static int computeFloatSize(int n, float f) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeFloatSizeNoTag(f);
    }

    public static int computeDoubleSize(int n, double d) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeDoubleSizeNoTag(d);
    }

    public static int computeBoolSize(int n, boolean bl) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeBoolSizeNoTag(bl);
    }

    public static int computeEnumSize(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeEnumSizeNoTag(n2);
    }

    public static int computeStringSize(int n, String string) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeStringSizeNoTag(string);
    }

    public static int computeBytesSize(int n, ByteString byteString) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeBytesSizeNoTag(byteString);
    }

    public static int computeByteArraySize(int n, byte[] byArray) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeByteArraySizeNoTag(byArray);
    }

    public static int computeByteBufferSize(int n, ByteBuffer byteBuffer) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeByteBufferSizeNoTag(byteBuffer);
    }

    public static int computeLazyFieldSize(int n, LazyFieldLite lazyFieldLite) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLazyFieldSizeNoTag(lazyFieldLite);
    }

    public static int computeMessageSize(int n, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeMessageSizeNoTag(messageLite);
    }

    static int computeMessageSize(int n, MessageLite messageLite, Schema schema) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeMessageSizeNoTag(messageLite, schema);
    }

    public static int computeMessageSetExtensionSize(int n, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeMessageSize(3, messageLite);
    }

    public static int computeRawMessageSetExtensionSize(int n, ByteString byteString) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeBytesSize(3, byteString);
    }

    public static int computeLazyFieldMessageSetExtensionSize(int n, LazyFieldLite lazyFieldLite) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeLazyFieldSize(3, lazyFieldLite);
    }

    public static int computeTagSize(int n) {
        return CodedOutputStream.computeUInt32SizeNoTag(WireFormat.makeTag(n, 0));
    }

    public static int computeInt32SizeNoTag(int n) {
        if (n >= 0) {
            return CodedOutputStream.computeUInt32SizeNoTag(n);
        }
        return 10;
    }

    public static int computeUInt32SizeNoTag(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int computeSInt32SizeNoTag(int n) {
        return CodedOutputStream.computeUInt32SizeNoTag(CodedOutputStream.encodeZigZag32(n));
    }

    public static int computeFixed32SizeNoTag(int n) {
        return 4;
    }

    public static int computeSFixed32SizeNoTag(int n) {
        return 4;
    }

    public static int computeInt64SizeNoTag(long l) {
        return CodedOutputStream.computeUInt64SizeNoTag(l);
    }

    public static int computeUInt64SizeNoTag(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int computeSInt64SizeNoTag(long l) {
        return CodedOutputStream.computeUInt64SizeNoTag(CodedOutputStream.encodeZigZag64(l));
    }

    public static int computeFixed64SizeNoTag(long l) {
        return 8;
    }

    public static int computeSFixed64SizeNoTag(long l) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float f) {
        return 4;
    }

    public static int computeDoubleSizeNoTag(double d) {
        return 8;
    }

    public static int computeBoolSizeNoTag(boolean bl) {
        return 1;
    }

    public static int computeEnumSizeNoTag(int n) {
        return CodedOutputStream.computeInt32SizeNoTag(n);
    }

    public static int computeStringSizeNoTag(String string) {
        int n;
        try {
            n = Utf8.encodedLength(string);
        }
        catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
            byte[] byArray = string.getBytes(Internal.UTF_8);
            n = byArray.length;
        }
        return CodedOutputStream.computeLengthDelimitedFieldSize(n);
    }

    public static int computeLazyFieldSizeNoTag(LazyFieldLite lazyFieldLite) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(lazyFieldLite.getSerializedSize());
    }

    public static int computeBytesSizeNoTag(ByteString byteString) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(byteString.size());
    }

    public static int computeByteArraySizeNoTag(byte[] byArray) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(byArray.length);
    }

    public static int computeByteBufferSizeNoTag(ByteBuffer byteBuffer) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(byteBuffer.capacity());
    }

    public static int computeMessageSizeNoTag(MessageLite messageLite) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(messageLite.getSerializedSize());
    }

    static int computeMessageSizeNoTag(MessageLite messageLite, Schema schema) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(((AbstractMessageLite)messageLite).getSerializedSize(schema));
    }

    static int computeLengthDelimitedFieldSize(int n) {
        return CodedOutputStream.computeUInt32SizeNoTag(n) + n;
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int spaceLeft();

    public final void checkNoSpaceLeft() {
        if (this.spaceLeft() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public abstract int getTotalBytesWritten();

    abstract void writeByteArrayNoTag(byte[] var1, int var2, int var3) throws IOException;

    final void inefficientWriteStringNoTag(String string, Utf8.UnpairedSurrogateException unpairedSurrogateException) throws IOException {
        logger.log(Level.WARNING, "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", unpairedSurrogateException);
        byte[] byArray = string.getBytes(Internal.UTF_8);
        try {
            this.writeUInt32NoTag(byArray.length);
            this.writeLazy(byArray, 0, byArray.length);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new OutOfSpaceException(indexOutOfBoundsException);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw outOfSpaceException;
        }
    }

    @Deprecated
    public final void writeGroup(int n, MessageLite messageLite) throws IOException {
        this.writeTag(n, 3);
        this.writeGroupNoTag(messageLite);
        this.writeTag(n, 4);
    }

    @Deprecated
    final void writeGroup(int n, MessageLite messageLite, Schema schema) throws IOException {
        this.writeTag(n, 3);
        this.writeGroupNoTag(messageLite, schema);
        this.writeTag(n, 4);
    }

    @Deprecated
    public final void writeGroupNoTag(MessageLite messageLite) throws IOException {
        messageLite.writeTo(this);
    }

    @Deprecated
    final void writeGroupNoTag(MessageLite messageLite, Schema schema) throws IOException {
        schema.writeTo(messageLite, this.wrapper);
    }

    @Deprecated
    public static int computeGroupSize(int n, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(n) * 2 + CodedOutputStream.computeGroupSizeNoTag(messageLite);
    }

    @Deprecated
    static int computeGroupSize(int n, MessageLite messageLite, Schema schema) {
        return CodedOutputStream.computeTagSize(n) * 2 + CodedOutputStream.computeGroupSizeNoTag(messageLite, schema);
    }

    @Deprecated
    public static int computeGroupSizeNoTag(MessageLite messageLite) {
        return messageLite.getSerializedSize();
    }

    @Deprecated
    static int computeGroupSizeNoTag(MessageLite messageLite, Schema schema) {
        return ((AbstractMessageLite)messageLite).getSerializedSize(schema);
    }

    @Deprecated
    public final void writeRawVarint32(int n) throws IOException {
        this.writeUInt32NoTag(n);
    }

    @Deprecated
    public final void writeRawVarint64(long l) throws IOException {
        this.writeUInt64NoTag(l);
    }

    @Deprecated
    public static int computeRawVarint32Size(int n) {
        return CodedOutputStream.computeUInt32SizeNoTag(n);
    }

    @Deprecated
    public static int computeRawVarint64Size(long l) {
        return CodedOutputStream.computeUInt64SizeNoTag(l);
    }

    @Deprecated
    public final void writeRawLittleEndian32(int n) throws IOException {
        this.writeFixed32NoTag(n);
    }

    @Deprecated
    public final void writeRawLittleEndian64(long l) throws IOException {
        this.writeFixed64NoTag(l);
    }

    private static final class OutputStreamEncoder
    extends AbstractBufferedEncoder {
        private final OutputStream out;

        OutputStreamEncoder(OutputStream outputStream, int n) {
            super(n);
            if (outputStream == null) {
                throw new NullPointerException("out");
            }
            this.out = outputStream;
        }

        @Override
        public void writeTag(int n, int n2) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(n, n2));
        }

        @Override
        public void writeInt32(int n, int n2) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(n, 0);
            this.bufferInt32NoTag(n2);
        }

        @Override
        public void writeUInt32(int n, int n2) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(n, 0);
            this.bufferUInt32NoTag(n2);
        }

        @Override
        public void writeFixed32(int n, int n2) throws IOException {
            this.flushIfNotAvailable(14);
            this.bufferTag(n, 5);
            this.bufferFixed32NoTag(n2);
        }

        @Override
        public void writeUInt64(int n, long l) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(n, 0);
            this.bufferUInt64NoTag(l);
        }

        @Override
        public void writeFixed64(int n, long l) throws IOException {
            this.flushIfNotAvailable(18);
            this.bufferTag(n, 1);
            this.bufferFixed64NoTag(l);
        }

        @Override
        public void writeBool(int n, boolean bl) throws IOException {
            this.flushIfNotAvailable(11);
            this.bufferTag(n, 0);
            this.buffer((byte)(bl ? 1 : 0));
        }

        @Override
        public void writeString(int n, String string) throws IOException {
            this.writeTag(n, 2);
            this.writeStringNoTag(string);
        }

        @Override
        public void writeBytes(int n, ByteString byteString) throws IOException {
            this.writeTag(n, 2);
            this.writeBytesNoTag(byteString);
        }

        @Override
        public void writeByteArray(int n, byte[] byArray) throws IOException {
            this.writeByteArray(n, byArray, 0, byArray.length);
        }

        @Override
        public void writeByteArray(int n, byte[] byArray, int n2, int n3) throws IOException {
            this.writeTag(n, 2);
            this.writeByteArrayNoTag(byArray, n2, n3);
        }

        @Override
        public void writeByteBuffer(int n, ByteBuffer byteBuffer) throws IOException {
            this.writeTag(n, 2);
            this.writeUInt32NoTag(byteBuffer.capacity());
            this.writeRawBytes(byteBuffer);
        }

        @Override
        public void writeBytesNoTag(ByteString byteString) throws IOException {
            this.writeUInt32NoTag(byteString.size());
            byteString.writeTo(this);
        }

        @Override
        public void writeByteArrayNoTag(byte[] byArray, int n, int n2) throws IOException {
            this.writeUInt32NoTag(n2);
            this.write(byArray, n, n2);
        }

        @Override
        public void writeRawBytes(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.hasArray()) {
                this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
            } else {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                byteBuffer2.clear();
                this.write(byteBuffer2);
            }
        }

        @Override
        public void writeMessage(int n, MessageLite messageLite) throws IOException {
            this.writeTag(n, 2);
            this.writeMessageNoTag(messageLite);
        }

        @Override
        void writeMessage(int n, MessageLite messageLite, Schema schema) throws IOException {
            this.writeTag(n, 2);
            this.writeMessageNoTag(messageLite, schema);
        }

        @Override
        public void writeMessageSetExtension(int n, MessageLite messageLite) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            this.writeMessage(3, messageLite);
            this.writeTag(1, 4);
        }

        @Override
        public void writeRawMessageSetExtension(int n, ByteString byteString) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            this.writeBytes(3, byteString);
            this.writeTag(1, 4);
        }

        @Override
        public void writeMessageNoTag(MessageLite messageLite) throws IOException {
            this.writeUInt32NoTag(messageLite.getSerializedSize());
            messageLite.writeTo(this);
        }

        @Override
        void writeMessageNoTag(MessageLite messageLite, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)messageLite).getSerializedSize(schema));
            schema.writeTo(messageLite, this.wrapper);
        }

        @Override
        public void write(byte by) throws IOException {
            if (this.position == this.limit) {
                this.doFlush();
            }
            this.buffer(by);
        }

        @Override
        public void writeInt32NoTag(int n) throws IOException {
            if (n >= 0) {
                this.writeUInt32NoTag(n);
            } else {
                this.writeUInt64NoTag(n);
            }
        }

        @Override
        public void writeUInt32NoTag(int n) throws IOException {
            this.flushIfNotAvailable(5);
            this.bufferUInt32NoTag(n);
        }

        @Override
        public void writeFixed32NoTag(int n) throws IOException {
            this.flushIfNotAvailable(4);
            this.bufferFixed32NoTag(n);
        }

        @Override
        public void writeUInt64NoTag(long l) throws IOException {
            this.flushIfNotAvailable(10);
            this.bufferUInt64NoTag(l);
        }

        @Override
        public void writeFixed64NoTag(long l) throws IOException {
            this.flushIfNotAvailable(8);
            this.bufferFixed64NoTag(l);
        }

        @Override
        public void writeStringNoTag(String string) throws IOException {
            try {
                int n = string.length() * 3;
                int n2 = OutputStreamEncoder.computeUInt32SizeNoTag(n);
                if (n2 + n > this.limit) {
                    byte[] byArray = new byte[n];
                    int n3 = Utf8.encode(string, byArray, 0, n);
                    this.writeUInt32NoTag(n3);
                    this.writeLazy(byArray, 0, n3);
                    return;
                }
                if (n2 + n > this.limit - this.position) {
                    this.doFlush();
                }
                int n4 = OutputStreamEncoder.computeUInt32SizeNoTag(string.length());
                int n5 = this.position;
                try {
                    int n6;
                    if (n4 == n2) {
                        this.position = n5 + n4;
                        int n7 = Utf8.encode(string, this.buffer, this.position, this.limit - this.position);
                        this.position = n5;
                        n6 = n7 - n5 - n4;
                        this.bufferUInt32NoTag(n6);
                        this.position = n7;
                    } else {
                        n6 = Utf8.encodedLength(string);
                        this.bufferUInt32NoTag(n6);
                        this.position = Utf8.encode(string, this.buffer, this.position, n6);
                    }
                    this.totalBytesWritten += n6;
                }
                catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
                    this.totalBytesWritten -= this.position - n5;
                    this.position = n5;
                    throw unpairedSurrogateException;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new OutOfSpaceException(arrayIndexOutOfBoundsException);
                }
            }
            catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
                this.inefficientWriteStringNoTag(string, unpairedSurrogateException);
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.position > 0) {
                this.doFlush();
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.limit - this.position >= n2) {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                this.totalBytesWritten += n2;
            } else {
                int n3 = this.limit - this.position;
                System.arraycopy(byArray, n, this.buffer, this.position, n3);
                n += n3;
                this.position = this.limit;
                this.totalBytesWritten += n3;
                this.doFlush();
                if ((n2 -= n3) <= this.limit) {
                    System.arraycopy(byArray, n, this.buffer, 0, n2);
                    this.position = n2;
                } else {
                    this.out.write(byArray, n, n2);
                }
                this.totalBytesWritten += n2;
            }
        }

        @Override
        public void writeLazy(byte[] byArray, int n, int n2) throws IOException {
            this.write(byArray, n, n2);
        }

        @Override
        public void write(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.remaining();
            if (this.limit - this.position >= n) {
                byteBuffer.get(this.buffer, this.position, n);
                this.position += n;
                this.totalBytesWritten += n;
            } else {
                int n2 = this.limit - this.position;
                byteBuffer.get(this.buffer, this.position, n2);
                n -= n2;
                this.position = this.limit;
                this.totalBytesWritten += n2;
                this.doFlush();
                while (n > this.limit) {
                    byteBuffer.get(this.buffer, 0, this.limit);
                    this.out.write(this.buffer, 0, this.limit);
                    n -= this.limit;
                    this.totalBytesWritten += this.limit;
                }
                byteBuffer.get(this.buffer, 0, n);
                this.position = n;
                this.totalBytesWritten += n;
            }
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) throws IOException {
            this.write(byteBuffer);
        }

        private void flushIfNotAvailable(int n) throws IOException {
            if (this.limit - this.position < n) {
                this.doFlush();
            }
        }

        private void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    private static final class ByteOutputEncoder
    extends AbstractBufferedEncoder {
        private final ByteOutput out;

        ByteOutputEncoder(ByteOutput byteOutput, int n) {
            super(n);
            if (byteOutput == null) {
                throw new NullPointerException("out");
            }
            this.out = byteOutput;
        }

        @Override
        public void writeTag(int n, int n2) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(n, n2));
        }

        @Override
        public void writeInt32(int n, int n2) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(n, 0);
            this.bufferInt32NoTag(n2);
        }

        @Override
        public void writeUInt32(int n, int n2) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(n, 0);
            this.bufferUInt32NoTag(n2);
        }

        @Override
        public void writeFixed32(int n, int n2) throws IOException {
            this.flushIfNotAvailable(14);
            this.bufferTag(n, 5);
            this.bufferFixed32NoTag(n2);
        }

        @Override
        public void writeUInt64(int n, long l) throws IOException {
            this.flushIfNotAvailable(20);
            this.bufferTag(n, 0);
            this.bufferUInt64NoTag(l);
        }

        @Override
        public void writeFixed64(int n, long l) throws IOException {
            this.flushIfNotAvailable(18);
            this.bufferTag(n, 1);
            this.bufferFixed64NoTag(l);
        }

        @Override
        public void writeBool(int n, boolean bl) throws IOException {
            this.flushIfNotAvailable(11);
            this.bufferTag(n, 0);
            this.buffer((byte)(bl ? 1 : 0));
        }

        @Override
        public void writeString(int n, String string) throws IOException {
            this.writeTag(n, 2);
            this.writeStringNoTag(string);
        }

        @Override
        public void writeBytes(int n, ByteString byteString) throws IOException {
            this.writeTag(n, 2);
            this.writeBytesNoTag(byteString);
        }

        @Override
        public void writeByteArray(int n, byte[] byArray) throws IOException {
            this.writeByteArray(n, byArray, 0, byArray.length);
        }

        @Override
        public void writeByteArray(int n, byte[] byArray, int n2, int n3) throws IOException {
            this.writeTag(n, 2);
            this.writeByteArrayNoTag(byArray, n2, n3);
        }

        @Override
        public void writeByteBuffer(int n, ByteBuffer byteBuffer) throws IOException {
            this.writeTag(n, 2);
            this.writeUInt32NoTag(byteBuffer.capacity());
            this.writeRawBytes(byteBuffer);
        }

        @Override
        public void writeBytesNoTag(ByteString byteString) throws IOException {
            this.writeUInt32NoTag(byteString.size());
            byteString.writeTo(this);
        }

        @Override
        public void writeByteArrayNoTag(byte[] byArray, int n, int n2) throws IOException {
            this.writeUInt32NoTag(n2);
            this.write(byArray, n, n2);
        }

        @Override
        public void writeRawBytes(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.hasArray()) {
                this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
            } else {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                byteBuffer2.clear();
                this.write(byteBuffer2);
            }
        }

        @Override
        public void writeMessage(int n, MessageLite messageLite) throws IOException {
            this.writeTag(n, 2);
            this.writeMessageNoTag(messageLite);
        }

        @Override
        void writeMessage(int n, MessageLite messageLite, Schema schema) throws IOException {
            this.writeTag(n, 2);
            this.writeMessageNoTag(messageLite, schema);
        }

        @Override
        public void writeMessageSetExtension(int n, MessageLite messageLite) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            this.writeMessage(3, messageLite);
            this.writeTag(1, 4);
        }

        @Override
        public void writeRawMessageSetExtension(int n, ByteString byteString) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            this.writeBytes(3, byteString);
            this.writeTag(1, 4);
        }

        @Override
        public void writeMessageNoTag(MessageLite messageLite) throws IOException {
            this.writeUInt32NoTag(messageLite.getSerializedSize());
            messageLite.writeTo(this);
        }

        @Override
        void writeMessageNoTag(MessageLite messageLite, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)messageLite).getSerializedSize(schema));
            schema.writeTo(messageLite, this.wrapper);
        }

        @Override
        public void write(byte by) throws IOException {
            if (this.position == this.limit) {
                this.doFlush();
            }
            this.buffer(by);
        }

        @Override
        public void writeInt32NoTag(int n) throws IOException {
            if (n >= 0) {
                this.writeUInt32NoTag(n);
            } else {
                this.writeUInt64NoTag(n);
            }
        }

        @Override
        public void writeUInt32NoTag(int n) throws IOException {
            this.flushIfNotAvailable(5);
            this.bufferUInt32NoTag(n);
        }

        @Override
        public void writeFixed32NoTag(int n) throws IOException {
            this.flushIfNotAvailable(4);
            this.bufferFixed32NoTag(n);
        }

        @Override
        public void writeUInt64NoTag(long l) throws IOException {
            this.flushIfNotAvailable(10);
            this.bufferUInt64NoTag(l);
        }

        @Override
        public void writeFixed64NoTag(long l) throws IOException {
            this.flushIfNotAvailable(8);
            this.bufferFixed64NoTag(l);
        }

        @Override
        public void writeStringNoTag(String string) throws IOException {
            int n = string.length() * 3;
            int n2 = ByteOutputEncoder.computeUInt32SizeNoTag(n);
            if (n2 + n > this.limit) {
                byte[] byArray = new byte[n];
                int n3 = Utf8.encode(string, byArray, 0, n);
                this.writeUInt32NoTag(n3);
                this.writeLazy(byArray, 0, n3);
                return;
            }
            if (n2 + n > this.limit - this.position) {
                this.doFlush();
            }
            int n4 = this.position;
            try {
                int n5 = ByteOutputEncoder.computeUInt32SizeNoTag(string.length());
                if (n5 == n2) {
                    this.position = n4 + n5;
                    int n6 = Utf8.encode(string, this.buffer, this.position, this.limit - this.position);
                    this.position = n4;
                    int n7 = n6 - n4 - n5;
                    this.bufferUInt32NoTag(n7);
                    this.position = n6;
                    this.totalBytesWritten += n7;
                } else {
                    int n8 = Utf8.encodedLength(string);
                    this.bufferUInt32NoTag(n8);
                    this.position = Utf8.encode(string, this.buffer, this.position, n8);
                    this.totalBytesWritten += n8;
                }
            }
            catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
                this.totalBytesWritten -= this.position - n4;
                this.position = n4;
                this.inefficientWriteStringNoTag(string, unpairedSurrogateException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.position > 0) {
                this.doFlush();
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.flush();
            this.out.write(byArray, n, n2);
            this.totalBytesWritten += n2;
        }

        @Override
        public void writeLazy(byte[] byArray, int n, int n2) throws IOException {
            this.flush();
            this.out.writeLazy(byArray, n, n2);
            this.totalBytesWritten += n2;
        }

        @Override
        public void write(ByteBuffer byteBuffer) throws IOException {
            this.flush();
            int n = byteBuffer.remaining();
            this.out.write(byteBuffer);
            this.totalBytesWritten += n;
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) throws IOException {
            this.flush();
            int n = byteBuffer.remaining();
            this.out.writeLazy(byteBuffer);
            this.totalBytesWritten += n;
        }

        private void flushIfNotAvailable(int n) throws IOException {
            if (this.limit - this.position < n) {
                this.doFlush();
            }
        }

        private void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    private static abstract class AbstractBufferedEncoder
    extends CodedOutputStream {
        final byte[] buffer;
        final int limit;
        int position;
        int totalBytesWritten;

        AbstractBufferedEncoder(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("bufferSize must be >= 0");
            }
            this.buffer = new byte[Math.max(n, 20)];
            this.limit = this.buffer.length;
        }

        @Override
        public final int spaceLeft() {
            throw new UnsupportedOperationException("spaceLeft() can only be called on CodedOutputStreams that are writing to a flat array or ByteBuffer.");
        }

        @Override
        public final int getTotalBytesWritten() {
            return this.totalBytesWritten;
        }

        final void buffer(byte by) {
            this.buffer[this.position++] = by;
            ++this.totalBytesWritten;
        }

        final void bufferTag(int n, int n2) {
            this.bufferUInt32NoTag(WireFormat.makeTag(n, n2));
        }

        final void bufferInt32NoTag(int n) {
            if (n >= 0) {
                this.bufferUInt32NoTag(n);
            } else {
                this.bufferUInt64NoTag(n);
            }
        }

        final void bufferUInt32NoTag(int n) {
            if (HAS_UNSAFE_ARRAY_OPERATIONS) {
                long l = this.position;
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) break;
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)n);
                int n2 = (int)((long)this.position - l);
                this.totalBytesWritten += n2;
            } else {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        ++this.totalBytesWritten;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    ++this.totalBytesWritten;
                    n >>>= 7;
                }
            }
        }

        final void bufferUInt64NoTag(long l) {
            if (HAS_UNSAFE_ARRAY_OPERATIONS) {
                long l2 = this.position;
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) break;
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)l);
                int n = (int)((long)this.position - l2);
                this.totalBytesWritten += n;
            } else {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        ++this.totalBytesWritten;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    ++this.totalBytesWritten;
                    l >>>= 7;
                }
            }
        }

        final void bufferFixed32NoTag(int n) {
            this.buffer[this.position++] = (byte)(n & 0xFF);
            this.buffer[this.position++] = (byte)(n >> 8 & 0xFF);
            this.buffer[this.position++] = (byte)(n >> 16 & 0xFF);
            this.buffer[this.position++] = (byte)(n >> 24 & 0xFF);
            this.totalBytesWritten += 4;
        }

        final void bufferFixed64NoTag(long l) {
            this.buffer[this.position++] = (byte)(l & 0xFFL);
            this.buffer[this.position++] = (byte)(l >> 8 & 0xFFL);
            this.buffer[this.position++] = (byte)(l >> 16 & 0xFFL);
            this.buffer[this.position++] = (byte)(l >> 24 & 0xFFL);
            this.buffer[this.position++] = (byte)((int)(l >> 32) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l >> 40) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l >> 48) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l >> 56) & 0xFF);
            this.totalBytesWritten += 8;
        }
    }

    private static final class UnsafeDirectNioEncoder
    extends CodedOutputStream {
        private final ByteBuffer originalBuffer;
        private final ByteBuffer buffer;
        private final long address;
        private final long initialPosition;
        private final long limit;
        private final long oneVarintLimit;
        private long position;

        UnsafeDirectNioEncoder(ByteBuffer byteBuffer) {
            this.originalBuffer = byteBuffer;
            this.buffer = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.address = UnsafeUtil.addressOffset(byteBuffer);
            this.initialPosition = this.address + (long)byteBuffer.position();
            this.limit = this.address + (long)byteBuffer.limit();
            this.oneVarintLimit = this.limit - 10L;
            this.position = this.initialPosition;
        }

        static boolean isSupported() {
            return UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        @Override
        public void writeTag(int n, int n2) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(n, n2));
        }

        @Override
        public void writeInt32(int n, int n2) throws IOException {
            this.writeTag(n, 0);
            this.writeInt32NoTag(n2);
        }

        @Override
        public void writeUInt32(int n, int n2) throws IOException {
            this.writeTag(n, 0);
            this.writeUInt32NoTag(n2);
        }

        @Override
        public void writeFixed32(int n, int n2) throws IOException {
            this.writeTag(n, 5);
            this.writeFixed32NoTag(n2);
        }

        @Override
        public void writeUInt64(int n, long l) throws IOException {
            this.writeTag(n, 0);
            this.writeUInt64NoTag(l);
        }

        @Override
        public void writeFixed64(int n, long l) throws IOException {
            this.writeTag(n, 1);
            this.writeFixed64NoTag(l);
        }

        @Override
        public void writeBool(int n, boolean bl) throws IOException {
            this.writeTag(n, 0);
            this.write((byte)(bl ? 1 : 0));
        }

        @Override
        public void writeString(int n, String string) throws IOException {
            this.writeTag(n, 2);
            this.writeStringNoTag(string);
        }

        @Override
        public void writeBytes(int n, ByteString byteString) throws IOException {
            this.writeTag(n, 2);
            this.writeBytesNoTag(byteString);
        }

        @Override
        public void writeByteArray(int n, byte[] byArray) throws IOException {
            this.writeByteArray(n, byArray, 0, byArray.length);
        }

        @Override
        public void writeByteArray(int n, byte[] byArray, int n2, int n3) throws IOException {
            this.writeTag(n, 2);
            this.writeByteArrayNoTag(byArray, n2, n3);
        }

        @Override
        public void writeByteBuffer(int n, ByteBuffer byteBuffer) throws IOException {
            this.writeTag(n, 2);
            this.writeUInt32NoTag(byteBuffer.capacity());
            this.writeRawBytes(byteBuffer);
        }

        @Override
        public void writeMessage(int n, MessageLite messageLite) throws IOException {
            this.writeTag(n, 2);
            this.writeMessageNoTag(messageLite);
        }

        @Override
        void writeMessage(int n, MessageLite messageLite, Schema schema) throws IOException {
            this.writeTag(n, 2);
            this.writeMessageNoTag(messageLite, schema);
        }

        @Override
        public void writeMessageSetExtension(int n, MessageLite messageLite) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            this.writeMessage(3, messageLite);
            this.writeTag(1, 4);
        }

        @Override
        public void writeRawMessageSetExtension(int n, ByteString byteString) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            this.writeBytes(3, byteString);
            this.writeTag(1, 4);
        }

        @Override
        public void writeMessageNoTag(MessageLite messageLite) throws IOException {
            this.writeUInt32NoTag(messageLite.getSerializedSize());
            messageLite.writeTo(this);
        }

        @Override
        void writeMessageNoTag(MessageLite messageLite, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)messageLite).getSerializedSize(schema));
            schema.writeTo(messageLite, this.wrapper);
        }

        @Override
        public void write(byte by) throws IOException {
            if (this.position >= this.limit) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1));
            }
            UnsafeUtil.putByte(this.position++, by);
        }

        @Override
        public void writeBytesNoTag(ByteString byteString) throws IOException {
            this.writeUInt32NoTag(byteString.size());
            byteString.writeTo(this);
        }

        @Override
        public void writeByteArrayNoTag(byte[] byArray, int n, int n2) throws IOException {
            this.writeUInt32NoTag(n2);
            this.write(byArray, n, n2);
        }

        @Override
        public void writeRawBytes(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.hasArray()) {
                this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
            } else {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                byteBuffer2.clear();
                this.write(byteBuffer2);
            }
        }

        @Override
        public void writeInt32NoTag(int n) throws IOException {
            if (n >= 0) {
                this.writeUInt32NoTag(n);
            } else {
                this.writeUInt64NoTag(n);
            }
        }

        @Override
        public void writeUInt32NoTag(int n) throws IOException {
            if (this.position <= this.oneVarintLimit) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        UnsafeUtil.putByte(this.position++, (byte)n);
                        return;
                    }
                    UnsafeUtil.putByte(this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.position < this.limit) {
                if ((n & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.position++, (byte)n);
                    return;
                }
                UnsafeUtil.putByte(this.position++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1));
        }

        @Override
        public void writeFixed32NoTag(int n) throws IOException {
            this.buffer.putInt(this.bufferPos(this.position), n);
            this.position += 4L;
        }

        @Override
        public void writeUInt64NoTag(long l) throws IOException {
            if (this.position <= this.oneVarintLimit) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        UnsafeUtil.putByte(this.position++, (byte)l);
                        return;
                    }
                    UnsafeUtil.putByte(this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.position < this.limit) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    UnsafeUtil.putByte(this.position++, (byte)l);
                    return;
                }
                UnsafeUtil.putByte(this.position++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1));
        }

        @Override
        public void writeFixed64NoTag(long l) throws IOException {
            this.buffer.putLong(this.bufferPos(this.position), l);
            this.position += 8L;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.limit - (long)n2 < this.position) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2));
            }
            UnsafeUtil.copyMemory(byArray, n, this.position, (long)n2);
            this.position += (long)n2;
        }

        @Override
        public void writeLazy(byte[] byArray, int n, int n2) throws IOException {
            this.write(byArray, n, n2);
        }

        @Override
        public void write(ByteBuffer byteBuffer) throws IOException {
            try {
                int n = byteBuffer.remaining();
                this.repositionBuffer(this.position);
                this.buffer.put(byteBuffer);
                this.position += (long)n;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) throws IOException {
            this.write(byteBuffer);
        }

        @Override
        public void writeStringNoTag(String string) throws IOException {
            long l = this.position;
            try {
                int n = string.length() * 3;
                int n2 = UnsafeDirectNioEncoder.computeUInt32SizeNoTag(n);
                int n3 = UnsafeDirectNioEncoder.computeUInt32SizeNoTag(string.length());
                if (n3 == n2) {
                    int n4 = this.bufferPos(this.position) + n3;
                    this.buffer.position(n4);
                    Utf8.encodeUtf8(string, this.buffer);
                    int n5 = this.buffer.position() - n4;
                    this.writeUInt32NoTag(n5);
                    this.position += (long)n5;
                } else {
                    int n6 = Utf8.encodedLength(string);
                    this.writeUInt32NoTag(n6);
                    this.repositionBuffer(this.position);
                    Utf8.encodeUtf8(string, this.buffer);
                    this.position += (long)n6;
                }
            }
            catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
                this.position = l;
                this.repositionBuffer(this.position);
                this.inefficientWriteStringNoTag(string, unpairedSurrogateException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new OutOfSpaceException(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
            this.originalBuffer.position(this.bufferPos(this.position));
        }

        @Override
        public int spaceLeft() {
            return (int)(this.limit - this.position);
        }

        @Override
        public int getTotalBytesWritten() {
            return (int)(this.position - this.initialPosition);
        }

        private void repositionBuffer(long l) {
            this.buffer.position(this.bufferPos(l));
        }

        private int bufferPos(long l) {
            return (int)(l - this.address);
        }
    }

    private static final class SafeDirectNioEncoder
    extends CodedOutputStream {
        private final ByteBuffer originalBuffer;
        private final ByteBuffer buffer;
        private final int initialPosition;

        SafeDirectNioEncoder(ByteBuffer byteBuffer) {
            this.originalBuffer = byteBuffer;
            this.buffer = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.initialPosition = byteBuffer.position();
        }

        @Override
        public void writeTag(int n, int n2) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(n, n2));
        }

        @Override
        public void writeInt32(int n, int n2) throws IOException {
            this.writeTag(n, 0);
            this.writeInt32NoTag(n2);
        }

        @Override
        public void writeUInt32(int n, int n2) throws IOException {
            this.writeTag(n, 0);
            this.writeUInt32NoTag(n2);
        }

        @Override
        public void writeFixed32(int n, int n2) throws IOException {
            this.writeTag(n, 5);
            this.writeFixed32NoTag(n2);
        }

        @Override
        public void writeUInt64(int n, long l) throws IOException {
            this.writeTag(n, 0);
            this.writeUInt64NoTag(l);
        }

        @Override
        public void writeFixed64(int n, long l) throws IOException {
            this.writeTag(n, 1);
            this.writeFixed64NoTag(l);
        }

        @Override
        public void writeBool(int n, boolean bl) throws IOException {
            this.writeTag(n, 0);
            this.write((byte)(bl ? 1 : 0));
        }

        @Override
        public void writeString(int n, String string) throws IOException {
            this.writeTag(n, 2);
            this.writeStringNoTag(string);
        }

        @Override
        public void writeBytes(int n, ByteString byteString) throws IOException {
            this.writeTag(n, 2);
            this.writeBytesNoTag(byteString);
        }

        @Override
        public void writeByteArray(int n, byte[] byArray) throws IOException {
            this.writeByteArray(n, byArray, 0, byArray.length);
        }

        @Override
        public void writeByteArray(int n, byte[] byArray, int n2, int n3) throws IOException {
            this.writeTag(n, 2);
            this.writeByteArrayNoTag(byArray, n2, n3);
        }

        @Override
        public void writeByteBuffer(int n, ByteBuffer byteBuffer) throws IOException {
            this.writeTag(n, 2);
            this.writeUInt32NoTag(byteBuffer.capacity());
            this.writeRawBytes(byteBuffer);
        }

        @Override
        public void writeMessage(int n, MessageLite messageLite) throws IOException {
            this.writeTag(n, 2);
            this.writeMessageNoTag(messageLite);
        }

        @Override
        void writeMessage(int n, MessageLite messageLite, Schema schema) throws IOException {
            this.writeTag(n, 2);
            this.writeMessageNoTag(messageLite, schema);
        }

        @Override
        public void writeMessageSetExtension(int n, MessageLite messageLite) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            this.writeMessage(3, messageLite);
            this.writeTag(1, 4);
        }

        @Override
        public void writeRawMessageSetExtension(int n, ByteString byteString) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            this.writeBytes(3, byteString);
            this.writeTag(1, 4);
        }

        @Override
        public void writeMessageNoTag(MessageLite messageLite) throws IOException {
            this.writeUInt32NoTag(messageLite.getSerializedSize());
            messageLite.writeTo(this);
        }

        @Override
        void writeMessageNoTag(MessageLite messageLite, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)messageLite).getSerializedSize(schema));
            schema.writeTo(messageLite, this.wrapper);
        }

        @Override
        public void write(byte by) throws IOException {
            try {
                this.buffer.put(by);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void writeBytesNoTag(ByteString byteString) throws IOException {
            this.writeUInt32NoTag(byteString.size());
            byteString.writeTo(this);
        }

        @Override
        public void writeByteArrayNoTag(byte[] byArray, int n, int n2) throws IOException {
            this.writeUInt32NoTag(n2);
            this.write(byArray, n, n2);
        }

        @Override
        public void writeRawBytes(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.hasArray()) {
                this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
            } else {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                byteBuffer2.clear();
                this.write(byteBuffer2);
            }
        }

        @Override
        public void writeInt32NoTag(int n) throws IOException {
            if (n >= 0) {
                this.writeUInt32NoTag(n);
            } else {
                this.writeUInt64NoTag(n);
            }
        }

        @Override
        public void writeUInt32NoTag(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer.put((byte)n);
                        return;
                    }
                    this.buffer.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void writeFixed32NoTag(int n) throws IOException {
            try {
                this.buffer.putInt(n);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void writeUInt64NoTag(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer.put((byte)l);
                        return;
                    }
                    this.buffer.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void writeFixed64NoTag(long l) throws IOException {
            try {
                this.buffer.putLong(l);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.buffer.put(byArray, n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void writeLazy(byte[] byArray, int n, int n2) throws IOException {
            this.write(byArray, n, n2);
        }

        @Override
        public void write(ByteBuffer byteBuffer) throws IOException {
            try {
                this.buffer.put(byteBuffer);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new OutOfSpaceException(bufferOverflowException);
            }
        }

        @Override
        public void writeLazy(ByteBuffer byteBuffer) throws IOException {
            this.write(byteBuffer);
        }

        @Override
        public void writeStringNoTag(String string) throws IOException {
            int n = this.buffer.position();
            try {
                int n2 = string.length() * 3;
                int n3 = SafeDirectNioEncoder.computeUInt32SizeNoTag(n2);
                int n4 = SafeDirectNioEncoder.computeUInt32SizeNoTag(string.length());
                if (n4 == n3) {
                    int n5 = this.buffer.position() + n4;
                    this.buffer.position(n5);
                    this.encode(string);
                    int n6 = this.buffer.position();
                    this.buffer.position(n);
                    this.writeUInt32NoTag(n6 - n5);
                    this.buffer.position(n6);
                } else {
                    int n7 = Utf8.encodedLength(string);
                    this.writeUInt32NoTag(n7);
                    this.encode(string);
                }
            }
            catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
                this.buffer.position(n);
                this.inefficientWriteStringNoTag(string, unpairedSurrogateException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new OutOfSpaceException(illegalArgumentException);
            }
        }

        @Override
        public void flush() {
            this.originalBuffer.position(this.buffer.position());
        }

        @Override
        public int spaceLeft() {
            return this.buffer.remaining();
        }

        @Override
        public int getTotalBytesWritten() {
            return this.buffer.position() - this.initialPosition;
        }

        private void encode(String string) throws IOException {
            try {
                Utf8.encodeUtf8(string, this.buffer);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(indexOutOfBoundsException);
            }
        }
    }

    private static final class HeapNioEncoder
    extends ArrayEncoder {
        private final ByteBuffer byteBuffer;
        private int initialPosition;

        HeapNioEncoder(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.byteBuffer = byteBuffer;
            this.initialPosition = byteBuffer.position();
        }

        @Override
        public void flush() {
            this.byteBuffer.position(this.initialPosition + this.getTotalBytesWritten());
        }
    }

    private static class ArrayEncoder
    extends CodedOutputStream {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        ArrayEncoder(byte[] byArray, int n, int n2) {
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void writeTag(int n, int n2) throws IOException {
            this.writeUInt32NoTag(WireFormat.makeTag(n, n2));
        }

        @Override
        public final void writeInt32(int n, int n2) throws IOException {
            this.writeTag(n, 0);
            this.writeInt32NoTag(n2);
        }

        @Override
        public final void writeUInt32(int n, int n2) throws IOException {
            this.writeTag(n, 0);
            this.writeUInt32NoTag(n2);
        }

        @Override
        public final void writeFixed32(int n, int n2) throws IOException {
            this.writeTag(n, 5);
            this.writeFixed32NoTag(n2);
        }

        @Override
        public final void writeUInt64(int n, long l) throws IOException {
            this.writeTag(n, 0);
            this.writeUInt64NoTag(l);
        }

        @Override
        public final void writeFixed64(int n, long l) throws IOException {
            this.writeTag(n, 1);
            this.writeFixed64NoTag(l);
        }

        @Override
        public final void writeBool(int n, boolean bl) throws IOException {
            this.writeTag(n, 0);
            this.write((byte)(bl ? 1 : 0));
        }

        @Override
        public final void writeString(int n, String string) throws IOException {
            this.writeTag(n, 2);
            this.writeStringNoTag(string);
        }

        @Override
        public final void writeBytes(int n, ByteString byteString) throws IOException {
            this.writeTag(n, 2);
            this.writeBytesNoTag(byteString);
        }

        @Override
        public final void writeByteArray(int n, byte[] byArray) throws IOException {
            this.writeByteArray(n, byArray, 0, byArray.length);
        }

        @Override
        public final void writeByteArray(int n, byte[] byArray, int n2, int n3) throws IOException {
            this.writeTag(n, 2);
            this.writeByteArrayNoTag(byArray, n2, n3);
        }

        @Override
        public final void writeByteBuffer(int n, ByteBuffer byteBuffer) throws IOException {
            this.writeTag(n, 2);
            this.writeUInt32NoTag(byteBuffer.capacity());
            this.writeRawBytes(byteBuffer);
        }

        @Override
        public final void writeBytesNoTag(ByteString byteString) throws IOException {
            this.writeUInt32NoTag(byteString.size());
            byteString.writeTo(this);
        }

        @Override
        public final void writeByteArrayNoTag(byte[] byArray, int n, int n2) throws IOException {
            this.writeUInt32NoTag(n2);
            this.write(byArray, n, n2);
        }

        @Override
        public final void writeRawBytes(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.hasArray()) {
                this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
            } else {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                byteBuffer2.clear();
                this.write(byteBuffer2);
            }
        }

        @Override
        public final void writeMessage(int n, MessageLite messageLite) throws IOException {
            this.writeTag(n, 2);
            this.writeMessageNoTag(messageLite);
        }

        @Override
        final void writeMessage(int n, MessageLite messageLite, Schema schema) throws IOException {
            this.writeTag(n, 2);
            this.writeUInt32NoTag(((AbstractMessageLite)messageLite).getSerializedSize(schema));
            schema.writeTo(messageLite, this.wrapper);
        }

        @Override
        public final void writeMessageSetExtension(int n, MessageLite messageLite) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            this.writeMessage(3, messageLite);
            this.writeTag(1, 4);
        }

        @Override
        public final void writeRawMessageSetExtension(int n, ByteString byteString) throws IOException {
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            this.writeBytes(3, byteString);
            this.writeTag(1, 4);
        }

        @Override
        public final void writeMessageNoTag(MessageLite messageLite) throws IOException {
            this.writeUInt32NoTag(messageLite.getSerializedSize());
            messageLite.writeTo(this);
        }

        @Override
        final void writeMessageNoTag(MessageLite messageLite, Schema schema) throws IOException {
            this.writeUInt32NoTag(((AbstractMessageLite)messageLite).getSerializedSize(schema));
            schema.writeTo(messageLite, this.wrapper);
        }

        @Override
        public final void write(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void writeInt32NoTag(int n) throws IOException {
            if (n >= 0) {
                this.writeUInt32NoTag(n);
            } else {
                this.writeUInt64NoTag(n);
            }
        }

        @Override
        public final void writeUInt32NoTag(int n) throws IOException {
            if (HAS_UNSAFE_ARRAY_OPERATIONS && !Android.isOnAndroidDevice() && this.spaceLeft() >= 5) {
                if ((n & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
            } else {
                try {
                    while (true) {
                        if ((n & 0xFFFFFF80) == 0) {
                            this.buffer[this.position++] = (byte)n;
                            return;
                        }
                        this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                        n >>>= 7;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
                }
            }
            UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(n | 0x80));
            UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(n >>>= 7));
        }

        @Override
        public final void writeFixed32NoTag(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)(n & 0xFF);
                this.buffer[this.position++] = (byte)(n >> 8 & 0xFF);
                this.buffer[this.position++] = (byte)(n >> 16 & 0xFF);
                this.buffer[this.position++] = (byte)(n >> 24 & 0xFF);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void writeUInt64NoTag(long l) throws IOException {
            if (HAS_UNSAFE_ARRAY_OPERATIONS && this.spaceLeft() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void writeFixed64NoTag(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)((int)l & 0xFF);
                this.buffer[this.position++] = (byte)((int)(l >> 8) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(l >> 16) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(l >> 24) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(l >> 32) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(l >> 40) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(l >> 48) & 0xFF);
                this.buffer[this.position++] = (byte)((int)(l >> 56) & 0xFF);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void writeLazy(byte[] byArray, int n, int n2) throws IOException {
            this.write(byArray, n, n2);
        }

        @Override
        public final void write(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.remaining();
            try {
                byteBuffer.get(this.buffer, this.position, n);
                this.position += n;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n), indexOutOfBoundsException);
            }
        }

        @Override
        public final void writeLazy(ByteBuffer byteBuffer) throws IOException {
            this.write(byteBuffer);
        }

        @Override
        public final void writeStringNoTag(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = string.length() * 3;
                int n3 = ArrayEncoder.computeUInt32SizeNoTag(n2);
                int n4 = ArrayEncoder.computeUInt32SizeNoTag(string.length());
                if (n4 == n3) {
                    this.position = n + n4;
                    int n5 = Utf8.encode(string, this.buffer, this.position, this.spaceLeft());
                    this.position = n;
                    int n6 = n5 - n - n4;
                    this.writeUInt32NoTag(n6);
                    this.position = n5;
                } else {
                    int n7 = Utf8.encodedLength(string);
                    this.writeUInt32NoTag(n7);
                    this.position = Utf8.encode(string, this.buffer, this.position, this.spaceLeft());
                }
            }
            catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
                this.position = n;
                this.inefficientWriteStringNoTag(string, unpairedSurrogateException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new OutOfSpaceException(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int spaceLeft() {
            return this.limit - this.position;
        }

        @Override
        public final int getTotalBytesWritten() {
            return this.position - this.offset;
        }
    }

    public static class OutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = -6947486886997889499L;
        private static final String MESSAGE = "CodedOutputStream was writing to a flat byte array and ran out of space.";

        OutOfSpaceException() {
            super(MESSAGE);
        }

        OutOfSpaceException(String string) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.: " + string);
        }

        OutOfSpaceException(Throwable throwable) {
            super(MESSAGE, throwable);
        }

        OutOfSpaceException(String string, Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.: " + string, throwable);
        }
    }
}

