/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AllocatedBuffer;
import java.nio.ByteBuffer;

abstract class BufferAllocator {
    private static final BufferAllocator UNPOOLED = new BufferAllocator(){

        @Override
        public AllocatedBuffer allocateHeapBuffer(int n) {
            return AllocatedBuffer.wrap(new byte[n]);
        }

        @Override
        public AllocatedBuffer allocateDirectBuffer(int n) {
            return AllocatedBuffer.wrap(ByteBuffer.allocateDirect(n));
        }
    };

    BufferAllocator() {
    }

    public static BufferAllocator unpooled() {
        return UNPOOLED;
    }

    public abstract AllocatedBuffer allocateHeapBuffer(int var1);

    public abstract AllocatedBuffer allocateDirectBuffer(int var1);
}

