/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.CpModelProto;
import com.google.ortools.sat.CpSolverResponse;
import com.google.ortools.sat.IntegerVariableProto;
import com.google.ortools.sat.SatParameters;
import com.google.ortools.sat.SolutionCallback;
import com.google.ortools.sat.mainJNI;
import com.google.ortools.util.Domain;
import com.google.protobuf.InvalidProtocolBufferException;

public class SatHelper {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    public SatHelper(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(SatHelper satHelper) {
        return satHelper == null ? 0L : satHelper.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_SatHelper(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static CpSolverResponse solve(CpModelProto cpModelProto) {
        byte[] byArray = mainJNI.SatHelper_solve(cpModelProto.toByteArray());
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            return CpSolverResponse.parseFrom(byArray);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw new RuntimeException("Unable to parse com.google.ortools.sat.CpSolverResponse protocol message.");
        }
    }

    public static CpSolverResponse solveWithParameters(CpModelProto cpModelProto, SatParameters satParameters) {
        byte[] byArray = mainJNI.SatHelper_solveWithParameters(cpModelProto.toByteArray(), satParameters.toByteArray());
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            return CpSolverResponse.parseFrom(byArray);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw new RuntimeException("Unable to parse com.google.ortools.sat.CpSolverResponse protocol message.");
        }
    }

    public static CpSolverResponse solveWithParametersAndSolutionCallback(CpModelProto cpModelProto, SatParameters satParameters, SolutionCallback solutionCallback) {
        byte[] byArray = mainJNI.SatHelper_solveWithParametersAndSolutionCallback(cpModelProto.toByteArray(), satParameters.toByteArray(), SolutionCallback.getCPtr(solutionCallback), solutionCallback);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            return CpSolverResponse.parseFrom(byArray);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw new RuntimeException("Unable to parse com.google.ortools.sat.CpSolverResponse protocol message.");
        }
    }

    public static String modelStats(CpModelProto cpModelProto) {
        return mainJNI.SatHelper_modelStats(cpModelProto.toByteArray());
    }

    public static String solverResponseStats(CpSolverResponse cpSolverResponse) {
        return mainJNI.SatHelper_solverResponseStats(cpSolverResponse.toByteArray());
    }

    public static String validateModel(CpModelProto cpModelProto) {
        return mainJNI.SatHelper_validateModel(cpModelProto.toByteArray());
    }

    public static Domain variableDomain(IntegerVariableProto integerVariableProto) {
        return new Domain(mainJNI.SatHelper_variableDomain(integerVariableProto.toByteArray()), true);
    }

    public SatHelper() {
        this(mainJNI.new_SatHelper(), true);
    }
}

