/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.CpModelProto;
import com.google.ortools.sat.IntegerVariableProto;
import com.google.ortools.sat.LinearExpr;
import com.google.ortools.sat.Literal;
import com.google.ortools.sat.NotBooleanVariable;
import com.google.ortools.sat.SatHelper;
import com.google.ortools.util.Domain;

public final class IntVar
implements Literal,
LinearExpr {
    private final CpModelProto.Builder modelBuilder;
    private final int variableIndex;
    private final IntegerVariableProto.Builder varBuilder;
    private NotBooleanVariable negation_ = null;

    IntVar(CpModelProto.Builder builder, Domain domain, String string) {
        this.modelBuilder = builder;
        this.variableIndex = this.modelBuilder.getVariablesCount();
        this.varBuilder = this.modelBuilder.addVariablesBuilder();
        this.varBuilder.setName(string);
        for (long l : domain.flattenedIntervals()) {
            this.varBuilder.addDomain(l);
        }
        this.negation_ = null;
    }

    public String toString() {
        return this.varBuilder.toString();
    }

    public String getName() {
        return this.varBuilder.getName();
    }

    @Override
    public int getIndex() {
        return this.variableIndex;
    }

    public IntegerVariableProto.Builder getBuilder() {
        return this.varBuilder;
    }

    @Override
    public int numElements() {
        return 1;
    }

    @Override
    public IntVar getVariable(int n) {
        assert (n == 0);
        return this;
    }

    @Override
    public long getCoefficient(int n) {
        assert (n == 0);
        return 1L;
    }

    @Override
    public String getShortString() {
        if (this.varBuilder.getName().isEmpty()) {
            if (this.varBuilder.getDomainCount() == 2 && this.varBuilder.getDomain(0) == this.varBuilder.getDomain(1)) {
                return String.format("%d", this.varBuilder.getDomain(0));
            }
            return String.format("var_%d(%s)", this.getIndex(), this.displayBounds());
        }
        return String.format("%s(%s)", this.getName(), this.displayBounds());
    }

    public String displayBounds() {
        String string = "";
        for (int i = 0; i < this.varBuilder.getDomainCount(); i += 2) {
            if (i != 0) {
                string = string + ", ";
            }
            string = this.varBuilder.getDomain(i) == this.varBuilder.getDomain(i + 1) ? string + String.format("%d", this.varBuilder.getDomain(i)) : string + String.format("%d..%d", this.varBuilder.getDomain(i), this.varBuilder.getDomain(i + 1));
        }
        return string;
    }

    @Override
    public Literal not() {
        if (this.negation_ == null) {
            this.negation_ = new NotBooleanVariable(this);
        }
        return this.negation_;
    }

    public Domain getDomain() {
        return SatHelper.variableDomain(this.varBuilder.build());
    }
}

