/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.CpModelProtobuf;
import com.google.ortools.sat.CpSolverResponseOrBuilder;
import com.google.ortools.sat.CpSolverStatus;
import com.google.ortools.sat.IntegerVariableProto;
import com.google.ortools.sat.IntegerVariableProtoOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class CpSolverResponse
extends GeneratedMessageV3
implements CpSolverResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int STATUS_FIELD_NUMBER = 1;
    private int status_;
    public static final int SOLUTION_FIELD_NUMBER = 2;
    private Internal.LongList solution_;
    private int solutionMemoizedSerializedSize = -1;
    public static final int OBJECTIVE_VALUE_FIELD_NUMBER = 3;
    private double objectiveValue_;
    public static final int BEST_OBJECTIVE_BOUND_FIELD_NUMBER = 4;
    private double bestObjectiveBound_;
    public static final int SOLUTION_LOWER_BOUNDS_FIELD_NUMBER = 18;
    private Internal.LongList solutionLowerBounds_;
    private int solutionLowerBoundsMemoizedSerializedSize = -1;
    public static final int SOLUTION_UPPER_BOUNDS_FIELD_NUMBER = 19;
    private Internal.LongList solutionUpperBounds_;
    private int solutionUpperBoundsMemoizedSerializedSize = -1;
    public static final int TIGHTENED_VARIABLES_FIELD_NUMBER = 21;
    private List<IntegerVariableProto> tightenedVariables_;
    public static final int SUFFICIENT_ASSUMPTIONS_FOR_INFEASIBILITY_FIELD_NUMBER = 23;
    private Internal.IntList sufficientAssumptionsForInfeasibility_;
    private int sufficientAssumptionsForInfeasibilityMemoizedSerializedSize = -1;
    public static final int ALL_SOLUTIONS_WERE_FOUND_FIELD_NUMBER = 5;
    private boolean allSolutionsWereFound_;
    public static final int NUM_BOOLEANS_FIELD_NUMBER = 10;
    private long numBooleans_;
    public static final int NUM_CONFLICTS_FIELD_NUMBER = 11;
    private long numConflicts_;
    public static final int NUM_BRANCHES_FIELD_NUMBER = 12;
    private long numBranches_;
    public static final int NUM_BINARY_PROPAGATIONS_FIELD_NUMBER = 13;
    private long numBinaryPropagations_;
    public static final int NUM_INTEGER_PROPAGATIONS_FIELD_NUMBER = 14;
    private long numIntegerPropagations_;
    public static final int WALL_TIME_FIELD_NUMBER = 15;
    private double wallTime_;
    public static final int USER_TIME_FIELD_NUMBER = 16;
    private double userTime_;
    public static final int DETERMINISTIC_TIME_FIELD_NUMBER = 17;
    private double deterministicTime_;
    public static final int PRIMAL_INTEGRAL_FIELD_NUMBER = 22;
    private double primalIntegral_;
    public static final int SOLUTION_INFO_FIELD_NUMBER = 20;
    private volatile Object solutionInfo_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final CpSolverResponse DEFAULT_INSTANCE = new CpSolverResponse();
    private static final Parser<CpSolverResponse> PARSER = new AbstractParser<CpSolverResponse>(){

        public CpSolverResponse parsePartialFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return new CpSolverResponse(codedInputStream, extensionRegistryLite);
        }
    };

    private CpSolverResponse(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private CpSolverResponse() {
        this.status_ = 0;
        this.solution_ = CpSolverResponse.emptyLongList();
        this.solutionLowerBounds_ = CpSolverResponse.emptyLongList();
        this.solutionUpperBounds_ = CpSolverResponse.emptyLongList();
        this.tightenedVariables_ = Collections.emptyList();
        this.sufficientAssumptionsForInfeasibility_ = CpSolverResponse.emptyIntList();
        this.solutionInfo_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unusedPrivateParameter) {
        return new CpSolverResponse();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private CpSolverResponse(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistryLite == null) {
            throw new NullPointerException();
        }
        int n = 0;
        UnknownFieldSet.Builder builder = UnknownFieldSet.newBuilder();
        try {
            boolean bl = false;
            block32: while (!bl) {
                int n2 = codedInputStream.readTag();
                switch (n2) {
                    case 0: {
                        bl = true;
                        continue block32;
                    }
                    case 8: {
                        int n3;
                        this.status_ = n3 = codedInputStream.readEnum();
                        continue block32;
                    }
                    case 16: {
                        if ((n & 1) == 0) {
                            this.solution_ = CpSolverResponse.newLongList();
                            n |= 1;
                        }
                        this.solution_.addLong(codedInputStream.readInt64());
                        continue block32;
                    }
                    case 18: {
                        int n4 = codedInputStream.readRawVarint32();
                        int n5 = codedInputStream.pushLimit(n4);
                        if ((n & 1) == 0 && codedInputStream.getBytesUntilLimit() > 0) {
                            this.solution_ = CpSolverResponse.newLongList();
                            n |= 1;
                        }
                        while (codedInputStream.getBytesUntilLimit() > 0) {
                            this.solution_.addLong(codedInputStream.readInt64());
                        }
                        codedInputStream.popLimit(n5);
                        continue block32;
                    }
                    case 25: {
                        this.objectiveValue_ = codedInputStream.readDouble();
                        continue block32;
                    }
                    case 33: {
                        this.bestObjectiveBound_ = codedInputStream.readDouble();
                        continue block32;
                    }
                    case 40: {
                        this.allSolutionsWereFound_ = codedInputStream.readBool();
                        continue block32;
                    }
                    case 80: {
                        this.numBooleans_ = codedInputStream.readInt64();
                        continue block32;
                    }
                    case 88: {
                        this.numConflicts_ = codedInputStream.readInt64();
                        continue block32;
                    }
                    case 96: {
                        this.numBranches_ = codedInputStream.readInt64();
                        continue block32;
                    }
                    case 104: {
                        this.numBinaryPropagations_ = codedInputStream.readInt64();
                        continue block32;
                    }
                    case 112: {
                        this.numIntegerPropagations_ = codedInputStream.readInt64();
                        continue block32;
                    }
                    case 121: {
                        this.wallTime_ = codedInputStream.readDouble();
                        continue block32;
                    }
                    case 129: {
                        this.userTime_ = codedInputStream.readDouble();
                        continue block32;
                    }
                    case 137: {
                        this.deterministicTime_ = codedInputStream.readDouble();
                        continue block32;
                    }
                    case 144: {
                        if ((n & 2) == 0) {
                            this.solutionLowerBounds_ = CpSolverResponse.newLongList();
                            n |= 2;
                        }
                        this.solutionLowerBounds_.addLong(codedInputStream.readInt64());
                        continue block32;
                    }
                    case 146: {
                        int n6 = codedInputStream.readRawVarint32();
                        int n5 = codedInputStream.pushLimit(n6);
                        if ((n & 2) == 0 && codedInputStream.getBytesUntilLimit() > 0) {
                            this.solutionLowerBounds_ = CpSolverResponse.newLongList();
                            n |= 2;
                        }
                        while (codedInputStream.getBytesUntilLimit() > 0) {
                            this.solutionLowerBounds_.addLong(codedInputStream.readInt64());
                        }
                        codedInputStream.popLimit(n5);
                        continue block32;
                    }
                    case 152: {
                        if ((n & 4) == 0) {
                            this.solutionUpperBounds_ = CpSolverResponse.newLongList();
                            n |= 4;
                        }
                        this.solutionUpperBounds_.addLong(codedInputStream.readInt64());
                        continue block32;
                    }
                    case 154: {
                        int n7 = codedInputStream.readRawVarint32();
                        int n5 = codedInputStream.pushLimit(n7);
                        if ((n & 4) == 0 && codedInputStream.getBytesUntilLimit() > 0) {
                            this.solutionUpperBounds_ = CpSolverResponse.newLongList();
                            n |= 4;
                        }
                        while (codedInputStream.getBytesUntilLimit() > 0) {
                            this.solutionUpperBounds_.addLong(codedInputStream.readInt64());
                        }
                        codedInputStream.popLimit(n5);
                        continue block32;
                    }
                    case 162: {
                        String string = codedInputStream.readStringRequireUtf8();
                        this.solutionInfo_ = string;
                        continue block32;
                    }
                    case 170: {
                        if ((n & 8) == 0) {
                            this.tightenedVariables_ = new ArrayList<IntegerVariableProto>();
                            n |= 8;
                        }
                        this.tightenedVariables_.add((IntegerVariableProto)codedInputStream.readMessage(IntegerVariableProto.parser(), extensionRegistryLite));
                        continue block32;
                    }
                    case 177: {
                        this.primalIntegral_ = codedInputStream.readDouble();
                        continue block32;
                    }
                    case 184: {
                        if ((n & 0x10) == 0) {
                            this.sufficientAssumptionsForInfeasibility_ = CpSolverResponse.newIntList();
                            n |= 0x10;
                        }
                        this.sufficientAssumptionsForInfeasibility_.addInt(codedInputStream.readInt32());
                        continue block32;
                    }
                    case 186: {
                        int n8 = codedInputStream.readRawVarint32();
                        int n5 = codedInputStream.pushLimit(n8);
                        if ((n & 0x10) == 0 && codedInputStream.getBytesUntilLimit() > 0) {
                            this.sufficientAssumptionsForInfeasibility_ = CpSolverResponse.newIntList();
                            n |= 0x10;
                        }
                        while (codedInputStream.getBytesUntilLimit() > 0) {
                            this.sufficientAssumptionsForInfeasibility_.addInt(codedInputStream.readInt32());
                        }
                        codedInputStream.popLimit(n5);
                        continue block32;
                    }
                }
                if (this.parseUnknownField(codedInputStream, builder, extensionRegistryLite, n2)) continue;
                bl = true;
            }
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw invalidProtocolBufferException.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException iOException) {
            throw new InvalidProtocolBufferException(iOException).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (n & true) {
                this.solution_.makeImmutable();
            }
            if ((n & 2) != 0) {
                this.solutionLowerBounds_.makeImmutable();
            }
            if ((n & 4) != 0) {
                this.solutionUpperBounds_.makeImmutable();
            }
            if ((n & 8) != 0) {
                this.tightenedVariables_ = Collections.unmodifiableList(this.tightenedVariables_);
            }
            if ((n & 0x10) != 0) {
                this.sufficientAssumptionsForInfeasibility_.makeImmutable();
            }
            this.unknownFields = builder.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CpModelProtobuf.internal_static_operations_research_sat_CpSolverResponse_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CpModelProtobuf.internal_static_operations_research_sat_CpSolverResponse_fieldAccessorTable.ensureFieldAccessorsInitialized(CpSolverResponse.class, Builder.class);
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public CpSolverStatus getStatus() {
        CpSolverStatus cpSolverStatus = CpSolverStatus.valueOf(this.status_);
        return cpSolverStatus == null ? CpSolverStatus.UNRECOGNIZED : cpSolverStatus;
    }

    @Override
    public List<Long> getSolutionList() {
        return this.solution_;
    }

    @Override
    public int getSolutionCount() {
        return this.solution_.size();
    }

    @Override
    public long getSolution(int n) {
        return this.solution_.getLong(n);
    }

    @Override
    public double getObjectiveValue() {
        return this.objectiveValue_;
    }

    @Override
    public double getBestObjectiveBound() {
        return this.bestObjectiveBound_;
    }

    @Override
    public List<Long> getSolutionLowerBoundsList() {
        return this.solutionLowerBounds_;
    }

    @Override
    public int getSolutionLowerBoundsCount() {
        return this.solutionLowerBounds_.size();
    }

    @Override
    public long getSolutionLowerBounds(int n) {
        return this.solutionLowerBounds_.getLong(n);
    }

    @Override
    public List<Long> getSolutionUpperBoundsList() {
        return this.solutionUpperBounds_;
    }

    @Override
    public int getSolutionUpperBoundsCount() {
        return this.solutionUpperBounds_.size();
    }

    @Override
    public long getSolutionUpperBounds(int n) {
        return this.solutionUpperBounds_.getLong(n);
    }

    @Override
    public List<IntegerVariableProto> getTightenedVariablesList() {
        return this.tightenedVariables_;
    }

    @Override
    public List<? extends IntegerVariableProtoOrBuilder> getTightenedVariablesOrBuilderList() {
        return this.tightenedVariables_;
    }

    @Override
    public int getTightenedVariablesCount() {
        return this.tightenedVariables_.size();
    }

    @Override
    public IntegerVariableProto getTightenedVariables(int n) {
        return this.tightenedVariables_.get(n);
    }

    @Override
    public IntegerVariableProtoOrBuilder getTightenedVariablesOrBuilder(int n) {
        return this.tightenedVariables_.get(n);
    }

    @Override
    public List<Integer> getSufficientAssumptionsForInfeasibilityList() {
        return this.sufficientAssumptionsForInfeasibility_;
    }

    @Override
    public int getSufficientAssumptionsForInfeasibilityCount() {
        return this.sufficientAssumptionsForInfeasibility_.size();
    }

    @Override
    public int getSufficientAssumptionsForInfeasibility(int n) {
        return this.sufficientAssumptionsForInfeasibility_.getInt(n);
    }

    @Override
    public boolean getAllSolutionsWereFound() {
        return this.allSolutionsWereFound_;
    }

    @Override
    public long getNumBooleans() {
        return this.numBooleans_;
    }

    @Override
    public long getNumConflicts() {
        return this.numConflicts_;
    }

    @Override
    public long getNumBranches() {
        return this.numBranches_;
    }

    @Override
    public long getNumBinaryPropagations() {
        return this.numBinaryPropagations_;
    }

    @Override
    public long getNumIntegerPropagations() {
        return this.numIntegerPropagations_;
    }

    @Override
    public double getWallTime() {
        return this.wallTime_;
    }

    @Override
    public double getUserTime() {
        return this.userTime_;
    }

    @Override
    public double getDeterministicTime() {
        return this.deterministicTime_;
    }

    @Override
    public double getPrimalIntegral() {
        return this.primalIntegral_;
    }

    @Override
    public String getSolutionInfo() {
        Object object = this.solutionInfo_;
        if (object instanceof String) {
            return (String)object;
        }
        ByteString byteString = (ByteString)object;
        String string = byteString.toStringUtf8();
        this.solutionInfo_ = string;
        return string;
    }

    @Override
    public ByteString getSolutionInfoBytes() {
        Object object = this.solutionInfo_;
        if (object instanceof String) {
            ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
            this.solutionInfo_ = byteString;
            return byteString;
        }
        return (ByteString)object;
    }

    public final boolean isInitialized() {
        byte by = this.memoizedIsInitialized;
        if (by == 1) {
            return true;
        }
        if (by == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        int n;
        this.getSerializedSize();
        if (this.status_ != CpSolverStatus.UNKNOWN.getNumber()) {
            codedOutputStream.writeEnum(1, this.status_);
        }
        if (this.getSolutionList().size() > 0) {
            codedOutputStream.writeUInt32NoTag(18);
            codedOutputStream.writeUInt32NoTag(this.solutionMemoizedSerializedSize);
        }
        for (n = 0; n < this.solution_.size(); ++n) {
            codedOutputStream.writeInt64NoTag(this.solution_.getLong(n));
        }
        if (this.objectiveValue_ != 0.0) {
            codedOutputStream.writeDouble(3, this.objectiveValue_);
        }
        if (this.bestObjectiveBound_ != 0.0) {
            codedOutputStream.writeDouble(4, this.bestObjectiveBound_);
        }
        if (this.allSolutionsWereFound_) {
            codedOutputStream.writeBool(5, this.allSolutionsWereFound_);
        }
        if (this.numBooleans_ != 0L) {
            codedOutputStream.writeInt64(10, this.numBooleans_);
        }
        if (this.numConflicts_ != 0L) {
            codedOutputStream.writeInt64(11, this.numConflicts_);
        }
        if (this.numBranches_ != 0L) {
            codedOutputStream.writeInt64(12, this.numBranches_);
        }
        if (this.numBinaryPropagations_ != 0L) {
            codedOutputStream.writeInt64(13, this.numBinaryPropagations_);
        }
        if (this.numIntegerPropagations_ != 0L) {
            codedOutputStream.writeInt64(14, this.numIntegerPropagations_);
        }
        if (this.wallTime_ != 0.0) {
            codedOutputStream.writeDouble(15, this.wallTime_);
        }
        if (this.userTime_ != 0.0) {
            codedOutputStream.writeDouble(16, this.userTime_);
        }
        if (this.deterministicTime_ != 0.0) {
            codedOutputStream.writeDouble(17, this.deterministicTime_);
        }
        if (this.getSolutionLowerBoundsList().size() > 0) {
            codedOutputStream.writeUInt32NoTag(146);
            codedOutputStream.writeUInt32NoTag(this.solutionLowerBoundsMemoizedSerializedSize);
        }
        for (n = 0; n < this.solutionLowerBounds_.size(); ++n) {
            codedOutputStream.writeInt64NoTag(this.solutionLowerBounds_.getLong(n));
        }
        if (this.getSolutionUpperBoundsList().size() > 0) {
            codedOutputStream.writeUInt32NoTag(154);
            codedOutputStream.writeUInt32NoTag(this.solutionUpperBoundsMemoizedSerializedSize);
        }
        for (n = 0; n < this.solutionUpperBounds_.size(); ++n) {
            codedOutputStream.writeInt64NoTag(this.solutionUpperBounds_.getLong(n));
        }
        if (!this.getSolutionInfoBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)codedOutputStream, (int)20, (Object)this.solutionInfo_);
        }
        for (n = 0; n < this.tightenedVariables_.size(); ++n) {
            codedOutputStream.writeMessage(21, (MessageLite)this.tightenedVariables_.get(n));
        }
        if (this.primalIntegral_ != 0.0) {
            codedOutputStream.writeDouble(22, this.primalIntegral_);
        }
        if (this.getSufficientAssumptionsForInfeasibilityList().size() > 0) {
            codedOutputStream.writeUInt32NoTag(186);
            codedOutputStream.writeUInt32NoTag(this.sufficientAssumptionsForInfeasibilityMemoizedSerializedSize);
        }
        for (n = 0; n < this.sufficientAssumptionsForInfeasibility_.size(); ++n) {
            codedOutputStream.writeInt32NoTag(this.sufficientAssumptionsForInfeasibility_.getInt(n));
        }
        this.unknownFields.writeTo(codedOutputStream);
    }

    public int getSerializedSize() {
        int n;
        int n2 = this.memoizedSize;
        if (n2 != -1) {
            return n2;
        }
        n2 = 0;
        if (this.status_ != CpSolverStatus.UNKNOWN.getNumber()) {
            n2 += CodedOutputStream.computeEnumSize((int)1, (int)this.status_);
        }
        int n3 = 0;
        for (n = 0; n < this.solution_.size(); ++n) {
            n3 += CodedOutputStream.computeInt64SizeNoTag((long)this.solution_.getLong(n));
        }
        n2 += n3;
        if (!this.getSolutionList().isEmpty()) {
            ++n2;
            n2 += CodedOutputStream.computeInt32SizeNoTag((int)n3);
        }
        this.solutionMemoizedSerializedSize = n3;
        if (this.objectiveValue_ != 0.0) {
            n2 += CodedOutputStream.computeDoubleSize((int)3, (double)this.objectiveValue_);
        }
        if (this.bestObjectiveBound_ != 0.0) {
            n2 += CodedOutputStream.computeDoubleSize((int)4, (double)this.bestObjectiveBound_);
        }
        if (this.allSolutionsWereFound_) {
            n2 += CodedOutputStream.computeBoolSize((int)5, (boolean)this.allSolutionsWereFound_);
        }
        if (this.numBooleans_ != 0L) {
            n2 += CodedOutputStream.computeInt64Size((int)10, (long)this.numBooleans_);
        }
        if (this.numConflicts_ != 0L) {
            n2 += CodedOutputStream.computeInt64Size((int)11, (long)this.numConflicts_);
        }
        if (this.numBranches_ != 0L) {
            n2 += CodedOutputStream.computeInt64Size((int)12, (long)this.numBranches_);
        }
        if (this.numBinaryPropagations_ != 0L) {
            n2 += CodedOutputStream.computeInt64Size((int)13, (long)this.numBinaryPropagations_);
        }
        if (this.numIntegerPropagations_ != 0L) {
            n2 += CodedOutputStream.computeInt64Size((int)14, (long)this.numIntegerPropagations_);
        }
        if (this.wallTime_ != 0.0) {
            n2 += CodedOutputStream.computeDoubleSize((int)15, (double)this.wallTime_);
        }
        if (this.userTime_ != 0.0) {
            n2 += CodedOutputStream.computeDoubleSize((int)16, (double)this.userTime_);
        }
        if (this.deterministicTime_ != 0.0) {
            n2 += CodedOutputStream.computeDoubleSize((int)17, (double)this.deterministicTime_);
        }
        n3 = 0;
        for (n = 0; n < this.solutionLowerBounds_.size(); ++n) {
            n3 += CodedOutputStream.computeInt64SizeNoTag((long)this.solutionLowerBounds_.getLong(n));
        }
        n2 += n3;
        if (!this.getSolutionLowerBoundsList().isEmpty()) {
            n2 += 2;
            n2 += CodedOutputStream.computeInt32SizeNoTag((int)n3);
        }
        this.solutionLowerBoundsMemoizedSerializedSize = n3;
        n3 = 0;
        for (n = 0; n < this.solutionUpperBounds_.size(); ++n) {
            n3 += CodedOutputStream.computeInt64SizeNoTag((long)this.solutionUpperBounds_.getLong(n));
        }
        n2 += n3;
        if (!this.getSolutionUpperBoundsList().isEmpty()) {
            n2 += 2;
            n2 += CodedOutputStream.computeInt32SizeNoTag((int)n3);
        }
        this.solutionUpperBoundsMemoizedSerializedSize = n3;
        if (!this.getSolutionInfoBytes().isEmpty()) {
            n2 += GeneratedMessageV3.computeStringSize((int)20, (Object)this.solutionInfo_);
        }
        for (n3 = 0; n3 < this.tightenedVariables_.size(); ++n3) {
            n2 += CodedOutputStream.computeMessageSize((int)21, (MessageLite)((MessageLite)this.tightenedVariables_.get(n3)));
        }
        if (this.primalIntegral_ != 0.0) {
            n2 += CodedOutputStream.computeDoubleSize((int)22, (double)this.primalIntegral_);
        }
        n3 = 0;
        for (n = 0; n < this.sufficientAssumptionsForInfeasibility_.size(); ++n) {
            n3 += CodedOutputStream.computeInt32SizeNoTag((int)this.sufficientAssumptionsForInfeasibility_.getInt(n));
        }
        n2 += n3;
        if (!this.getSufficientAssumptionsForInfeasibilityList().isEmpty()) {
            n2 += 2;
            n2 += CodedOutputStream.computeInt32SizeNoTag((int)n3);
        }
        this.sufficientAssumptionsForInfeasibilityMemoizedSerializedSize = n3;
        this.memoizedSize = n2 += this.unknownFields.getSerializedSize();
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CpSolverResponse)) {
            return super.equals(object);
        }
        CpSolverResponse cpSolverResponse = (CpSolverResponse)object;
        if (this.status_ != cpSolverResponse.status_) {
            return false;
        }
        if (!this.getSolutionList().equals(cpSolverResponse.getSolutionList())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getObjectiveValue()) != Double.doubleToLongBits(cpSolverResponse.getObjectiveValue())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getBestObjectiveBound()) != Double.doubleToLongBits(cpSolverResponse.getBestObjectiveBound())) {
            return false;
        }
        if (!this.getSolutionLowerBoundsList().equals(cpSolverResponse.getSolutionLowerBoundsList())) {
            return false;
        }
        if (!this.getSolutionUpperBoundsList().equals(cpSolverResponse.getSolutionUpperBoundsList())) {
            return false;
        }
        if (!this.getTightenedVariablesList().equals(cpSolverResponse.getTightenedVariablesList())) {
            return false;
        }
        if (!this.getSufficientAssumptionsForInfeasibilityList().equals(cpSolverResponse.getSufficientAssumptionsForInfeasibilityList())) {
            return false;
        }
        if (this.getAllSolutionsWereFound() != cpSolverResponse.getAllSolutionsWereFound()) {
            return false;
        }
        if (this.getNumBooleans() != cpSolverResponse.getNumBooleans()) {
            return false;
        }
        if (this.getNumConflicts() != cpSolverResponse.getNumConflicts()) {
            return false;
        }
        if (this.getNumBranches() != cpSolverResponse.getNumBranches()) {
            return false;
        }
        if (this.getNumBinaryPropagations() != cpSolverResponse.getNumBinaryPropagations()) {
            return false;
        }
        if (this.getNumIntegerPropagations() != cpSolverResponse.getNumIntegerPropagations()) {
            return false;
        }
        if (Double.doubleToLongBits(this.getWallTime()) != Double.doubleToLongBits(cpSolverResponse.getWallTime())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getUserTime()) != Double.doubleToLongBits(cpSolverResponse.getUserTime())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getDeterministicTime()) != Double.doubleToLongBits(cpSolverResponse.getDeterministicTime())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getPrimalIntegral()) != Double.doubleToLongBits(cpSolverResponse.getPrimalIntegral())) {
            return false;
        }
        if (!this.getSolutionInfo().equals(cpSolverResponse.getSolutionInfo())) {
            return false;
        }
        return this.unknownFields.equals((Object)cpSolverResponse.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int n = 41;
        n = 19 * n + CpSolverResponse.getDescriptor().hashCode();
        n = 37 * n + 1;
        n = 53 * n + this.status_;
        if (this.getSolutionCount() > 0) {
            n = 37 * n + 2;
            n = 53 * n + this.getSolutionList().hashCode();
        }
        n = 37 * n + 3;
        n = 53 * n + Internal.hashLong((long)Double.doubleToLongBits(this.getObjectiveValue()));
        n = 37 * n + 4;
        n = 53 * n + Internal.hashLong((long)Double.doubleToLongBits(this.getBestObjectiveBound()));
        if (this.getSolutionLowerBoundsCount() > 0) {
            n = 37 * n + 18;
            n = 53 * n + this.getSolutionLowerBoundsList().hashCode();
        }
        if (this.getSolutionUpperBoundsCount() > 0) {
            n = 37 * n + 19;
            n = 53 * n + this.getSolutionUpperBoundsList().hashCode();
        }
        if (this.getTightenedVariablesCount() > 0) {
            n = 37 * n + 21;
            n = 53 * n + this.getTightenedVariablesList().hashCode();
        }
        if (this.getSufficientAssumptionsForInfeasibilityCount() > 0) {
            n = 37 * n + 23;
            n = 53 * n + this.getSufficientAssumptionsForInfeasibilityList().hashCode();
        }
        n = 37 * n + 5;
        n = 53 * n + Internal.hashBoolean((boolean)this.getAllSolutionsWereFound());
        n = 37 * n + 10;
        n = 53 * n + Internal.hashLong((long)this.getNumBooleans());
        n = 37 * n + 11;
        n = 53 * n + Internal.hashLong((long)this.getNumConflicts());
        n = 37 * n + 12;
        n = 53 * n + Internal.hashLong((long)this.getNumBranches());
        n = 37 * n + 13;
        n = 53 * n + Internal.hashLong((long)this.getNumBinaryPropagations());
        n = 37 * n + 14;
        n = 53 * n + Internal.hashLong((long)this.getNumIntegerPropagations());
        n = 37 * n + 15;
        n = 53 * n + Internal.hashLong((long)Double.doubleToLongBits(this.getWallTime()));
        n = 37 * n + 16;
        n = 53 * n + Internal.hashLong((long)Double.doubleToLongBits(this.getUserTime()));
        n = 37 * n + 17;
        n = 53 * n + Internal.hashLong((long)Double.doubleToLongBits(this.getDeterministicTime()));
        n = 37 * n + 22;
        n = 53 * n + Internal.hashLong((long)Double.doubleToLongBits(this.getPrimalIntegral()));
        n = 37 * n + 20;
        n = 53 * n + this.getSolutionInfo().hashCode();
        this.memoizedHashCode = n = 29 * n + this.unknownFields.hashCode();
        return n;
    }

    public static CpSolverResponse parseFrom(ByteBuffer byteBuffer) throws InvalidProtocolBufferException {
        return (CpSolverResponse)PARSER.parseFrom(byteBuffer);
    }

    public static CpSolverResponse parseFrom(ByteBuffer byteBuffer, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return (CpSolverResponse)PARSER.parseFrom(byteBuffer, extensionRegistryLite);
    }

    public static CpSolverResponse parseFrom(ByteString byteString) throws InvalidProtocolBufferException {
        return (CpSolverResponse)PARSER.parseFrom(byteString);
    }

    public static CpSolverResponse parseFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return (CpSolverResponse)PARSER.parseFrom(byteString, extensionRegistryLite);
    }

    public static CpSolverResponse parseFrom(byte[] byArray) throws InvalidProtocolBufferException {
        return (CpSolverResponse)PARSER.parseFrom(byArray);
    }

    public static CpSolverResponse parseFrom(byte[] byArray, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return (CpSolverResponse)PARSER.parseFrom(byArray, extensionRegistryLite);
    }

    public static CpSolverResponse parseFrom(InputStream inputStream) throws IOException {
        return (CpSolverResponse)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)inputStream);
    }

    public static CpSolverResponse parseFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return (CpSolverResponse)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)inputStream, (ExtensionRegistryLite)extensionRegistryLite);
    }

    public static CpSolverResponse parseDelimitedFrom(InputStream inputStream) throws IOException {
        return (CpSolverResponse)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)inputStream);
    }

    public static CpSolverResponse parseDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return (CpSolverResponse)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)inputStream, (ExtensionRegistryLite)extensionRegistryLite);
    }

    public static CpSolverResponse parseFrom(CodedInputStream codedInputStream) throws IOException {
        return (CpSolverResponse)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)codedInputStream);
    }

    public static CpSolverResponse parseFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return (CpSolverResponse)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)codedInputStream, (ExtensionRegistryLite)extensionRegistryLite);
    }

    public Builder newBuilderForType() {
        return CpSolverResponse.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CpSolverResponse cpSolverResponse) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(cpSolverResponse);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent builderParent) {
        Builder builder = new Builder(builderParent);
        return builder;
    }

    public static CpSolverResponse getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<CpSolverResponse> parser() {
        return PARSER;
    }

    public Parser<CpSolverResponse> getParserForType() {
        return PARSER;
    }

    public CpSolverResponse getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    static /* synthetic */ Internal.LongList access$3000() {
        return CpSolverResponse.emptyLongList();
    }

    static /* synthetic */ Internal.LongList access$3300() {
        return CpSolverResponse.emptyLongList();
    }

    static /* synthetic */ Internal.LongList access$3600() {
        return CpSolverResponse.emptyLongList();
    }

    static /* synthetic */ Internal.IntList access$3900() {
        return CpSolverResponse.emptyIntList();
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements CpSolverResponseOrBuilder {
        private int bitField0_;
        private int status_ = 0;
        private Internal.LongList solution_ = CpSolverResponse.access$3000();
        private double objectiveValue_;
        private double bestObjectiveBound_;
        private Internal.LongList solutionLowerBounds_ = CpSolverResponse.access$3300();
        private Internal.LongList solutionUpperBounds_ = CpSolverResponse.access$3600();
        private List<IntegerVariableProto> tightenedVariables_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<IntegerVariableProto, IntegerVariableProto.Builder, IntegerVariableProtoOrBuilder> tightenedVariablesBuilder_;
        private Internal.IntList sufficientAssumptionsForInfeasibility_ = CpSolverResponse.access$3900();
        private boolean allSolutionsWereFound_;
        private long numBooleans_;
        private long numConflicts_;
        private long numBranches_;
        private long numBinaryPropagations_;
        private long numIntegerPropagations_;
        private double wallTime_;
        private double userTime_;
        private double deterministicTime_;
        private double primalIntegral_;
        private Object solutionInfo_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return CpModelProtobuf.internal_static_operations_research_sat_CpSolverResponse_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CpModelProtobuf.internal_static_operations_research_sat_CpSolverResponse_fieldAccessorTable.ensureFieldAccessorsInitialized(CpSolverResponse.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent builderParent) {
            super(builderParent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getTightenedVariablesFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.status_ = 0;
            this.solution_ = CpSolverResponse.emptyLongList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.objectiveValue_ = 0.0;
            this.bestObjectiveBound_ = 0.0;
            this.solutionLowerBounds_ = CpSolverResponse.emptyLongList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.solutionUpperBounds_ = CpSolverResponse.emptyLongList();
            this.bitField0_ &= 0xFFFFFFFB;
            if (this.tightenedVariablesBuilder_ == null) {
                this.tightenedVariables_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
            } else {
                this.tightenedVariablesBuilder_.clear();
            }
            this.sufficientAssumptionsForInfeasibility_ = CpSolverResponse.emptyIntList();
            this.bitField0_ &= 0xFFFFFFEF;
            this.allSolutionsWereFound_ = false;
            this.numBooleans_ = 0L;
            this.numConflicts_ = 0L;
            this.numBranches_ = 0L;
            this.numBinaryPropagations_ = 0L;
            this.numIntegerPropagations_ = 0L;
            this.wallTime_ = 0.0;
            this.userTime_ = 0.0;
            this.deterministicTime_ = 0.0;
            this.primalIntegral_ = 0.0;
            this.solutionInfo_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CpModelProtobuf.internal_static_operations_research_sat_CpSolverResponse_descriptor;
        }

        public CpSolverResponse getDefaultInstanceForType() {
            return CpSolverResponse.getDefaultInstance();
        }

        public CpSolverResponse build() {
            CpSolverResponse cpSolverResponse = this.buildPartial();
            if (!cpSolverResponse.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)cpSolverResponse);
            }
            return cpSolverResponse;
        }

        public CpSolverResponse buildPartial() {
            CpSolverResponse cpSolverResponse = new CpSolverResponse(this);
            int n = this.bitField0_;
            cpSolverResponse.status_ = this.status_;
            if ((this.bitField0_ & 1) != 0) {
                this.solution_.makeImmutable();
                this.bitField0_ &= 0xFFFFFFFE;
            }
            cpSolverResponse.solution_ = this.solution_;
            cpSolverResponse.objectiveValue_ = this.objectiveValue_;
            cpSolverResponse.bestObjectiveBound_ = this.bestObjectiveBound_;
            if ((this.bitField0_ & 2) != 0) {
                this.solutionLowerBounds_.makeImmutable();
                this.bitField0_ &= 0xFFFFFFFD;
            }
            cpSolverResponse.solutionLowerBounds_ = this.solutionLowerBounds_;
            if ((this.bitField0_ & 4) != 0) {
                this.solutionUpperBounds_.makeImmutable();
                this.bitField0_ &= 0xFFFFFFFB;
            }
            cpSolverResponse.solutionUpperBounds_ = this.solutionUpperBounds_;
            if (this.tightenedVariablesBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0) {
                    this.tightenedVariables_ = Collections.unmodifiableList(this.tightenedVariables_);
                    this.bitField0_ &= 0xFFFFFFF7;
                }
                cpSolverResponse.tightenedVariables_ = this.tightenedVariables_;
            } else {
                cpSolverResponse.tightenedVariables_ = this.tightenedVariablesBuilder_.build();
            }
            if ((this.bitField0_ & 0x10) != 0) {
                this.sufficientAssumptionsForInfeasibility_.makeImmutable();
                this.bitField0_ &= 0xFFFFFFEF;
            }
            cpSolverResponse.sufficientAssumptionsForInfeasibility_ = this.sufficientAssumptionsForInfeasibility_;
            cpSolverResponse.allSolutionsWereFound_ = this.allSolutionsWereFound_;
            cpSolverResponse.numBooleans_ = this.numBooleans_;
            cpSolverResponse.numConflicts_ = this.numConflicts_;
            cpSolverResponse.numBranches_ = this.numBranches_;
            cpSolverResponse.numBinaryPropagations_ = this.numBinaryPropagations_;
            cpSolverResponse.numIntegerPropagations_ = this.numIntegerPropagations_;
            cpSolverResponse.wallTime_ = this.wallTime_;
            cpSolverResponse.userTime_ = this.userTime_;
            cpSolverResponse.deterministicTime_ = this.deterministicTime_;
            cpSolverResponse.primalIntegral_ = this.primalIntegral_;
            cpSolverResponse.solutionInfo_ = this.solutionInfo_;
            this.onBuilt();
            return cpSolverResponse;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
            return (Builder)super.setField(fieldDescriptor, object);
        }

        public Builder clearField(Descriptors.FieldDescriptor fieldDescriptor) {
            return (Builder)super.clearField(fieldDescriptor);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneofDescriptor) {
            return (Builder)super.clearOneof(oneofDescriptor);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, int n, Object object) {
            return (Builder)super.setRepeatedField(fieldDescriptor, n, object);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
            return (Builder)super.addRepeatedField(fieldDescriptor, object);
        }

        public Builder mergeFrom(Message message) {
            if (message instanceof CpSolverResponse) {
                return this.mergeFrom((CpSolverResponse)message);
            }
            super.mergeFrom(message);
            return this;
        }

        public Builder mergeFrom(CpSolverResponse cpSolverResponse) {
            if (cpSolverResponse == CpSolverResponse.getDefaultInstance()) {
                return this;
            }
            if (cpSolverResponse.status_ != 0) {
                this.setStatusValue(cpSolverResponse.getStatusValue());
            }
            if (!cpSolverResponse.solution_.isEmpty()) {
                if (this.solution_.isEmpty()) {
                    this.solution_ = cpSolverResponse.solution_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureSolutionIsMutable();
                    this.solution_.addAll((Collection)cpSolverResponse.solution_);
                }
                this.onChanged();
            }
            if (cpSolverResponse.getObjectiveValue() != 0.0) {
                this.setObjectiveValue(cpSolverResponse.getObjectiveValue());
            }
            if (cpSolverResponse.getBestObjectiveBound() != 0.0) {
                this.setBestObjectiveBound(cpSolverResponse.getBestObjectiveBound());
            }
            if (!cpSolverResponse.solutionLowerBounds_.isEmpty()) {
                if (this.solutionLowerBounds_.isEmpty()) {
                    this.solutionLowerBounds_ = cpSolverResponse.solutionLowerBounds_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureSolutionLowerBoundsIsMutable();
                    this.solutionLowerBounds_.addAll((Collection)cpSolverResponse.solutionLowerBounds_);
                }
                this.onChanged();
            }
            if (!cpSolverResponse.solutionUpperBounds_.isEmpty()) {
                if (this.solutionUpperBounds_.isEmpty()) {
                    this.solutionUpperBounds_ = cpSolverResponse.solutionUpperBounds_;
                    this.bitField0_ &= 0xFFFFFFFB;
                } else {
                    this.ensureSolutionUpperBoundsIsMutable();
                    this.solutionUpperBounds_.addAll((Collection)cpSolverResponse.solutionUpperBounds_);
                }
                this.onChanged();
            }
            if (this.tightenedVariablesBuilder_ == null) {
                if (!cpSolverResponse.tightenedVariables_.isEmpty()) {
                    if (this.tightenedVariables_.isEmpty()) {
                        this.tightenedVariables_ = cpSolverResponse.tightenedVariables_;
                        this.bitField0_ &= 0xFFFFFFF7;
                    } else {
                        this.ensureTightenedVariablesIsMutable();
                        this.tightenedVariables_.addAll(cpSolverResponse.tightenedVariables_);
                    }
                    this.onChanged();
                }
            } else if (!cpSolverResponse.tightenedVariables_.isEmpty()) {
                if (this.tightenedVariablesBuilder_.isEmpty()) {
                    this.tightenedVariablesBuilder_.dispose();
                    this.tightenedVariablesBuilder_ = null;
                    this.tightenedVariables_ = cpSolverResponse.tightenedVariables_;
                    this.bitField0_ &= 0xFFFFFFF7;
                    this.tightenedVariablesBuilder_ = alwaysUseFieldBuilders ? this.getTightenedVariablesFieldBuilder() : null;
                } else {
                    this.tightenedVariablesBuilder_.addAllMessages((Iterable)cpSolverResponse.tightenedVariables_);
                }
            }
            if (!cpSolverResponse.sufficientAssumptionsForInfeasibility_.isEmpty()) {
                if (this.sufficientAssumptionsForInfeasibility_.isEmpty()) {
                    this.sufficientAssumptionsForInfeasibility_ = cpSolverResponse.sufficientAssumptionsForInfeasibility_;
                    this.bitField0_ &= 0xFFFFFFEF;
                } else {
                    this.ensureSufficientAssumptionsForInfeasibilityIsMutable();
                    this.sufficientAssumptionsForInfeasibility_.addAll((Collection)cpSolverResponse.sufficientAssumptionsForInfeasibility_);
                }
                this.onChanged();
            }
            if (cpSolverResponse.getAllSolutionsWereFound()) {
                this.setAllSolutionsWereFound(cpSolverResponse.getAllSolutionsWereFound());
            }
            if (cpSolverResponse.getNumBooleans() != 0L) {
                this.setNumBooleans(cpSolverResponse.getNumBooleans());
            }
            if (cpSolverResponse.getNumConflicts() != 0L) {
                this.setNumConflicts(cpSolverResponse.getNumConflicts());
            }
            if (cpSolverResponse.getNumBranches() != 0L) {
                this.setNumBranches(cpSolverResponse.getNumBranches());
            }
            if (cpSolverResponse.getNumBinaryPropagations() != 0L) {
                this.setNumBinaryPropagations(cpSolverResponse.getNumBinaryPropagations());
            }
            if (cpSolverResponse.getNumIntegerPropagations() != 0L) {
                this.setNumIntegerPropagations(cpSolverResponse.getNumIntegerPropagations());
            }
            if (cpSolverResponse.getWallTime() != 0.0) {
                this.setWallTime(cpSolverResponse.getWallTime());
            }
            if (cpSolverResponse.getUserTime() != 0.0) {
                this.setUserTime(cpSolverResponse.getUserTime());
            }
            if (cpSolverResponse.getDeterministicTime() != 0.0) {
                this.setDeterministicTime(cpSolverResponse.getDeterministicTime());
            }
            if (cpSolverResponse.getPrimalIntegral() != 0.0) {
                this.setPrimalIntegral(cpSolverResponse.getPrimalIntegral());
            }
            if (!cpSolverResponse.getSolutionInfo().isEmpty()) {
                this.solutionInfo_ = cpSolverResponse.solutionInfo_;
                this.onChanged();
            }
            this.mergeUnknownFields(cpSolverResponse.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            CpSolverResponse cpSolverResponse = null;
            try {
                cpSolverResponse = (CpSolverResponse)PARSER.parsePartialFrom(codedInputStream, extensionRegistryLite);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                cpSolverResponse = (CpSolverResponse)invalidProtocolBufferException.getUnfinishedMessage();
                throw invalidProtocolBufferException.unwrapIOException();
            }
            finally {
                if (cpSolverResponse != null) {
                    this.mergeFrom(cpSolverResponse);
                }
            }
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int n) {
            this.status_ = n;
            this.onChanged();
            return this;
        }

        @Override
        public CpSolverStatus getStatus() {
            CpSolverStatus cpSolverStatus = CpSolverStatus.valueOf(this.status_);
            return cpSolverStatus == null ? CpSolverStatus.UNRECOGNIZED : cpSolverStatus;
        }

        public Builder setStatus(CpSolverStatus cpSolverStatus) {
            if (cpSolverStatus == null) {
                throw new NullPointerException();
            }
            this.status_ = cpSolverStatus.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureSolutionIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.solution_ = CpSolverResponse.mutableCopy((Internal.LongList)this.solution_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<Long> getSolutionList() {
            return (this.bitField0_ & 1) != 0 ? Collections.unmodifiableList(this.solution_) : this.solution_;
        }

        @Override
        public int getSolutionCount() {
            return this.solution_.size();
        }

        @Override
        public long getSolution(int n) {
            return this.solution_.getLong(n);
        }

        public Builder setSolution(int n, long l) {
            this.ensureSolutionIsMutable();
            this.solution_.setLong(n, l);
            this.onChanged();
            return this;
        }

        public Builder addSolution(long l) {
            this.ensureSolutionIsMutable();
            this.solution_.addLong(l);
            this.onChanged();
            return this;
        }

        public Builder addAllSolution(Iterable<? extends Long> iterable) {
            this.ensureSolutionIsMutable();
            AbstractMessageLite.Builder.addAll(iterable, (List)this.solution_);
            this.onChanged();
            return this;
        }

        public Builder clearSolution() {
            this.solution_ = CpSolverResponse.emptyLongList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        @Override
        public double getObjectiveValue() {
            return this.objectiveValue_;
        }

        public Builder setObjectiveValue(double d) {
            this.objectiveValue_ = d;
            this.onChanged();
            return this;
        }

        public Builder clearObjectiveValue() {
            this.objectiveValue_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public double getBestObjectiveBound() {
            return this.bestObjectiveBound_;
        }

        public Builder setBestObjectiveBound(double d) {
            this.bestObjectiveBound_ = d;
            this.onChanged();
            return this;
        }

        public Builder clearBestObjectiveBound() {
            this.bestObjectiveBound_ = 0.0;
            this.onChanged();
            return this;
        }

        private void ensureSolutionLowerBoundsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.solutionLowerBounds_ = CpSolverResponse.mutableCopy((Internal.LongList)this.solutionLowerBounds_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<Long> getSolutionLowerBoundsList() {
            return (this.bitField0_ & 2) != 0 ? Collections.unmodifiableList(this.solutionLowerBounds_) : this.solutionLowerBounds_;
        }

        @Override
        public int getSolutionLowerBoundsCount() {
            return this.solutionLowerBounds_.size();
        }

        @Override
        public long getSolutionLowerBounds(int n) {
            return this.solutionLowerBounds_.getLong(n);
        }

        public Builder setSolutionLowerBounds(int n, long l) {
            this.ensureSolutionLowerBoundsIsMutable();
            this.solutionLowerBounds_.setLong(n, l);
            this.onChanged();
            return this;
        }

        public Builder addSolutionLowerBounds(long l) {
            this.ensureSolutionLowerBoundsIsMutable();
            this.solutionLowerBounds_.addLong(l);
            this.onChanged();
            return this;
        }

        public Builder addAllSolutionLowerBounds(Iterable<? extends Long> iterable) {
            this.ensureSolutionLowerBoundsIsMutable();
            AbstractMessageLite.Builder.addAll(iterable, (List)this.solutionLowerBounds_);
            this.onChanged();
            return this;
        }

        public Builder clearSolutionLowerBounds() {
            this.solutionLowerBounds_ = CpSolverResponse.emptyLongList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        private void ensureSolutionUpperBoundsIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.solutionUpperBounds_ = CpSolverResponse.mutableCopy((Internal.LongList)this.solutionUpperBounds_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<Long> getSolutionUpperBoundsList() {
            return (this.bitField0_ & 4) != 0 ? Collections.unmodifiableList(this.solutionUpperBounds_) : this.solutionUpperBounds_;
        }

        @Override
        public int getSolutionUpperBoundsCount() {
            return this.solutionUpperBounds_.size();
        }

        @Override
        public long getSolutionUpperBounds(int n) {
            return this.solutionUpperBounds_.getLong(n);
        }

        public Builder setSolutionUpperBounds(int n, long l) {
            this.ensureSolutionUpperBoundsIsMutable();
            this.solutionUpperBounds_.setLong(n, l);
            this.onChanged();
            return this;
        }

        public Builder addSolutionUpperBounds(long l) {
            this.ensureSolutionUpperBoundsIsMutable();
            this.solutionUpperBounds_.addLong(l);
            this.onChanged();
            return this;
        }

        public Builder addAllSolutionUpperBounds(Iterable<? extends Long> iterable) {
            this.ensureSolutionUpperBoundsIsMutable();
            AbstractMessageLite.Builder.addAll(iterable, (List)this.solutionUpperBounds_);
            this.onChanged();
            return this;
        }

        public Builder clearSolutionUpperBounds() {
            this.solutionUpperBounds_ = CpSolverResponse.emptyLongList();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        private void ensureTightenedVariablesIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.tightenedVariables_ = new ArrayList<IntegerVariableProto>(this.tightenedVariables_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<IntegerVariableProto> getTightenedVariablesList() {
            if (this.tightenedVariablesBuilder_ == null) {
                return Collections.unmodifiableList(this.tightenedVariables_);
            }
            return this.tightenedVariablesBuilder_.getMessageList();
        }

        @Override
        public int getTightenedVariablesCount() {
            if (this.tightenedVariablesBuilder_ == null) {
                return this.tightenedVariables_.size();
            }
            return this.tightenedVariablesBuilder_.getCount();
        }

        @Override
        public IntegerVariableProto getTightenedVariables(int n) {
            if (this.tightenedVariablesBuilder_ == null) {
                return this.tightenedVariables_.get(n);
            }
            return (IntegerVariableProto)this.tightenedVariablesBuilder_.getMessage(n);
        }

        public Builder setTightenedVariables(int n, IntegerVariableProto integerVariableProto) {
            if (this.tightenedVariablesBuilder_ == null) {
                if (integerVariableProto == null) {
                    throw new NullPointerException();
                }
                this.ensureTightenedVariablesIsMutable();
                this.tightenedVariables_.set(n, integerVariableProto);
                this.onChanged();
            } else {
                this.tightenedVariablesBuilder_.setMessage(n, (AbstractMessage)integerVariableProto);
            }
            return this;
        }

        public Builder setTightenedVariables(int n, IntegerVariableProto.Builder builder) {
            if (this.tightenedVariablesBuilder_ == null) {
                this.ensureTightenedVariablesIsMutable();
                this.tightenedVariables_.set(n, builder.build());
                this.onChanged();
            } else {
                this.tightenedVariablesBuilder_.setMessage(n, (AbstractMessage)builder.build());
            }
            return this;
        }

        public Builder addTightenedVariables(IntegerVariableProto integerVariableProto) {
            if (this.tightenedVariablesBuilder_ == null) {
                if (integerVariableProto == null) {
                    throw new NullPointerException();
                }
                this.ensureTightenedVariablesIsMutable();
                this.tightenedVariables_.add(integerVariableProto);
                this.onChanged();
            } else {
                this.tightenedVariablesBuilder_.addMessage((AbstractMessage)integerVariableProto);
            }
            return this;
        }

        public Builder addTightenedVariables(int n, IntegerVariableProto integerVariableProto) {
            if (this.tightenedVariablesBuilder_ == null) {
                if (integerVariableProto == null) {
                    throw new NullPointerException();
                }
                this.ensureTightenedVariablesIsMutable();
                this.tightenedVariables_.add(n, integerVariableProto);
                this.onChanged();
            } else {
                this.tightenedVariablesBuilder_.addMessage(n, (AbstractMessage)integerVariableProto);
            }
            return this;
        }

        public Builder addTightenedVariables(IntegerVariableProto.Builder builder) {
            if (this.tightenedVariablesBuilder_ == null) {
                this.ensureTightenedVariablesIsMutable();
                this.tightenedVariables_.add(builder.build());
                this.onChanged();
            } else {
                this.tightenedVariablesBuilder_.addMessage((AbstractMessage)builder.build());
            }
            return this;
        }

        public Builder addTightenedVariables(int n, IntegerVariableProto.Builder builder) {
            if (this.tightenedVariablesBuilder_ == null) {
                this.ensureTightenedVariablesIsMutable();
                this.tightenedVariables_.add(n, builder.build());
                this.onChanged();
            } else {
                this.tightenedVariablesBuilder_.addMessage(n, (AbstractMessage)builder.build());
            }
            return this;
        }

        public Builder addAllTightenedVariables(Iterable<? extends IntegerVariableProto> iterable) {
            if (this.tightenedVariablesBuilder_ == null) {
                this.ensureTightenedVariablesIsMutable();
                AbstractMessageLite.Builder.addAll(iterable, this.tightenedVariables_);
                this.onChanged();
            } else {
                this.tightenedVariablesBuilder_.addAllMessages(iterable);
            }
            return this;
        }

        public Builder clearTightenedVariables() {
            if (this.tightenedVariablesBuilder_ == null) {
                this.tightenedVariables_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
            } else {
                this.tightenedVariablesBuilder_.clear();
            }
            return this;
        }

        public Builder removeTightenedVariables(int n) {
            if (this.tightenedVariablesBuilder_ == null) {
                this.ensureTightenedVariablesIsMutable();
                this.tightenedVariables_.remove(n);
                this.onChanged();
            } else {
                this.tightenedVariablesBuilder_.remove(n);
            }
            return this;
        }

        public IntegerVariableProto.Builder getTightenedVariablesBuilder(int n) {
            return (IntegerVariableProto.Builder)this.getTightenedVariablesFieldBuilder().getBuilder(n);
        }

        @Override
        public IntegerVariableProtoOrBuilder getTightenedVariablesOrBuilder(int n) {
            if (this.tightenedVariablesBuilder_ == null) {
                return this.tightenedVariables_.get(n);
            }
            return (IntegerVariableProtoOrBuilder)this.tightenedVariablesBuilder_.getMessageOrBuilder(n);
        }

        @Override
        public List<? extends IntegerVariableProtoOrBuilder> getTightenedVariablesOrBuilderList() {
            if (this.tightenedVariablesBuilder_ != null) {
                return this.tightenedVariablesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.tightenedVariables_);
        }

        public IntegerVariableProto.Builder addTightenedVariablesBuilder() {
            return (IntegerVariableProto.Builder)this.getTightenedVariablesFieldBuilder().addBuilder((AbstractMessage)IntegerVariableProto.getDefaultInstance());
        }

        public IntegerVariableProto.Builder addTightenedVariablesBuilder(int n) {
            return (IntegerVariableProto.Builder)this.getTightenedVariablesFieldBuilder().addBuilder(n, (AbstractMessage)IntegerVariableProto.getDefaultInstance());
        }

        public List<IntegerVariableProto.Builder> getTightenedVariablesBuilderList() {
            return this.getTightenedVariablesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<IntegerVariableProto, IntegerVariableProto.Builder, IntegerVariableProtoOrBuilder> getTightenedVariablesFieldBuilder() {
            if (this.tightenedVariablesBuilder_ == null) {
                this.tightenedVariablesBuilder_ = new RepeatedFieldBuilderV3(this.tightenedVariables_, (this.bitField0_ & 8) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.tightenedVariables_ = null;
            }
            return this.tightenedVariablesBuilder_;
        }

        private void ensureSufficientAssumptionsForInfeasibilityIsMutable() {
            if ((this.bitField0_ & 0x10) == 0) {
                this.sufficientAssumptionsForInfeasibility_ = CpSolverResponse.mutableCopy((Internal.IntList)this.sufficientAssumptionsForInfeasibility_);
                this.bitField0_ |= 0x10;
            }
        }

        @Override
        public List<Integer> getSufficientAssumptionsForInfeasibilityList() {
            return (this.bitField0_ & 0x10) != 0 ? Collections.unmodifiableList(this.sufficientAssumptionsForInfeasibility_) : this.sufficientAssumptionsForInfeasibility_;
        }

        @Override
        public int getSufficientAssumptionsForInfeasibilityCount() {
            return this.sufficientAssumptionsForInfeasibility_.size();
        }

        @Override
        public int getSufficientAssumptionsForInfeasibility(int n) {
            return this.sufficientAssumptionsForInfeasibility_.getInt(n);
        }

        public Builder setSufficientAssumptionsForInfeasibility(int n, int n2) {
            this.ensureSufficientAssumptionsForInfeasibilityIsMutable();
            this.sufficientAssumptionsForInfeasibility_.setInt(n, n2);
            this.onChanged();
            return this;
        }

        public Builder addSufficientAssumptionsForInfeasibility(int n) {
            this.ensureSufficientAssumptionsForInfeasibilityIsMutable();
            this.sufficientAssumptionsForInfeasibility_.addInt(n);
            this.onChanged();
            return this;
        }

        public Builder addAllSufficientAssumptionsForInfeasibility(Iterable<? extends Integer> iterable) {
            this.ensureSufficientAssumptionsForInfeasibilityIsMutable();
            AbstractMessageLite.Builder.addAll(iterable, (List)this.sufficientAssumptionsForInfeasibility_);
            this.onChanged();
            return this;
        }

        public Builder clearSufficientAssumptionsForInfeasibility() {
            this.sufficientAssumptionsForInfeasibility_ = CpSolverResponse.emptyIntList();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getAllSolutionsWereFound() {
            return this.allSolutionsWereFound_;
        }

        public Builder setAllSolutionsWereFound(boolean bl) {
            this.allSolutionsWereFound_ = bl;
            this.onChanged();
            return this;
        }

        public Builder clearAllSolutionsWereFound() {
            this.allSolutionsWereFound_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public long getNumBooleans() {
            return this.numBooleans_;
        }

        public Builder setNumBooleans(long l) {
            this.numBooleans_ = l;
            this.onChanged();
            return this;
        }

        public Builder clearNumBooleans() {
            this.numBooleans_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getNumConflicts() {
            return this.numConflicts_;
        }

        public Builder setNumConflicts(long l) {
            this.numConflicts_ = l;
            this.onChanged();
            return this;
        }

        public Builder clearNumConflicts() {
            this.numConflicts_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getNumBranches() {
            return this.numBranches_;
        }

        public Builder setNumBranches(long l) {
            this.numBranches_ = l;
            this.onChanged();
            return this;
        }

        public Builder clearNumBranches() {
            this.numBranches_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getNumBinaryPropagations() {
            return this.numBinaryPropagations_;
        }

        public Builder setNumBinaryPropagations(long l) {
            this.numBinaryPropagations_ = l;
            this.onChanged();
            return this;
        }

        public Builder clearNumBinaryPropagations() {
            this.numBinaryPropagations_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getNumIntegerPropagations() {
            return this.numIntegerPropagations_;
        }

        public Builder setNumIntegerPropagations(long l) {
            this.numIntegerPropagations_ = l;
            this.onChanged();
            return this;
        }

        public Builder clearNumIntegerPropagations() {
            this.numIntegerPropagations_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public double getWallTime() {
            return this.wallTime_;
        }

        public Builder setWallTime(double d) {
            this.wallTime_ = d;
            this.onChanged();
            return this;
        }

        public Builder clearWallTime() {
            this.wallTime_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public double getUserTime() {
            return this.userTime_;
        }

        public Builder setUserTime(double d) {
            this.userTime_ = d;
            this.onChanged();
            return this;
        }

        public Builder clearUserTime() {
            this.userTime_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public double getDeterministicTime() {
            return this.deterministicTime_;
        }

        public Builder setDeterministicTime(double d) {
            this.deterministicTime_ = d;
            this.onChanged();
            return this;
        }

        public Builder clearDeterministicTime() {
            this.deterministicTime_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public double getPrimalIntegral() {
            return this.primalIntegral_;
        }

        public Builder setPrimalIntegral(double d) {
            this.primalIntegral_ = d;
            this.onChanged();
            return this;
        }

        public Builder clearPrimalIntegral() {
            this.primalIntegral_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public String getSolutionInfo() {
            Object object = this.solutionInfo_;
            if (!(object instanceof String)) {
                ByteString byteString = (ByteString)object;
                String string = byteString.toStringUtf8();
                this.solutionInfo_ = string;
                return string;
            }
            return (String)object;
        }

        @Override
        public ByteString getSolutionInfoBytes() {
            Object object = this.solutionInfo_;
            if (object instanceof String) {
                ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
                this.solutionInfo_ = byteString;
                return byteString;
            }
            return (ByteString)object;
        }

        public Builder setSolutionInfo(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.solutionInfo_ = string;
            this.onChanged();
            return this;
        }

        public Builder clearSolutionInfo() {
            this.solutionInfo_ = CpSolverResponse.getDefaultInstance().getSolutionInfo();
            this.onChanged();
            return this;
        }

        public Builder setSolutionInfoBytes(ByteString byteString) {
            if (byteString == null) {
                throw new NullPointerException();
            }
            CpSolverResponse.checkByteStringIsUtf8((ByteString)byteString);
            this.solutionInfo_ = byteString;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFieldSet) {
            return (Builder)super.setUnknownFields(unknownFieldSet);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFieldSet) {
            return (Builder)super.mergeUnknownFields(unknownFieldSet);
        }
    }
}

