/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.CpModel;
import com.google.ortools.sat.CpSolverResponse;
import com.google.ortools.sat.CpSolverSolutionCallback;
import com.google.ortools.sat.CpSolverStatus;
import com.google.ortools.sat.IntVar;
import com.google.ortools.sat.Literal;
import com.google.ortools.sat.SatHelper;
import com.google.ortools.sat.SatParameters;

public final class CpSolver {
    private CpSolverResponse solveResponse;
    private final SatParameters.Builder solveParameters = SatParameters.newBuilder();

    public CpSolverStatus solve(CpModel cpModel) {
        this.solveResponse = SatHelper.solveWithParameters(cpModel.model(), this.solveParameters.build());
        return this.solveResponse.getStatus();
    }

    public CpSolverStatus solveWithSolutionCallback(CpModel cpModel, CpSolverSolutionCallback cpSolverSolutionCallback) {
        this.solveResponse = SatHelper.solveWithParametersAndSolutionCallback(cpModel.model(), this.solveParameters.build(), cpSolverSolutionCallback);
        return this.solveResponse.getStatus();
    }

    public CpSolverStatus searchAllSolutions(CpModel cpModel, CpSolverSolutionCallback cpSolverSolutionCallback) {
        this.solveParameters.setEnumerateAllSolutions(true);
        this.solveResponse = SatHelper.solveWithParametersAndSolutionCallback(cpModel.model(), this.solveParameters.build(), cpSolverSolutionCallback);
        this.solveParameters.setEnumerateAllSolutions(true);
        return this.solveResponse.getStatus();
    }

    public double objectiveValue() {
        return this.solveResponse.getObjectiveValue();
    }

    public double bestObjectiveBound() {
        return this.solveResponse.getBestObjectiveBound();
    }

    public long value(IntVar intVar) {
        return this.solveResponse.getSolution(intVar.getIndex());
    }

    public Boolean booleanValue(Literal literal) {
        int n = literal.getIndex();
        if (n >= 0) {
            return this.solveResponse.getSolution(n) != 0L;
        }
        return this.solveResponse.getSolution(-n - 1) == 0L;
    }

    public CpSolverResponse response() {
        return this.solveResponse;
    }

    public long numBranches() {
        return this.solveResponse.getNumBranches();
    }

    public long numConflicts() {
        return this.solveResponse.getNumConflicts();
    }

    public double wallTime() {
        return this.solveResponse.getWallTime();
    }

    public double userTime() {
        return this.solveResponse.getUserTime();
    }

    public SatParameters.Builder getParameters() {
        return this.solveParameters;
    }

    public String responseStats() {
        return SatHelper.solverResponseStats(this.solveResponse);
    }
}

