/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.AllDifferentConstraintProto;
import com.google.ortools.sat.AutomatonConstraintProto;
import com.google.ortools.sat.BoolArgumentProto;
import com.google.ortools.sat.CircuitConstraintProto;
import com.google.ortools.sat.Constraint;
import com.google.ortools.sat.CpModelProto;
import com.google.ortools.sat.CpObjectiveProto;
import com.google.ortools.sat.CumulativeConstraintProto;
import com.google.ortools.sat.DecisionStrategyProto;
import com.google.ortools.sat.Difference;
import com.google.ortools.sat.ElementConstraintProto;
import com.google.ortools.sat.IntVar;
import com.google.ortools.sat.IntegerArgumentProto;
import com.google.ortools.sat.IntegerVariableProto;
import com.google.ortools.sat.IntervalVar;
import com.google.ortools.sat.InverseConstraintProto;
import com.google.ortools.sat.LinearConstraintProto;
import com.google.ortools.sat.LinearExpr;
import com.google.ortools.sat.Literal;
import com.google.ortools.sat.NoOverlap2DConstraintProto;
import com.google.ortools.sat.NoOverlapConstraintProto;
import com.google.ortools.sat.ReservoirConstraintProto;
import com.google.ortools.sat.SatHelper;
import com.google.ortools.sat.TableConstraintProto;
import com.google.ortools.util.Domain;

public final class CpModel {
    private final CpModelProto.Builder modelBuilder = CpModelProto.newBuilder();

    public IntVar newIntVar(long l, long l2, String string) {
        return new IntVar(this.modelBuilder, new Domain(l, l2), string);
    }

    public IntVar newIntVarFromDomain(Domain domain, String string) {
        return new IntVar(this.modelBuilder, domain, string);
    }

    public IntVar newBoolVar(String string) {
        return new IntVar(this.modelBuilder, new Domain(0L, 1L), string);
    }

    public IntVar newConstant(long l) {
        return new IntVar(this.modelBuilder, new Domain(l), "");
    }

    public Constraint addBoolOr(Literal[] literalArray) {
        Constraint constraint = new Constraint(this.modelBuilder);
        BoolArgumentProto.Builder builder = constraint.getBuilder().getBoolOrBuilder();
        for (Literal literal : literalArray) {
            builder.addLiterals(literal.getIndex());
        }
        return constraint;
    }

    public Constraint addBoolAnd(Literal[] literalArray) {
        Constraint constraint = new Constraint(this.modelBuilder);
        BoolArgumentProto.Builder builder = constraint.getBuilder().getBoolAndBuilder();
        for (Literal literal : literalArray) {
            builder.addLiterals(literal.getIndex());
        }
        return constraint;
    }

    public Constraint addBoolXor(Literal[] literalArray) {
        Constraint constraint = new Constraint(this.modelBuilder);
        BoolArgumentProto.Builder builder = constraint.getBuilder().getBoolXorBuilder();
        for (Literal literal : literalArray) {
            builder.addLiterals(literal.getIndex());
        }
        return constraint;
    }

    public Constraint addImplication(Literal literal, Literal literal2) {
        return this.addBoolOr(new Literal[]{literal.not(), literal2});
    }

    public Constraint addLinearExpressionInDomain(LinearExpr linearExpr, Domain domain) {
        Constraint constraint = new Constraint(this.modelBuilder);
        LinearConstraintProto.Builder builder = constraint.getBuilder().getLinearBuilder();
        for (int i = 0; i < linearExpr.numElements(); ++i) {
            builder.addVars(linearExpr.getVariable(i).getIndex());
            builder.addCoeffs(linearExpr.getCoefficient(i));
        }
        for (long l : domain.flattenedIntervals()) {
            builder.addDomain(l);
        }
        return constraint;
    }

    public Constraint addLinearConstraint(LinearExpr linearExpr, long l, long l2) {
        return this.addLinearExpressionInDomain(linearExpr, new Domain(l, l2));
    }

    public Constraint addEquality(LinearExpr linearExpr, long l) {
        return this.addLinearExpressionInDomain(linearExpr, new Domain(l));
    }

    public Constraint addEquality(LinearExpr linearExpr, LinearExpr linearExpr2) {
        return this.addLinearExpressionInDomain(new Difference(linearExpr, linearExpr2), new Domain(0L));
    }

    public Constraint addEqualityWithOffset(LinearExpr linearExpr, LinearExpr linearExpr2, long l) {
        return this.addLinearExpressionInDomain(new Difference(linearExpr, linearExpr2), new Domain(-l));
    }

    public Constraint addLessOrEqual(LinearExpr linearExpr, long l) {
        return this.addLinearExpressionInDomain(linearExpr, new Domain(Long.MIN_VALUE, l));
    }

    public Constraint addLessOrEqual(LinearExpr linearExpr, LinearExpr linearExpr2) {
        return this.addLinearExpressionInDomain(new Difference(linearExpr, linearExpr2), new Domain(Long.MIN_VALUE, 0L));
    }

    public Constraint addLessThan(LinearExpr linearExpr, long l) {
        return this.addLinearExpressionInDomain(linearExpr, new Domain(Long.MIN_VALUE, l - 1L));
    }

    public Constraint addLessThan(LinearExpr linearExpr, LinearExpr linearExpr2) {
        return this.addLinearExpressionInDomain(new Difference(linearExpr, linearExpr2), new Domain(Long.MIN_VALUE, -1L));
    }

    public Constraint addLessOrEqualWithOffset(LinearExpr linearExpr, LinearExpr linearExpr2, long l) {
        return this.addLinearExpressionInDomain(new Difference(linearExpr, linearExpr2), new Domain(Long.MIN_VALUE, -l));
    }

    public Constraint addGreaterOrEqual(LinearExpr linearExpr, long l) {
        return this.addLinearExpressionInDomain(linearExpr, new Domain(l, Long.MAX_VALUE));
    }

    public Constraint addGreaterOrEqual(LinearExpr linearExpr, LinearExpr linearExpr2) {
        return this.addLinearExpressionInDomain(new Difference(linearExpr, linearExpr2), new Domain(0L, Long.MAX_VALUE));
    }

    public Constraint addGreaterThan(LinearExpr linearExpr, long l) {
        return this.addLinearExpressionInDomain(linearExpr, new Domain(l + 1L, Long.MAX_VALUE));
    }

    public Constraint addGreaterThan(LinearExpr linearExpr, LinearExpr linearExpr2) {
        return this.addLinearExpressionInDomain(new Difference(linearExpr, linearExpr2), new Domain(1L, Long.MAX_VALUE));
    }

    public Constraint addGreaterOrEqualWithOffset(LinearExpr linearExpr, LinearExpr linearExpr2, long l) {
        return this.addLinearExpressionInDomain(new Difference(linearExpr, linearExpr2), new Domain(-l, Long.MAX_VALUE));
    }

    public Constraint addDifferent(LinearExpr linearExpr, long l) {
        return this.addLinearExpressionInDomain(linearExpr, Domain.fromFlatIntervals(new long[]{Long.MIN_VALUE, l - 1L, l + 1L, Long.MAX_VALUE}));
    }

    public Constraint addDifferent(IntVar intVar, IntVar intVar2) {
        return this.addLinearExpressionInDomain(new Difference(intVar, intVar2), Domain.fromFlatIntervals(new long[]{Long.MIN_VALUE, -1L, 1L, Long.MAX_VALUE}));
    }

    public Constraint addDifferentWithOffset(IntVar intVar, IntVar intVar2, long l) {
        return this.addLinearExpressionInDomain(new Difference(intVar, intVar2), Domain.fromFlatIntervals(new long[]{Long.MIN_VALUE, -l - 1L, -l + 1L, Long.MAX_VALUE}));
    }

    public Constraint addAllDifferent(IntVar[] intVarArray) {
        Constraint constraint = new Constraint(this.modelBuilder);
        AllDifferentConstraintProto.Builder builder = constraint.getBuilder().getAllDiffBuilder();
        for (IntVar intVar : intVarArray) {
            builder.addVars(intVar.getIndex());
        }
        return constraint;
    }

    public Constraint addElement(IntVar intVar, IntVar[] intVarArray, IntVar intVar2) {
        Constraint constraint = new Constraint(this.modelBuilder);
        ElementConstraintProto.Builder builder = constraint.getBuilder().getElementBuilder();
        builder.setIndex(intVar.getIndex());
        for (IntVar intVar3 : intVarArray) {
            builder.addVars(intVar3.getIndex());
        }
        builder.setTarget(intVar2.getIndex());
        return constraint;
    }

    public Constraint addElement(IntVar intVar, long[] lArray, IntVar intVar2) {
        Constraint constraint = new Constraint(this.modelBuilder);
        ElementConstraintProto.Builder builder = constraint.getBuilder().getElementBuilder();
        builder.setIndex(intVar.getIndex());
        for (long l : lArray) {
            builder.addVars(this.indexFromConstant(l));
        }
        builder.setTarget(intVar2.getIndex());
        return constraint;
    }

    public Constraint addElement(IntVar intVar, int[] nArray, IntVar intVar2) {
        Constraint constraint = new Constraint(this.modelBuilder);
        ElementConstraintProto.Builder builder = constraint.getBuilder().getElementBuilder();
        builder.setIndex(intVar.getIndex());
        int[] nArray2 = nArray;
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            long l = nArray2[i];
            builder.addVars(this.indexFromConstant(l));
        }
        builder.setTarget(intVar2.getIndex());
        return constraint;
    }

    public Constraint addCircuit(int[] nArray, int[] nArray2, Literal[] literalArray) throws MismatchedArrayLengths {
        if (nArray.length != nArray2.length) {
            throw new MismatchedArrayLengths("addCircuit", "tails", "heads");
        }
        if (nArray.length != literalArray.length) {
            throw new MismatchedArrayLengths("addCircuit", "tails", "literals");
        }
        Constraint constraint = new Constraint(this.modelBuilder);
        CircuitConstraintProto.Builder builder = constraint.getBuilder().getCircuitBuilder();
        for (int n : nArray) {
            builder.addTails(n);
        }
        for (int n : nArray2) {
            builder.addHeads(n);
        }
        for (Literal literal : literalArray) {
            builder.addLiterals(literal.getIndex());
        }
        return constraint;
    }

    public Constraint addAllowedAssignments(IntVar[] intVarArray, long[][] lArray) throws WrongLength {
        int n;
        Constraint constraint = new Constraint(this.modelBuilder);
        TableConstraintProto.Builder builder = constraint.getBuilder().getTableBuilder();
        IntVar[] intVarArray2 = intVarArray;
        int n2 = intVarArray2.length;
        for (n = 0; n < n2; ++n) {
            IntVar intVar = intVarArray2[n];
            builder.addVars(intVar.getIndex());
        }
        int n3 = intVarArray.length;
        for (n2 = 0; n2 < lArray.length; ++n2) {
            if (lArray[n2].length != n3) {
                throw new WrongLength("addAllowedAssignments", "tuple " + n2 + " does not have the same length as the variables");
            }
            for (n = 0; n < lArray[n2].length; ++n) {
                builder.addValues(lArray[n2][n]);
            }
        }
        return constraint;
    }

    public Constraint addAllowedAssignments(IntVar[] intVarArray, int[][] nArray) throws WrongLength {
        int n;
        Constraint constraint = new Constraint(this.modelBuilder);
        TableConstraintProto.Builder builder = constraint.getBuilder().getTableBuilder();
        IntVar[] intVarArray2 = intVarArray;
        int n2 = intVarArray2.length;
        for (n = 0; n < n2; ++n) {
            IntVar intVar = intVarArray2[n];
            builder.addVars(intVar.getIndex());
        }
        int n3 = intVarArray.length;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2].length != n3) {
                throw new WrongLength("addAllowedAssignments", "tuple " + n2 + " does not have the same length as the variables");
            }
            for (n = 0; n < nArray[n2].length; ++n) {
                builder.addValues(nArray[n2][n]);
            }
        }
        return constraint;
    }

    public Constraint addForbiddenAssignments(IntVar[] intVarArray, long[][] lArray) throws WrongLength {
        Constraint constraint = this.addAllowedAssignments(intVarArray, lArray);
        constraint.getBuilder().getTableBuilder().setNegated(true);
        return constraint;
    }

    public Constraint addForbiddenAssignments(IntVar[] intVarArray, int[][] nArray) throws WrongLength {
        Constraint constraint = this.addAllowedAssignments(intVarArray, nArray);
        constraint.getBuilder().getTableBuilder().setNegated(true);
        return constraint;
    }

    public Constraint addAutomaton(IntVar[] intVarArray, long l, long[] lArray, long[][] lArray2) throws WrongLength {
        Constraint constraint = new Constraint(this.modelBuilder);
        AutomatonConstraintProto.Builder builder = constraint.getBuilder().getAutomatonBuilder();
        for (IntVar intVar : intVarArray) {
            builder.addVars(intVar.getIndex());
        }
        builder.setStartingState(l);
        for (long l2 : lArray) {
            builder.addFinalStates(l2);
        }
        for (long[] lArray3 : lArray2) {
            if (lArray3.length != 3) {
                throw new WrongLength("addAutomaton", "transition does not have length 3");
            }
            builder.addTransitionTail(lArray3[0]);
            builder.addTransitionLabel(lArray3[1]);
            builder.addTransitionHead(lArray3[2]);
        }
        return constraint;
    }

    public Constraint addInverse(IntVar[] intVarArray, IntVar[] intVarArray2) throws MismatchedArrayLengths {
        if (intVarArray.length != intVarArray2.length) {
            throw new MismatchedArrayLengths("addInverse", "variables", "inverseVariables");
        }
        Constraint constraint = new Constraint(this.modelBuilder);
        InverseConstraintProto.Builder builder = constraint.getBuilder().getInverseBuilder();
        for (IntVar intVar : intVarArray) {
            builder.addFDirect(intVar.getIndex());
        }
        for (IntVar intVar : intVarArray2) {
            builder.addFInverse(intVar.getIndex());
        }
        return constraint;
    }

    public Constraint addReservoirConstraint(IntVar[] intVarArray, long[] lArray, long l, long l2) throws MismatchedArrayLengths {
        if (intVarArray.length != lArray.length) {
            throw new MismatchedArrayLengths("addReservoirConstraint", "times", "demands");
        }
        Constraint constraint = new Constraint(this.modelBuilder);
        ReservoirConstraintProto.Builder builder = constraint.getBuilder().getReservoirBuilder();
        for (IntVar intVar : intVarArray) {
            builder.addTimes(intVar.getIndex());
        }
        for (long l3 : lArray) {
            builder.addDemands(l3);
        }
        builder.setMinLevel(l);
        builder.setMaxLevel(l2);
        return constraint;
    }

    public Constraint addReservoirConstraint(IntVar[] intVarArray, int[] nArray, long l, long l2) throws MismatchedArrayLengths {
        return this.addReservoirConstraint(intVarArray, this.toLongArray(nArray), l, l2);
    }

    public Constraint addReservoirConstraintWithActive(IntVar[] intVarArray, long[] lArray, IntVar[] intVarArray2, long l, long l2) throws MismatchedArrayLengths {
        if (intVarArray.length != lArray.length) {
            throw new MismatchedArrayLengths("addReservoirConstraint", "times", "demands");
        }
        if (intVarArray.length != intVarArray2.length) {
            throw new MismatchedArrayLengths("addReservoirConstraint", "times", "actives");
        }
        Constraint constraint = new Constraint(this.modelBuilder);
        ReservoirConstraintProto.Builder builder = constraint.getBuilder().getReservoirBuilder();
        for (IntVar intVar : intVarArray) {
            builder.addTimes(intVar.getIndex());
        }
        for (long l3 : lArray) {
            builder.addDemands(l3);
        }
        for (IntVar intVar : intVarArray2) {
            builder.addActives(intVar.getIndex());
        }
        builder.setMinLevel(l);
        builder.setMaxLevel(l2);
        return constraint;
    }

    public Constraint addReservoirConstraintWithActive(IntVar[] intVarArray, int[] nArray, IntVar[] intVarArray2, long l, long l2) throws MismatchedArrayLengths {
        return this.addReservoirConstraintWithActive(intVarArray, this.toLongArray(nArray), intVarArray2, l, l2);
    }

    public void addMapDomain(IntVar intVar, Literal[] literalArray, long l) {
        for (int i = 0; i < literalArray.length; ++i) {
            this.addEquality((LinearExpr)intVar, l + (long)i).onlyEnforceIf(literalArray[i]);
            this.addDifferent((LinearExpr)intVar, l + (long)i).onlyEnforceIf(literalArray[i].not());
        }
    }

    public Constraint addMinEquality(IntVar intVar, IntVar[] intVarArray) {
        Constraint constraint = new Constraint(this.modelBuilder);
        IntegerArgumentProto.Builder builder = constraint.getBuilder().getIntMinBuilder();
        builder.setTarget(intVar.getIndex());
        for (IntVar intVar2 : intVarArray) {
            builder.addVars(intVar2.getIndex());
        }
        return constraint;
    }

    public Constraint addMaxEquality(IntVar intVar, IntVar[] intVarArray) {
        Constraint constraint = new Constraint(this.modelBuilder);
        IntegerArgumentProto.Builder builder = constraint.getBuilder().getIntMaxBuilder();
        builder.setTarget(intVar.getIndex());
        for (IntVar intVar2 : intVarArray) {
            builder.addVars(intVar2.getIndex());
        }
        return constraint;
    }

    public Constraint addDivisionEquality(IntVar intVar, IntVar intVar2, IntVar intVar3) {
        Constraint constraint = new Constraint(this.modelBuilder);
        IntegerArgumentProto.Builder builder = constraint.getBuilder().getIntDivBuilder();
        builder.setTarget(intVar.getIndex());
        builder.addVars(intVar2.getIndex());
        builder.addVars(intVar3.getIndex());
        return constraint;
    }

    public Constraint addAbsEquality(IntVar intVar, IntVar intVar2) {
        Constraint constraint = new Constraint(this.modelBuilder);
        IntegerArgumentProto.Builder builder = constraint.getBuilder().getIntMaxBuilder();
        builder.setTarget(intVar.getIndex());
        builder.addVars(intVar2.getIndex());
        builder.addVars(-intVar2.getIndex() - 1);
        return constraint;
    }

    public Constraint addModuloEquality(IntVar intVar, IntVar intVar2, IntVar intVar3) {
        Constraint constraint = new Constraint(this.modelBuilder);
        IntegerArgumentProto.Builder builder = constraint.getBuilder().getIntModBuilder();
        builder.setTarget(intVar.getIndex());
        builder.addVars(intVar2.getIndex());
        builder.addVars(intVar3.getIndex());
        return constraint;
    }

    public Constraint addModuloEquality(IntVar intVar, IntVar intVar2, long l) {
        Constraint constraint = new Constraint(this.modelBuilder);
        IntegerArgumentProto.Builder builder = constraint.getBuilder().getIntModBuilder();
        builder.setTarget(intVar.getIndex());
        builder.addVars(intVar2.getIndex());
        builder.addVars(this.indexFromConstant(l));
        return constraint;
    }

    public Constraint addProductEquality(IntVar intVar, IntVar[] intVarArray) {
        Constraint constraint = new Constraint(this.modelBuilder);
        IntegerArgumentProto.Builder builder = constraint.getBuilder().getIntProdBuilder();
        builder.setTarget(intVar.getIndex());
        for (IntVar intVar2 : intVarArray) {
            builder.addVars(intVar2.getIndex());
        }
        return constraint;
    }

    public IntervalVar newIntervalVar(IntVar intVar, IntVar intVar2, IntVar intVar3, String string) {
        return new IntervalVar(this.modelBuilder, intVar.getIndex(), intVar2.getIndex(), intVar3.getIndex(), string);
    }

    public IntervalVar newIntervalVar(IntVar intVar, IntVar intVar2, long l, String string) {
        return new IntervalVar(this.modelBuilder, intVar.getIndex(), intVar2.getIndex(), this.indexFromConstant(l), string);
    }

    public IntervalVar newIntervalVar(IntVar intVar, long l, IntVar intVar2, String string) {
        return new IntervalVar(this.modelBuilder, intVar.getIndex(), this.indexFromConstant(l), intVar2.getIndex(), string);
    }

    public IntervalVar newIntervalVar(long l, IntVar intVar, IntVar intVar2, String string) {
        return new IntervalVar(this.modelBuilder, this.indexFromConstant(l), intVar.getIndex(), intVar2.getIndex(), string);
    }

    public IntervalVar newFixedInterval(long l, long l2, String string) {
        return new IntervalVar(this.modelBuilder, this.indexFromConstant(l), this.indexFromConstant(l2), this.indexFromConstant(l + l2), string);
    }

    public IntervalVar newOptionalIntervalVar(IntVar intVar, IntVar intVar2, IntVar intVar3, Literal literal, String string) {
        return new IntervalVar(this.modelBuilder, intVar.getIndex(), intVar2.getIndex(), intVar3.getIndex(), literal.getIndex(), string);
    }

    public IntervalVar newOptionalIntervalVar(IntVar intVar, IntVar intVar2, long l, Literal literal, String string) {
        return new IntervalVar(this.modelBuilder, intVar.getIndex(), intVar2.getIndex(), this.indexFromConstant(l), literal.getIndex(), string);
    }

    public IntervalVar newOptionalIntervalVar(IntVar intVar, long l, IntVar intVar2, Literal literal, String string) {
        return new IntervalVar(this.modelBuilder, intVar.getIndex(), this.indexFromConstant(l), intVar2.getIndex(), literal.getIndex(), string);
    }

    public IntervalVar newOptionalIntervalVar(long l, IntVar intVar, IntVar intVar2, Literal literal, String string) {
        return new IntervalVar(this.modelBuilder, this.indexFromConstant(l), intVar.getIndex(), intVar2.getIndex(), literal.getIndex(), string);
    }

    public IntervalVar newOptionalFixedInterval(long l, long l2, Literal literal, String string) {
        return new IntervalVar(this.modelBuilder, this.indexFromConstant(l), this.indexFromConstant(l2), this.indexFromConstant(l + l2), literal.getIndex(), string);
    }

    public Constraint addNoOverlap(IntervalVar[] intervalVarArray) {
        Constraint constraint = new Constraint(this.modelBuilder);
        NoOverlapConstraintProto.Builder builder = constraint.getBuilder().getNoOverlapBuilder();
        for (IntervalVar intervalVar : intervalVarArray) {
            builder.addIntervals(intervalVar.getIndex());
        }
        return constraint;
    }

    public Constraint addNoOverlap2D(IntervalVar[] intervalVarArray, IntervalVar[] intervalVarArray2) {
        Constraint constraint = new Constraint(this.modelBuilder);
        NoOverlap2DConstraintProto.Builder builder = constraint.getBuilder().getNoOverlap2DBuilder();
        for (IntervalVar intervalVar : intervalVarArray) {
            builder.addXIntervals(intervalVar.getIndex());
        }
        for (IntervalVar intervalVar : intervalVarArray2) {
            builder.addYIntervals(intervalVar.getIndex());
        }
        return constraint;
    }

    public Constraint addCumulative(IntervalVar[] intervalVarArray, IntVar[] intVarArray, IntVar intVar) {
        Constraint constraint = new Constraint(this.modelBuilder);
        CumulativeConstraintProto.Builder builder = constraint.getBuilder().getCumulativeBuilder();
        for (IntervalVar object : intervalVarArray) {
            builder.addIntervals(object.getIndex());
        }
        for (IntVar intVar2 : intVarArray) {
            builder.addDemands(intVar2.getIndex());
        }
        builder.setCapacity(intVar.getIndex());
        return constraint;
    }

    public Constraint addCumulative(IntervalVar[] intervalVarArray, long[] lArray, IntVar intVar) {
        Constraint constraint = new Constraint(this.modelBuilder);
        CumulativeConstraintProto.Builder builder = constraint.getBuilder().getCumulativeBuilder();
        for (IntervalVar intervalVar : intervalVarArray) {
            builder.addIntervals(intervalVar.getIndex());
        }
        for (long l : lArray) {
            builder.addDemands(this.indexFromConstant(l));
        }
        builder.setCapacity(intVar.getIndex());
        return constraint;
    }

    public Constraint addCumulative(IntervalVar[] intervalVarArray, int[] nArray, IntVar intVar) {
        return this.addCumulative(intervalVarArray, this.toLongArray(nArray), intVar);
    }

    public Constraint addCumulative(IntervalVar[] intervalVarArray, IntVar[] intVarArray, long l) {
        Constraint constraint = new Constraint(this.modelBuilder);
        CumulativeConstraintProto.Builder builder = constraint.getBuilder().getCumulativeBuilder();
        for (IntervalVar object : intervalVarArray) {
            builder.addIntervals(object.getIndex());
        }
        for (IntVar intVar : intVarArray) {
            builder.addDemands(intVar.getIndex());
        }
        builder.setCapacity(this.indexFromConstant(l));
        return constraint;
    }

    public Constraint addCumulative(IntervalVar[] intervalVarArray, long[] lArray, long l) {
        Constraint constraint = new Constraint(this.modelBuilder);
        CumulativeConstraintProto.Builder builder = constraint.getBuilder().getCumulativeBuilder();
        for (IntervalVar intervalVar : intervalVarArray) {
            builder.addIntervals(intervalVar.getIndex());
        }
        for (long l2 : lArray) {
            builder.addDemands(this.indexFromConstant(l2));
        }
        builder.setCapacity(this.indexFromConstant(l));
        return constraint;
    }

    public Constraint addCumulative(IntervalVar[] intervalVarArray, int[] nArray, long l) {
        return this.addCumulative(intervalVarArray, this.toLongArray(nArray), l);
    }

    public void addHint(IntVar intVar, long l) {
        this.modelBuilder.getSolutionHintBuilder().addVars(intVar.getIndex());
        this.modelBuilder.getSolutionHintBuilder().addValues(l);
    }

    public void minimize(LinearExpr linearExpr) {
        CpObjectiveProto.Builder builder = this.modelBuilder.getObjectiveBuilder();
        for (int i = 0; i < linearExpr.numElements(); ++i) {
            builder.addVars(linearExpr.getVariable(i).getIndex());
            builder.addCoeffs(linearExpr.getCoefficient(i));
        }
    }

    public void maximize(LinearExpr linearExpr) {
        CpObjectiveProto.Builder builder = this.modelBuilder.getObjectiveBuilder();
        for (int i = 0; i < linearExpr.numElements(); ++i) {
            builder.addVars(linearExpr.getVariable(i).getIndex());
            builder.addCoeffs(-linearExpr.getCoefficient(i));
        }
        builder.setScalingFactor(-1.0);
    }

    public void addDecisionStrategy(IntVar[] intVarArray, DecisionStrategyProto.VariableSelectionStrategy variableSelectionStrategy, DecisionStrategyProto.DomainReductionStrategy domainReductionStrategy) {
        DecisionStrategyProto.Builder builder = this.modelBuilder.addSearchStrategyBuilder();
        for (IntVar intVar : intVarArray) {
            builder.addVariables(intVar.getIndex());
        }
        builder.setVariableSelectionStrategy(variableSelectionStrategy);
        builder.setDomainReductionStrategy(domainReductionStrategy);
    }

    public String modelStats() {
        return SatHelper.modelStats(this.model());
    }

    public String validate() {
        return SatHelper.validateModel(this.model());
    }

    long[] toLongArray(int[] nArray) {
        long[] lArray = new long[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            lArray[i] = nArray[i];
        }
        return lArray;
    }

    int indexFromConstant(long l) {
        int n = this.modelBuilder.getVariablesCount();
        IntegerVariableProto.Builder builder = this.modelBuilder.addVariablesBuilder();
        builder.addDomain(l);
        builder.addDomain(l);
        return n;
    }

    public CpModelProto model() {
        return this.modelBuilder.build();
    }

    public int negated(int n) {
        return -n - 1;
    }

    public CpModelProto.Builder getBuilder() {
        return this.modelBuilder;
    }

    public static class WrongLength
    extends CpModelException {
        public WrongLength(String string, String string2) {
            super(string, string2);
        }
    }

    public static class MismatchedArrayLengths
    extends CpModelException {
        public MismatchedArrayLengths(String string, String string2, String string3) {
            super(string, string2 + " and " + string3 + " have mismatched lengths");
        }
    }

    static class CpModelException
    extends Exception {
        public CpModelException(String string, String string2) {
            super("CpModel." + string + ": " + string2);
        }
    }
}

