/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.linearsolver;

import com.google.ortools.linearsolver.MPConstraint;
import com.google.ortools.linearsolver.MPModelExportOptions;
import com.google.ortools.linearsolver.MPModelProto;
import com.google.ortools.linearsolver.MPModelRequest;
import com.google.ortools.linearsolver.MPObjective;
import com.google.ortools.linearsolver.MPSolutionResponse;
import com.google.ortools.linearsolver.MPSolverParameters;
import com.google.ortools.linearsolver.MPVariable;
import com.google.ortools.linearsolver.main_research_linear_solverJNI;
import com.google.protobuf.InvalidProtocolBufferException;

public class MPSolver {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected MPSolver(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(MPSolver mPSolver) {
        return mPSolver == null ? 0L : mPSolver.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                main_research_linear_solverJNI.delete_MPSolver(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public MPVariable[] makeVarArray(int n, double d, double d2, boolean bl) {
        MPVariable[] mPVariableArray = new MPVariable[n];
        for (int i = 0; i < n; ++i) {
            mPVariableArray[i] = this.makeVar(d, d2, bl, "");
        }
        return mPVariableArray;
    }

    public MPVariable[] makeVarArray(int n, double d, double d2, boolean bl, String string) {
        MPVariable[] mPVariableArray = new MPVariable[n];
        for (int i = 0; i < n; ++i) {
            mPVariableArray[i] = this.makeVar(d, d2, bl, string + i);
        }
        return mPVariableArray;
    }

    public MPVariable[] makeNumVarArray(int n, double d, double d2) {
        return this.makeVarArray(n, d, d2, false);
    }

    public MPVariable[] makeNumVarArray(int n, double d, double d2, String string) {
        return this.makeVarArray(n, d, d2, false, string);
    }

    public MPVariable[] makeIntVarArray(int n, double d, double d2) {
        return this.makeVarArray(n, d, d2, true);
    }

    public MPVariable[] makeIntVarArray(int n, double d, double d2, String string) {
        return this.makeVarArray(n, d, d2, true, string);
    }

    public MPVariable[] makeBoolVarArray(int n) {
        return this.makeVarArray(n, 0.0, 1.0, true);
    }

    public MPVariable[] makeBoolVarArray(int n, String string) {
        return this.makeVarArray(n, 0.0, 1.0, true, string);
    }

    public MPSolver(String string, OptimizationProblemType optimizationProblemType) {
        this(main_research_linear_solverJNI.new_MPSolver(string, optimizationProblemType.swigValue()), true);
    }

    public static boolean supportsProblemType(OptimizationProblemType optimizationProblemType) {
        return main_research_linear_solverJNI.MPSolver_supportsProblemType(optimizationProblemType.swigValue());
    }

    public void clear() {
        main_research_linear_solverJNI.MPSolver_clear(this.swigCPtr, this);
    }

    public int numVariables() {
        return main_research_linear_solverJNI.MPSolver_numVariables(this.swigCPtr, this);
    }

    public MPVariable[] variables() {
        return main_research_linear_solverJNI.MPSolver_variables(this.swigCPtr, this);
    }

    public MPVariable lookupVariableOrNull(String string) {
        long l = main_research_linear_solverJNI.MPSolver_lookupVariableOrNull(this.swigCPtr, this, string);
        return l == 0L ? null : new MPVariable(l, false);
    }

    public MPVariable makeVar(double d, double d2, boolean bl, String string) {
        long l = main_research_linear_solverJNI.MPSolver_makeVar(this.swigCPtr, this, d, d2, bl, string);
        return l == 0L ? null : new MPVariable(l, false);
    }

    public MPVariable makeNumVar(double d, double d2, String string) {
        long l = main_research_linear_solverJNI.MPSolver_makeNumVar(this.swigCPtr, this, d, d2, string);
        return l == 0L ? null : new MPVariable(l, false);
    }

    public MPVariable makeIntVar(double d, double d2, String string) {
        long l = main_research_linear_solverJNI.MPSolver_makeIntVar(this.swigCPtr, this, d, d2, string);
        return l == 0L ? null : new MPVariable(l, false);
    }

    public MPVariable makeBoolVar(String string) {
        long l = main_research_linear_solverJNI.MPSolver_makeBoolVar(this.swigCPtr, this, string);
        return l == 0L ? null : new MPVariable(l, false);
    }

    public int numConstraints() {
        return main_research_linear_solverJNI.MPSolver_numConstraints(this.swigCPtr, this);
    }

    public MPConstraint[] constraints() {
        return main_research_linear_solverJNI.MPSolver_constraints(this.swigCPtr, this);
    }

    public MPConstraint lookupConstraintOrNull(String string) {
        long l = main_research_linear_solverJNI.MPSolver_lookupConstraintOrNull(this.swigCPtr, this, string);
        return l == 0L ? null : new MPConstraint(l, false);
    }

    public MPConstraint makeConstraint(double d, double d2) {
        long l = main_research_linear_solverJNI.MPSolver_makeConstraint__SWIG_0(this.swigCPtr, this, d, d2);
        return l == 0L ? null : new MPConstraint(l, false);
    }

    public MPConstraint makeConstraint() {
        long l = main_research_linear_solverJNI.MPSolver_makeConstraint__SWIG_1(this.swigCPtr, this);
        return l == 0L ? null : new MPConstraint(l, false);
    }

    public MPConstraint makeConstraint(double d, double d2, String string) {
        long l = main_research_linear_solverJNI.MPSolver_makeConstraint__SWIG_2(this.swigCPtr, this, d, d2, string);
        return l == 0L ? null : new MPConstraint(l, false);
    }

    public MPConstraint makeConstraint(String string) {
        long l = main_research_linear_solverJNI.MPSolver_makeConstraint__SWIG_3(this.swigCPtr, this, string);
        return l == 0L ? null : new MPConstraint(l, false);
    }

    public MPObjective objective() {
        long l = main_research_linear_solverJNI.MPSolver_objective(this.swigCPtr, this);
        return l == 0L ? null : new MPObjective(l, false);
    }

    public ResultStatus solve() {
        return ResultStatus.swigToEnum(main_research_linear_solverJNI.MPSolver_solve__SWIG_0(this.swigCPtr, this));
    }

    public ResultStatus solve(MPSolverParameters mPSolverParameters) {
        return ResultStatus.swigToEnum(main_research_linear_solverJNI.MPSolver_solve__SWIG_1(this.swigCPtr, this, MPSolverParameters.getCPtr(mPSolverParameters), mPSolverParameters));
    }

    public double[] computeConstraintActivities() {
        return main_research_linear_solverJNI.MPSolver_computeConstraintActivities(this.swigCPtr, this);
    }

    public boolean verifySolution(double d, boolean bl) {
        return main_research_linear_solverJNI.MPSolver_verifySolution(this.swigCPtr, this, d, bl);
    }

    public void reset() {
        main_research_linear_solverJNI.MPSolver_reset(this.swigCPtr, this);
    }

    public boolean interruptSolve() {
        return main_research_linear_solverJNI.MPSolver_interruptSolve(this.swigCPtr, this);
    }

    public boolean setSolverSpecificParametersAsString(String string) {
        return main_research_linear_solverJNI.MPSolver_setSolverSpecificParametersAsString(this.swigCPtr, this, string);
    }

    public static double infinity() {
        return main_research_linear_solverJNI.MPSolver_infinity();
    }

    public void enableOutput() {
        main_research_linear_solverJNI.MPSolver_enableOutput(this.swigCPtr, this);
    }

    public void suppressOutput() {
        main_research_linear_solverJNI.MPSolver_suppressOutput(this.swigCPtr, this);
    }

    public long iterations() {
        return main_research_linear_solverJNI.MPSolver_iterations(this.swigCPtr, this);
    }

    public long nodes() {
        return main_research_linear_solverJNI.MPSolver_nodes(this.swigCPtr, this);
    }

    public double computeExactConditionNumber() {
        return main_research_linear_solverJNI.MPSolver_computeExactConditionNumber(this.swigCPtr, this);
    }

    public void setTimeLimit(long l) {
        main_research_linear_solverJNI.MPSolver_setTimeLimit(this.swigCPtr, this, l);
    }

    public long wallTime() {
        return main_research_linear_solverJNI.MPSolver_wallTime(this.swigCPtr, this);
    }

    public String loadModelFromProto(MPModelProto mPModelProto) {
        return main_research_linear_solverJNI.MPSolver_loadModelFromProto(this.swigCPtr, this, mPModelProto.toByteArray());
    }

    public String loadModelFromProtoWithUniqueNamesOrDie(MPModelProto mPModelProto) {
        return main_research_linear_solverJNI.MPSolver_loadModelFromProtoWithUniqueNamesOrDie(this.swigCPtr, this, mPModelProto.toByteArray());
    }

    public MPModelProto exportModelToProto() {
        byte[] byArray = main_research_linear_solverJNI.MPSolver_exportModelToProto(this.swigCPtr, this);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            return MPModelProto.parseFrom(byArray);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw new RuntimeException("Unable to parse com.google.ortools.linearsolver.MPModelProto protocol message.");
        }
    }

    public MPSolutionResponse createSolutionResponseProto() {
        byte[] byArray = main_research_linear_solverJNI.MPSolver_createSolutionResponseProto(this.swigCPtr, this);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            return MPSolutionResponse.parseFrom(byArray);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw new RuntimeException("Unable to parse com.google.ortools.linearsolver.MPSolutionResponse protocol message.");
        }
    }

    public boolean loadSolutionFromProto(MPSolutionResponse mPSolutionResponse) {
        return main_research_linear_solverJNI.MPSolver_loadSolutionFromProto(this.swigCPtr, this, mPSolutionResponse.toByteArray());
    }

    public static MPSolutionResponse solveWithProto(MPModelRequest mPModelRequest) {
        byte[] byArray = main_research_linear_solverJNI.MPSolver_solveWithProto(mPModelRequest.toByteArray());
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            return MPSolutionResponse.parseFrom(byArray);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw new RuntimeException("Unable to parse com.google.ortools.linearsolver.MPSolutionResponse protocol message.");
        }
    }

    public String exportModelAsLpFormat(MPModelExportOptions mPModelExportOptions) {
        return main_research_linear_solverJNI.MPSolver_exportModelAsLpFormat__SWIG_0(this.swigCPtr, this, MPModelExportOptions.getCPtr(mPModelExportOptions), mPModelExportOptions);
    }

    public String exportModelAsLpFormat() {
        return main_research_linear_solverJNI.MPSolver_exportModelAsLpFormat__SWIG_1(this.swigCPtr, this);
    }

    public String exportModelAsMpsFormat(MPModelExportOptions mPModelExportOptions) {
        return main_research_linear_solverJNI.MPSolver_exportModelAsMpsFormat__SWIG_0(this.swigCPtr, this, MPModelExportOptions.getCPtr(mPModelExportOptions), mPModelExportOptions);
    }

    public String exportModelAsMpsFormat() {
        return main_research_linear_solverJNI.MPSolver_exportModelAsMpsFormat__SWIG_1(this.swigCPtr, this);
    }

    public void setHint(MPVariable[] mPVariableArray, double[] dArray) {
        main_research_linear_solverJNI.MPSolver_setHint(this.swigCPtr, this, mPVariableArray, dArray);
    }

    public boolean setNumThreads(int n) {
        return main_research_linear_solverJNI.MPSolver_setNumThreads(this.swigCPtr, this, n);
    }

    public static enum BasisStatus {
        FREE(main_research_linear_solverJNI.MPSolver_FREE_get()),
        AT_LOWER_BOUND,
        AT_UPPER_BOUND,
        FIXED_VALUE,
        BASIC;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static BasisStatus swigToEnum(int n) {
            BasisStatus[] basisStatusArray = (BasisStatus[])BasisStatus.class.getEnumConstants();
            if (n < basisStatusArray.length && n >= 0 && basisStatusArray[n].swigValue == n) {
                return basisStatusArray[n];
            }
            for (BasisStatus basisStatus : basisStatusArray) {
                if (basisStatus.swigValue != n) continue;
                return basisStatus;
            }
            throw new IllegalArgumentException("No enum " + BasisStatus.class + " with value " + n);
        }

        private BasisStatus() {
            this.swigValue = SwigNext.next++;
        }

        private BasisStatus(int n2) {
            this.swigValue = n2;
            SwigNext.next = n2 + 1;
        }

        private BasisStatus(BasisStatus basisStatus) {
            this.swigValue = basisStatus.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum ResultStatus {
        OPTIMAL,
        FEASIBLE,
        INFEASIBLE,
        UNBOUNDED,
        ABNORMAL,
        NOT_SOLVED(main_research_linear_solverJNI.MPSolver_NOT_SOLVED_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static ResultStatus swigToEnum(int n) {
            ResultStatus[] resultStatusArray = (ResultStatus[])ResultStatus.class.getEnumConstants();
            if (n < resultStatusArray.length && n >= 0 && resultStatusArray[n].swigValue == n) {
                return resultStatusArray[n];
            }
            for (ResultStatus resultStatus : resultStatusArray) {
                if (resultStatus.swigValue != n) continue;
                return resultStatus;
            }
            throw new IllegalArgumentException("No enum " + ResultStatus.class + " with value " + n);
        }

        private ResultStatus() {
            this.swigValue = SwigNext.next++;
        }

        private ResultStatus(int n2) {
            this.swigValue = n2;
            SwigNext.next = n2 + 1;
        }

        private ResultStatus(ResultStatus resultStatus) {
            this.swigValue = resultStatus.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum OptimizationProblemType {
        CLP_LINEAR_PROGRAMMING(main_research_linear_solverJNI.MPSolver_CLP_LINEAR_PROGRAMMING_get()),
        GLOP_LINEAR_PROGRAMMING(main_research_linear_solverJNI.MPSolver_GLOP_LINEAR_PROGRAMMING_get()),
        CBC_MIXED_INTEGER_PROGRAMMING(main_research_linear_solverJNI.MPSolver_CBC_MIXED_INTEGER_PROGRAMMING_get()),
        BOP_INTEGER_PROGRAMMING(main_research_linear_solverJNI.MPSolver_BOP_INTEGER_PROGRAMMING_get()),
        SAT_INTEGER_PROGRAMMING(main_research_linear_solverJNI.MPSolver_SAT_INTEGER_PROGRAMMING_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static OptimizationProblemType swigToEnum(int n) {
            OptimizationProblemType[] optimizationProblemTypeArray = (OptimizationProblemType[])OptimizationProblemType.class.getEnumConstants();
            if (n < optimizationProblemTypeArray.length && n >= 0 && optimizationProblemTypeArray[n].swigValue == n) {
                return optimizationProblemTypeArray[n];
            }
            for (OptimizationProblemType optimizationProblemType : optimizationProblemTypeArray) {
                if (optimizationProblemType.swigValue != n) continue;
                return optimizationProblemType;
            }
            throw new IllegalArgumentException("No enum " + OptimizationProblemType.class + " with value " + n);
        }

        private OptimizationProblemType() {
            this.swigValue = SwigNext.next++;
        }

        private OptimizationProblemType(int n2) {
            this.swigValue = n2;
            SwigNext.next = n2 + 1;
        }

        private OptimizationProblemType(OptimizationProblemType optimizationProblemType) {
            this.swigValue = optimizationProblemType.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

