/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.constraintsolver;

import com.google.ortools.constraintsolver.Assignment;
import com.google.ortools.constraintsolver.IntVar;
import com.google.ortools.constraintsolver.IntervalVar;
import com.google.ortools.constraintsolver.SearchMonitor;
import com.google.ortools.constraintsolver.SequenceVar;
import com.google.ortools.constraintsolver.Solver;
import com.google.ortools.constraintsolver.mainJNI;

public class SolutionCollector
extends SearchMonitor {
    private transient long swigCPtr;

    protected SolutionCollector(long l, boolean bl) {
        super(mainJNI.SolutionCollector_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(SolutionCollector solutionCollector) {
        return solutionCollector == null ? 0L : solutionCollector.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_SolutionCollector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public SolutionCollector(Solver solver, Assignment assignment) {
        this(mainJNI.new_SolutionCollector__SWIG_0(Solver.getCPtr(solver), solver, Assignment.getCPtr(assignment), assignment), true);
    }

    public SolutionCollector(Solver solver) {
        this(mainJNI.new_SolutionCollector__SWIG_1(Solver.getCPtr(solver), solver), true);
    }

    @Override
    public String toString() {
        return mainJNI.SolutionCollector_toString(this.swigCPtr, this);
    }

    public void add(IntVar intVar) {
        mainJNI.SolutionCollector_add__SWIG_0(this.swigCPtr, this, IntVar.getCPtr(intVar), intVar);
    }

    public void add(IntVar[] intVarArray) {
        mainJNI.SolutionCollector_add__SWIG_1(this.swigCPtr, this, intVarArray);
    }

    public void add(IntervalVar intervalVar) {
        mainJNI.SolutionCollector_add__SWIG_2(this.swigCPtr, this, IntervalVar.getCPtr(intervalVar), intervalVar);
    }

    public void add(IntervalVar[] intervalVarArray) {
        mainJNI.SolutionCollector_add__SWIG_3(this.swigCPtr, this, intervalVarArray);
    }

    public void add(SequenceVar sequenceVar) {
        mainJNI.SolutionCollector_add__SWIG_4(this.swigCPtr, this, SequenceVar.getCPtr(sequenceVar), sequenceVar);
    }

    public void add(SequenceVar[] sequenceVarArray) {
        mainJNI.SolutionCollector_add__SWIG_5(this.swigCPtr, this, sequenceVarArray);
    }

    public void addObjective(IntVar intVar) {
        mainJNI.SolutionCollector_addObjective(this.swigCPtr, this, IntVar.getCPtr(intVar), intVar);
    }

    @Override
    public void enterSearch() {
        mainJNI.SolutionCollector_enterSearch(this.swigCPtr, this);
    }

    public int solutionCount() {
        return mainJNI.SolutionCollector_solutionCount(this.swigCPtr, this);
    }

    public Assignment solution(int n) {
        long l = mainJNI.SolutionCollector_solution(this.swigCPtr, this, n);
        return l == 0L ? null : new Assignment(l, false);
    }

    public long wallTime(int n) {
        return mainJNI.SolutionCollector_wallTime(this.swigCPtr, this, n);
    }

    public long branches(int n) {
        return mainJNI.SolutionCollector_branches(this.swigCPtr, this, n);
    }

    public long failures(int n) {
        return mainJNI.SolutionCollector_failures(this.swigCPtr, this, n);
    }

    public long objectiveValue(int n) {
        return mainJNI.SolutionCollector_objectiveValue(this.swigCPtr, this, n);
    }

    public long value(int n, IntVar intVar) {
        return mainJNI.SolutionCollector_value(this.swigCPtr, this, n, IntVar.getCPtr(intVar), intVar);
    }

    public long startValue(int n, IntervalVar intervalVar) {
        return mainJNI.SolutionCollector_startValue(this.swigCPtr, this, n, IntervalVar.getCPtr(intervalVar), intervalVar);
    }

    public long endValue(int n, IntervalVar intervalVar) {
        return mainJNI.SolutionCollector_endValue(this.swigCPtr, this, n, IntervalVar.getCPtr(intervalVar), intervalVar);
    }

    public long durationValue(int n, IntervalVar intervalVar) {
        return mainJNI.SolutionCollector_durationValue(this.swigCPtr, this, n, IntervalVar.getCPtr(intervalVar), intervalVar);
    }

    public long performedValue(int n, IntervalVar intervalVar) {
        return mainJNI.SolutionCollector_performedValue(this.swigCPtr, this, n, IntervalVar.getCPtr(intervalVar), intervalVar);
    }

    public int[] forwardSequence(int n, SequenceVar sequenceVar) {
        return mainJNI.SolutionCollector_forwardSequence(this.swigCPtr, this, n, SequenceVar.getCPtr(sequenceVar), sequenceVar);
    }

    public int[] backwardSequence(int n, SequenceVar sequenceVar) {
        return mainJNI.SolutionCollector_backwardSequence(this.swigCPtr, this, n, SequenceVar.getCPtr(sequenceVar), sequenceVar);
    }

    public int[] unperformed(int n, SequenceVar sequenceVar) {
        return mainJNI.SolutionCollector_unperformed(this.swigCPtr, this, n, SequenceVar.getCPtr(sequenceVar), sequenceVar);
    }
}

