/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.algorithms;

import com.google.ortools.algorithms.mainJNI;

public class KnapsackSolver {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected KnapsackSolver(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(KnapsackSolver knapsackSolver) {
        return knapsackSolver == null ? 0L : knapsackSolver.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_KnapsackSolver(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public KnapsackSolver(String string) {
        this(mainJNI.new_KnapsackSolver__SWIG_0(string), true);
    }

    public KnapsackSolver(SolverType solverType, String string) {
        this(mainJNI.new_KnapsackSolver__SWIG_1(solverType.swigValue(), string), true);
    }

    public void init(long[] lArray, long[][] lArray2, long[] lArray3) {
        mainJNI.KnapsackSolver_init(this.swigCPtr, this, lArray, lArray2, lArray3);
    }

    public long solve() {
        return mainJNI.KnapsackSolver_solve(this.swigCPtr, this);
    }

    public boolean bestSolutionContains(int n) {
        return mainJNI.KnapsackSolver_bestSolutionContains(this.swigCPtr, this, n);
    }

    public boolean isSolutionOptimal() {
        return mainJNI.KnapsackSolver_isSolutionOptimal(this.swigCPtr, this);
    }

    public String getName() {
        return mainJNI.KnapsackSolver_getName(this.swigCPtr, this);
    }

    public boolean useReduction() {
        return mainJNI.KnapsackSolver_useReduction(this.swigCPtr, this);
    }

    public void setUseReduction(boolean bl) {
        mainJNI.KnapsackSolver_setUseReduction(this.swigCPtr, this, bl);
    }

    public void setTimeLimit(double d) {
        mainJNI.KnapsackSolver_setTimeLimit(this.swigCPtr, this, d);
    }

    public static enum SolverType {
        KNAPSACK_BRUTE_FORCE_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_BRUTE_FORCE_SOLVER_get()),
        KNAPSACK_64ITEMS_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_64ITEMS_SOLVER_get()),
        KNAPSACK_DYNAMIC_PROGRAMMING_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_DYNAMIC_PROGRAMMING_SOLVER_get()),
        KNAPSACK_MULTIDIMENSION_CBC_MIP_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_MULTIDIMENSION_CBC_MIP_SOLVER_get()),
        KNAPSACK_MULTIDIMENSION_BRANCH_AND_BOUND_SOLVER(mainJNI.KnapsackSolver_KNAPSACK_MULTIDIMENSION_BRANCH_AND_BOUND_SOLVER_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static SolverType swigToEnum(int n) {
            SolverType[] solverTypeArray = (SolverType[])SolverType.class.getEnumConstants();
            if (n < solverTypeArray.length && n >= 0 && solverTypeArray[n].swigValue == n) {
                return solverTypeArray[n];
            }
            for (SolverType solverType : solverTypeArray) {
                if (solverType.swigValue != n) continue;
                return solverType;
            }
            throw new IllegalArgumentException("No enum " + SolverType.class + " with value " + n);
        }

        private SolverType() {
            this.swigValue = SwigNext.next++;
        }

        private SolverType(int n2) {
            this.swigValue = n2;
            SwigNext.next = n2 + 1;
        }

        private SolverType(SolverType solverType) {
            this.swigValue = solverType.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

