/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPanel;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.Animator;
import jugglinglab.core.PlatformSpecific;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public abstract class View
extends JPanel {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    public static final int VIEW_NONE = 0;
    public static final int VIEW_SIMPLE = 1;
    public static final int VIEW_EDIT = 2;
    public static final int VIEW_SELECTION = 3;
    public static final int VIEW_JML = 4;
    public static final String[] viewNames = new String[]{"simple", "edit", "selection", "jml"};
    protected JFrame parent;

    public void setParent(JFrame jFrame) {
        this.parent = jFrame;
    }

    public abstract void restartView(JMLPattern var1, AnimationPrefs var2) throws JuggleExceptionUser, JuggleExceptionInternal;

    public abstract void restartView() throws JuggleExceptionUser, JuggleExceptionInternal;

    public abstract Dimension getAnimationPanelSize();

    public abstract void setAnimationPanelPreferredSize(Dimension var1);

    public abstract JMLPattern getPattern();

    public abstract AnimationPrefs getAnimationPrefs();

    public abstract boolean getPaused();

    public abstract void setPaused(boolean var1);

    public abstract void disposeView();

    public abstract void writeGIF();

    protected class GIFWriter
    extends Thread {
        private AnimationPanel ap;
        private Runnable cleanup;

        public GIFWriter(AnimationPanel animationPanel, Runnable runnable) {
            this.ap = animationPanel;
            this.cleanup = runnable;
            this.setPriority(1);
            this.start();
        }

        @Override
        public void run() {
            try {
                File file = null;
                try {
                    int n = PlatformSpecific.getPlatformSpecific().showSaveDialog(View.this.parent);
                    if (n == 0 && (file = PlatformSpecific.getPlatformSpecific().getSelectedFile()) != null) {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        final ProgressMonitor progressMonitor = new ProgressMonitor(View.this.parent, guistrings.getString("Saving_animated_GIF"), "", 0, 1);
                        progressMonitor.setMillisToPopup(1000);
                        Animator.WriteGIFMonitor writeGIFMonitor = new Animator.WriteGIFMonitor(){

                            @Override
                            public void update(final int n, final int n2) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        progressMonitor.setMaximum(n2);
                                        progressMonitor.setProgress(n);
                                    }
                                });
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Override
                            public boolean isCanceled() {
                                if (progressMonitor.isCanceled()) return true;
                                1 v0 = this;
                                if (!v0.GIFWriter.this.interrupted()) return false;
                                return true;
                            }
                        };
                        this.ap.getAnimator().writeGIF(fileOutputStream, writeGIFMonitor);
                    }
                }
                catch (IOException iOException) {
                    throw new JuggleExceptionUser("Problem writing to file: " + file.toString());
                }
            }
            catch (JuggleExceptionUser juggleExceptionUser) {
                new ErrorDialog(View.this.parent, juggleExceptionUser.getMessage());
            }
            catch (JuggleExceptionInternal juggleExceptionInternal) {
                ErrorDialog.handleFatalException(juggleExceptionInternal);
            }
            if (this.cleanup != null) {
                SwingUtilities.invokeLater(this.cleanup);
            }
        }
    }
}

