/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import jugglinglab.core.AnimationPanel;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.view.Mutator;
import jugglinglab.view.View;

public class SelectionView
extends View {
    protected static final int rows = 3;
    protected static final int columns = 3;
    protected static final int count = 9;
    protected static final int center = 4;
    protected AnimationPanel[] ja = new AnimationPanel[9];
    protected JLayeredPane layered;
    protected Mutator mutator;

    public SelectionView(Dimension dimension) {
        for (int i = 0; i < 9; ++i) {
            this.ja[i] = new AnimationPanel();
        }
        this.layered = this.makeLayeredPane(dimension, this.makeAnimationGrid(), this.makeOverlay());
        this.mutator = new Mutator();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.add(this.layered);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.layered, gridBagConstraints);
        JPanel jPanel = this.mutator.getControlPanel();
        this.add(jPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
    }

    protected JPanel makeAnimationGrid() {
        JPanel jPanel = new JPanel(new GridLayout(3, 3));
        for (int i = 0; i < 9; ++i) {
            jPanel.add(this.ja[i]);
        }
        jPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n;
                Component component = mouseEvent.getComponent();
                for (n = 0; n < 9 && component != SelectionView.this.ja[n]; ++n) {
                }
                if (n == 9) {
                    return;
                }
                try {
                    SelectionView.this.restartView(SelectionView.this.ja[n].getPattern(), null);
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    new ErrorDialog(SelectionView.this.parent, juggleExceptionUser.getMessage());
                }
                catch (JuggleExceptionInternal juggleExceptionInternal) {
                    ErrorDialog.handleFatalException(juggleExceptionInternal);
                }
            }
        });
        jPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n;
                Component component = mouseEvent.getComponent();
                for (n = 0; n < 9 && component != SelectionView.this.ja[n]; ++n) {
                }
                if (n == 9) {
                    return;
                }
                double[] dArray = SelectionView.this.ja[n].getCameraAngle();
                for (int i = 0; i < 9; ++i) {
                    if (i == n) continue;
                    SelectionView.this.ja[i].setCameraAngle(dArray);
                }
            }
        });
        jPanel.setOpaque(true);
        return jPanel;
    }

    protected JPanel makeOverlay() {
        JPanel jPanel = new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                Dimension dimension = this.getSize();
                int n = dimension.width * 1 / 3;
                int n2 = dimension.height * 1 / 3;
                int n3 = dimension.width / 3;
                int n4 = dimension.height / 3;
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setStroke(new BasicStroke(2.0f, 0, 2, 0.0f));
                graphics2D.setColor(Color.lightGray);
                graphics2D.drawRect(n, n2, n3, n4);
                graphics2D.dispose();
            }
        };
        jPanel.setOpaque(false);
        return jPanel;
    }

    protected JLayeredPane makeLayeredPane(Dimension dimension, final JPanel jPanel, final JPanel jPanel2) {
        final JLayeredPane jLayeredPane = new JLayeredPane();
        jLayeredPane.setLayout(null);
        jLayeredPane.add((Component)jPanel, JLayeredPane.DEFAULT_LAYER);
        jLayeredPane.add((Component)jPanel2, JLayeredPane.PALETTE_LAYER);
        jLayeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = jLayeredPane.getSize();
                jPanel.setBounds(0, 0, dimension.width, dimension.height);
                jPanel2.setBounds(0, 0, dimension.width, dimension.height);
            }
        });
        int n = 3 * dimension.width;
        int n2 = 3 * dimension.height;
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = dimension2.width - 300;
        int n4 = dimension2.height - 120;
        if (n > n3 || n2 > n4) {
            double d = Math.min((double)n3 / (double)n, (double)n4 / (double)n2);
            n = (int)(d * (double)n);
            n2 = (int)(d * (double)n2);
        }
        jLayeredPane.setPreferredSize(new Dimension(n, n2));
        jPanel.setBounds(0, 0, n, n2);
        jPanel2.setBounds(0, 0, n, n2);
        return jLayeredPane;
    }

    @Override
    public void restartView(JMLPattern jMLPattern, AnimationPrefs animationPrefs) throws JuggleExceptionUser, JuggleExceptionInternal {
        AnimationPrefs animationPrefs2 = null;
        if (animationPrefs != null) {
            animationPrefs2 = new AnimationPrefs(animationPrefs);
            animationPrefs2.startPause = false;
        }
        this.ja[4].restartJuggle(jMLPattern, animationPrefs2);
        for (int i = 0; i < 9; ++i) {
            if (i == 4) continue;
            JMLPattern jMLPattern2 = jMLPattern == null ? null : this.mutator.mutatePattern(jMLPattern);
            this.ja[i].restartJuggle(jMLPattern2, animationPrefs2);
        }
    }

    @Override
    public void restartView() throws JuggleExceptionUser, JuggleExceptionInternal {
        for (int i = 0; i < 9; ++i) {
            this.ja[i].restartJuggle();
        }
    }

    @Override
    public Dimension getAnimationPanelSize() {
        return this.ja[4].getSize(new Dimension());
    }

    @Override
    public void setAnimationPanelPreferredSize(Dimension dimension) {
        int n = 3 * dimension.width;
        int n2 = 3 * dimension.height;
        this.layered.setPreferredSize(new Dimension(n, n2));
    }

    @Override
    public JMLPattern getPattern() {
        return this.ja[4].getPattern();
    }

    @Override
    public AnimationPrefs getAnimationPrefs() {
        return this.ja[4].getAnimationPrefs();
    }

    @Override
    public boolean getPaused() {
        return this.ja[4].getPaused();
    }

    @Override
    public void setPaused(boolean bl) {
        if (this.ja[4].message == null) {
            for (int i = 0; i < 9; ++i) {
                this.ja[i].setPaused(bl);
            }
        }
    }

    @Override
    public void disposeView() {
        for (int i = 0; i < 9; ++i) {
            this.ja[i].disposeAnimation();
        }
    }

    @Override
    public void writeGIF() {
        boolean bl;
        for (bl = false; bl < 9 != 0; bl += 1) {
            this.ja[bl].writingGIF = true;
        }
        bl = this.getPaused();
        this.setPaused(true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SelectionView.this.setPaused(bl);
                for (int i = 0; i < 9; ++i) {
                    SelectionView.this.ja[i].writingGIF = false;
                }
            }
        };
        new View.GIFWriter(this, this.ja[4], runnable);
    }
}

