/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLPosition;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class Mutator {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    static final double mutationPositionCm = 40.0;
    static final double mutationMinEventDeltaSec = 0.03;
    static final double mutationTimingScale = 0.5;
    static final double mutationNewEventPositionCm = 40.0;
    static final double[] mutation_freq = new double[]{0.4, 0.1, 0.1, 0.2, 0.2};
    static final double[] slider_rates = new double[]{0.2, 0.4, 0.7, 1.0, 1.3, 1.6, 2.0};
    protected double rate;
    protected JPanel controls = this.makeControlPanel();
    protected JCheckBox[] cb;
    protected JSlider slider_rate;

    public JMLPattern mutatePattern(JMLPattern jMLPattern) throws JuggleExceptionInternal {
        double[] dArray = new double[5];
        double d = 0.0;
        for (int i = 0; i < 5; ++i) {
            dArray[i] = d += this.cb[i].isSelected() ? mutation_freq[i] : 0.0;
        }
        if (d == 0.0) {
            return (JMLPattern)jMLPattern.clone();
        }
        this.rate = this.slider_rate == null ? 1.0 : slider_rates[this.slider_rate.getValue()];
        JMLPattern jMLPattern2 = null;
        int n = 0;
        try {
            JMLPattern jMLPattern3;
            double d2;
            do {
                jMLPattern3 = (JMLPattern)jMLPattern.clone();
            } while ((jMLPattern2 = (d2 = d * Math.random()) < dArray[0] ? this.mutateEventPosition(jMLPattern3) : (d2 < dArray[1] ? this.mutateEventTime(jMLPattern3) : (d2 < dArray[2] ? this.mutatePatternTiming(jMLPattern3) : (d2 < dArray[3] ? this.mutateAddEvent(jMLPattern3) : this.mutateRemoveEvent(jMLPattern3))))) == null && ++n < 5);
        }
        catch (JuggleExceptionUser juggleExceptionUser) {
            throw new JuggleExceptionInternal("Mutator: User error: " + juggleExceptionUser.getMessage());
        }
        if (jMLPattern2 == null) {
            return (JMLPattern)jMLPattern.clone();
        }
        return jMLPattern2;
    }

    public JPanel getControlPanel() {
        return this.controls;
    }

    protected JMLPattern mutateEventPosition(JMLPattern jMLPattern) throws JuggleExceptionUser, JuggleExceptionInternal {
        JMLEvent jMLEvent = this.pickMasterEvent(jMLPattern);
        Coordinate coordinate = jMLEvent.getLocalCoordinate();
        coordinate = this.pickNewPosition(jMLEvent.getHand(), this.rate * 40.0, coordinate);
        jMLEvent.setLocalCoordinate(coordinate);
        jMLPattern.setNeedsLayout(true);
        return jMLPattern;
    }

    protected JMLPattern mutateEventTime(JMLPattern jMLPattern) throws JuggleExceptionUser, JuggleExceptionInternal {
        double d;
        JMLEvent jMLEvent;
        JMLEvent jMLEvent2;
        JMLEvent jMLEvent3 = this.pickMasterEvent(jMLPattern);
        for (jMLEvent2 = jMLEvent3.getPrevious(); jMLEvent2 != null && (jMLEvent2.getJuggler() != jMLEvent3.getJuggler() || jMLEvent2.getHand() != jMLEvent3.getHand()); jMLEvent2 = jMLEvent2.getPrevious()) {
        }
        double d2 = jMLEvent2 == null ? jMLPattern.getLoopStartTime() : Math.max(jMLPattern.getLoopStartTime(), jMLEvent2.getT()) + 0.03;
        for (jMLEvent = jMLEvent3.getNext(); jMLEvent != null && (jMLEvent.getJuggler() != jMLEvent3.getJuggler() || jMLEvent.getHand() != jMLEvent3.getHand()); jMLEvent = jMLEvent.getNext()) {
        }
        double d3 = d = jMLEvent == null ? jMLPattern.getLoopEndTime() : Math.min(jMLPattern.getLoopEndTime(), jMLEvent.getT()) - 0.03;
        if (d <= d2) {
            return null;
        }
        double d4 = Math.random();
        double d5 = jMLEvent3.getT();
        double d6 = 0.0;
        d6 = d4 < 0.5 ? d2 + (d5 - d2) * Math.sqrt(2.0 * d4) : d - (d - d5) * Math.sqrt(2.0 * (1.0 - d4));
        jMLEvent3.setT(d6);
        jMLPattern.setNeedsLayout(true);
        return jMLPattern;
    }

    protected JMLPattern mutatePatternTiming(JMLPattern jMLPattern) throws JuggleExceptionUser, JuggleExceptionInternal {
        double d = Math.random();
        double d2 = 1.0 / (1.0 + this.rate * 0.5);
        double d3 = 1.0 + this.rate * 0.5;
        double d4 = 0.0;
        d4 = d < 0.5 ? d2 + (1.0 - d2) * Math.sqrt(2.0 * d) : d3 - (d3 - 1.0) * Math.sqrt(2.0 * (1.0 - d));
        for (JMLEvent jMLEvent = jMLPattern.getEventList(); jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
            if (!jMLEvent.isMaster()) continue;
            jMLEvent.setT(jMLEvent.getT() * d4);
        }
        for (JMLPosition jMLPosition = jMLPattern.getPositionList(); jMLPosition != null; jMLPosition = jMLPosition.getNext()) {
            jMLPosition.setT(jMLPosition.getT() * d4);
        }
        for (int i = 0; i < jMLPattern.getNumberOfSymmetries(); ++i) {
            JMLSymmetry jMLSymmetry = jMLPattern.getSymmetry(i);
            double d5 = jMLSymmetry.getDelay();
            if (!(d5 > 0.0)) continue;
            jMLSymmetry.setDelay(d5 * d4);
        }
        jMLPattern.setNeedsLayout(true);
        return jMLPattern;
    }

    protected JMLPattern mutateAddEvent(JMLPattern jMLPattern) throws JuggleExceptionUser, JuggleExceptionInternal {
        double d;
        int n;
        int n2;
        double d2;
        double d3;
        if (!jMLPattern.isLaidout()) {
            jMLPattern.layoutPattern();
        }
        JMLEvent jMLEvent = null;
        int n3 = 0;
        do {
            n2 = 1 + (int)((double)jMLPattern.getNumberOfJugglers() * Math.random());
            n = Math.random() < 0.5 ? 1 : 2;
            d3 = jMLPattern.getLoopStartTime();
            d2 = jMLPattern.getLoopEndTime();
            d = d3 + (d2 - d3) * Math.random();
            for (jMLEvent = jMLPattern.getEventList(); !(jMLEvent == null || jMLEvent.getJuggler() == n2 && jMLEvent.getHand() == n && jMLEvent.getT() >= d); jMLEvent = jMLEvent.getNext()) {
            }
            if (jMLEvent == null) {
                return null;
            }
            d2 = jMLEvent.getT() - 0.03;
            while (!(jMLEvent == null || jMLEvent.getJuggler() == n2 && jMLEvent.getHand() == n && jMLEvent.getT() <= d)) {
                jMLEvent = jMLEvent.getPrevious();
            }
            if (jMLEvent != null) continue;
            return null;
        } while ((d3 = jMLEvent.getT() + 0.03) > d2 && ++n3 < 5);
        if (n3 == 5) {
            return null;
        }
        for (d = (var12_9 = Math.random()) < 0.5 ? d3 + (d2 - d3) * Math.sqrt(0.5 * var12_9) : d2 - (d2 - d3) * Math.sqrt(0.5 * (1.0 - var12_9)); d < jMLPattern.getLoopStartTime(); d += jMLPattern.getLoopEndTime() - jMLPattern.getLoopStartTime()) {
        }
        while (d > jMLPattern.getLoopEndTime()) {
            d -= jMLPattern.getLoopEndTime() - jMLPattern.getLoopStartTime();
        }
        jMLEvent = new JMLEvent();
        jMLEvent.setHand(n2, n);
        jMLEvent.setT(d);
        jMLEvent.setMaster(null);
        Coordinate coordinate = new Coordinate();
        jMLPattern.getHandCoordinate(n2, n, d, coordinate);
        coordinate = jMLPattern.convertGlobalToLocal(coordinate, n2, d);
        coordinate = this.pickNewPosition(n, this.rate * 40.0, coordinate);
        jMLEvent.setLocalCoordinate(coordinate);
        for (int i = 1; i <= jMLPattern.getNumberOfPaths(); ++i) {
            if (!jMLPattern.isHandHoldingPath(n2, n, d, i)) continue;
            JMLTransition jMLTransition = new JMLTransition(4, i, null, null);
            jMLEvent.addTransition(jMLTransition);
        }
        jMLPattern.addEvent(jMLEvent);
        jMLPattern.setNeedsLayout(true);
        return jMLPattern;
    }

    protected JMLPattern mutateRemoveEvent(JMLPattern jMLPattern) throws JuggleExceptionUser, JuggleExceptionInternal {
        int n;
        int n2;
        boolean bl;
        JMLEvent jMLEvent;
        int n3 = 0;
        for (jMLEvent = jMLPattern.getEventList(); jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
            if (!jMLEvent.isMaster()) continue;
            bl = true;
            for (n2 = 0; n2 < jMLEvent.getNumberOfTransitions(); ++n2) {
                n = jMLEvent.getTransition(n2).getType();
                if (n == 0 || n == 4) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            ++n3;
        }
        if (n3 == 0) {
            return null;
        }
        n3 = (int)((double)n3 * Math.random());
        for (jMLEvent = jMLPattern.getEventList(); jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
            if (!jMLEvent.isMaster()) continue;
            bl = true;
            for (n2 = 0; n2 < jMLEvent.getNumberOfTransitions(); ++n2) {
                n = jMLEvent.getTransition(n2).getType();
                if (n == 0 || n == 4) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            if (n3 == 0) {
                jMLPattern.removeEvent(jMLEvent);
                jMLPattern.setNeedsLayout(true);
                return jMLPattern;
            }
            --n3;
        }
        throw new JuggleExceptionInternal("mutateRemoveEvent error");
    }

    protected JMLEvent pickMasterEvent(JMLPattern jMLPattern) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (!jMLPattern.isLaidout()) {
            jMLPattern.layoutPattern();
        }
        JMLEvent jMLEvent = jMLPattern.getEventList();
        int n = 0;
        JMLEvent jMLEvent2 = jMLEvent;
        do {
            if (!jMLEvent2.isMaster()) continue;
            ++n;
        } while ((jMLEvent2 = jMLEvent2.getNext()) != null);
        int n2 = (int)(Math.random() * (double)n);
        jMLEvent2 = jMLEvent;
        do {
            if (!jMLEvent2.isMaster()) continue;
            if (n2 == 0) {
                return jMLEvent2;
            }
            --n2;
        } while ((jMLEvent2 = jMLEvent2.getNext()) != null);
        throw new JuggleExceptionInternal("Mutator: pickEvent() failed");
    }

    protected Coordinate pickNewPosition(int n, double d, Coordinate coordinate) {
        boolean bl;
        Coordinate coordinate2 = null;
        do {
            coordinate2 = new Coordinate(coordinate);
            coordinate2.x += 2.0 * d * (Math.random() - 0.5);
            coordinate2.z += 2.0 * d * (Math.random() - 0.5);
            if (n == 1) {
                bl = coordinate2.x < -75.0 || coordinate2.x > 40.0 || coordinate2.z < -20.0 || coordinate2.z > 80.0;
                continue;
            }
            boolean bl2 = bl = coordinate2.x < -40.0 || coordinate2.x > 75.0 || coordinate2.z < -20.0 || coordinate2.z > 80.0;
        } while (bl && Math.random() < 0.5);
        return coordinate2;
    }

    protected JPanel makeControlPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JLabel jLabel = new JLabel(guistrings.getString("Mutator_header1"));
        gridBagLayout.setConstraints(jLabel, Mutator.make_constraints(21, 0, 0, new Insets(0, 0, 10, 0)));
        jPanel.add(jLabel);
        this.cb = new JCheckBox[5];
        this.cb[0] = new JCheckBox(guistrings.getString("Mutator_type1"), true);
        gridBagLayout.setConstraints(this.cb[0], Mutator.make_constraints(21, 0, 1, null));
        jPanel.add(this.cb[0]);
        this.cb[1] = new JCheckBox(guistrings.getString("Mutator_type2"), true);
        gridBagLayout.setConstraints(this.cb[1], Mutator.make_constraints(21, 0, 2, null));
        jPanel.add(this.cb[1]);
        this.cb[2] = new JCheckBox(guistrings.getString("Mutator_type3"), true);
        gridBagLayout.setConstraints(this.cb[2], Mutator.make_constraints(21, 0, 3, null));
        jPanel.add(this.cb[2]);
        this.cb[3] = new JCheckBox(guistrings.getString("Mutator_type4"), true);
        gridBagLayout.setConstraints(this.cb[3], Mutator.make_constraints(21, 0, 4, null));
        jPanel.add(this.cb[3]);
        this.cb[4] = new JCheckBox(guistrings.getString("Mutator_type5"), true);
        gridBagLayout.setConstraints(this.cb[4], Mutator.make_constraints(21, 0, 5, null));
        jPanel.add(this.cb[4]);
        jLabel = new JLabel(guistrings.getString("Mutator_header2"));
        gridBagLayout.setConstraints(jLabel, Mutator.make_constraints(21, 0, 6, new Insets(20, 0, 10, 0)));
        jPanel.add(jLabel);
        this.slider_rate = new JSlider(0, 0, 6, 3);
        GridBagConstraints gridBagConstraints = Mutator.make_constraints(21, 0, 7, null);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.slider_rate, gridBagConstraints);
        this.slider_rate.setMajorTickSpacing(1);
        this.slider_rate.setPaintTicks(true);
        this.slider_rate.setSnapToTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel(guistrings.getString("Mutation_rate_low")));
        hashtable.put(new Integer(3), new JLabel(guistrings.getString("Mutation_rate_medium")));
        hashtable.put(new Integer(6), new JLabel(guistrings.getString("Mutation_rate_high")));
        this.slider_rate.setLabelTable(hashtable);
        this.slider_rate.setPaintLabels(true);
        jPanel.add(this.slider_rate);
        return jPanel;
    }

    protected static GridBagConstraints make_constraints(int n, int n2, int n3, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = n;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.insets = insets == null ? new Insets(0, 0, 0, 0) : insets;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        return gridBagConstraints;
    }
}

