/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jugglinglab.core.AnimationPanel;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.view.View;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JMLView
extends View
implements DocumentListener {
    protected AnimationPanel ja;
    protected JSplitPane jsp;
    protected JTextArea ta;
    protected JButton compile;
    protected JButton revert;
    protected JLabel lab;
    protected boolean isdirty = false;

    public JMLView(Dimension dimension) {
        this.setLayout(new BorderLayout());
        this.ja = new AnimationPanel();
        this.ja.setAnimationPanelPreferredSize(dimension);
        this.ta = new JTextArea();
        this.ta.getDocument().addDocumentListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.ta);
        jScrollPane.setPreferredSize(new Dimension(400, 1));
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        this.jsp = new JSplitPane(1, true, this.ja, jScrollPane);
        this.add((Component)this.jsp, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(3));
        this.compile = new JButton(guistrings.getString("JMLView_compile_button"));
        this.compile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JMLView.this.compilePattern();
                }
                catch (Exception exception) {
                    ErrorDialog.handleFatalException(exception);
                }
            }
        });
        jPanel.add(this.compile);
        this.revert = new JButton(guistrings.getString("JMLView_revert_button"));
        this.revert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JMLView.this.revertPattern();
                }
                catch (Exception exception) {
                    ErrorDialog.handleFatalException(exception);
                }
            }
        });
        jPanel.add(this.revert);
        this.lab = new JLabel("");
        jPanel.add(this.lab);
        this.add((Component)jPanel, "Last");
    }

    @Override
    public void restartView(JMLPattern jMLPattern, AnimationPrefs animationPrefs) {
        try {
            this.ja.restartJuggle(jMLPattern, animationPrefs);
            this.updateTextArea();
            this.lab.setText("");
            this.setDirty(false);
            if (jMLPattern != null) {
                this.parent.setTitle(jMLPattern.getTitle());
            }
        }
        catch (JuggleException juggleException) {
            this.lab.setText(juggleException.getMessage());
            this.setDirty(true);
        }
        catch (IOException iOException) {
            this.lab.setText(iOException.getMessage());
            this.setDirty(true);
        }
    }

    @Override
    public void restartView() {
        try {
            this.ja.restartJuggle();
        }
        catch (JuggleException juggleException) {
            this.lab.setText(juggleException.getMessage());
        }
    }

    @Override
    public Dimension getAnimationPanelSize() {
        return this.ja.getSize(new Dimension());
    }

    @Override
    public void setAnimationPanelPreferredSize(Dimension dimension) {
        this.ja.setAnimationPanelPreferredSize(dimension);
        this.jsp.resetToPreferredSizes();
    }

    @Override
    public JMLPattern getPattern() {
        return this.ja.getPattern();
    }

    @Override
    public AnimationPrefs getAnimationPrefs() {
        return this.ja.getAnimationPrefs();
    }

    @Override
    public boolean getPaused() {
        return this.ja.getPaused();
    }

    @Override
    public void setPaused(boolean bl) {
        if (this.ja.message == null) {
            this.ja.setPaused(bl);
        }
    }

    @Override
    public void disposeView() {
        this.ja.disposeAnimation();
    }

    @Override
    public void writeGIF() {
        this.ja.writingGIF = true;
        final boolean bl = this.getPaused();
        this.setPaused(true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JMLView.this.setPaused(bl);
                JMLView.this.ja.writingGIF = false;
            }
        };
        new View.GIFWriter(this, this.ja, runnable);
    }

    protected void compilePattern() {
        if (this.isdirty) {
            try {
                JMLPattern jMLPattern = new JMLPattern(new StringReader(this.ta.getText()));
                this.ja.restartJuggle(jMLPattern, null);
                this.lab.setText("");
                this.parent.setTitle(jMLPattern.getTitle());
                this.updateTextArea();
                this.setDirty(false);
            }
            catch (JuggleExceptionUser juggleExceptionUser) {
                this.lab.setText(juggleExceptionUser.getMessage());
                this.setDirty(true);
            }
            catch (JuggleExceptionInternal juggleExceptionInternal) {
                ErrorDialog.handleFatalException(juggleExceptionInternal);
                this.setDirty(true);
            }
            catch (SAXParseException sAXParseException) {
                String string = errorstrings.getString("Error_parsing");
                Object[] objectArray = new Object[]{new Integer(sAXParseException.getLineNumber())};
                this.lab.setText(MessageFormat.format(string, objectArray));
                this.setDirty(true);
            }
            catch (SAXException sAXException) {
                this.lab.setText(sAXException.getMessage());
                this.setDirty(true);
            }
            catch (IOException iOException) {
                ErrorDialog.handleFatalException(iOException);
                this.setDirty(true);
            }
        }
    }

    protected void revertPattern() {
        if (this.isdirty) {
            try {
                this.updateTextArea();
                this.lab.setText("");
                this.setDirty(false);
            }
            catch (IOException iOException) {
                this.lab.setText(iOException.getMessage());
            }
        }
    }

    protected void updateTextArea() throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.ja.getPattern().writeJML(stringWriter, true);
        stringWriter.close();
        this.ta.setText(stringWriter.toString());
        this.ta.setCaretPosition(0);
    }

    protected void setDirty(boolean bl) {
        this.isdirty = bl;
        this.compile.setEnabled(bl);
        this.revert.setEnabled(bl);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty(true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty(true);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirty(true);
    }
}

