/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import jugglinglab.core.AnimationEditPanel;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.EditLadderDiagram;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.view.View;

public class EditView
extends View {
    protected AnimationEditPanel jae = new AnimationEditPanel();
    protected JPanel ladder;
    protected JSplitPane jsp;
    protected static int ladder_width = 150;
    protected static int ladder_min_width = 80;

    public EditView(Dimension dimension) {
        this.jae.setAnimationPanelPreferredSize(dimension);
        this.ladder = new JPanel();
        this.ladder.setLayout(new BorderLayout());
        this.ladder.setPreferredSize(new Dimension(ladder_width, 1));
        this.ladder.setMinimumSize(new Dimension(ladder_min_width, 1));
        this.ladder.setBackground(Color.white);
        Locale locale = JLLocale.getLocale();
        if (ComponentOrientation.getOrientation(locale) == ComponentOrientation.LEFT_TO_RIGHT) {
            this.jsp = new JSplitPane(1, true, this.jae, this.ladder);
            this.jsp.setResizeWeight(1.0);
        } else {
            this.jsp = new JSplitPane(1, true, this.ladder, this.jae);
            this.jsp.setResizeWeight(0.0);
        }
        this.jsp.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.jsp.setBackground(Color.white);
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jsp, "Center");
    }

    @Override
    public void restartView(JMLPattern jMLPattern, AnimationPrefs animationPrefs) throws JuggleExceptionUser, JuggleExceptionInternal {
        this.jae.restartJuggle(jMLPattern, animationPrefs);
        if (jMLPattern != null) {
            EditLadderDiagram editLadderDiagram = new EditLadderDiagram(jMLPattern, this.parent);
            editLadderDiagram.setAnimationPanel(this.jae);
            this.jae.setLadderDiagram(editLadderDiagram);
            this.jae.deactivateEvent();
            editLadderDiagram.setPreferredSize(new Dimension(ladder_width, 1));
            editLadderDiagram.setMinimumSize(new Dimension(ladder_min_width, 1));
            this.ladder.removeAll();
            this.ladder.add((Component)editLadderDiagram, "Center");
            this.ladder.validate();
        }
    }

    @Override
    public void restartView() throws JuggleExceptionUser, JuggleExceptionInternal {
        this.jae.restartJuggle();
    }

    @Override
    public Dimension getAnimationPanelSize() {
        return this.jae.getSize(new Dimension());
    }

    @Override
    public void setAnimationPanelPreferredSize(Dimension dimension) {
        this.jae.setAnimationPanelPreferredSize(dimension);
        this.jsp.resetToPreferredSizes();
    }

    @Override
    public JMLPattern getPattern() {
        return this.jae.getPattern();
    }

    @Override
    public AnimationPrefs getAnimationPrefs() {
        return this.jae.getAnimationPrefs();
    }

    @Override
    public boolean getPaused() {
        return this.jae.getPaused();
    }

    @Override
    public void setPaused(boolean bl) {
        if (this.jae.message == null) {
            this.jae.setPaused(bl);
        }
    }

    @Override
    public void disposeView() {
        this.jae.disposeAnimation();
    }

    @Override
    public void writeGIF() {
        this.jae.writingGIF = true;
        this.jae.deactivateEvent();
        final boolean bl = this.getPaused();
        this.setPaused(true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EditView.this.setPaused(bl);
                EditView.this.jae.writingGIF = false;
            }
        };
        new View.GIFWriter(this, this.jae, runnable);
    }
}

