/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import jugglinglab.JugglingLab;
import jugglinglab.util.JuggleExceptionUser;

public class ParameterList {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected int size = 0;
    protected ArrayList<String> names;
    protected ArrayList<String> values;

    public ParameterList() {
    }

    public ParameterList(String string) {
        this();
        this.readParameters(string);
    }

    public void addParameter(String string, String string2) {
        if (this.size == 0) {
            this.names = new ArrayList();
            this.values = new ArrayList();
        }
        this.names.add(string);
        this.values.add(string2);
        ++this.size;
    }

    public String getParameter(String string) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!string.equalsIgnoreCase(this.getParameterName(i))) continue;
            return this.getParameterValue(i);
        }
        return null;
    }

    public String removeParameter(String string) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!string.equalsIgnoreCase(this.getParameterName(i))) continue;
            --this.size;
            this.names.remove(i);
            return this.values.remove(i);
        }
        return null;
    }

    public String getParameterName(int n) {
        return this.names.get(n);
    }

    public String getParameterValue(int n) {
        return this.values.get(n);
    }

    public int getNumberOfParameters() {
        return this.size;
    }

    public void readParameters(String string) {
        if (string == null) {
            return;
        }
        string = string.replace("\n", "").replace("\r", "");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n <= 0) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (string3.length() == 0 || string4.length() == 0) continue;
            this.addParameter(string3, string4);
        }
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                string = string + ";";
            }
            string = string + this.getParameterName(i) + "=" + this.getParameterValue(i);
        }
        return string;
    }

    public void errorIfParametersLeft() throws JuggleExceptionUser {
        int n = this.getNumberOfParameters();
        if (n == 0) {
            return;
        }
        if (n == 1) {
            String string = errorstrings.getString("Error_unused_param");
            Object[] objectArray = new Object[]{"\"" + this.getParameterName(0) + "\""};
            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
        }
        String string = errorstrings.getString("Error_unused_params");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add("\"" + this.getParameterName(i) + "\"");
        }
        Object[] objectArray = new Object[]{String.join((CharSequence)", ", arrayList)};
        throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
    }
}

