/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import jugglinglab.JugglingLab;
import jugglinglab.util.JLLocale;

public class ErrorDialog {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;

    public ErrorDialog(final Component component, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(component, string, "Error", 0);
            }
        });
    }

    public static void handleFatalException(Exception exception) {
        String string = errorstrings.getString("Error_internal_part1");
        String string2 = errorstrings.getString("Error_internal_part2");
        String string3 = errorstrings.getString("Error_internal_part3");
        String string4 = errorstrings.getString("Error_internal_part4");
        String string5 = errorstrings.getString("Error_internal_part5");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        stringWriter.write(errorstrings.getString("Error_internal_msg_part1") + "\n\n");
        stringWriter.write(errorstrings.getString("Error_internal_msg_part2") + "\n" + errorstrings.getString("Error_internal_msg_part3") + "\n\n");
        stringWriter.write("Juggling Lab version: 1.4.1\n\n");
        exception.printStackTrace(printWriter);
        stringWriter.write("\n");
        final JFrame jFrame = new JFrame(errorstrings.getString("Error_internal_title"));
        jFrame.setDefaultCloseOperation(0);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("SansSerif", 1, 12));
        jPanel.add(jLabel);
        gridBagLayout.setConstraints(jLabel, ErrorDialog.make_constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        JLabel jLabel2 = new JLabel(string2);
        jLabel2.setFont(new Font("SansSerif", 0, 12));
        jPanel.add(jLabel2);
        gridBagLayout.setConstraints(jLabel2, ErrorDialog.make_constraints(21, 0, 1, new Insets(10, 10, 0, 10)));
        JLabel jLabel3 = new JLabel(string3);
        jLabel3.setFont(new Font("SansSerif", 0, 12));
        jPanel.add(jLabel3);
        gridBagLayout.setConstraints(jLabel3, ErrorDialog.make_constraints(21, 0, 2, new Insets(0, 10, 0, 10)));
        JLabel jLabel4 = new JLabel(string4);
        jLabel4.setFont(new Font("SansSerif", 0, 12));
        jPanel.add(jLabel4);
        gridBagLayout.setConstraints(jLabel4, ErrorDialog.make_constraints(21, 0, 3, new Insets(0, 10, 0, 10)));
        JLabel jLabel5 = new JLabel(string5);
        jLabel5.setFont(new Font("SansSerif", 1, 12));
        jPanel.add(jLabel5);
        gridBagLayout.setConstraints(jLabel5, ErrorDialog.make_constraints(21, 0, 4, new Insets(10, 10, 10, 10)));
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(stringWriter.toString());
        jTextArea.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(450, 300));
        jPanel.add(jScrollPane);
        gridBagLayout.setConstraints(jScrollPane, ErrorDialog.make_constraints(10, 0, 5, new Insets(10, 10, 10, 10)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(3));
        JButton jButton = new JButton(guistrings.getString("Quit"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(guistrings.getString("Continue"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.setVisible(false);
                jFrame.dispose();
            }
        });
        jPanel2.add(jButton2);
        jPanel.add(jPanel2);
        gridBagLayout.setConstraints(jPanel2, ErrorDialog.make_constraints(22, 0, 6, new Insets(10, 10, 10, 10)));
        jFrame.setContentPane(jPanel);
        Locale locale = JLLocale.getLocale();
        jFrame.applyComponentOrientation(ComponentOrientation.getOrientation(locale));
        jFrame.pack();
        jFrame.setResizable(false);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    protected static GridBagConstraints make_constraints(int n, int n2, int n3, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = n;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        return gridBagConstraints;
    }
}

