/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.prop;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jugglinglab.prop.Prop;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;

public class RingProp
extends Prop {
    static String[] colornames = new String[]{"black", "blue", "cyan", "gray", "green", "magenta", "orange", "pink", "red", "white", "yellow"};
    static Color[] colorvals = new Color[]{Color.black, Color.blue, Color.cyan, Color.gray, Color.green, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    protected static final int colornum_def = 8;
    protected static final double outside_diam_def = 25.0;
    protected static final double inside_diam_def = 20.0;
    protected static final int polysides = 200;
    protected double outside_diam = 25.0;
    protected double inside_diam = 20.0;
    protected int colornum = 8;
    protected Color color;
    protected BufferedImage image;
    protected double lastzoom = 0.0;
    protected double[] lastcamangle = new double[]{0.0, 0.0};
    protected Dimension size;
    protected Dimension center;
    protected Dimension grip;
    protected Coordinate propmax;
    protected Coordinate propmin;
    protected int[] px;
    protected int[] py;

    @Override
    public String getType() {
        return "Ring";
    }

    @Override
    public Color getEditorColor() {
        return this.color;
    }

    @Override
    public ParameterDescriptor[] getParameterDescriptors() {
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[3];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < colornames.length; ++i) {
            arrayList.add(colornames[i]);
        }
        parameterDescriptorArray[0] = new ParameterDescriptor("color", 3, arrayList, colornames[8], colornames[this.colornum]);
        parameterDescriptorArray[1] = new ParameterDescriptor("outside", 2, null, new Double(25.0), new Double(this.outside_diam));
        parameterDescriptorArray[2] = new ParameterDescriptor("inside", 2, null, new Double(20.0), new Double(this.inside_diam));
        return parameterDescriptorArray;
    }

    @Override
    protected void init(String string) throws JuggleExceptionUser {
        String string2;
        Object object;
        this.px = new int[200];
        this.py = new int[200];
        this.color = Color.red;
        if (string == null) {
            return;
        }
        ParameterList parameterList = new ParameterList(string);
        String string3 = parameterList.getParameter("color");
        if (string3 != null) {
            object = null;
            if (string3.indexOf(44) == -1) {
                for (int i = 0; i < colornames.length; ++i) {
                    if (!colornames[i].equalsIgnoreCase(string3)) continue;
                    object = colorvals[i];
                    this.colornum = i;
                    break;
                }
            } else {
                int n;
                String string4 = string3;
                while ((n = string4.indexOf(123)) >= 0) {
                    string4 = string4.substring(0, n) + string4.substring(n + 1, string4.length());
                }
                while ((n = string4.indexOf(125)) >= 0) {
                    string4 = string4.substring(0, n) + string4.substring(n + 1, string4.length());
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",", false);
                if (stringTokenizer.hasMoreTokens()) {
                    n2 = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    n3 = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    n4 = Integer.valueOf(stringTokenizer.nextToken());
                }
                object = new Color(n2, n3, n4);
            }
            if (object != null) {
                this.color = object;
            } else {
                String string5 = errorstrings.getString("Error_prop_color");
                Object[] objectArray = new Object[]{string3};
                throw new JuggleExceptionUser(MessageFormat.format(string5, objectArray));
            }
        }
        if ((object = parameterList.getParameter("outside")) != null) {
            try {
                Double d = Double.valueOf((String)object);
                double d2 = d;
                if (!(d2 > 0.0)) {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_prop_diameter"));
                }
                this.outside_diam = d2;
            }
            catch (NumberFormatException numberFormatException) {
                String string6 = errorstrings.getString("Error_number_format");
                Object[] objectArray = new Object[]{"diam"};
                throw new JuggleExceptionUser(MessageFormat.format(string6, objectArray));
            }
        }
        if ((string2 = parameterList.getParameter("inside")) != null) {
            try {
                Double d = Double.valueOf(string2);
                double d3 = d;
                if (!(d3 > 0.0)) {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_prop_diameter"));
                }
                this.inside_diam = d3;
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = errorstrings.getString("Error_number_format");
                Object[] objectArray = new Object[]{"diam"};
                throw new JuggleExceptionUser(MessageFormat.format(string7, objectArray));
            }
        }
    }

    @Override
    public Coordinate getMax() {
        if (this.propmax == null) {
            this.propmax = new Coordinate(this.outside_diam / 2.0, 0.0, this.outside_diam / 2.0);
        }
        return this.propmax;
    }

    @Override
    public Coordinate getMin() {
        if (this.propmin == null) {
            this.propmin = new Coordinate(-this.outside_diam / 2.0, 0.0, -this.outside_diam / 2.0);
        }
        return this.propmin;
    }

    @Override
    public double getWidth() {
        return 0.05 * this.outside_diam;
    }

    @Override
    public Image getProp2DImage(double d, double[] dArray) {
        if (this.image == null || d != this.lastzoom || dArray[0] != this.lastcamangle[0] || dArray[1] != this.lastcamangle[1]) {
            this.redrawImage(d, dArray);
        }
        return this.image;
    }

    @Override
    public Dimension getProp2DSize(double d) {
        if (this.size == null || d != this.lastzoom) {
            this.redrawImage(d, this.lastcamangle);
        }
        return this.size;
    }

    @Override
    public Dimension getProp2DCenter(double d) {
        if (this.center == null || d != this.lastzoom) {
            this.redrawImage(d, this.lastcamangle);
        }
        return this.center;
    }

    @Override
    public Dimension getProp2DGrip(double d) {
        if (this.grip == null || d != this.lastzoom) {
            this.redrawImage(d, this.lastcamangle);
        }
        return this.grip;
    }

    private void redrawImage(double d, double[] dArray) {
        double d2;
        double d3;
        double d4;
        int n;
        double d5;
        double d6;
        int n2;
        int n3;
        int n4;
        double d7;
        int n5 = (int)(0.5 + d * this.outside_diam);
        int n6 = (int)(0.5 + d * this.inside_diam);
        double d8 = Math.cos(dArray[0]);
        double d9 = Math.sin(dArray[0]);
        int n7 = (int)((double)n5 * Math.abs(d9 * (d7 = Math.sin(dArray[1]))));
        if (n7 < 2) {
            n7 = 2;
        }
        if ((n4 = n5) < 2) {
            n4 = 2;
        }
        if ((n3 = (int)((double)n6 * Math.abs(d9 * d7))) == n7) {
            n3 -= 2;
        }
        if ((n2 = n6) == n4) {
            n2 -= 2;
        }
        double d10 = d6 = (d5 = Math.sqrt(d8 * d8 / (1.0 - d9 * d9 * d7 * d7))) < 1.0 ? Math.acos(d5) : 0.0;
        if (d8 * d9 > 0.0) {
            d6 = -d6;
        }
        double d11 = Math.sin(d6);
        double d12 = Math.cos(d6);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (n = 0; n < 200; ++n) {
            double d13 = (double)n * 2.0 * Math.PI / 200.0;
            double d14 = (double)n7 * Math.cos(d13) * 0.5;
            double d15 = (double)n4 * Math.sin(d13) * 0.5;
            this.px[n] = (int)(d12 * d14 - d11 * d15 + 0.5);
            this.py[n] = (int)(d12 * d15 + d11 * d14 + 0.5);
            if (n == 0 || this.px[n] < n8) {
                n8 = this.px[n];
            }
            if (n == 0 || this.px[n] > n9) {
                n9 = this.px[n];
            }
            if (n == 0 || this.py[n] < n10) {
                n10 = this.py[n];
            }
            if (n != 0 && this.py[n] <= n11) continue;
            n11 = this.py[n];
        }
        n = n9 - n8 + 1;
        int n12 = n11 - n10 + 1;
        this.size = new Dimension(n, n12);
        this.image = new BufferedImage(n, n12, 3);
        Graphics2D graphics2D = this.image.createGraphics();
        graphics2D.setColor(this.color);
        int n13 = 0;
        while (n13 < 200) {
            int n14 = n13;
            this.px[n14] = this.px[n14] - n8;
            int n15 = n13++;
            this.py[n15] = this.py[n15] - n10;
        }
        graphics2D.fillPolygon(this.px, this.py, 200);
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        for (n13 = 0; n13 < 200; ++n13) {
            d4 = (double)n13 * 2.0 * Math.PI / 200.0;
            d3 = (double)n3 * Math.cos(d4) * 0.5;
            d2 = (double)n2 * Math.sin(d4) * 0.5;
            this.px[n13] = (int)(d12 * d3 - d11 * d2 + 0.5) - n8;
            this.py[n13] = (int)(d12 * d2 + d11 * d3 + 0.5) - n10;
        }
        graphics2D.fillPolygon(this.px, this.py, 200);
        this.center = new Dimension(n / 2, n12 / 2);
        n13 = d9 < 0.0 ? n - 1 : 0;
        d4 = d11 * d11 + d12 * d12 * Math.abs(d9 * d7);
        d3 = d9 * d9 * d7 * d7 * d12 * d12 + d11 * d11 - d4 * d4;
        double d16 = d2 = d3 > 0.0 ? Math.sqrt(d3) : 0.0;
        if (d8 > 0.0) {
            d2 = -d2;
        }
        int n16 = (int)((double)n5 * d2) + n12 / 2;
        this.grip = new Dimension(n13, n16);
        this.lastzoom = d;
        this.lastcamangle = new double[]{dArray[0], dArray[1]};
    }
}

