/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.prop;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import jugglinglab.JugglingLab;
import jugglinglab.prop.BallProp;
import jugglinglab.prop.ImageProp;
import jugglinglab.prop.RingProp;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;

public abstract class Prop {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected String initString;
    public static final String[] builtinProps = new String[]{"Ball", "Image", "Ring"};

    public static Prop newProp(String string) throws JuggleExceptionUser {
        if (string == null) {
            throw new JuggleExceptionUser("Prop type not specified");
        }
        if (string.equalsIgnoreCase("ball")) {
            return new BallProp();
        }
        if (string.equalsIgnoreCase("image")) {
            return new ImageProp();
        }
        if (string.equalsIgnoreCase("ring")) {
            return new RingProp();
        }
        String string2 = errorstrings.getString("Error_prop_type");
        Object[] objectArray = new Object[]{string};
        throw new JuggleExceptionUser(MessageFormat.format(string2, objectArray));
    }

    public void initProp(String string) throws JuggleExceptionUser {
        this.initString = string;
        this.init(string);
    }

    public abstract String getType();

    public abstract Color getEditorColor();

    public abstract ParameterDescriptor[] getParameterDescriptors();

    protected abstract void init(String var1) throws JuggleExceptionUser;

    public abstract Coordinate getMax();

    public abstract Coordinate getMin();

    public abstract double getWidth();

    public abstract Image getProp2DImage(double var1, double[] var3);

    public abstract Dimension getProp2DSize(double var1);

    public abstract Dimension getProp2DCenter(double var1);

    public abstract Dimension getProp2DGrip(double var1);
}

