/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.prop;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import javax.imageio.ImageIO;
import jugglinglab.prop.Prop;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;

public class ImageProp
extends Prop {
    static URL image_url_default = ImageProp.class.getResource("/ball.png");
    protected URL url;
    protected BufferedImage image;
    protected BufferedImage scaled_image;
    protected final float width_default = 10.0f;
    protected float width;
    protected float height;
    protected Dimension size;
    protected Dimension center;
    protected Dimension grip;
    protected Coordinate propmax;
    protected Coordinate propmin;
    private double last_zoom = 0.0;

    public ImageProp() throws JuggleExceptionUser {
        if (image_url_default == null) {
            throw new JuggleExceptionUser("ImageProp error: Default image not set");
        }
        this.url = image_url_default;
        this.loadImage();
        this.rescaleImage(1.0);
    }

    private void loadImage() throws JuggleExceptionUser {
        try {
            MediaTracker mediaTracker = new MediaTracker(new Component(){});
            this.image = ImageIO.read(this.url);
            mediaTracker.addImage(this.image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (mediaTracker.isErrorAny()) {
                this.image = null;
                throw new JuggleExceptionUser(errorstrings.getString("Error_bad_file"));
            }
            float f = (float)this.image.getHeight() / (float)this.image.getWidth();
            this.width = 10.0f;
            this.height = 10.0f * f;
        }
        catch (IOException iOException) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_bad_file"));
        }
        catch (SecurityException securityException) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_security_restriction"));
        }
    }

    private void rescaleImage(double d) {
        int n;
        int n2 = (int)(0.5 + d * (double)this.width);
        if (n2 < 1) {
            n2 = 1;
        }
        if ((n = (int)(0.5 + d * (double)this.height)) < 1) {
            n = 1;
        }
        this.size = new Dimension(n2, n);
        this.center = new Dimension(n2 / 2, n / 2);
        int n3 = n2 / 2;
        int n4 = n;
        this.grip = new Dimension(n3, n4);
        this.last_zoom = d;
        this.scaled_image = new BufferedImage(n2, n, this.image.getType());
        Graphics2D graphics2D = this.scaled_image.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(this.image, 0, 0, n2, n, 0, 0, this.image.getWidth(), this.image.getHeight(), null);
        graphics2D.dispose();
    }

    @Override
    public String getType() {
        return "Image";
    }

    @Override
    public Color getEditorColor() {
        return Color.white;
    }

    @Override
    public ParameterDescriptor[] getParameterDescriptors() {
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{new ParameterDescriptor("image", 5, null, image_url_default, this.url), new ParameterDescriptor("width", 2, null, new Double(10.0), new Double(this.width))};
        return parameterDescriptorArray;
    }

    @Override
    protected void init(String string) throws JuggleExceptionUser {
        String string2;
        if (string == null) {
            return;
        }
        ParameterList parameterList = new ParameterList(string);
        String string3 = parameterList.getParameter("image");
        if (string3 != null) {
            try {
                this.url = new URL(string3);
                this.loadImage();
            }
            catch (MalformedURLException malformedURLException) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_malformed_URL"));
            }
        }
        if ((string2 = parameterList.getParameter("width")) != null) {
            try {
                Float f = Float.valueOf(string2);
                float f2 = f.floatValue();
                if (!(f2 > 0.0f)) {
                    throw new NumberFormatException();
                }
                this.width = f2;
                float f3 = (float)this.image.getHeight(null) / (float)this.image.getWidth(null);
                this.height = this.width * f3;
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = errorstrings.getString("Error_number_format");
                Object[] objectArray = new Object[]{"width"};
                throw new JuggleExceptionUser(MessageFormat.format(string4, objectArray));
            }
        }
    }

    @Override
    public Image getProp2DImage(double d, double[] dArray) {
        if (d != this.last_zoom) {
            this.rescaleImage(d);
        }
        return this.scaled_image;
    }

    @Override
    public Coordinate getMax() {
        if (this.propmax == null) {
            this.propmax = new Coordinate((double)this.width / 2.0, 0.0, this.width);
        }
        return this.propmax;
    }

    @Override
    public Coordinate getMin() {
        if (this.propmin == null) {
            this.propmin = new Coordinate((double)(-this.width) / 2.0, 0.0, 0.0);
        }
        return this.propmin;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public Dimension getProp2DSize(double d) {
        if (this.size == null || d != this.last_zoom) {
            this.rescaleImage(d);
        }
        return this.size;
    }

    @Override
    public Dimension getProp2DCenter(double d) {
        if (this.center == null || d != this.last_zoom) {
            this.rescaleImage(d);
        }
        return this.center;
    }

    @Override
    public Dimension getProp2DGrip(double d) {
        if (this.grip == null || d != this.last_zoom) {
            this.rescaleImage(d);
        }
        return this.grip;
    }
}

