/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.path;

import java.text.MessageFormat;
import jugglinglab.path.Path;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;

public class TossPath
extends Path {
    protected static final double g_def = 980.0;
    protected double bx;
    protected double cx;
    protected double by;
    protected double cy;
    protected double az;
    protected double bz;
    protected double cz;
    protected double g = 980.0;

    @Override
    public String getType() {
        return "Toss";
    }

    @Override
    public ParameterDescriptor[] getParameterDescriptors() {
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{new ParameterDescriptor("g", 2, null, new Double(980.0), new Double(this.g))};
        return parameterDescriptorArray;
    }

    @Override
    public void initPath(String string) throws JuggleExceptionUser {
        double d = 980.0;
        ParameterList parameterList = new ParameterList(string);
        for (int i = 0; i < parameterList.getNumberOfParameters(); ++i) {
            String string2 = parameterList.getParameterName(i);
            String string3 = parameterList.getParameterValue(i);
            if (string2.equalsIgnoreCase("g")) {
                try {
                    d = Double.valueOf(string3);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String string4 = errorstrings.getString("Error_number_format");
                    Object[] objectArray = new Object[]{"g"};
                    throw new JuggleExceptionUser(MessageFormat.format(string4, objectArray));
                }
            }
            throw new JuggleExceptionUser(errorstrings.getString("Error_path_badmod") + ": '" + string2 + "'");
        }
        this.g = d;
        this.az = -0.5 * d;
    }

    @Override
    public void calcPath() throws JuggleExceptionInternal {
        if (this.start_coord == null || this.end_coord == null) {
            throw new JuggleExceptionInternal("Error in parabolic path: endpoints not set");
        }
        double d = this.getDuration();
        this.cx = this.start_coord.x;
        this.bx = (this.end_coord.x - this.start_coord.x) / d;
        this.cy = this.start_coord.y;
        this.by = (this.end_coord.y - this.start_coord.y) / d;
        this.cz = this.start_coord.z;
        this.bz = (this.end_coord.z - this.start_coord.z) / d - this.az * d;
    }

    @Override
    public Coordinate getStartVelocity() {
        return new Coordinate(this.bx, this.by, this.bz);
    }

    @Override
    public Coordinate getEndVelocity() {
        return new Coordinate(this.bx, this.by, this.bz + 2.0 * this.az * this.getDuration());
    }

    @Override
    public void getCoordinate(double d, Coordinate coordinate) {
        if (d < this.start_time || d > this.end_time) {
            return;
        }
        coordinate.setCoordinate(this.cx + this.bx * (d -= this.start_time), this.cy + this.by * d, this.cz + d * (this.bz + this.az * d));
    }

    @Override
    protected Coordinate getMax2(double d, double d2) {
        double d3;
        Coordinate coordinate = null;
        double d4 = Math.max(this.start_time, d);
        double d5 = Math.min(this.end_time, d2);
        coordinate = this.check(coordinate, d4, true);
        coordinate = this.check(coordinate, d5, true);
        if (this.az < 0.0 && d4 < (d3 = -this.bz / (2.0 * this.az) + this.start_time) && d3 < d5) {
            coordinate = this.check(coordinate, d3, true);
        }
        return coordinate;
    }

    @Override
    protected Coordinate getMin2(double d, double d2) {
        double d3;
        Coordinate coordinate = null;
        double d4 = Math.max(this.start_time, d);
        double d5 = Math.min(this.end_time, d2);
        coordinate = this.check(coordinate, d4, false);
        coordinate = this.check(coordinate, d5, false);
        if (this.az > 0.0 && d4 < (d3 = -this.by / (2.0 * this.az) + this.start_time) && d3 < d5) {
            coordinate = this.check(coordinate, d3, false);
        }
        return coordinate;
    }
}

