/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.path;

import java.util.ResourceBundle;
import jugglinglab.JugglingLab;
import jugglinglab.path.BouncePath;
import jugglinglab.path.TossPath;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;

public abstract class Path {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected double start_time;
    protected double end_time;
    protected Coordinate start_coord;
    protected Coordinate end_coord;
    public static final String[] builtinPaths = new String[]{"Toss", "Bounce"};

    public static Path newPath(String string) throws JuggleExceptionUser {
        if (string == null) {
            throw new JuggleExceptionUser("Path type not specified");
        }
        if (string.equalsIgnoreCase("toss")) {
            return new TossPath();
        }
        if (string.equalsIgnoreCase("bounce")) {
            return new BouncePath();
        }
        throw new JuggleExceptionUser("Path type '" + string + "' not recognized");
    }

    public void setStart(Coordinate coordinate, double d) {
        this.start_coord = coordinate;
        this.start_time = d;
    }

    public void setEnd(Coordinate coordinate, double d) {
        this.end_coord = coordinate;
        this.end_time = d;
    }

    public double getStartTime() {
        return this.start_time;
    }

    public double getEndTime() {
        return this.end_time;
    }

    public double getDuration() {
        return this.end_time - this.start_time;
    }

    public void translateTime(double d) {
        this.start_time += d;
        this.end_time += d;
    }

    public Coordinate getMax() {
        return this.getMax2(this.start_time, this.end_time);
    }

    public Coordinate getMin() {
        return this.getMin2(this.start_time, this.end_time);
    }

    public Coordinate getMax(double d, double d2) {
        if (d2 < this.start_time || d > this.end_time) {
            return null;
        }
        return this.getMax2(d, d2);
    }

    public Coordinate getMin(double d, double d2) {
        if (d2 < this.start_time || d > this.end_time) {
            return null;
        }
        return this.getMin2(d, d2);
    }

    protected Coordinate check(Coordinate coordinate, double d, boolean bl) {
        Coordinate coordinate2 = new Coordinate(0.0, 0.0, 0.0);
        this.getCoordinate(d, coordinate2);
        coordinate = bl ? Coordinate.max(coordinate, coordinate2) : Coordinate.min(coordinate, coordinate2);
        return coordinate;
    }

    public abstract String getType();

    public abstract ParameterDescriptor[] getParameterDescriptors();

    public abstract void initPath(String var1) throws JuggleExceptionUser;

    public abstract void calcPath() throws JuggleExceptionInternal;

    public abstract Coordinate getStartVelocity();

    public abstract Coordinate getEndVelocity();

    public abstract void getCoordinate(double var1, Coordinate var3);

    protected abstract Coordinate getMax2(double var1, double var3);

    protected abstract Coordinate getMin2(double var1, double var3);
}

