/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.path;

import java.text.MessageFormat;
import jugglinglab.path.Path;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;

public class BouncePath
extends Path {
    protected static final int bounces_def = 1;
    protected static final boolean forced_def = false;
    protected static final boolean hyper_def = false;
    protected static final double bounceplane_def = 0.0;
    protected static final double bouncefrac_def = 0.9;
    protected static final double g_def = 980.0;
    protected double bx;
    protected double cx;
    protected double by;
    protected double cy;
    protected double[] az;
    protected double[] bz;
    protected double[] cz;
    protected double[] endtime;
    protected int bounces = 1;
    protected boolean forced = false;
    protected boolean hyper = false;
    protected double bounceplane = 0.0;
    protected double bouncefrac = 0.9;
    protected double g = 980.0;
    protected double bouncefracsqrt;
    protected double bouncetime;
    protected int numbounces;

    @Override
    public String getType() {
        return "Bounce";
    }

    @Override
    public ParameterDescriptor[] getParameterDescriptors() {
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{new ParameterDescriptor("bounces", 4, null, new Integer(1), new Integer(this.bounces)), new ParameterDescriptor("forced", 1, null, new Boolean(false), new Boolean(this.forced)), new ParameterDescriptor("hyper", 1, null, new Boolean(false), new Boolean(this.hyper)), new ParameterDescriptor("bounceplane", 2, null, new Double(0.0), new Double(this.bounceplane)), new ParameterDescriptor("bouncefrac", 2, null, new Double(0.9), new Double(this.bouncefrac)), new ParameterDescriptor("g", 2, null, new Double(980.0), new Double(this.g))};
        return parameterDescriptorArray;
    }

    @Override
    public void initPath(String string) throws JuggleExceptionUser {
        int n = 1;
        boolean bl = false;
        boolean bl2 = false;
        double d = 0.0;
        double d2 = 0.9;
        double d3 = 980.0;
        ParameterList parameterList = new ParameterList(string);
        for (int i = 0; i < parameterList.getNumberOfParameters(); ++i) {
            String string2 = parameterList.getParameterName(i);
            String string3 = parameterList.getParameterValue(i);
            if (string2.equalsIgnoreCase("bounces")) {
                try {
                    n = Integer.valueOf(string3);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String string4 = errorstrings.getString("Error_number_format");
                    Object[] objectArray = new Object[]{"bounces"};
                    throw new JuggleExceptionUser(MessageFormat.format(string4, objectArray));
                }
            }
            if (string2.equalsIgnoreCase("forced")) {
                bl = Boolean.valueOf(string3);
                continue;
            }
            if (string2.equalsIgnoreCase("hyper")) {
                bl2 = Boolean.valueOf(string3);
                continue;
            }
            if (string2.equalsIgnoreCase("bounceplane")) {
                try {
                    d = Double.valueOf(string3);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = errorstrings.getString("Error_number_format");
                    Object[] objectArray = new Object[]{"bounceplane"};
                    throw new JuggleExceptionUser(MessageFormat.format(string5, objectArray));
                }
            }
            if (string2.equalsIgnoreCase("bouncefrac")) {
                try {
                    d2 = Double.valueOf(string3);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String string6 = errorstrings.getString("Error_number_format");
                    Object[] objectArray = new Object[]{"bouncefrac"};
                    throw new JuggleExceptionUser(MessageFormat.format(string6, objectArray));
                }
            }
            if (string2.equalsIgnoreCase("g")) {
                try {
                    d3 = Double.valueOf(string3);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String string7 = errorstrings.getString("Error_number_format");
                    Object[] objectArray = new Object[]{"g"};
                    throw new JuggleExceptionUser(MessageFormat.format(string7, objectArray));
                }
            }
            throw new JuggleExceptionUser(errorstrings.getString("Error_path_badmod") + ": '" + string2 + "'");
        }
        this.bounces = n;
        this.forced = bl;
        this.hyper = bl2;
        this.bounceplane = d;
        this.bouncefrac = d2;
        try {
            this.bouncefracsqrt = Math.sqrt(d2);
        }
        catch (ArithmeticException arithmeticException) {
            this.bouncefracsqrt = 1.0;
        }
        this.g = d3;
        this.az = new double[n + 1];
        this.bz = new double[n + 1];
        this.cz = new double[n + 1];
        this.endtime = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            this.az[i] = -0.5 * d3;
        }
    }

    @Override
    public void calcPath() throws JuggleExceptionInternal {
        if (this.start_coord == null || this.end_coord == null) {
            return;
        }
        double d = this.getDuration();
        this.cx = this.start_coord.x;
        this.bx = (this.end_coord.x - this.start_coord.x) / d;
        this.cy = this.start_coord.y;
        this.by = (this.end_coord.y - this.start_coord.y) / d;
        this.cz[0] = this.start_coord.z;
        double[] dArray = new double[4];
        boolean[] blArray = new boolean[4];
        this.numbounces = this.bounces;
        while (this.numbounces > 0) {
            double d2;
            int n;
            int n2 = 0;
            double d3 = this.bouncefracsqrt;
            for (int i = 1; i < this.numbounces; ++i) {
                d3 *= this.bouncefracsqrt;
            }
            double d4 = this.bouncefracsqrt == 1.0 ? 2.0 * (double)this.numbounces : 1.0 + d3 + 2.0 * this.bouncefracsqrt * (1.0 - d3 / this.bouncefracsqrt) / (1.0 - this.bouncefracsqrt);
            double d5 = 2.0 * this.g * (this.start_coord.z - this.bounceplane);
            double d6 = 2.0 * this.g * (this.end_coord.z - this.bounceplane);
            double d7 = d3 * d3;
            double d8 = d5 - d6 / d7;
            double d9 = d4 * d4;
            double d10 = this.g * d;
            double[] dArray2 = new double[5];
            dArray2[4] = 1.0 + d9 * d9 + d7 * d7 - 2.0 * d9 - 2.0 * d7 - 2.0 * d9 * d7;
            dArray2[3] = -4.0 * d10 + 4.0 * d7 * d10 + 4.0 * d9 * d10;
            dArray2[2] = 6.0 * d10 * d10 + 2.0 * d9 * d9 * d5 + 2.0 * d7 * d7 * d8 - 2.0 * d7 * d8 - 2.0 * d7 * d10 * d10 - 2.0 * d9 * d10 * d10 - 2.0 * d9 * d5 - 2.0 * d9 * d7 * d8 - 2.0 * d9 * d7 * d5;
            dArray2[1] = -4.0 * d10 * d10 * d10 + 4.0 * d7 * d10 * d8 + 4.0 * d9 * d10 * d5;
            dArray2[0] = d10 * d10 * d10 * d10 + d9 * d9 * d5 * d5 + d7 * d7 * d8 * d8 - 2.0 * d10 * d10 * d7 * d8 - 2.0 * d9 * d10 * d10 * d5 - 2.0 * d9 * d7 * d5 * d8;
            double[] dArray3 = new double[4];
            int n3 = 0;
            if (this.numbounces > 1) {
                n = 0;
                while (n < 4) {
                    int n4 = n++;
                    dArray2[n4] = dArray2[n4] / dArray2[4];
                }
                n3 = BouncePath.findRealRootsPolynomial(dArray2, 4, dArray3);
            } else {
                n = 0;
                while (n < 3) {
                    int n5 = n++;
                    dArray2[n5] = dArray2[n5] / dArray2[3];
                }
                n3 = BouncePath.findRealRootsPolynomial(dArray2, 3, dArray3);
            }
            for (n = 0; n < n3; ++n) {
                d2 = dArray3[n];
                if (!(d2 * d2 + d8 >= 0.0)) continue;
                dArray[n2] = d2;
                blArray[n2] = d10 - d2 - d4 * Math.sqrt(d2 * d2 + d5) > 0.0;
                ++n2;
            }
            if (n2 != 0) {
                int n6;
                n = 0;
                d2 = dArray[0];
                for (n6 = 0; n6 < n2; ++n6) {
                    if (this.forced && dArray[n6] > 0.0 || !this.forced && dArray[n6] < 0.0 || this.hyper && !(blArray[n6] ^ this.forced) || !this.hyper && blArray[n6] ^ this.forced) continue;
                    d2 = dArray[n6];
                    n = 1;
                    break;
                }
                if (n == 0) {
                    for (n6 = 0; n6 < n2; ++n6) {
                        if (this.forced && dArray[n6] > 0.0 || !this.forced && dArray[n6] < 0.0) continue;
                        d2 = dArray[n6];
                        n = 1;
                        break;
                    }
                }
                if (n == 0) {
                    for (n6 = 0; n6 < n2; ++n6) {
                        if (this.hyper && !(blArray[n6] ^ dArray[n6] < 0.0) || !this.hyper && blArray[n6] ^ dArray[n6] < 0.0) continue;
                        d2 = dArray[n6];
                        n = 1;
                        break;
                    }
                }
                this.bz[0] = d2;
                this.endtime[0] = this.az[0] < 0.0 ? (-d2 - Math.sqrt(d2 * d2 - 4.0 * this.az[0] * (this.cz[0] - this.bounceplane))) / (2.0 * this.az[0]) : (-d2 + Math.sqrt(d2 * d2 - 4.0 * this.az[0] * (this.cz[0] - this.bounceplane))) / (2.0 * this.az[0]);
                double d11 = (-d2 - 2.0 * this.az[0] * this.endtime[0]) * this.bouncefracsqrt;
                for (int i = 1; i <= this.numbounces; ++i) {
                    this.bz[i] = d11 - 2.0 * this.az[i] * this.endtime[i - 1];
                    this.cz[i] = this.bounceplane - this.az[i] * this.endtime[i - 1] * this.endtime[i - 1] - this.bz[i] * this.endtime[i - 1];
                    this.endtime[i] = this.endtime[i - 1] - d11 / this.az[i];
                    d11 = this.bouncefracsqrt * d11;
                }
                this.endtime[this.numbounces] = this.getDuration();
                return;
            }
            --this.numbounces;
        }
        throw new JuggleExceptionInternal("No root found in bouncePath");
    }

    @Override
    public Coordinate getStartVelocity() {
        return new Coordinate(this.bx, this.by, this.bz[0]);
    }

    @Override
    public Coordinate getEndVelocity() {
        return new Coordinate(this.bx, this.by, this.bz[this.numbounces] + 2.0 * this.az[this.numbounces] * (this.end_time - this.start_time));
    }

    @Override
    public void getCoordinate(double d, Coordinate coordinate) {
        if (d < this.start_time || d > this.end_time) {
            return;
        }
        d -= this.start_time;
        double d2 = 0.0;
        for (int i = 0; i <= this.numbounces; ++i) {
            if (!(d < this.endtime[i]) && i != this.numbounces) continue;
            d2 = this.cz[i] + d * (this.bz[i] + this.az[i] * d);
            break;
        }
        coordinate.setCoordinate(this.cx + this.bx * d, this.cy + this.by * d, d2);
    }

    @Override
    protected Coordinate getMax2(double d, double d2) {
        double d3;
        Coordinate coordinate = null;
        double d4 = Math.max(this.start_time, d);
        double d5 = Math.min(this.end_time, d2);
        coordinate = this.check(coordinate, d4, true);
        coordinate = this.check(coordinate, d5, true);
        if (this.az[0] < 0.0 && d4 < (d3 = -this.bz[0] / (2.0 * this.az[0]) + this.start_time) && d3 < Math.min(d5, this.start_time + this.endtime[0])) {
            coordinate = this.check(coordinate, d3, true);
        }
        if (this.az[this.numbounces] < 0.0) {
            d3 = -this.bz[this.numbounces] / (2.0 * this.az[this.numbounces]) + this.start_time;
            if (Math.max(d4, this.start_time + this.endtime[this.numbounces - 1]) < d3 && d3 < d5) {
                coordinate = this.check(coordinate, d3, true);
            }
        }
        if (d4 < this.start_time + this.endtime[0] && this.start_time + this.endtime[0] < d5) {
            coordinate = this.check(coordinate, this.start_time + this.endtime[0], true);
        }
        for (int i = 1; i < this.numbounces; ++i) {
            if (this.az[i] < 0.0) {
                double d6 = -this.bz[i] / (2.0 * this.az[i]) + this.start_time;
                if (Math.max(d4, this.start_time + this.endtime[i - 1]) < d6 && d6 < Math.min(d5, this.start_time + this.endtime[i])) {
                    coordinate = this.check(coordinate, d6, true);
                }
            }
            if (!(d4 < this.start_time + this.endtime[i]) || !(this.start_time + this.endtime[i] < d5)) continue;
            coordinate = this.check(coordinate, this.start_time + this.endtime[i], true);
        }
        return coordinate;
    }

    @Override
    protected Coordinate getMin2(double d, double d2) {
        double d3;
        Coordinate coordinate = null;
        double d4 = Math.max(this.start_time, d);
        double d5 = Math.min(this.end_time, d2);
        coordinate = this.check(coordinate, d4, false);
        coordinate = this.check(coordinate, d5, false);
        if (this.az[0] > 0.0 && d4 < (d3 = -this.bz[0] / (2.0 * this.az[0]) + this.start_time) && d3 < Math.min(d5, this.start_time + this.endtime[0])) {
            coordinate = this.check(coordinate, d3, false);
        }
        if (this.az[this.numbounces] > 0.0) {
            d3 = -this.bz[this.numbounces] / (2.0 * this.az[this.numbounces]) + this.start_time;
            if (Math.max(d4, this.start_time + this.endtime[this.numbounces - 1]) < d3 && d3 < d5) {
                coordinate = this.check(coordinate, d3, false);
            }
        }
        if (d4 < this.start_time + this.endtime[0] && this.start_time + this.endtime[0] < d5) {
            coordinate = this.check(coordinate, this.start_time + this.endtime[0], false);
        }
        for (int i = 1; i < this.numbounces; ++i) {
            if (this.az[i] > 0.0) {
                double d6 = -this.bz[i] / (2.0 * this.az[i]) + this.start_time;
                if (Math.max(d4, this.start_time + this.endtime[i - 1]) < d6 && d6 < Math.min(d5, this.start_time + this.endtime[i])) {
                    coordinate = this.check(coordinate, d6, false);
                }
            }
            if (!(d4 < this.start_time + this.endtime[i]) || !(this.start_time + this.endtime[i] < d5)) continue;
            coordinate = this.check(coordinate, this.start_time + this.endtime[i], false);
        }
        return coordinate;
    }

    protected static double evalPolynomial(double[] dArray, int n, double d) {
        double d2 = dArray[0];
        double d3 = d;
        for (int i = 1; i < n; ++i) {
            d2 += dArray[i] * d3;
            d3 *= d;
        }
        return d2 + d3;
    }

    protected static double bracketOpenInterval(double[] dArray, int n, double d, boolean bl) {
        boolean bl2 = BouncePath.evalPolynomial(dArray, n, d) > 0.0;
        double d2 = d;
        double d3 = bl ? 1.0 : -1.0;
        while (BouncePath.evalPolynomial(dArray, n, d2 += (d3 *= 2.0)) > 0.0 == bl2) {
        }
        return d2;
    }

    protected static double findRoot(double[] dArray, int n, double d, double d2) {
        double d3;
        double d4 = BouncePath.evalPolynomial(dArray, n, d);
        if (d4 * (d3 = BouncePath.evalPolynomial(dArray, n, d2)) > 0.0) {
            return 0.5 * (d + d2);
        }
        while (Math.abs(d - d2) > 1.0E-6) {
            double d5 = 0.5 * (d + d2);
            double d6 = BouncePath.evalPolynomial(dArray, n, d5);
            if (d6 * d4 > 0.0) {
                d = d5;
                d4 = d6;
                continue;
            }
            d2 = d5;
            d3 = d6;
        }
        return d;
    }

    protected static int findRealRootsPolynomial(double[] dArray, int n, double[] dArray2) {
        int n2;
        int n3;
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            dArray2[0] = -dArray[0];
            return 1;
        }
        if (n == 2) {
            double d = dArray[1] * dArray[1] - 4.0 * dArray[0];
            if (d < 0.0) {
                return 0;
            }
            if (d == 0.0) {
                dArray2[0] = -0.5 * dArray[1];
                return 1;
            }
            double d2 = Math.sqrt(d);
            dArray2[0] = -0.5 * (dArray[1] + d2);
            dArray2[1] = -0.5 * (dArray[1] - d2);
            return 2;
        }
        if (n == 3) {
            double d = dArray[2] * dArray[2] * dArray[2] / 27.0 - dArray[1] * dArray[2] / 6.0 + dArray[0] / 2.0;
            double d3 = dArray[2] * dArray[2] / 9.0 - dArray[1] / 3.0;
            double d4 = d * d - d3 * d3 * d3;
            if (d4 > 0.0) {
                double d5 = Math.pow(Math.sqrt(d4) + Math.abs(d), 0.3333333333333333);
                dArray2[0] = (d > 0.0 ? -(d5 + d3 / d5) : d5 + d3 / d5) - dArray[2] / 3.0;
                return 1;
            }
            double d6 = Math.acos(d / Math.sqrt(d3 * d3 * d3)) / 3.0;
            double d7 = -2.0 * Math.sqrt(d3);
            double d8 = 2.0943951023931953;
            dArray2[0] = d7 * Math.cos(d6) - dArray[2] / 3.0;
            dArray2[1] = d7 * Math.cos(d6 + d8) - dArray[2] / 3.0;
            dArray2[2] = d7 * Math.cos(d6 + 2.0 * d8) - dArray[2] / 3.0;
            return 3;
        }
        double[] dArray3 = new double[n - 1];
        double[] dArray4 = new double[n - 1];
        for (n3 = 0; n3 < n - 1; ++n3) {
            dArray3[n3] = (double)(n3 + 1) * dArray[n3 + 1] / (double)n;
        }
        n3 = BouncePath.findRealRootsPolynomial(dArray3, n - 1, dArray4);
        boolean bl = true;
        boolean bl2 = n % 2 == 0;
        int n4 = 0;
        if (n3 == 0) {
            double d;
            boolean bl3;
            boolean bl4 = bl3 = dArray[0] > 0.0;
            if (bl3 != bl) {
                d = BouncePath.bracketOpenInterval(dArray, n, 0.0, true);
                dArray2[n4++] = BouncePath.findRoot(dArray, n, 0.0, d);
            }
            if (bl3 != bl2) {
                d = BouncePath.bracketOpenInterval(dArray, n, 0.0, false);
                dArray2[n4++] = BouncePath.findRoot(dArray, n, d, 0.0);
            }
            return n4;
        }
        for (int i = 0; i < n3; ++i) {
            for (n2 = i; n2 < n3; ++n2) {
                if (!(dArray4[i] > dArray4[n2])) continue;
                double d = dArray4[i];
                dArray4[i] = dArray4[n2];
                dArray4[n2] = d;
            }
        }
        boolean[] blArray = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            blArray[n2] = BouncePath.evalPolynomial(dArray, n, dArray4[n2]) > 0.0;
        }
        if (bl2 != blArray[0]) {
            double d = BouncePath.bracketOpenInterval(dArray, n, dArray4[0], false);
            dArray2[n4++] = BouncePath.findRoot(dArray, n, d, dArray4[0]);
        }
        for (int i = 0; i < n3 - 1; ++i) {
            if (blArray[i] == blArray[i + 1]) continue;
            dArray2[n4++] = BouncePath.findRoot(dArray, n, dArray4[i], dArray4[i + 1]);
        }
        if (bl != blArray[n3 - 1]) {
            double d = BouncePath.bracketOpenInterval(dArray, n, dArray4[n3 - 1], true);
            dArray2[n4++] = BouncePath.findRoot(dArray, n, dArray4[n3 - 1], d);
        }
        return n4;
    }

    public double getBounceVolume(double d, double d2) {
        if (d2 < this.start_time || d > this.end_time) {
            return 0.0;
        }
        d -= this.start_time;
        d2 -= this.start_time;
        for (int i = 0; i < this.numbounces; ++i) {
            if (!(d < this.endtime[i])) continue;
            if (d2 > this.endtime[i]) {
                return 1.0;
            }
            return 0.0;
        }
        return 0.0;
    }
}

