/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.optimizer;

import com.google.ortools.linearsolver.MPConstraint;
import com.google.ortools.linearsolver.MPObjective;
import com.google.ortools.linearsolver.MPSolver;
import com.google.ortools.linearsolver.MPVariable;
import java.util.ResourceBundle;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.optimizer.MarginEquations;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class Optimizer {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected static final double epsilon = 1.0E-7;
    protected static final double infinity = Double.POSITIVE_INFINITY;
    protected static boolean optimizer_loaded = false;
    protected JMLPattern pat;
    protected MarginEquations me;
    protected boolean[] pinned;

    public static boolean optimizerAvailable() {
        return optimizer_loaded;
    }

    public static JMLPattern optimize(JMLPattern jMLPattern) throws JuggleExceptionInternal, JuggleExceptionUser {
        if (!Optimizer.optimizerAvailable()) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_optimizer_unavailable"));
        }
        Optimizer optimizer = new Optimizer(jMLPattern);
        if (optimizer.me.marginsNum > 0) {
            boolean bl = optimizer.doOptimizationMILP();
            if (bl) {
                optimizer.updatePattern();
            } else {
                throw new JuggleExceptionUser(errorstrings.getString("Error_optimizer_failed"));
            }
        }
        return jMLPattern;
    }

    protected Optimizer(JMLPattern jMLPattern) throws JuggleExceptionInternal, JuggleExceptionUser {
        this.pat = jMLPattern;
        this.me = new MarginEquations(jMLPattern);
        if (this.me.marginsNum == 0) {
            return;
        }
        this.pinned = new boolean[this.me.varsNum];
    }

    protected boolean runMILP() {
        MPSolver mPSolver = new MPSolver("JugglingLab", MPSolver.OptimizationProblemType.CBC_MIXED_INTEGER_PROGRAMMING);
        MPVariable[] mPVariableArray = new MPVariable[this.me.varsNum];
        for (int i = 0; i < this.me.varsNum; ++i) {
            if (this.pinned[i]) continue;
            mPVariableArray[i] = mPSolver.makeNumVar(this.me.varsMin[i], this.me.varsMax[i], "x" + i);
        }
        MPVariable[] mPVariableArray2 = new MPVariable[this.me.marginsNum];
        for (int i = 0; i < this.me.marginsNum; ++i) {
            if (this.me.marginsEqs[i].done()) continue;
            mPVariableArray2[i] = mPSolver.makeBoolVar("z" + i);
        }
        MPVariable mPVariable = mPSolver.makeNumVar(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, "err");
        MPConstraint[] mPConstraintArray = new MPConstraint[this.me.marginsNum * 2];
        for (int i = 0; i < this.me.marginsNum; ++i) {
            double d;
            int n;
            if (this.me.marginsEqs[i].done()) continue;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int j = 0; j < this.me.varsNum; ++j) {
                double d4 = this.me.marginsEqs[i].coef(j);
                if (d4 > 0.0) {
                    d2 += d4 * this.me.varsMax[j];
                    d3 += d4 * this.me.varsMin[j];
                    continue;
                }
                d2 += d4 * this.me.varsMin[j];
                d3 += d4 * this.me.varsMax[j];
            }
            double d5 = 2.0 * Math.max(Math.abs(d2), Math.abs(d3)) + 1.0;
            double d6 = this.me.marginsEqs[i].constant();
            for (n = 0; n < this.me.varsNum; ++n) {
                if (!this.pinned[n]) continue;
                d6 += this.me.marginsEqs[i].coef(n) * this.me.varsValues[n];
            }
            mPConstraintArray[2 * i] = mPSolver.makeConstraint(Double.NEGATIVE_INFINITY, d6, "c" + i + "a");
            mPConstraintArray[2 * i].setCoefficient(mPVariable, 1.0);
            mPConstraintArray[2 * i].setCoefficient(mPVariableArray2[i], -d5);
            for (n = 0; n < this.me.varsNum; ++n) {
                if (this.pinned[n] || (d = this.me.marginsEqs[i].coef(n)) == 0.0) continue;
                mPConstraintArray[2 * i].setCoefficient(mPVariableArray[n], -d);
            }
            d6 = this.me.marginsEqs[i].constant() + d5;
            for (n = 0; n < this.me.varsNum; ++n) {
                if (!this.pinned[n]) continue;
                d6 -= this.me.marginsEqs[i].coef(n) * this.me.varsValues[n];
            }
            mPConstraintArray[2 * i + 1] = mPSolver.makeConstraint(Double.NEGATIVE_INFINITY, d6, "c" + i + "b");
            mPConstraintArray[2 * i + 1].setCoefficient(mPVariable, 1.0);
            mPConstraintArray[2 * i + 1].setCoefficient(mPVariableArray2[i], d5);
            for (n = 0; n < this.me.varsNum; ++n) {
                if (this.pinned[n] || (d = this.me.marginsEqs[i].coef(n)) == 0.0) continue;
                mPConstraintArray[2 * i + 1].setCoefficient(mPVariableArray[n], d);
            }
        }
        MPObjective mPObjective = mPSolver.objective();
        mPObjective.setCoefficient(mPVariable, 1.0);
        mPObjective.setMaximization();
        MPSolver.ResultStatus resultStatus = mPSolver.solve();
        if (resultStatus != MPSolver.ResultStatus.OPTIMAL) {
            return false;
        }
        for (int i = 0; i < this.me.varsNum; ++i) {
            if (this.pinned[i]) continue;
            this.me.varsValues[i] = mPVariableArray[i].solutionValue();
        }
        return true;
    }

    protected void markFinished() {
        double d;
        int n;
        double d2 = Double.POSITIVE_INFINITY;
        for (n = 0; n < this.me.marginsNum; ++n) {
            if (this.me.marginsEqs[n].done() || !(this.me.getMargin(n) < d2)) continue;
            d2 = this.me.getMargin(n);
        }
        for (n = 0; n < this.me.marginsNum; ++n) {
            double d3;
            if (this.me.marginsEqs[n].done() || (d = (d3 = this.me.getMargin(n)) - d2) < -1.0E-7 || d > 1.0E-7) continue;
            for (int i = 0; i < this.me.varsNum; ++i) {
                double d4 = this.me.marginsEqs[n].coef(i);
                if (this.pinned[i] || !(d4 > 1.0E-7) && !(d4 < -1.0E-7)) continue;
                this.pinned[i] = true;
            }
        }
        for (n = 0; n < this.me.marginsNum; ++n) {
            if (this.me.marginsEqs[n].done()) continue;
            boolean bl = true;
            for (int i = 0; i < this.me.varsNum; ++i) {
                d = this.me.marginsEqs[n].coef(i);
                if (this.pinned[i] || !(d > 1.0E-7) && !(d < -1.0E-7)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.me.marginsEqs[n].setDone(true);
        }
    }

    protected boolean doOptimizationMILP() {
        int n = 1;
        while (true) {
            boolean bl;
            if (!(bl = this.runMILP())) {
                return false;
            }
            this.markFinished();
            boolean bl2 = true;
            for (int i = 0; i < this.me.marginsNum; ++i) {
                if (this.me.marginsEqs[i].done()) continue;
                bl2 = false;
                break;
            }
            if (bl2) break;
            ++n;
        }
        return true;
    }

    protected void updatePattern() {
        for (int i = 0; i < this.me.varsNum; ++i) {
            if (!this.pinned[i]) continue;
            JMLEvent jMLEvent = this.me.varsEvents[i];
            double d = (double)Math.round(this.me.varsValues[i] * 100.0) / 100.0;
            Coordinate coordinate = jMLEvent.getLocalCoordinate();
            coordinate.x = d;
            jMLEvent.setLocalCoordinate(coordinate);
        }
        this.pat.setNeedsLayout(true);
    }

    static {
        try {
            System.loadLibrary("jniortools");
            optimizer_loaded = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }
}

