/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.PathLink;
import jugglinglab.optimizer.LinearEquation;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;

public class MarginEquations {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected static final double epsilon = 1.0E-6;
    public int varsNum = 0;
    public JMLEvent[] varsEvents = null;
    public double[] varsValues = null;
    public double[] varsMin = null;
    public double[] varsMax = null;
    public int marginsNum = 0;
    public LinearEquation[] marginsEqs = null;

    public MarginEquations() {
    }

    public MarginEquations(JMLPattern jMLPattern) throws JuggleExceptionInternal, JuggleExceptionUser {
        this();
        this.findeqs(jMLPattern);
    }

    public double getNumberOfEquations() {
        return this.marginsNum;
    }

    public double getMargin(int n) {
        double d = 0.0;
        for (int i = 0; i < this.varsNum; ++i) {
            d += this.marginsEqs[n].coef(i) * this.varsValues[i];
        }
        return Math.abs(d) + this.marginsEqs[n].constant();
    }

    public double getMargin() {
        if (this.marginsNum == 0) {
            return -100.0;
        }
        double d = this.getMargin(0);
        for (int i = 1; i < this.marginsNum; ++i) {
            double d2 = this.getMargin(i);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    protected void findeqs(JMLPattern jMLPattern) throws JuggleExceptionInternal, JuggleExceptionUser {
        Object object;
        int n;
        int n2;
        Object object2;
        int n3;
        int n4;
        int n5;
        int n6;
        JMLEvent jMLEvent;
        if (jMLPattern.getNumberOfJugglers() > 1) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_optimizer_no_passing"));
        }
        if (jMLPattern.isBouncePattern()) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_optimizer_no_bouncing"));
        }
        jMLPattern.layoutPattern();
        JMLEvent jMLEvent2 = jMLPattern.getEventList();
        ArrayList<ArrayList<PathLink>> arrayList = jMLPattern.getPathlinks();
        ArrayList<JMLEvent> arrayList2 = new ArrayList<JMLEvent>();
        double d = 0.0;
        double d2 = 980.0;
        block7: for (jMLEvent = jMLEvent2; jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
            if (!jMLEvent.isMaster()) continue;
            for (n6 = 0; n6 < jMLEvent.getNumberOfTransitions(); ++n6) {
                ParameterList parameterList;
                String string;
                int n7 = jMLEvent.getTransition(n6).getType();
                if (n7 != 1 && n7 != 2 && n7 != 3) continue;
                ++this.varsNum;
                arrayList2.add(jMLEvent);
                Coordinate coordinate = jMLEvent.getLocalCoordinate();
                if (Math.abs(coordinate.x) > d) {
                    d = Math.abs(coordinate.x);
                }
                if (n7 != 1 || (string = (parameterList = new ParameterList(jMLEvent.getTransition(n6).getMod())).getParameter("g")) == null) continue block7;
                try {
                    d2 = Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {}
                continue block7;
            }
        }
        this.varsEvents = new JMLEvent[this.varsNum];
        this.varsValues = new double[this.varsNum];
        this.varsMin = new double[this.varsNum];
        this.varsMax = new double[this.varsNum];
        for (n6 = 0; n6 < this.varsNum; ++n6) {
            jMLEvent = (JMLEvent)arrayList2.get(n6);
            Coordinate coordinate = jMLEvent.getLocalCoordinate();
            int n8 = jMLEvent.getTransition(0).getType();
            this.varsEvents[n6] = jMLEvent;
            this.varsValues[n6] = coordinate.x;
            if (this.varsValues[n6] > 0.0) {
                this.varsMin[n6] = 0.1 * d;
                this.varsMax[n6] = d;
                if (n8 != 1) continue;
                int n9 = n6;
                this.varsMax[n9] = this.varsMax[n9] * 0.9;
                continue;
            }
            this.varsMin[n6] = -d;
            this.varsMax[n6] = -0.1 * d;
            if (n8 != 1) continue;
            int n10 = n6;
            this.varsMin[n10] = this.varsMin[n10] * 0.9;
        }
        double d3 = 0.0;
        for (n5 = 0; n5 < jMLPattern.getNumberOfProps(); ++n5) {
            double d4 = 0.5 * jMLPattern.getProp(n5 + 1).getWidth();
            if (!(d4 > d3)) continue;
            d3 = d4;
        }
        n5 = 0;
        PathLink[] pathLinkArray = null;
        for (int i = 1; i < 3; ++i) {
            int n11 = 0;
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                for (n3 = 0; n3 < arrayList.get(n4).size(); ++n3) {
                    object2 = arrayList.get(n4).get(n3);
                    if (((PathLink)object2).isInHand() || !((PathLink)object2).getStartEvent().isMaster()) continue;
                    if (i == 1) {
                        ++n5;
                        continue;
                    }
                    pathLinkArray[n11++] = object2;
                }
            }
            if (i != 1) continue;
            pathLinkArray = new PathLink[n5];
        }
        double d5 = -1.0;
        n4 = 0;
        block14: for (n3 = 0; n3 < jMLPattern.getNumberOfSymmetries(); ++n3) {
            object2 = jMLPattern.getSymmetry(n3);
            switch (((JMLSymmetry)object2).getType()) {
                case 1: {
                    d5 = ((JMLSymmetry)object2).getDelay();
                    continue block14;
                }
                case 3: {
                    n4 = 1;
                    continue block14;
                }
                case 2: {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_no_optimize_switch"));
                }
            }
        }
        ArrayList<double[]> arrayList3 = new ArrayList<double[]>();
        for (n2 = 0; n2 < n5; ++n2) {
            for (n = 0; n < n5; ++n) {
                PathLink pathLink = pathLinkArray[n2];
                object = pathLinkArray[n];
                double d6 = pathLink.getStartEvent().getT();
                double d7 = pathLink.getEndEvent().getT();
                double d8 = ((PathLink)object).getStartEvent().getT();
                double d9 = ((PathLink)object).getEndEvent().getT();
                double d10 = 0.0;
                boolean bl = false;
                do {
                    boolean bl2 = true;
                    if (d10 == 0.0 && pathLink.getStartEvent() == ((PathLink)object).getStartEvent()) {
                        bl2 = false;
                    }
                    if (d6 > d8 + d10) {
                        bl2 = false;
                    } else if (d6 == d8 + d10) {
                        if (d7 > d9 + d10) {
                            bl2 = false;
                        } else if (d7 == d9 + d10) {
                            if (pathLink.getStartEvent().getJuggler() > ((PathLink)object).getStartEvent().getJuggler()) {
                                bl2 = false;
                            } else if (pathLink.getStartEvent().getJuggler() == ((PathLink)object).getStartEvent().getJuggler() && pathLink.getStartEvent().getHand() == 1) {
                                bl2 = false;
                            }
                        }
                    }
                    double d11 = -1.0;
                    double d12 = d8 + d9 + 2.0 * d10 - (d6 + d7);
                    if (d12 == 0.0) {
                        bl2 = false;
                    }
                    if (bl2 && ((d11 = ((d8 + d10) * (d9 + d10) - d6 * d7) / d12) < d6 || d11 > d7 || d11 < d8 + d10 || d11 > d9 + d10)) {
                        bl2 = false;
                    }
                    if (bl2) {
                        double[] dArray = new double[this.varsNum + 1];
                        double d13 = d7;
                        double d14 = d6;
                        double d15 = 0.5 * d2 * (d13 - d14);
                        double d16 = d9 + d10;
                        double d17 = d8 + d10;
                        double d18 = 0.5 * d2 * (d16 - d17);
                        double d19 = d15 * (d11 - d14) + d18 * (d11 - d17);
                        if (d19 > 1.0E-6) {
                            int n12;
                            double d20 = (d13 - d11) / ((d13 - d14) * (d19 *= Math.PI / 180));
                            double d21 = (d11 - d14) / ((d13 - d14) * d19);
                            double d22 = -(d16 - d11) / ((d16 - d17) * d19);
                            double d23 = -(d11 - d17) / ((d16 - d17) * d19);
                            double d24 = -2.0 * d3 / d19;
                            JMLEvent jMLEvent3 = pathLink.getStartEvent();
                            if (!jMLEvent3.isMaster()) {
                                if (jMLEvent3.getHand() != jMLEvent3.getMaster().getHand()) {
                                    d20 = -d20;
                                }
                                jMLEvent3 = jMLEvent3.getMaster();
                            }
                            int n13 = arrayList2.indexOf(jMLEvent3);
                            jMLEvent3 = pathLink.getEndEvent();
                            if (!jMLEvent3.isMaster()) {
                                if (jMLEvent3.getHand() != jMLEvent3.getMaster().getHand()) {
                                    d21 = -d21;
                                }
                                jMLEvent3 = jMLEvent3.getMaster();
                            }
                            int n14 = arrayList2.indexOf(jMLEvent3);
                            jMLEvent3 = ((PathLink)object).getStartEvent();
                            if (!jMLEvent3.isMaster()) {
                                if (jMLEvent3.getHand() != jMLEvent3.getMaster().getHand()) {
                                    d22 = -d22;
                                }
                                jMLEvent3 = jMLEvent3.getMaster();
                            }
                            int n15 = arrayList2.indexOf(jMLEvent3);
                            jMLEvent3 = ((PathLink)object).getEndEvent();
                            if (!jMLEvent3.isMaster()) {
                                if (jMLEvent3.getHand() != jMLEvent3.getMaster().getHand()) {
                                    d23 = -d23;
                                }
                                jMLEvent3 = jMLEvent3.getMaster();
                            }
                            int n16 = arrayList2.indexOf(jMLEvent3);
                            if (n13 < 0 || n14 < 0 || n15 < 0 || n16 < 0) {
                                throw new JuggleExceptionInternal("Could not find master event in variableEvents");
                            }
                            if (bl) {
                                d22 = -d22;
                                d23 = -d23;
                            }
                            int n17 = n13;
                            dArray[n17] = dArray[n17] + d20;
                            int n18 = n14;
                            dArray[n18] = dArray[n18] + d21;
                            int n19 = n15;
                            dArray[n19] = dArray[n19] + d22;
                            int n20 = n16;
                            dArray[n20] = dArray[n20] + d23;
                            dArray[this.varsNum] = d24;
                            double d25 = 0.0;
                            for (n12 = 0; n12 < this.varsNum; ++n12) {
                                d25 += dArray[n12] * this.varsValues[n12];
                            }
                            if (d25 < 0.0) {
                                for (n12 = 0; n12 < this.varsNum; ++n12) {
                                    if (dArray[n12] == 0.0) continue;
                                    dArray[n12] = -dArray[n12];
                                }
                            }
                            arrayList3.add(dArray);
                            ++this.marginsNum;
                        }
                    }
                    if (n4 != 0) {
                        d10 += 0.5 * d5;
                        bl = !bl;
                        continue;
                    }
                    d10 += d5;
                } while (d7 > d8 + d10);
            }
        }
        n2 = 1;
        for (n = 1; n < this.marginsNum; ++n) {
            boolean bl;
            boolean bl3 = false;
            object = (double[])arrayList3.get(n);
            for (int i = 0; !bl3 && i < n; bl3 |= bl, ++i) {
                double[] dArray = (double[])arrayList3.get(i);
                bl = true;
                for (int j = 0; bl && j <= this.varsNum; ++j) {
                    if (!(object[j] < dArray[j] - 1.0E-6) && !(object[j] > dArray[j] + 1.0E-6)) continue;
                    bl = false;
                }
            }
            if (!bl3) continue;
            arrayList3.remove(n);
            --n;
            --this.marginsNum;
        }
        this.marginsEqs = new LinearEquation[this.marginsNum];
        for (n = 0; n < this.marginsNum; ++n) {
            this.marginsEqs[n] = new LinearEquation(this.varsNum);
            this.marginsEqs[n].setCoefficients((double[])arrayList3.get(n));
        }
        this.sort();
    }

    public void sort() {
        Comparator<LinearEquation> comparator = new Comparator<LinearEquation>(){

            @Override
            public int compare(LinearEquation linearEquation, LinearEquation linearEquation2) {
                if (linearEquation.done() && !linearEquation2.done()) {
                    return -1;
                }
                if (!linearEquation.done() && linearEquation2.done()) {
                    return 1;
                }
                double d = linearEquation.constant();
                double d2 = linearEquation2.constant();
                for (int i = 0; i < MarginEquations.this.varsNum; ++i) {
                    d += linearEquation.coef(i) * MarginEquations.this.varsValues[i];
                    d2 += linearEquation2.coef(i) * MarginEquations.this.varsValues[i];
                }
                if (d < d2) {
                    return -1;
                }
                if (d > d2) {
                    return 1;
                }
                return 0;
            }

            public boolean equals(LinearEquation linearEquation) {
                return false;
            }
        };
        Arrays.sort(this.marginsEqs, comparator);
    }
}

