/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.text.MessageFormat;
import java.util.ArrayList;
import jugglinglab.notation.MHNPattern;
import jugglinglab.notation.MHNSymmetry;
import jugglinglab.notation.MHNThrow;
import jugglinglab.notation.ssparser.ParseException;
import jugglinglab.notation.ssparser.SiteswapParser;
import jugglinglab.notation.ssparser.SiteswapTreeItem;
import jugglinglab.notation.ssparser.TokenMgrError;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;
import jugglinglab.util.Permutation;

public class SiteswapPattern
extends MHNPattern {
    protected boolean oddperiod = false;
    protected boolean has_hands_specifier = false;
    boolean[] right_on_even;

    @Override
    public String getNotationName() {
        return "Siteswap";
    }

    @Override
    public SiteswapPattern fromString(String string) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (string.indexOf(61) == -1) {
            string = "pattern=" + string;
        }
        ParameterList parameterList = new ParameterList(string);
        this.fromParameters(parameterList);
        parameterList.errorIfParametersLeft();
        return this;
    }

    @Override
    public SiteswapPattern fromParameters(ParameterList parameterList) throws JuggleExceptionUser, JuggleExceptionInternal {
        super.fromParameters(parameterList);
        this.parseSiteswapNotation();
        if (this.hands != null || this.bodies != null) {
            int n;
            int n2;
            int n3 = this.getNorepPeriod();
            int n4 = 1;
            if (this.hands != null) {
                for (n2 = 1; n2 <= this.getNumberOfJugglers(); ++n2) {
                    n4 = Permutation.lcm(n4, this.hands.getPeriod(n2));
                }
            }
            n2 = 1;
            if (this.bodies != null) {
                for (n = 1; n <= this.getNumberOfJugglers(); ++n) {
                    n2 = Permutation.lcm(n2, this.bodies.getPeriod(n));
                }
            }
            n = n3;
            n = Permutation.lcm(n, n4);
            if ((n = Permutation.lcm(n, n2)) != n3) {
                int n5 = n / n3;
                this.pattern = "(" + this.pattern + "^" + n5 + ")";
                this.parseSiteswapNotation();
            }
        }
        super.buildRepresentation();
        return this;
    }

    public boolean hasHandsSpecifier() {
        return this.has_hands_specifier;
    }

    protected int getNorepPeriod() {
        return this.oddperiod ? this.getPeriod() / 2 : this.getPeriod();
    }

    protected void parseSiteswapNotation() throws JuggleExceptionUser, JuggleExceptionInternal {
        this.th = null;
        this.symmetry = new ArrayList();
        SiteswapTreeItem siteswapTreeItem = null;
        try {
            siteswapTreeItem = SiteswapParser.parsePattern(this.pattern);
        }
        catch (ParseException parseException) {
            if (parseException.currentToken == null) {
                String string = errorstrings.getString("Error_pattern_parsing");
                Object[] objectArray = new Object[]{parseException.getMessage()};
                throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
            }
            String string = errorstrings.getString("Error_pattern_syntax");
            String string2 = ParseException.add_escapes(parseException.currentToken.next.image);
            Object[] objectArray = new Object[]{string2, new Integer(parseException.currentToken.next.beginColumn)};
            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
        }
        catch (TokenMgrError tokenMgrError) {
            String string = errorstrings.getString("Error_pattern_syntax");
            String string3 = TokenMgrError.addEscapes(String.valueOf(tokenMgrError.curChar));
            Object[] objectArray = new Object[]{string3, new Integer(tokenMgrError.errorColumn - 1)};
            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
        }
        this.numjugglers = siteswapTreeItem.jugglers;
        this.max_occupancy = 0;
        this.max_throw = 0;
        this.right_on_even = new boolean[this.numjugglers];
        for (int i = 0; i < this.numjugglers; ++i) {
            this.right_on_even[i] = true;
        }
        siteswapTreeItem.beatnum = 0;
        this.doFirstPass(siteswapTreeItem);
        if (!siteswapTreeItem.switchrepeat && siteswapTreeItem.vanilla_async && siteswapTreeItem.beats % 2 == 1) {
            siteswapTreeItem.switchrepeat = true;
            siteswapTreeItem.beats *= 2;
            siteswapTreeItem.throw_sum *= 2;
            this.oddperiod = true;
        }
        this.period = siteswapTreeItem.beats;
        if (siteswapTreeItem.throw_sum % siteswapTreeItem.beats != 0) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_siteswap_bad_average"));
        }
        this.numpaths = siteswapTreeItem.throw_sum / siteswapTreeItem.beats;
        this.indexes = this.max_throw + this.period + 1;
        this.th = new MHNThrow[this.numjugglers][2][this.indexes][this.max_occupancy];
        this.doSecondPass(siteswapTreeItem, false, 0);
        this.addSymmetry(new MHNSymmetry(1, this.numjugglers, null, this.period));
        if (siteswapTreeItem.switchrepeat) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i <= this.numjugglers; ++i) {
                stringBuffer.append("(" + i + "," + i + "*)");
            }
            this.addSymmetry(new MHNSymmetry(3, this.numjugglers, stringBuffer.toString(), this.period / 2));
        }
        if (this.bodies != null && this.bodies.getNumberOfJugglers() < this.getNumberOfJugglers()) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_jugglers_body"));
        }
    }

    protected void doFirstPass(SiteswapTreeItem siteswapTreeItem) throws JuggleExceptionUser, JuggleExceptionInternal {
        SiteswapTreeItem siteswapTreeItem2 = null;
        siteswapTreeItem.throw_sum = 0;
        siteswapTreeItem.vanilla_async = true;
        switch (siteswapTreeItem.type) {
            case 1: {
                siteswapTreeItem.beats = 0;
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum + siteswapTreeItem.beats;
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem.beats += siteswapTreeItem2.beats;
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.throw_sum;
                    siteswapTreeItem.vanilla_async &= siteswapTreeItem2.vanilla_async;
                }
                if (!siteswapTreeItem.switchrepeat) break;
                siteswapTreeItem.beats *= 2;
                siteswapTreeItem.throw_sum *= 2;
                break;
            }
            case 2: {
                siteswapTreeItem2 = siteswapTreeItem.getChild(0);
                if (siteswapTreeItem.getNumberOfChildren() > 1) {
                    siteswapTreeItem.removeChildren();
                    siteswapTreeItem.addChild(siteswapTreeItem2);
                }
                siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum;
                this.doFirstPass(siteswapTreeItem2);
                for (int i = 1; i < siteswapTreeItem.repeats; ++i) {
                    SiteswapTreeItem siteswapTreeItem3 = (SiteswapTreeItem)siteswapTreeItem2.clone();
                    siteswapTreeItem.addChild(siteswapTreeItem3);
                    siteswapTreeItem3.beatnum = siteswapTreeItem.beatnum + i * siteswapTreeItem2.beats;
                    this.doFirstPass(siteswapTreeItem3);
                }
                siteswapTreeItem.beats = siteswapTreeItem2.beats * siteswapTreeItem.repeats;
                siteswapTreeItem.throw_sum = siteswapTreeItem2.throw_sum * siteswapTreeItem.repeats;
                siteswapTreeItem.vanilla_async &= siteswapTreeItem2.vanilla_async;
                break;
            }
            case 3: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum + siteswapTreeItem2.seq_beatnum;
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.throw_sum;
                    siteswapTreeItem.vanilla_async &= siteswapTreeItem2.vanilla_async;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum;
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem2.left = i == 0;
                    siteswapTreeItem2.sync_throw = true;
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.throw_sum;
                }
                siteswapTreeItem.vanilla_async = false;
                break;
            }
            case 5: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum;
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.value;
                    siteswapTreeItem.vanilla_async &= siteswapTreeItem2.vanilla_async;
                }
                siteswapTreeItem.left = siteswapTreeItem.beatnum % 2 == 0 ? !this.right_on_even[siteswapTreeItem.source_juggler - 1] : this.right_on_even[siteswapTreeItem.source_juggler - 1];
                if (siteswapTreeItem.getNumberOfChildren() <= this.max_occupancy) break;
                this.max_occupancy = siteswapTreeItem.getNumberOfChildren();
                break;
            }
            case 6: {
                if (siteswapTreeItem.value > this.max_throw) {
                    this.max_throw = siteswapTreeItem.value;
                }
                siteswapTreeItem.vanilla_async = !siteswapTreeItem.x;
                break;
            }
            case 7: 
            case 8: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum;
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.throw_sum;
                    siteswapTreeItem.vanilla_async &= siteswapTreeItem2.vanilla_async;
                }
                break;
            }
            case 9: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum + siteswapTreeItem2.seq_beatnum;
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.throw_sum;
                    siteswapTreeItem.vanilla_async &= siteswapTreeItem2.vanilla_async;
                }
                break;
            }
            case 10: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum;
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem2.left = i == 0;
                    siteswapTreeItem2.sync_throw = true;
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.throw_sum;
                }
                siteswapTreeItem.vanilla_async = false;
                break;
            }
            case 11: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum;
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.value;
                    siteswapTreeItem.vanilla_async &= siteswapTreeItem2.vanilla_async;
                }
                siteswapTreeItem.left = siteswapTreeItem.beatnum % 2 == 0 ? !this.right_on_even[siteswapTreeItem.source_juggler - 1] : this.right_on_even[siteswapTreeItem.source_juggler - 1];
                if (siteswapTreeItem.getNumberOfChildren() <= this.max_occupancy) break;
                this.max_occupancy = siteswapTreeItem.getNumberOfChildren();
                break;
            }
            case 12: {
                if (siteswapTreeItem.value > this.max_throw) {
                    this.max_throw = siteswapTreeItem.value;
                }
                siteswapTreeItem.vanilla_async = !siteswapTreeItem.x;
                break;
            }
            case 13: {
                if (siteswapTreeItem.transition != null) {
                    siteswapTreeItem.transition.beatnum = siteswapTreeItem.beatnum;
                    this.doFirstPass(siteswapTreeItem.transition);
                    siteswapTreeItem.throw_sum = siteswapTreeItem.transition.throw_sum;
                    siteswapTreeItem.vanilla_async = siteswapTreeItem.transition.vanilla_async;
                    siteswapTreeItem.beats = siteswapTreeItem.transition.beats;
                    break;
                }
                throw new JuggleExceptionInternal("Wildcard not resolved");
            }
            case 14: {
                this.right_on_even[siteswapTreeItem.source_juggler - 1] = siteswapTreeItem.beatnum % 2 == 0 ? !siteswapTreeItem.spec_left : siteswapTreeItem.spec_left;
                siteswapTreeItem.throw_sum = 0;
                if (siteswapTreeItem.beatnum > 0) {
                    siteswapTreeItem.vanilla_async = false;
                }
                this.has_hands_specifier = true;
            }
        }
    }

    protected void doSecondPass(SiteswapTreeItem siteswapTreeItem, boolean bl, int n) throws JuggleExceptionUser {
        SiteswapTreeItem siteswapTreeItem2 = null;
        switch (siteswapTreeItem.type) {
            case 1: {
                int n2;
                for (n2 = 0; n2 < siteswapTreeItem.getNumberOfChildren(); ++n2) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(n2);
                    this.doSecondPass(siteswapTreeItem2, bl, n);
                }
                if (!siteswapTreeItem.switchrepeat) break;
                for (n2 = 0; n2 < siteswapTreeItem.getNumberOfChildren(); ++n2) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(n2);
                    this.doSecondPass(siteswapTreeItem2, !bl, n + siteswapTreeItem.beats / 2);
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    this.doSecondPass(siteswapTreeItem2, bl, n);
                }
                break;
            }
            case 5: 
            case 11: {
                for (int i = siteswapTreeItem.beatnum + n; i < this.indexes; i += this.period) {
                    for (int j = 0; j < siteswapTreeItem.getNumberOfChildren(); ++j) {
                        int n3;
                        String string;
                        int n4;
                        siteswapTreeItem2 = siteswapTreeItem.getChild(j);
                        int n5 = bl ? (siteswapTreeItem.left ? 0 : 1) : (siteswapTreeItem.left ? 1 : 0);
                        int n6 = n4 = siteswapTreeItem2.value % 2 == 0 ? n5 : 1 - n5;
                        if (siteswapTreeItem2.x) {
                            n4 = 1 - n4;
                        }
                        if ((string = siteswapTreeItem2.mod) == null) {
                            string = "T";
                            if (siteswapTreeItem2.source_juggler == siteswapTreeItem2.dest_juggler && n5 == n4 && siteswapTreeItem2.value <= 2) {
                                string = "H";
                            }
                        }
                        if ((n3 = siteswapTreeItem2.dest_juggler) > this.getNumberOfJugglers()) {
                            n3 = 1 + (n3 - 1) % this.getNumberOfJugglers();
                        }
                        MHNThrow mHNThrow = new MHNThrow(siteswapTreeItem2.source_juggler, n5, i, j, n3, n4, i + siteswapTreeItem2.value, -1, string);
                        if (this.hands != null) {
                            int n7 = i;
                            if (siteswapTreeItem.sync_throw && n5 == 0) {
                                ++n7;
                            }
                            mHNThrow.handsindex = n7 %= this.hands.getPeriod(siteswapTreeItem2.source_juggler);
                        }
                        this.th[siteswapTreeItem2.source_juggler - 1][n5][i][j] = mHNThrow;
                    }
                }
                break;
            }
        }
    }
}

