/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

public class MHNThrow {
    public int juggler;
    public int hand;
    public int index;
    public int slot;
    public int targetjuggler;
    public int targethand;
    public int targetindex;
    public int targetslot;
    public String mod;
    public int handsindex;
    public int pathnum = -1;
    public MHNThrow master;
    public MHNThrow source;
    public MHNThrow target;
    public boolean catching = false;
    public int catchnum = -1;

    public MHNThrow() {
    }

    public MHNThrow(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, String string) {
        this.juggler = n;
        this.hand = n2;
        this.index = n3;
        this.slot = n4;
        this.targetjuggler = n5;
        this.targethand = n6;
        this.targetindex = n7;
        this.targetslot = n8;
        this.mod = string;
    }

    public String toString() {
        String string = "(" + this.juggler + ", " + this.hand + ", " + this.index + ", " + this.slot;
        string = string + " -> " + this.targetjuggler + ", " + this.targethand + ", " + this.targetindex + ", " + this.targetslot + ")";
        if (this.master == this) {
            string = string + "*";
        }
        return string;
    }

    public boolean isHold() {
        if (this.targetindex - this.index > 2 || this.hand != this.targethand || this.juggler != this.targetjuggler) {
            return false;
        }
        return this.mod == null || this.mod.indexOf(84) == -1;
    }

    public static int compareThrows(MHNThrow mHNThrow, MHNThrow mHNThrow2) {
        boolean bl;
        int n = mHNThrow.targetindex - mHNThrow.index;
        int n2 = mHNThrow2.targetindex - mHNThrow2.index;
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        boolean bl2 = mHNThrow.targetjuggler != mHNThrow.juggler;
        boolean bl3 = mHNThrow2.targetjuggler != mHNThrow2.juggler;
        boolean bl4 = mHNThrow.targethand == mHNThrow.hand ^ n % 2 == 0;
        boolean bl5 = mHNThrow2.targethand == mHNThrow2.hand ^ n2 % 2 == 0;
        if (bl2 && !bl3) {
            return 1;
        }
        if (!bl2 && bl3) {
            return -1;
        }
        if (bl2) {
            if (mHNThrow.targetjuggler < mHNThrow2.targetjuggler) {
                return 1;
            }
            if (mHNThrow.targetjuggler > mHNThrow2.targetjuggler) {
                return -1;
            }
        }
        if (bl4 && !bl5) {
            return 1;
        }
        if (!bl4 && bl5) {
            return -1;
        }
        boolean bl6 = mHNThrow.mod != null;
        boolean bl7 = bl = mHNThrow2.mod != null;
        if (bl6 && !bl) {
            return 1;
        }
        if (!bl6 && bl) {
            return -1;
        }
        if (bl6 && bl) {
            int n3 = mHNThrow.mod.compareTo(mHNThrow2.mod);
            if (n3 < 0) {
                return 1;
            }
            if (n3 > 0) {
                return -1;
            }
        }
        return 0;
    }
}

