/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLPosition;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.jml.PropDef;
import jugglinglab.notation.MHNBody;
import jugglinglab.notation.MHNHands;
import jugglinglab.notation.MHNSymmetry;
import jugglinglab.notation.MHNThrow;
import jugglinglab.notation.Pattern;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;
import jugglinglab.util.Permutation;

public abstract class MHNPattern
extends Pattern {
    protected static double bps_default = -1.0;
    protected static double dwell_default = 1.3;
    protected static double gravity_default = 980.0;
    protected static double propdiam_default = 10.0;
    protected static double bouncefrac_default = 0.9;
    protected static String prop_default = "ball";
    protected String config;
    protected String pattern;
    protected double bps = bps_default;
    protected double dwell = dwell_default;
    protected double gravity = gravity_default;
    protected double propdiam = propdiam_default;
    protected double bouncefrac = bouncefrac_default;
    protected String prop = prop_default;
    protected String[] color;
    protected String title;
    protected int numjugglers;
    protected int numpaths;
    protected int period;
    protected int max_occupancy;
    protected MHNThrow[][][][] th;
    protected MHNHands hands;
    protected MHNBody bodies;
    protected int max_throw;
    protected int indexes;
    protected ArrayList<MHNSymmetry> symmetry;
    public static final int RIGHT_HAND = 0;
    public static final int LEFT_HAND = 1;
    protected static final double[] samethrowx = new double[]{0.0, 20.0, 25.0, 12.0, 10.0, 7.5, 5.0, 5.0, 5.0};
    protected static final double[] crossingthrowx = new double[]{0.0, 20.0, 25.0, 12.0, 10.0, 18.0, 25.0, 25.0, 30.0};
    protected static final double[] catchx = new double[]{0.0, 30.0, 25.0, 30.0, 40.0, 45.0, 45.0, 50.0, 50.0};
    protected static final double restingx = 25.0;
    protected static final double splitcatchfactor = 0.4;
    protected static final double[] throwspersec = new double[]{2.0, 2.0, 2.0, 2.9, 3.4, 4.1, 4.25, 5.0, 5.0, 5.5};

    public int getNumberOfJugglers() {
        return this.numjugglers;
    }

    public int getNumberOfPaths() {
        return this.numpaths;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getIndexes() {
        return this.indexes;
    }

    public int getMaxOccupancy() {
        return this.max_occupancy;
    }

    public int getMaxThrow() {
        return this.max_throw;
    }

    public MHNThrow[][][][] getThrows() {
        return this.th;
    }

    public int getNumberOfSymmetries() {
        return this.symmetry.size();
    }

    public String getPropName() {
        return this.prop;
    }

    public void addSymmetry(MHNSymmetry mHNSymmetry) {
        this.symmetry.add(mHNSymmetry);
    }

    public MHNSymmetry getSymmetry(int n) {
        return this.symmetry.get(n);
    }

    @Override
    public MHNPattern fromParameters(ParameterList parameterList) throws JuggleExceptionUser, JuggleExceptionInternal {
        this.config = parameterList.toString();
        this.pattern = parameterList.removeParameter("pattern");
        if (this.pattern == null) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_no_pattern"));
        }
        String string = null;
        string = parameterList.removeParameter("bps");
        if (string != null) {
            try {
                this.bps = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_bps_value"));
            }
        }
        if ((string = parameterList.removeParameter("dwell")) != null) {
            try {
                this.dwell = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_dwell_value"));
            }
        }
        if ((string = parameterList.removeParameter("hands")) != null) {
            this.hands = new MHNHands(string);
        }
        if ((string = parameterList.removeParameter("body")) != null) {
            this.bodies = new MHNBody(string);
        }
        if ((string = parameterList.removeParameter("gravity")) != null) {
            try {
                this.gravity = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = parameterList.removeParameter("propdiam")) != null) {
            try {
                this.propdiam = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = parameterList.removeParameter("bouncefrac")) != null) {
            try {
                this.bouncefrac = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = parameterList.removeParameter("prop")) != null) {
            this.prop = string;
        }
        if ((string = parameterList.removeParameter("colors")) != null) {
            string = string.trim().equals("mixed") ? "{red}{green}{blue}{yellow}{cyan}{magenta}{orange}{pink}{gray}{black}" : JLFunc.expandRepeats(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "}", false);
            StringTokenizer stringTokenizer2 = null;
            String string2 = null;
            int n = stringTokenizer.countTokens();
            this.color = new String[n];
            block14: for (int i = 0; i < n; ++i) {
                string2 = stringTokenizer.nextToken().replace('{', ' ').trim();
                stringTokenizer2 = new StringTokenizer(string2, ",", false);
                switch (stringTokenizer2.countTokens()) {
                    case 1: {
                        this.color[i] = stringTokenizer2.nextToken().trim().toLowerCase();
                        continue block14;
                    }
                    case 3: {
                        this.color[i] = "{" + string2 + "}";
                        continue block14;
                    }
                    default: {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_color_format"));
                    }
                }
            }
        }
        if ((string = parameterList.removeParameter("title")) != null) {
            this.title = string.trim();
        }
        return this;
    }

    @Override
    public String toString() {
        if (this.config == null) {
            return null;
        }
        ParameterList parameterList = new ParameterList(this.config);
        String string = "";
        List<String> list = Arrays.asList("pattern", "bps", "dwell", "hands", "body", "gravity", "propdiam", "bouncefrac", "prop", "colors", "title");
        for (String string2 : list) {
            String string3 = parameterList.getParameter(string2);
            if (string3 == null) continue;
            string = string + string2 + "=" + string3 + ";";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected void buildRepresentation() throws JuggleExceptionUser, JuggleExceptionInternal {
        this.findMasterThrows();
        this.assignPaths();
        this.findThrowSources();
        this.setCatchOrder();
    }

    protected void findMasterThrows() throws JuggleExceptionInternal {
        int n;
        int n2;
        for (n2 = 0; n2 < this.indexes; ++n2) {
            for (n = 0; n < this.numjugglers; ++n) {
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < this.max_occupancy; ++j) {
                        MHNThrow mHNThrow = this.th[n][i][n2][j];
                        if (mHNThrow == null) continue;
                        mHNThrow.master = mHNThrow;
                        mHNThrow.source = null;
                    }
                }
            }
        }
        n2 = 1;
        while (n2 != 0) {
            n2 = 0;
            for (n = 0; n < this.getNumberOfSymmetries(); ++n) {
                MHNSymmetry mHNSymmetry = this.getSymmetry(n);
                Permutation permutation = mHNSymmetry.getJugglerPerm();
                int n3 = mHNSymmetry.getDelay();
                for (int i = 0; i < this.indexes; ++i) {
                    int n4 = i + n3;
                    if (n4 >= this.indexes) continue;
                    for (int j = 0; j < this.numjugglers; ++j) {
                        for (int k = 0; k < 2; ++k) {
                            for (int i2 = 0; i2 < this.max_occupancy; ++i2) {
                                MHNThrow mHNThrow = this.th[j][k][i][i2];
                                if (mHNThrow == null) continue;
                                int n5 = permutation.getMapping(j + 1);
                                int n6 = n5 > 0 ? k : 1 - k;
                                MHNThrow mHNThrow2 = this.th[n5 = Math.abs(n5) - 1][n6][n4][i2];
                                if (mHNThrow2 == null) {
                                    throw new JuggleExceptionInternal("Problem finding master throws");
                                }
                                MHNThrow mHNThrow3 = mHNThrow.master;
                                MHNThrow mHNThrow4 = mHNThrow2.master;
                                if (mHNThrow3 == mHNThrow4) continue;
                                MHNThrow mHNThrow5 = mHNThrow3;
                                if (mHNThrow3.index > mHNThrow4.index) {
                                    mHNThrow5 = mHNThrow4;
                                } else if (mHNThrow3.index == mHNThrow4.index) {
                                    if (mHNThrow3.juggler > mHNThrow4.juggler) {
                                        mHNThrow5 = mHNThrow4;
                                    } else if (mHNThrow3.juggler == mHNThrow4.juggler && mHNThrow3.hand > mHNThrow4.hand) {
                                        mHNThrow5 = mHNThrow4;
                                    }
                                }
                                mHNThrow.master = mHNThrow2.master = mHNThrow5;
                                n2 = 1;
                            }
                        }
                    }
                }
            }
        }
    }

    protected void assignPaths() throws JuggleExceptionUser, JuggleExceptionInternal {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < this.indexes; ++n4) {
            for (n3 = 0; n3 < this.numjugglers; ++n3) {
                for (n2 = 0; n2 < 2; ++n2) {
                    for (n = 0; n < this.max_occupancy; ++n) {
                        MHNThrow mHNThrow;
                        int n5;
                        int n6;
                        int n7;
                        int n8;
                        int n9;
                        MHNThrow mHNThrow2 = this.th[n3][n2][n4][n];
                        if (mHNThrow2 == null || mHNThrow2.master != mHNThrow2) continue;
                        for (n9 = 0; n9 < this.max_occupancy; ++n9) {
                            n8 = 1;
                            for (n7 = 0; n7 < this.indexes; ++n7) {
                                for (n6 = 0; n6 < this.numjugglers; ++n6) {
                                    for (n5 = 0; n5 < 2; ++n5) {
                                        for (int i = 0; i < this.max_occupancy; ++i) {
                                            mHNThrow = this.th[n6][n5][n7][i];
                                            if (mHNThrow == null || mHNThrow.master != mHNThrow2 || mHNThrow.targetindex >= this.indexes) continue;
                                            MHNThrow mHNThrow3 = this.th[mHNThrow.targetjuggler - 1][mHNThrow.targethand][mHNThrow.targetindex][n9];
                                            if (mHNThrow3 == null) {
                                                n8 = 0;
                                                continue;
                                            }
                                            n8 &= mHNThrow3.source == null ? 1 : 0;
                                        }
                                    }
                                }
                            }
                            if (n8 != 0) break;
                        }
                        if (n9 == this.max_occupancy) {
                            String string = errorstrings.getString("Error_badpattern_landings");
                            String string2 = mHNThrow2.targethand == 0 ? errorstrings.getString("Error_right_hand") : errorstrings.getString("Error_left_hand");
                            Object[] objectArray = new Object[]{new Integer(mHNThrow2.targetindex + 1), new Integer(mHNThrow2.targetjuggler), string2};
                            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
                        }
                        for (n8 = 0; n8 < this.indexes; ++n8) {
                            for (n7 = 0; n7 < this.numjugglers; ++n7) {
                                for (n6 = 0; n6 < 2; ++n6) {
                                    for (n5 = 0; n5 < this.max_occupancy; ++n5) {
                                        MHNThrow mHNThrow4 = this.th[n7][n6][n8][n5];
                                        if (mHNThrow4 == null || mHNThrow4.master != mHNThrow2 || mHNThrow4.targetindex >= this.indexes) continue;
                                        mHNThrow = this.th[mHNThrow4.targetjuggler - 1][mHNThrow4.targethand][mHNThrow4.targetindex][n9];
                                        if (mHNThrow == null) {
                                            throw new JuggleExceptionInternal("Got null target in assignPaths()");
                                        }
                                        mHNThrow4.target = mHNThrow;
                                        mHNThrow.source = mHNThrow4;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        n4 = 1;
        for (n3 = 0; n3 < this.indexes; ++n3) {
            for (n2 = 0; n2 < this.numjugglers; ++n2) {
                for (n = 0; n < 2; ++n) {
                    for (int i = 0; i < this.max_occupancy; ++i) {
                        MHNThrow mHNThrow = this.th[n2][n][n3][i];
                        if (mHNThrow == null) continue;
                        if (mHNThrow.source != null) {
                            mHNThrow.pathnum = mHNThrow.source.pathnum;
                            continue;
                        }
                        if (n4 > this.numpaths) {
                            throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern"));
                        }
                        mHNThrow.pathnum = n4++;
                    }
                }
            }
        }
        if (n4 <= this.numpaths) {
            throw new JuggleExceptionInternal("Problem assigning path numbers 2");
        }
    }

    protected void findThrowSources() throws JuggleExceptionInternal {
        for (int i = this.indexes - 1; i >= 0; --i) {
            for (int j = 0; j < this.numjugglers; ++j) {
                for (int k = 0; k < 2; ++k) {
                    for (int i2 = 0; i2 < this.max_occupancy; ++i2) {
                        MHNThrow mHNThrow = this.th[j][k][i][i2];
                        if (mHNThrow == null || mHNThrow.source != null) continue;
                        if (i + this.getPeriod() >= this.indexes) {
                            throw new JuggleExceptionInternal("Could not get throw source 2");
                        }
                        MHNThrow mHNThrow2 = this.th[j][k][i + this.getPeriod()][i2].source;
                        if (mHNThrow2 == null) {
                            throw new JuggleExceptionInternal("Could not get throw source 1");
                        }
                        MHNThrow mHNThrow3 = new MHNThrow();
                        mHNThrow3.juggler = mHNThrow2.juggler;
                        mHNThrow3.hand = mHNThrow2.hand;
                        mHNThrow3.index = mHNThrow2.index - this.getPeriod();
                        mHNThrow3.slot = mHNThrow2.slot;
                        mHNThrow3.targetjuggler = j;
                        mHNThrow3.targethand = k;
                        mHNThrow3.targetindex = i;
                        mHNThrow3.targetslot = i2;
                        mHNThrow3.handsindex = -1;
                        mHNThrow3.pathnum = mHNThrow.pathnum;
                        mHNThrow3.mod = mHNThrow2.mod;
                        mHNThrow3.master = mHNThrow2.master;
                        mHNThrow3.source = null;
                        mHNThrow3.target = mHNThrow;
                        mHNThrow.source = mHNThrow3;
                    }
                }
            }
        }
    }

    protected static boolean isCatchOrderIncorrect(MHNThrow mHNThrow, MHNThrow mHNThrow2) {
        int n;
        int n2;
        if (mHNThrow.source.index > mHNThrow2.source.index) {
            return true;
        }
        if (mHNThrow.source.index < mHNThrow2.source.index) {
            return false;
        }
        int n3 = Math.abs(mHNThrow.juggler - mHNThrow.source.juggler);
        if (n3 < (n2 = Math.abs(mHNThrow2.juggler - mHNThrow2.source.juggler))) {
            return true;
        }
        if (n3 > n2) {
            return false;
        }
        int n4 = Math.abs(mHNThrow.hand - mHNThrow.source.hand);
        if (n4 > (n = Math.abs(mHNThrow2.hand - mHNThrow2.source.hand))) {
            return true;
        }
        if (n4 < n) {
            return false;
        }
        return false;
    }

    protected void setCatchOrder() throws JuggleExceptionInternal {
        int n;
        int n2;
        int n3;
        int n4;
        MHNThrow[][][][] mHNThrowArray = this.getThrows();
        for (n4 = 0; n4 < this.getIndexes(); ++n4) {
            for (n3 = 0; n3 < this.getNumberOfJugglers(); ++n3) {
                for (n2 = 0; n2 < 2; ++n2) {
                    MHNThrow mHNThrow;
                    int n5;
                    n = 0;
                    for (n5 = 0; n5 < this.getMaxOccupancy() && (mHNThrow = mHNThrowArray[n3][n2][n4][n5]) != null; ++n5) {
                        boolean bl = mHNThrow.catching = mHNThrow.source.mod.charAt(0) != 'H';
                        if (!mHNThrow.catching) continue;
                        mHNThrow.catchnum = n++;
                    }
                    if (n < 2) continue;
                    for (n5 = 0; n5 < this.getMaxOccupancy() && (mHNThrow = mHNThrowArray[n3][n2][n4][n5]) != null && mHNThrow.master == mHNThrow; ++n5) {
                        MHNThrow mHNThrow2;
                        if (!mHNThrow.catching) continue;
                        for (int i = n5 + 1; i < this.getMaxOccupancy() && (mHNThrow2 = mHNThrowArray[n3][n2][n4][i]) != null && mHNThrow2.master == mHNThrow2; ++i) {
                            if (!mHNThrow2.catching) continue;
                            boolean bl = false;
                            bl = mHNThrow.catchnum < mHNThrow2.catchnum ? MHNPattern.isCatchOrderIncorrect(mHNThrow, mHNThrow2) : MHNPattern.isCatchOrderIncorrect(mHNThrow2, mHNThrow);
                            if (!bl) continue;
                            int n6 = mHNThrow.catchnum;
                            mHNThrow.catchnum = mHNThrow2.catchnum;
                            mHNThrow2.catchnum = n6;
                        }
                    }
                }
            }
        }
        for (n4 = 0; n4 < this.getIndexes(); ++n4) {
            for (n3 = 0; n3 < this.getNumberOfJugglers(); ++n3) {
                for (n2 = 0; n2 < 2; ++n2) {
                    MHNThrow mHNThrow;
                    for (n = 0; n < this.getMaxOccupancy() && (mHNThrow = mHNThrowArray[n3][n2][n4][n]) != null && mHNThrow.master != mHNThrow; ++n) {
                        mHNThrow.catchnum = mHNThrow.master.catchnum;
                    }
                }
            }
        }
    }

    protected String getInternalRepresentation() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("numjugglers = " + this.getNumberOfJugglers() + "\n");
        stringBuffer.append("numpaths = " + this.getNumberOfPaths() + "\n");
        stringBuffer.append("period = " + this.getPeriod() + "\n");
        stringBuffer.append("max_occupancy = " + this.getMaxOccupancy() + "\n");
        stringBuffer.append("max_throw = " + this.getMaxThrow() + "\n");
        stringBuffer.append("indexes = " + this.getIndexes() + "\n");
        stringBuffer.append("throws:\n");
        for (int i = 0; i < this.getIndexes(); ++i) {
            for (int j = 0; j < this.numjugglers; ++j) {
                for (int k = 0; k < 2; ++k) {
                    for (int i2 = 0; i2 < this.getMaxOccupancy(); ++i2) {
                        stringBuffer.append("  th[" + j + "][" + k + "][" + i + "][" + i2 + "] = ");
                        MHNThrow mHNThrow = this.th[j][k][i][i2];
                        if (mHNThrow == null) {
                            stringBuffer.append("null\n");
                            continue;
                        }
                        stringBuffer.append(mHNThrow.toString() + "\n");
                    }
                }
            }
        }
        stringBuffer.append("symmetries:\n");
        stringBuffer.append("hands:\n");
        stringBuffer.append("bodies:\n");
        return stringBuffer.toString();
    }

    public int[][][] getStartingState(int n) {
        int[][][] nArray = new int[this.getNumberOfJugglers()][2][n];
        for (int i = this.getPeriod(); i < this.getIndexes(); ++i) {
            for (int j = 0; j < this.numjugglers; ++j) {
                for (int k = 0; k < 2; ++k) {
                    for (int i2 = 0; i2 < this.getMaxOccupancy(); ++i2) {
                        MHNThrow mHNThrow = this.th[j][k][i][i2];
                        if (mHNThrow == null || mHNThrow.source.index >= this.getPeriod() || i - this.getPeriod() >= n) continue;
                        int[] nArray2 = nArray[j][k];
                        int n2 = i - this.getPeriod();
                        nArray2[n2] = nArray2[n2] + 1;
                    }
                }
            }
        }
        return nArray;
    }

    @Override
    public JMLPattern asJMLPattern() throws JuggleExceptionUser, JuggleExceptionInternal {
        double d;
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        JMLPattern jMLPattern = new JMLPattern();
        jMLPattern.setNumberOfJugglers(this.getNumberOfJugglers());
        jMLPattern.setNumberOfPaths(this.getNumberOfPaths());
        if (this.bps <= 0.0) {
            this.bps = this.calcBps();
        }
        int n5 = this.getNumberOfPaths();
        int n6 = this.color == null ? 1 : Math.min(n5, this.color.length);
        for (int i = 0; i < n6; ++i) {
            Object object2 = null;
            if (this.propdiam != propdiam_default) {
                object2 = "diam=" + this.propdiam;
            }
            if (this.color != null) {
                object = "color=" + this.color[i];
                object2 = object2 == null ? object : (String)object2 + ";" + (String)object;
            }
            jMLPattern.addProp(new PropDef(this.getPropName(), (String)object2));
        }
        int[] nArray = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            nArray[n4] = 1 + n4 % n6;
        }
        jMLPattern.setPropAssignments(nArray);
        for (n4 = 0; n4 < this.getNumberOfSymmetries(); ++n4) {
            Object object3;
            int n7;
            Object object4;
            object = this.getSymmetry(n4);
            int[] nArray2 = new int[n5 + 1];
            switch (((MHNSymmetry)object).getType()) {
                case 1: {
                    MHNThrow mHNThrow;
                    int n8;
                    int n9;
                    int n10;
                    n3 = 1;
                    object4 = this.getThrows();
                    for (n7 = 0; n7 < this.getIndexes() - ((MHNSymmetry)object).getDelay(); ++n7) {
                        for (n10 = 0; n10 < this.getNumberOfJugglers(); ++n10) {
                            for (n9 = 0; n9 < 2; ++n9) {
                                for (n8 = 0; n8 < this.getMaxOccupancy(); ++n8) {
                                    MHNThrow mHNThrow2 = object4[n10][n9][n7][n8];
                                    if (mHNThrow2 == null || mHNThrow2.pathnum == -1) continue;
                                    mHNThrow = object4[n10][n9][n7 + ((MHNSymmetry)object).getDelay()][n8];
                                    if (mHNThrow == null) {
                                        throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_paths"));
                                    }
                                    if (mHNThrow2.pathnum == 0 || mHNThrow.pathnum == 0) {
                                        throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_paths"));
                                    }
                                    if (nArray2[mHNThrow2.pathnum] == 0) {
                                        nArray2[mHNThrow2.pathnum] = mHNThrow.pathnum;
                                        continue;
                                    }
                                    if (nArray2[mHNThrow2.pathnum] == mHNThrow.pathnum) continue;
                                    throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_delay"));
                                }
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
                case 3: {
                    MHNThrow mHNThrow;
                    int n8;
                    int n9;
                    int n10;
                    n3 = 3;
                    object4 = ((MHNSymmetry)object).getJugglerPerm();
                    object3 = this.getThrows();
                    for (n10 = 0; n10 < this.getIndexes() - ((MHNSymmetry)object).getDelay(); ++n10) {
                        for (n9 = 0; n9 < this.getNumberOfJugglers(); ++n9) {
                            for (n8 = 0; n8 < 2; ++n8) {
                                for (int i = 0; i < this.getMaxOccupancy(); ++i) {
                                    int n11;
                                    mHNThrow = object3[n9][n8][n10][i];
                                    if (mHNThrow == null || mHNThrow.pathnum == -1) continue;
                                    n2 = ((Permutation)object4).getMapping(n9 + 1);
                                    int n12 = Math.abs(n2) - 1;
                                    MHNThrow mHNThrow3 = object3[n12][n11 = n2 > 0 ? n8 : 1 - n8][n10 + ((MHNSymmetry)object).getDelay()][i];
                                    if (mHNThrow3 == null) {
                                        throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_paths"));
                                    }
                                    if (mHNThrow.pathnum == 0 || mHNThrow3.pathnum == 0) {
                                        throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_paths"));
                                    }
                                    if (nArray2[mHNThrow.pathnum] == 0) {
                                        nArray2[mHNThrow.pathnum] = mHNThrow3.pathnum;
                                        continue;
                                    }
                                    if (nArray2[mHNThrow.pathnum] == mHNThrow3.pathnum) continue;
                                    throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_switchdelay"));
                                }
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_unknown_symmetry"));
                }
            }
            object4 = "";
            for (n7 = 1; n7 < n5; ++n7) {
                object4 = (String)object4 + nArray2[n7] + ",";
            }
            object4 = (String)object4 + nArray2[n5];
            object3 = new JMLSymmetry(n3, ((MHNSymmetry)object).getNumberOfJugglers(), ((MHNSymmetry)object).getJugglerPerm().toString(), this.getNumberOfPaths(), (String)object4, (double)((MHNSymmetry)object).getDelay() / this.bps);
            jMLPattern.addSymmetry((JMLSymmetry)object3);
        }
        boolean[][] blArray = new boolean[this.getNumberOfJugglers()][2];
        for (int i = 0; i < this.getNumberOfJugglers(); ++i) {
            for (n3 = 0; n3 < 2; ++n3) {
                blArray[i][n3] = false;
            }
        }
        boolean[] blArray2 = new boolean[this.getNumberOfPaths()];
        for (n3 = 0; n3 < this.getNumberOfPaths(); ++n3) {
            blArray2[n3] = false;
        }
        MHNThrow[][][][] mHNThrowArray = this.getThrows();
        for (n = 0; n < this.getPeriod(); ++n) {
            for (int i = 0; i < this.getNumberOfJugglers(); ++i) {
                int n13;
                for (n13 = 0; n13 < 2; ++n13) {
                    int n14;
                    Coordinate coordinate;
                    int n15;
                    int n16;
                    int n17;
                    MHNThrow mHNThrow;
                    int n18;
                    int n19;
                    MHNThrow mHNThrow4 = mHNThrowArray[i][n13][n][0];
                    if (mHNThrow4 == null || mHNThrow4.master != mHNThrow4) continue;
                    JMLEvent jMLEvent = new JMLEvent();
                    double d2 = 0.0;
                    int n20 = 0;
                    n2 = 0;
                    for (int j = 0; j < this.getMaxOccupancy(); ++j) {
                        MHNThrow mHNThrow5 = mHNThrowArray[i][n13][n][j];
                        if (mHNThrow5 == null) continue;
                        String string = null;
                        String string2 = null;
                        switch (mHNThrow5.mod.charAt(0)) {
                            case 'B': {
                                string = "bounce";
                                string2 = null;
                                if (mHNThrow5.mod.indexOf("F") != -1) {
                                    string2 = string2 == null ? "forced=true" : string2 + ";forced=true";
                                }
                                if (mHNThrow5.mod.indexOf("H") != -1) {
                                    string2 = string2 == null ? "hyper=true" : string2 + ";hyper=true";
                                }
                                n19 = 1;
                                for (n18 = 1; n18 < mHNThrow5.mod.length(); ++n18) {
                                    if (mHNThrow5.mod.charAt(n18) != 'B') continue;
                                    ++n19;
                                }
                                if (n19 > 1) {
                                    string2 = string2 == null ? "bounces=" + n19 : string2 + ";bounces=" + n19;
                                }
                                if (this.bouncefrac != bouncefrac_default) {
                                    string2 = string2 == null ? "bouncefrac=" + this.bouncefrac : string2 + ";bouncefrac=" + this.bouncefrac;
                                }
                                if (this.gravity == gravity_default) break;
                                if (string2 == null) {
                                    string2 = "g=" + this.gravity;
                                    break;
                                }
                                string2 = string2 + ";g=" + this.gravity;
                                break;
                            }
                            case 'F': {
                                string = "bounce";
                                string2 = "forced=true";
                                if (this.bouncefrac != bouncefrac_default) {
                                    string2 = string2 + ";bouncefrac=" + this.bouncefrac;
                                }
                                if (this.gravity == gravity_default) break;
                                string2 = string2 + ";g=" + this.gravity;
                                break;
                            }
                            case 'H': {
                                string = "hold";
                                string2 = null;
                                break;
                            }
                            default: {
                                string = "toss";
                                string2 = null;
                                if (this.gravity == gravity_default) break;
                                string2 = "g=" + this.gravity;
                            }
                        }
                        if (mHNThrow5.mod.charAt(0) != 'H') {
                            jMLEvent.addTransition(new JMLTransition(1, mHNThrow5.pathnum, string, string2));
                            n19 = mHNThrow5.targetindex - n;
                            if (n19 == 1) {
                                n2 = 1;
                            }
                            d2 = mHNThrow5.targethand == n13 ? (d2 += n19 > 8 ? samethrowx[8] : samethrowx[n19]) : (d2 += n19 > 8 ? crossingthrowx[8] : crossingthrowx[n19]);
                            ++n20;
                            continue;
                        }
                        if (this.hands == null || mHNThrow5.pathnum == -1) continue;
                        jMLEvent.addTransition(new JMLTransition(4, mHNThrow5.pathnum, string, string2));
                        blArray2[mHNThrow5.pathnum - 1] = true;
                    }
                    if (this.hands == null) {
                        if (n20 > 0) {
                            double d3 = d2 / (double)n20;
                            if (n13 == 1) {
                                d3 = -d3;
                            }
                            jMLEvent.setLocalCoordinate(new Coordinate(d3, 0.0, 0.0));
                            jMLEvent.calcpos = false;
                        } else {
                            jMLEvent.calcpos = true;
                        }
                    } else {
                        Coordinate coordinate2 = this.hands.getCoordinate(mHNThrow4.juggler, mHNThrow4.handsindex, 0);
                        if (n13 == 1) {
                            coordinate2.x = -coordinate2.x;
                        }
                        jMLEvent.setLocalCoordinate(coordinate2);
                        jMLEvent.calcpos = false;
                    }
                    double d4 = n2 != 0 ? ((double)n - 0.25 * this.dwell) / this.bps : (double)n / this.bps;
                    jMLEvent.setT(d4);
                    jMLEvent.setHand(i + 1, n13 == 0 ? 2 : 1);
                    jMLPattern.addEvent(jMLEvent);
                    for (int j = 0; j < this.indexes; ++j) {
                        for (int k = 0; k < this.numjugglers; ++k) {
                            for (n19 = 0; n19 < 2; ++n19) {
                                for (n18 = 0; n18 < this.max_occupancy; ++n18) {
                                    MHNThrow mHNThrow6 = mHNThrowArray[k][n19][j][n18];
                                    if (mHNThrow6 == null || mHNThrow6.master != mHNThrow4) continue;
                                    blArray[k][n19] = true;
                                }
                            }
                        }
                    }
                    double d5 = 0.0;
                    n19 = 0;
                    n18 = 0;
                    for (int j = 0; j < this.getMaxOccupancy() && (mHNThrow = mHNThrowArray[i][n13][n][j]) != null; ++j) {
                        if (!mHNThrow.catching) continue;
                        n17 = mHNThrow.pathnum;
                        n16 = n - mHNThrow.source.index;
                        blArray2[n17 - 1] = true;
                        d5 += n16 > 8 ? catchx[8] : catchx[n16];
                        ++n19;
                        if (n16 != 1) continue;
                        n18 = 1;
                    }
                    d = 0.0;
                    if (n19 < 2) {
                        MHNThrow mHNThrow7;
                        jMLEvent = new JMLEvent();
                        if (this.hands == null) {
                            if (n19 > 0) {
                                double d6 = d5 / (double)n19;
                                jMLEvent.setLocalCoordinate(new Coordinate(n13 == 0 ? d6 : -d6, 0.0, 0.0));
                                jMLEvent.calcpos = false;
                            } else {
                                jMLEvent.calcpos = true;
                            }
                        } else {
                            for (n17 = mHNThrow4.handsindex - 2; n17 < 0; n17 += this.hands.getPeriod(mHNThrow4.juggler)) {
                            }
                            n16 = this.hands.getCatchIndex(mHNThrow4.juggler, n17);
                            Coordinate coordinate3 = this.hands.getCoordinate(mHNThrow4.juggler, n17, n16);
                            if (n13 == 1) {
                                coordinate3.x = -coordinate3.x;
                            }
                            jMLEvent.setLocalCoordinate(coordinate3);
                            jMLEvent.calcpos = false;
                        }
                        d = n18 != 0 ? ((double)n - 0.5 * this.dwell) / this.bps : ((double)n - this.dwell) / this.bps;
                        jMLEvent.setT(d);
                        jMLEvent.setHand(i + 1, n13 == 0 ? 2 : 1);
                        for (n17 = 0; n17 < this.getMaxOccupancy() && (mHNThrow7 = mHNThrowArray[i][n13][n][n17]) != null; ++n17) {
                            if (mHNThrow7.catching) {
                                jMLEvent.addTransition(new JMLTransition(2, mHNThrow7.pathnum, null, null));
                                continue;
                            }
                            if (this.hands == null || mHNThrow7.pathnum == -1) continue;
                            jMLEvent.addTransition(new JMLTransition(4, mHNThrow7.pathnum, null, null));
                            blArray2[mHNThrow7.pathnum - 1] = true;
                        }
                        jMLPattern.addEvent(jMLEvent);
                    } else {
                        for (n17 = 0; n17 < this.getMaxOccupancy(); ++n17) {
                            MHNThrow mHNThrow8 = mHNThrowArray[i][n13][n][n17];
                            if (mHNThrow8 == null || !mHNThrow8.catching) continue;
                            jMLEvent = new JMLEvent();
                            if (this.hands == null) {
                                double d7 = d5 / (double)n19;
                                jMLEvent.setLocalCoordinate(new Coordinate(n13 == 0 ? d7 : -d7, 0.0, 0.0));
                            } else {
                                int n21;
                                for (n21 = mHNThrow4.handsindex - 2; n21 < 0; n21 += this.hands.getPeriod(mHNThrow4.juggler)) {
                                }
                                n15 = this.hands.getCatchIndex(mHNThrow4.juggler, n21);
                                coordinate = this.hands.getCoordinate(mHNThrow4.juggler, n21, n15);
                                if (n13 == 1) {
                                    coordinate.x = -coordinate.x;
                                }
                                jMLEvent.setLocalCoordinate(coordinate);
                            }
                            jMLEvent.calcpos = false;
                            double d8 = n18 != 0 ? ((double)n - 0.5 * this.dwell + ((double)mHNThrow8.catchnum / (double)(n19 - 1) - 0.5) * 0.4) / this.bps : ((double)n - this.dwell + ((double)mHNThrow8.catchnum / (double)(n19 - 1) - 0.5) * 0.4) / this.bps;
                            jMLEvent.setT(d8);
                            if (mHNThrow4.catchnum == n19 - 1) {
                                d = d8;
                            }
                            jMLEvent.setHand(i + 1, n13 == 0 ? 2 : 1);
                            jMLEvent.addTransition(new JMLTransition(2, mHNThrow8.pathnum, null, null));
                            jMLPattern.addEvent(jMLEvent);
                        }
                    }
                    if (this.hands == null) continue;
                    for (n17 = mHNThrow4.handsindex - 2; n17 < 0; n17 += this.hands.getPeriod(mHNThrow4.juggler)) {
                    }
                    int n22 = this.hands.getCatchIndex(mHNThrow4.juggler, n17);
                    int n23 = this.hands.getNumberOfCoordinates(mHNThrow4.juggler, n17) - n22;
                    for (n15 = 1; n15 < n23; ++n15) {
                        coordinate = this.hands.getCoordinate(mHNThrow4.juggler, n17, n22 + n15);
                        if (coordinate == null) continue;
                        jMLEvent = new JMLEvent();
                        if (n13 == 1) {
                            coordinate.x = -coordinate.x;
                        }
                        jMLEvent.setLocalCoordinate(coordinate);
                        jMLEvent.calcpos = false;
                        jMLEvent.setT(d + (double)n15 * (d4 - d) / (double)n23);
                        jMLEvent.setHand(mHNThrow4.juggler, n13 == 0 ? 2 : 1);
                        jMLPattern.addEvent(jMLEvent);
                    }
                    double d9 = d;
                    for (n14 = n + 1; n14 < this.getIndexes(); ++n14) {
                        MHNThrow mHNThrow9;
                        int n24 = 0;
                        boolean bl = false;
                        boolean bl2 = false;
                        for (int j = 0; j < this.getMaxOccupancy() && (mHNThrow9 = mHNThrowArray[i][n13][n14][j]) != null; ++j) {
                            bl = true;
                            if (!mHNThrow9.catching) continue;
                            ++n24;
                            if (n14 - mHNThrow9.source.index != 1) continue;
                            bl2 = true;
                        }
                        if (!bl) continue;
                        if (n24 < 2) {
                            if (bl2) {
                                d9 = ((double)n14 - 0.5 * this.dwell) / this.bps;
                                break;
                            }
                            d9 = ((double)n14 - this.dwell) / this.bps;
                            break;
                        }
                        if (bl2) {
                            d9 = ((double)n14 - 0.5 * this.dwell - 0.2) / this.bps;
                            break;
                        }
                        d9 = ((double)n14 - this.dwell - 0.2) / this.bps;
                        break;
                    }
                    if (d9 == d) {
                        throw new JuggleExceptionInternal("Couldn't find next catch/hold past t=" + d);
                    }
                    n17 = mHNThrow4.handsindex;
                    n23 = this.hands.getCatchIndex(mHNThrow4.juggler, n17);
                    for (n14 = 1; n14 < n23; ++n14) {
                        Coordinate coordinate4 = this.hands.getCoordinate(mHNThrow4.juggler, n17, n14);
                        if (coordinate4 == null) continue;
                        jMLEvent = new JMLEvent();
                        if (n13 == 1) {
                            coordinate4.x = -coordinate4.x;
                        }
                        jMLEvent.setLocalCoordinate(coordinate4);
                        jMLEvent.calcpos = false;
                        jMLEvent.setT(d4 + (double)n14 * (d9 - d4) / (double)n23);
                        jMLEvent.setHand(mHNThrow4.juggler, n13 == 0 ? 2 : 1);
                        jMLPattern.addEvent(jMLEvent);
                    }
                }
                if (this.bodies == null) continue;
                n13 = n % this.bodies.getPeriod(i + 1);
                int n25 = this.bodies.getNumberOfPositions(i + 1, n13);
                for (int j = 0; j < n25; ++j) {
                    JMLPosition jMLPosition = this.bodies.getPosition(i + 1, n13, j);
                    if (jMLPosition == null) continue;
                    jMLPosition.setT(((double)n + (double)j / (double)n25) / this.bps);
                    jMLPattern.addPosition(jMLPosition);
                }
            }
        }
        for (n = 0; n < this.getNumberOfJugglers(); ++n) {
            for (int i = 0; i < 2; ++i) {
                if (blArray[n][i]) continue;
                JMLEvent jMLEvent = new JMLEvent();
                jMLEvent.setLocalCoordinate(new Coordinate(i == 0 ? 25.0 : -25.0, 0.0, 0.0));
                jMLEvent.setT(-1.0);
                jMLEvent.setHand(n + 1, i == 0 ? 2 : 1);
                jMLEvent.calcpos = false;
                jMLPattern.addEvent(jMLEvent);
            }
        }
        for (n = 0; n < jMLPattern.getNumberOfSymmetries(); ++n) {
            Permutation permutation = jMLPattern.getSymmetry(n).getPathPerm();
            for (int i = 0; i < this.getNumberOfPaths(); ++i) {
                if (!blArray2[i]) continue;
                for (int j = 1; j < permutation.getOrder(i + 1); ++j) {
                    blArray2[permutation.getMapping((int)(i + 1), (int)j) - 1] = true;
                }
            }
        }
        for (n = 0; n < this.getNumberOfPaths(); ++n) {
            int n26;
            int n27;
            if (blArray2[n]) continue;
            int n28 = 1;
            int n29 = 0;
            block61: for (int i = 0; i < this.getIndexes(); ++i) {
                for (n27 = 0; n27 < this.getNumberOfJugglers(); ++n27) {
                    for (int j = 0; j < 2; ++j) {
                        for (n26 = 0; n26 < this.getMaxOccupancy(); ++n26) {
                            MHNThrow mHNThrow = mHNThrowArray[n27][j][i][n26];
                            if (mHNThrow == null || mHNThrow.pathnum != n + 1) continue;
                            n28 = j == 0 ? 2 : 1;
                            n29 = n27;
                            break block61;
                        }
                    }
                }
            }
            for (JMLEvent jMLEvent = jMLPattern.getEventList(); jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
                if (jMLEvent.getHand() != n28 || jMLEvent.getJuggler() != n29 + 1) continue;
                jMLEvent.addTransition(new JMLTransition(4, n + 1, null, null));
                blArray2[n] = true;
                for (n27 = 0; n27 < jMLPattern.getNumberOfSymmetries(); ++n27) {
                    Permutation permutation = jMLPattern.getSymmetry(n27).getPathPerm();
                    for (n26 = 1; n26 < permutation.getOrder(n + 1); ++n26) {
                        blArray2[permutation.getMapping((int)(n + 1), (int)n26) - 1] = true;
                    }
                }
            }
        }
        jMLPattern.buildEventList();
        for (n = 1; n <= this.getNumberOfJugglers(); ++n) {
            for (int i = 0; i < 2; ++i) {
                JMLEvent jMLEvent;
                int n30 = i == 0 ? 2 : 1;
                JMLEvent jMLEvent2 = null;
                int n31 = 1;
                for (jMLEvent = jMLPattern.getEventList(); jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
                    if (jMLEvent.getJuggler() != n || jMLEvent.getHand() != n30) continue;
                    if (jMLEvent.calcpos) {
                        n31 = 3;
                        continue;
                    }
                    switch (n31) {
                        case 1: {
                            n31 = 2;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            if (jMLEvent2 != null) {
                                JMLEvent jMLEvent3 = jMLEvent;
                                double d10 = jMLEvent3.getT();
                                Coordinate coordinate = jMLEvent3.getLocalCoordinate();
                                double d11 = jMLEvent2.getT();
                                Coordinate coordinate5 = jMLEvent2.getLocalCoordinate();
                                for (jMLEvent = jMLEvent2.getNext(); jMLEvent != jMLEvent3; jMLEvent = jMLEvent.getNext()) {
                                    if (jMLEvent.getJuggler() != n || jMLEvent.getHand() != n30) continue;
                                    double d12 = jMLEvent.getT();
                                    d = coordinate5.x + (d12 - d11) * (coordinate.x - coordinate5.x) / (d10 - d11);
                                    double d13 = coordinate5.y + (d12 - d11) * (coordinate.y - coordinate5.y) / (d10 - d11);
                                    double d14 = coordinate5.z + (d12 - d11) * (coordinate.z - coordinate5.z) / (d10 - d11);
                                    jMLEvent.setLocalCoordinate(new Coordinate(d, d13, d14));
                                    jMLEvent.calcpos = false;
                                }
                            }
                            n31 = 2;
                        }
                    }
                    jMLEvent2 = jMLEvent;
                }
                for (jMLEvent = jMLPattern.getEventList(); jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
                    if (jMLEvent.getJuggler() != n || jMLEvent.getHand() != n30 || !jMLEvent.calcpos) continue;
                    jMLEvent.setLocalCoordinate(new Coordinate(i == 0 ? 25.0 : -25.0, 0.0, 0.0));
                    jMLEvent.calcpos = false;
                }
            }
        }
        for (n = 0; n < this.getNumberOfPaths(); ++n) {
            boolean bl = false;
            boolean bl3 = false;
            int n32 = 0;
            int n33 = 0;
            JMLEvent jMLEvent = jMLPattern.getEventList();
            block74: while (jMLEvent != null) {
                JMLTransition jMLTransition = jMLEvent.getPathTransition(n + 1, 5);
                if (jMLTransition != null) {
                    switch (jMLTransition.getType()) {
                        case 1: {
                            if (!bl3 && !bl) {
                                bl = true;
                                n32 = jMLEvent.getJuggler();
                                n33 = jMLEvent.getHand();
                                jMLEvent = jMLPattern.getEventList();
                                continue block74;
                            }
                            bl = false;
                            break;
                        }
                        case 2: 
                        case 3: {
                            bl = true;
                            n32 = jMLEvent.getJuggler();
                            n33 = jMLEvent.getHand();
                            break;
                        }
                        case 4: {
                            if (!bl3 && !bl) {
                                bl = true;
                                n32 = jMLEvent.getJuggler();
                                n33 = jMLEvent.getHand();
                                jMLEvent = jMLPattern.getEventList();
                                continue block74;
                            }
                            bl = true;
                            n32 = jMLEvent.getJuggler();
                            n33 = jMLEvent.getHand();
                        }
                    }
                    bl3 = true;
                } else if (bl && jMLEvent.getJuggler() == n32 && jMLEvent.getHand() == n33 && jMLEvent.isMaster()) {
                    jMLEvent.addTransition(new JMLTransition(4, n + 1, null, null));
                }
                jMLEvent = jMLEvent.getNext();
            }
        }
        if (this.title != null) {
            jMLPattern.setTitle(this.title);
        }
        return jMLPattern;
    }

    protected double calcBps() {
        double d = 0.0;
        MHNThrow[][][][] mHNThrowArray = this.getThrows();
        int n = 0;
        for (int i = 0; i < this.getPeriod(); ++i) {
            for (int j = 0; j < this.getNumberOfJugglers(); ++j) {
                for (int k = 0; k < 2; ++k) {
                    for (int i2 = 0; i2 < this.getMaxOccupancy(); ++i2) {
                        int n2;
                        MHNThrow mHNThrow = mHNThrowArray[j][k][i][i2];
                        if (mHNThrow == null || (n2 = mHNThrow.targetindex - i) <= 2) continue;
                        d += throwspersec[n2 > 9 ? 9 : n2];
                        ++n;
                    }
                }
            }
        }
        d = n > 0 ? (d /= (double)n) : 2.0;
        return d;
    }
}

