/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import jugglinglab.JugglingLab;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class MHNHands {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected int jugglers;
    protected int[] size;
    protected int[][] coords;
    protected int[][] catches;
    protected double[][][][] handpath;

    public MHNHands(String string) throws JuggleExceptionUser, JuggleExceptionInternal {
        string = JLFunc.expandRepeats(string);
        String string2 = "[" + Pattern.quote("<>{}") + "]";
        string = string.replaceAll(string2, "");
        for (int i = 0; i < 4; ++i) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            boolean bl2 = false;
            int n4 = 0;
            while (n4 < string.length()) {
                Object object;
                char c = string.charAt(n4);
                if (c == ' ') {
                    ++n4;
                    continue;
                }
                if (c == '.') {
                    if (i == 2) {
                        this.coords[n][n2] = n3;
                        if (this.coords[n][n2] < 2) {
                            throw new JuggleExceptionUser(errorstrings.getString("Error_hands_toofewcoords"));
                        }
                        this.handpath[n][n2] = new double[n3][];
                    } else if (i == 3) {
                        if (!bl2) {
                            this.catches[n][n2] = this.coords[n][n2] - 1;
                        }
                        if (this.handpath[n][n2][0] == null) {
                            throw new JuggleExceptionUser(errorstrings.getString("Error_hands_nothrow"));
                        }
                        if (this.handpath[n][n2][this.catches[n][n2]] == null) {
                            throw new JuggleExceptionUser(errorstrings.getString("Error_hands_nocatch"));
                        }
                    }
                    bl2 = false;
                    bl = false;
                    ++n2;
                    n3 = 0;
                    ++n4;
                    continue;
                }
                if (c == '-') {
                    if (i == 3) {
                        this.handpath[n][n2][n3] = null;
                    }
                    ++n3;
                    ++n4;
                    continue;
                }
                if (c == 'T' || c == 't') {
                    if (n3 != 0) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_hands_Tnotstart"));
                    }
                    if (bl) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_hands_toomanycoords"));
                    }
                    bl = true;
                    ++n4;
                    continue;
                }
                if (c == 'C' || c == 'c') {
                    if (n3 == 0) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_hands_Catstart"));
                    }
                    if (bl2) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_hands_toomanycatches"));
                    }
                    if (i == 2) {
                        this.catches[n][n2] = n3;
                    }
                    bl2 = true;
                    ++n4;
                    continue;
                }
                if (c == '(') {
                    int n5 = string.indexOf(41, n4 + 1);
                    if (n5 < 0) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_hands_noparen"));
                    }
                    if (i == 3) {
                        this.handpath[n][n2][n3] = new double[3];
                        object = string.substring(n4 + 1, n5);
                        try {
                            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",", false);
                            this.handpath[n][n2][n3][0] = Double.valueOf(stringTokenizer.nextToken());
                            if (stringTokenizer.hasMoreTokens()) {
                                this.handpath[n][n2][n3][2] = Double.valueOf(stringTokenizer.nextToken());
                            }
                            if (stringTokenizer.hasMoreTokens()) {
                                this.handpath[n][n2][n3][1] = Double.valueOf(stringTokenizer.nextToken());
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new JuggleExceptionUser(errorstrings.getString("Error_hands_coordinate"));
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            throw new JuggleExceptionInternal("No such element exception in \"hands\"");
                        }
                    }
                    ++n3;
                    n4 = n5 + 1;
                    continue;
                }
                if (c == '|' || c == '!') {
                    if (n3 != 0) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_hands_badending"));
                    }
                    if (i == 1) {
                        this.size[n] = n2;
                        this.catches[n] = new int[n2];
                        this.coords[n] = new int[n2];
                        this.handpath[n] = new double[n2][][];
                    }
                    n2 = 0;
                    ++n;
                    ++n4;
                    continue;
                }
                String string3 = errorstrings.getString("Error_hands_character");
                object = new Object[]{Character.toString(c)};
                throw new JuggleExceptionUser(MessageFormat.format(string3, object));
            }
            if (n3 != 0) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_hands_badending"));
            }
            if (i == 0) {
                this.jugglers = n + 1;
                this.size = new int[this.jugglers];
                this.coords = new int[this.jugglers][];
                this.catches = new int[this.jugglers][];
                this.handpath = new double[this.jugglers][][][];
                continue;
            }
            if (i != 1) continue;
            this.size[n] = n2;
            this.catches[n] = new int[n2];
            this.coords[n] = new int[n2];
            this.handpath[n] = new double[n2][][];
        }
    }

    public int getPeriod(int n) {
        int n2 = (n - 1) % this.jugglers;
        return this.size[n2];
    }

    public int getNumberOfCoordinates(int n, int n2) {
        int n3 = (n - 1) % this.jugglers;
        return this.coords[n3][n2];
    }

    public int getCatchIndex(int n, int n2) {
        int n3 = (n - 1) % this.jugglers;
        return this.catches[n3][n2];
    }

    public Coordinate getCoordinate(int n, int n2, int n3) {
        if (n2 >= this.getPeriod(n) || n3 >= this.getNumberOfCoordinates(n, n2)) {
            return null;
        }
        int n4 = (n - 1) % this.jugglers;
        if (this.handpath[n4][n2][n3] == null) {
            return null;
        }
        return new Coordinate(this.handpath[n4][n2][n3][0], this.handpath[n4][n2][n3][1], this.handpath[n4][n2][n3][2]);
    }
}

