/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLPosition;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class MHNBody {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected int jugglers = 0;
    protected int[] size;
    protected int[][] coords;
    protected double[][][][] bodypath;

    public MHNBody(String string) throws JuggleExceptionUser, JuggleExceptionInternal {
        string = JLFunc.expandRepeats(string);
        String string2 = "[" + Pattern.quote("<>{}") + "]";
        string = string.replaceAll(string2, "");
        for (int i = 0; i < 4; ++i) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < string.length()) {
                Object object;
                char c = string.charAt(n4);
                if (c == ' ') {
                    ++n4;
                    continue;
                }
                if (c == '.') {
                    if (i == 2) {
                        if (n3 == 0) {
                            this.coords[n][n2] = 1;
                            this.bodypath[n][n2] = new double[1][];
                            this.bodypath[n][n2][0] = null;
                        } else {
                            this.coords[n][n2] = n3;
                            this.bodypath[n][n2] = new double[n3][];
                        }
                    }
                    ++n2;
                    n3 = 0;
                    ++n4;
                    continue;
                }
                if (c == '-') {
                    if (i == 3) {
                        this.bodypath[n][n2][n3] = null;
                    }
                    ++n3;
                    ++n4;
                    continue;
                }
                if (c == '(') {
                    int n5 = string.indexOf(41, n4 + 1);
                    if (n5 < 0) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_body_noparen"));
                    }
                    if (i == 3) {
                        this.bodypath[n][n2][n3] = new double[4];
                        this.bodypath[n][n2][n3][3] = 100.0;
                        object = string.substring(n4 + 1, n5);
                        try {
                            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",", false);
                            this.bodypath[n][n2][n3][0] = Double.valueOf(stringTokenizer.nextToken());
                            if (stringTokenizer.hasMoreTokens()) {
                                this.bodypath[n][n2][n3][1] = Double.valueOf(stringTokenizer.nextToken());
                            }
                            if (stringTokenizer.hasMoreTokens()) {
                                this.bodypath[n][n2][n3][2] = Double.valueOf(stringTokenizer.nextToken());
                            }
                            if (stringTokenizer.hasMoreTokens()) {
                                this.bodypath[n][n2][n3][3] = Double.valueOf(stringTokenizer.nextToken());
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new JuggleExceptionUser(errorstrings.getString("Error_body_coordinate"));
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            throw new JuggleExceptionInternal("No such element exception in MHNBody");
                        }
                    }
                    ++n3;
                    n4 = n5 + 1;
                    continue;
                }
                if (c == '|' || c == '!') {
                    if (n3 != 0) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_body_badending"));
                    }
                    if (i == 1) {
                        this.size[n] = n2;
                        this.coords[n] = new int[n2];
                        this.bodypath[n] = new double[n2][][];
                    }
                    n2 = 0;
                    ++n;
                    ++n4;
                    continue;
                }
                String string3 = errorstrings.getString("Error_body_character");
                object = new Object[]{Character.toString(c)};
                throw new JuggleExceptionUser(MessageFormat.format(string3, object));
            }
            if (n3 != 0) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_body_badending"));
            }
            if (i == 0) {
                this.jugglers = n + 1;
                this.size = new int[this.jugglers];
                this.coords = new int[this.jugglers][];
                this.bodypath = new double[this.jugglers][][][];
                continue;
            }
            if (i != 1) continue;
            this.size[n] = n2;
            this.coords[n] = new int[n2];
            this.bodypath[n] = new double[n2][][];
        }
    }

    public int getNumberOfJugglers() {
        return this.jugglers;
    }

    public int getPeriod(int n) {
        int n2 = (n - 1) % this.jugglers;
        return this.size[n2];
    }

    public int getNumberOfPositions(int n, int n2) {
        int n3 = (n - 1) % this.jugglers;
        return this.coords[n3][n2];
    }

    public JMLPosition getPosition(int n, int n2, int n3) {
        if (n2 >= this.getPeriod(n) || n3 >= this.getNumberOfPositions(n, n2)) {
            return null;
        }
        int n4 = (n - 1) % this.jugglers;
        if (this.bodypath[n4][n2][n3] == null) {
            return null;
        }
        JMLPosition jMLPosition = new JMLPosition();
        jMLPosition.setJuggler(n);
        jMLPosition.setCoordinate(new Coordinate(this.bodypath[n4][n2][n3][1], this.bodypath[n4][n2][n3][2], this.bodypath[n4][n2][n3][3]));
        jMLPosition.setAngle(this.bodypath[n4][n2][n3][0]);
        return jMLPosition;
    }
}

