/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.jml.JMLNode;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;

public class JMLSymmetry {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    int type;
    int numjugglers;
    int numpaths;
    Permutation jugglerperm = null;
    Permutation pathperm = null;
    double delay = -1.0;
    public static final int TYPE_DELAY = 1;
    public static final int TYPE_SWITCH = 2;
    public static final int TYPE_SWITCHDELAY = 3;

    public JMLSymmetry() {
    }

    public JMLSymmetry(int n, int n2, String string, int n3, String string2, double d) throws JuggleExceptionUser {
        this.setType(n);
        this.setJugglerPerm(n2, string);
        this.setPathPerm(n3, string2);
        this.setDelay(d);
    }

    public int getType() {
        return this.type;
    }

    protected void setType(int n) {
        this.type = n;
    }

    public int getNumberOfJugglers() {
        return this.numjugglers;
    }

    public Permutation getJugglerPerm() {
        return this.jugglerperm;
    }

    protected void setJugglerPerm(int n, String string) throws JuggleExceptionUser {
        this.numjugglers = n;
        try {
            this.jugglerperm = string == null ? new Permutation(this.numjugglers, true) : new Permutation(this.numjugglers, string, true);
        }
        catch (JuggleException juggleException) {
            throw new JuggleExceptionUser(juggleException.getMessage());
        }
    }

    public int getNumberOfPaths() {
        return this.numpaths;
    }

    public Permutation getPathPerm() {
        return this.pathperm;
    }

    protected void setPathPerm(int n, String string) throws JuggleExceptionUser {
        this.numpaths = n;
        try {
            this.pathperm = string == null ? new Permutation(this.numpaths, false) : new Permutation(this.numpaths, string, false);
        }
        catch (JuggleException juggleException) {
            throw new JuggleExceptionUser(juggleException.getMessage());
        }
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(double d) {
        this.delay = d;
    }

    public void readJML(JMLNode jMLNode, int n, int n2, String string) throws JuggleExceptionUser {
        int n3;
        JMLAttributes jMLAttributes = jMLNode.getAttributes();
        double d = -1.0;
        String string2 = jMLAttributes.getAttribute("type");
        String string3 = jMLAttributes.getAttribute("jperm");
        String string4 = jMLAttributes.getAttribute("pperm");
        String string5 = jMLAttributes.getAttribute("delay");
        if (string5 != null) {
            try {
                d = Double.valueOf(string5);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_symmetry_format"));
            }
        }
        if (string2 == null) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_symmetry_notype"));
        }
        if (string2.equalsIgnoreCase("delay")) {
            n3 = 1;
        } else if (string2.equalsIgnoreCase("switch")) {
            n3 = 2;
        } else if (string2.equalsIgnoreCase("switchdelay")) {
            n3 = 3;
        } else {
            throw new JuggleExceptionUser(errorstrings.getString("Error_symmetry_type"));
        }
        this.setType(n3);
        this.setJugglerPerm(n, string3);
        this.setPathPerm(n2, string4);
        this.setDelay(d);
    }

    public void writeJML(PrintWriter printWriter) throws IOException {
        String string = "<symmetry type=\"";
        switch (this.getType()) {
            case 1: {
                string = string + "delay\" pperm=\"" + this.pathperm.toString(true) + "\" delay=\"" + JLFunc.toStringTruncated(this.getDelay(), 4) + "\"/>";
                break;
            }
            case 2: {
                string = string + "switch\" jperm=\"" + this.jugglerperm.toString(true) + "\" pperm=\"" + this.pathperm.toString(true) + "\"/>";
                break;
            }
            case 3: {
                string = string + "switchdelay\" jperm=\"" + this.jugglerperm.toString(true) + "\" pperm=\"" + this.pathperm.toString(true) + "\"/>";
            }
        }
        printWriter.println(string);
    }
}

