/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import jugglinglab.JugglingLab;
import jugglinglab.curve.Curve;
import jugglinglab.curve.LineCurve;
import jugglinglab.curve.SplineCurve;
import jugglinglab.jml.EventImages;
import jugglinglab.jml.HandLink;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.jml.JMLDefs;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLParser;
import jugglinglab.jml.JMLPosition;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.jml.PathLink;
import jugglinglab.jml.PropDef;
import jugglinglab.jml.VelocityRef;
import jugglinglab.path.BouncePath;
import jugglinglab.path.Path;
import jugglinglab.prop.Prop;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;
import org.xml.sax.SAXException;

public class JMLPattern {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected String version = "1.2";
    protected String title;
    protected int numjugglers;
    protected int numpaths;
    protected ArrayList<PropDef> props = new ArrayList();
    protected int[] propassignment;
    protected boolean[] hasVDPathJMLTransition;
    protected boolean[][] hasVDHandJMLTransition;
    protected ArrayList<JMLSymmetry> symmetries = new ArrayList();
    protected JMLEvent eventlist;
    protected JMLPosition positionlist;
    protected boolean laidout = false;
    protected boolean valid = true;
    protected ArrayList<ArrayList<PathLink>> pathlinks;
    protected ArrayList<ArrayList<ArrayList<HandLink>>> handlinks;
    protected Curve[] jugglercurve;
    protected Curve[] jugglerangle;
    String loadingversion = null;

    public JMLPattern() {
    }

    public JMLPattern(JMLNode jMLNode) throws JuggleExceptionUser {
        this();
        this.readJML(jMLNode);
        this.valid = true;
    }

    public JMLPattern(JMLNode jMLNode, String string) throws JuggleExceptionUser {
        this();
        this.loadingversion = string;
        this.readJML(jMLNode);
        this.valid = true;
    }

    public JMLPattern(Reader reader) throws JuggleExceptionUser, SAXException, IOException {
        this();
        JMLParser jMLParser = new JMLParser();
        jMLParser.parse(reader);
        this.readJML(jMLParser.getTree());
        this.valid = true;
    }

    public void setTitle(String string) {
        this.title = string == null ? null : string.trim();
    }

    public void setNumberOfJugglers(int n) {
        this.numjugglers = n;
        this.setNeedsLayout(true);
    }

    public void setNumberOfPaths(int n) {
        this.numpaths = n;
        this.setNeedsLayout(true);
    }

    public void addProp(PropDef propDef) {
        this.props.add(propDef);
        this.setNeedsLayout(true);
    }

    public void removeProp(int n) {
        this.props.remove(n - 1);
        for (int i = 1; i <= this.getNumberOfPaths(); ++i) {
            if (this.getPropAssignment(i) <= n) continue;
            this.setPropAssignment(i, this.getPropAssignment(i) - 1);
        }
        this.setNeedsLayout(true);
    }

    public void setPropAssignment(int n, int n2) {
        this.propassignment[n - 1] = n2;
        this.setNeedsLayout(true);
    }

    public void setPropAssignments(int[] nArray) {
        this.propassignment = nArray;
        this.setNeedsLayout(true);
    }

    public void addSymmetry(JMLSymmetry jMLSymmetry) {
        this.symmetries.add(jMLSymmetry);
        this.setNeedsLayout(true);
    }

    public void addEvent(JMLEvent jMLEvent) {
        this.setNeedsLayout(true);
        if (this.eventlist == null || this.eventlist.getT() > jMLEvent.getT()) {
            jMLEvent.setPrevious(null);
            jMLEvent.setNext(this.eventlist);
            if (this.eventlist != null) {
                this.eventlist.setPrevious(jMLEvent);
            }
            this.eventlist = jMLEvent;
            return;
        }
        JMLEvent jMLEvent2 = this.eventlist;
        while (jMLEvent2.getNext() != null) {
            if (!((jMLEvent2 = jMLEvent2.getNext()).getT() > jMLEvent.getT())) continue;
            jMLEvent.setNext(jMLEvent2);
            jMLEvent.setPrevious(jMLEvent2.getPrevious());
            jMLEvent2.getPrevious().setNext(jMLEvent);
            jMLEvent2.setPrevious(jMLEvent);
            return;
        }
        jMLEvent2.setNext(jMLEvent);
        jMLEvent.setNext(null);
        jMLEvent.setPrevious(jMLEvent2);
    }

    public void removeEvent(JMLEvent jMLEvent) {
        this.setNeedsLayout(true);
        if (this.eventlist == jMLEvent) {
            this.eventlist = jMLEvent.getNext();
            if (this.eventlist != null) {
                this.eventlist.setPrevious(null);
            }
            return;
        }
        JMLEvent jMLEvent2 = jMLEvent.getNext();
        JMLEvent jMLEvent3 = jMLEvent.getPrevious();
        if (jMLEvent2 != null) {
            jMLEvent2.setPrevious(jMLEvent3);
        }
        if (jMLEvent3 != null) {
            jMLEvent3.setNext(jMLEvent2);
        }
    }

    public void setNeedsLayout(boolean bl) {
        this.laidout = !bl;
    }

    public JMLEvent getEventList() {
        return this.eventlist;
    }

    public ArrayList<ArrayList<PathLink>> getPathlinks() {
        return this.pathlinks;
    }

    public void addPosition(JMLPosition jMLPosition) throws JuggleExceptionUser {
        if (jMLPosition.getT() < this.getLoopStartTime() || jMLPosition.getT() > this.getLoopEndTime()) {
            return;
        }
        this.setNeedsLayout(true);
        if (this.positionlist == null || this.positionlist.getT() > jMLPosition.getT()) {
            jMLPosition.setPrevious(null);
            jMLPosition.setNext(this.positionlist);
            if (this.positionlist != null) {
                this.positionlist.setPrevious(jMLPosition);
            }
            this.positionlist = jMLPosition;
            return;
        }
        JMLPosition jMLPosition2 = this.positionlist;
        while (jMLPosition2.getNext() != null) {
            if (!((jMLPosition2 = jMLPosition2.getNext()).getT() > jMLPosition.getT())) continue;
            jMLPosition.setNext(jMLPosition2);
            jMLPosition.setPrevious(jMLPosition2.getPrevious());
            jMLPosition2.getPrevious().setNext(jMLPosition);
            jMLPosition2.setPrevious(jMLPosition);
            return;
        }
        jMLPosition2.setNext(jMLPosition);
        jMLPosition.setNext(null);
        jMLPosition.setPrevious(jMLPosition2);
    }

    public void removePosition(JMLPosition jMLPosition) {
        this.setNeedsLayout(true);
        if (this.positionlist == jMLPosition) {
            this.positionlist = jMLPosition.getNext();
            if (this.positionlist != null) {
                this.positionlist.setPrevious(null);
            }
            return;
        }
        JMLPosition jMLPosition2 = jMLPosition.getNext();
        JMLPosition jMLPosition3 = jMLPosition.getPrevious();
        if (jMLPosition2 != null) {
            jMLPosition2.setPrevious(jMLPosition3);
        }
        if (jMLPosition3 != null) {
            jMLPosition3.setNext(jMLPosition2);
        }
    }

    public JMLPosition getPositionList() {
        return this.positionlist;
    }

    public void layoutPattern() throws JuggleExceptionInternal, JuggleExceptionUser {
        if (!this.valid) {
            throw new JuggleExceptionInternal("Cannot do layout of invalid pattern");
        }
        if (this.getNumberOfProps() == 0) {
            this.addProp(new PropDef("ball", null));
        }
        for (int i = 0; i < this.getNumberOfProps(); ++i) {
            this.props.get(i).layoutProp();
        }
        this.buildEventList();
        this.findMasterEvents();
        this.findPositions();
        this.gotoGlobalCoordinates();
        this.buildLinkLists();
        this.layoutHandPaths();
        this.laidout = true;
    }

    public void buildEventList() throws JuggleExceptionInternal, JuggleExceptionUser {
        int n;
        int n2;
        JMLTransition jMLTransition;
        int n3;
        int n4;
        int n5;
        int n6;
        double d;
        int n7;
        int n8;
        int n9;
        JMLEvent jMLEvent;
        int n10 = 0;
        for (jMLEvent = this.eventlist; jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
            if (jMLEvent.getJuggler() < 1 || jMLEvent.getJuggler() > this.numjugglers) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_juggler_outofrange"));
            }
            if (jMLEvent.isMaster()) {
                ++n10;
                continue;
            }
            this.removeEvent(jMLEvent);
        }
        EventImages[] eventImagesArray = new EventImages[n10];
        jMLEvent = this.eventlist;
        for (int i = 0; i < n10; ++i) {
            eventImagesArray[i] = new EventImages(this, jMLEvent);
            jMLEvent = jMLEvent.getNext();
        }
        boolean[][] blArray = new boolean[this.numjugglers][2];
        boolean[][] blArray2 = new boolean[this.numjugglers][2];
        boolean[] blArray3 = new boolean[this.numpaths];
        boolean[] blArray4 = new boolean[this.numpaths];
        this.hasVDHandJMLTransition = new boolean[this.numjugglers][2];
        this.hasVDPathJMLTransition = new boolean[this.numpaths];
        for (n9 = 0; n9 < this.numjugglers; ++n9) {
            n8 = 0;
            n7 = 0;
            this.hasVDHandJMLTransition[n9][1] = false;
            this.hasVDHandJMLTransition[n9][0] = false;
            for (int i = 0; i < n10; ++i) {
                if (n8 == 0) {
                    n8 = eventImagesArray[i].hasJMLTransitionForHand(n9 + 1, 1) ? 1 : 0;
                }
                if (n7 == 0) {
                    n7 = eventImagesArray[i].hasJMLTransitionForHand(n9 + 1, 2) ? 1 : 0;
                }
                if (!this.hasVDHandJMLTransition[n9][0]) {
                    this.hasVDHandJMLTransition[n9][0] = eventImagesArray[i].hasVDJMLTransitionForHand(n9 + 1, 1);
                }
                if (this.hasVDHandJMLTransition[n9][1]) continue;
                this.hasVDHandJMLTransition[n9][1] = eventImagesArray[i].hasVDJMLTransitionForHand(n9 + 1, 2);
            }
            if (n8 == 0) {
                String string = errorstrings.getString("Error_no_left_events");
                Object[] objectArray = new Object[]{new Integer(n9 + 1)};
                throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
            }
            if (n7 == 0) {
                String string = errorstrings.getString("Error_no_right_events");
                Object[] objectArray = new Object[]{new Integer(n9 + 1)};
                throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
            }
            blArray2[n9][0] = this.hasVDHandJMLTransition[n9][0];
            blArray2[n9][1] = this.hasVDHandJMLTransition[n9][1];
            blArray[n9][1] = true;
            blArray[n9][0] = true;
        }
        for (n9 = 0; n9 < this.numpaths; ++n9) {
            n8 = 0;
            this.hasVDPathJMLTransition[n9] = false;
            for (n7 = 0; n7 < n10; ++n7) {
                if (n8 == 0) {
                    n8 = eventImagesArray[n7].hasJMLTransitionForPath(n9 + 1) ? 1 : 0;
                }
                if (this.hasVDPathJMLTransition[n9]) continue;
                this.hasVDPathJMLTransition[n9] = eventImagesArray[n7].hasVDJMLTransitionForPath(n9 + 1);
            }
            if (n8 == 0) {
                String string = errorstrings.getString("Error_no_path_events");
                Object[] objectArray = new Object[]{new Integer(n9 + 1)};
                throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
            }
            blArray3[n9] = true;
            blArray4[n9] = false;
        }
        JMLEvent[] jMLEventArray = new JMLEvent[n10];
        for (n8 = 0; n8 < n10; ++n8) {
            jMLEventArray[n8] = eventImagesArray[n8].getPrevious();
        }
        n8 = 0;
        do {
            JMLEvent jMLEvent2 = jMLEventArray[0];
            d = jMLEvent2.getT();
            n6 = 0;
            for (n5 = 1; n5 < n10; ++n5) {
                if (!(jMLEventArray[n5].getT() > d)) continue;
                jMLEvent2 = jMLEventArray[n5];
                d = jMLEvent2.getT();
                n6 = n5;
            }
            this.addEvent(jMLEvent2);
            jMLEventArray[n6] = eventImagesArray[n6].getPrevious();
            if (d < this.getLoopStartTime()) {
                n5 = jMLEvent2.getJuggler() - 1;
                if (!this.hasVDHandJMLTransition[n5][n4 = HandLink.index(jMLEvent2.getHand())]) {
                    blArray[n5][n4] = false;
                }
                block21: for (n3 = 0; n3 < jMLEvent2.getNumberOfTransitions(); ++n3) {
                    jMLTransition = jMLEvent2.getTransition(n3);
                    n2 = jMLTransition.getPath() - 1;
                    switch (jMLTransition.getType()) {
                        case 1: {
                            blArray3[n2] = false;
                            blArray[n5][n4] = false;
                            blArray2[n5][n4] = false;
                            blArray4[n2] = false;
                            continue block21;
                        }
                        case 2: {
                            continue block21;
                        }
                        case 3: {
                            if (blArray2[n5][n4]) {
                                blArray4[n2] = true;
                            }
                            blArray[n5][n4] = false;
                            blArray2[n5][n4] = false;
                            continue block21;
                        }
                        case 4: {
                            if (this.hasVDPathJMLTransition[n2]) continue block21;
                            blArray3[n2] = false;
                        }
                    }
                }
            }
            n8 = 0;
            for (n5 = 0; n5 < this.numjugglers; ++n5) {
                n8 |= blArray[n5][0];
                n8 |= blArray[n5][1];
                n8 |= blArray2[n5][0];
                n8 |= blArray2[n5][1];
            }
            for (n5 = 0; n5 < this.numpaths; ++n5) {
                n8 |= blArray3[n5];
                n8 |= blArray4[n5];
            }
        } while (n8 != 0);
        for (n = 0; n < this.numjugglers; ++n) {
            blArray2[n][0] = this.hasVDHandJMLTransition[n][0];
            blArray2[n][1] = this.hasVDHandJMLTransition[n][1];
            blArray[n][1] = true;
            blArray[n][0] = true;
        }
        for (n = 0; n < this.numpaths; ++n) {
            blArray3[n] = true;
            blArray4[n] = false;
        }
        for (n = 0; n < n10; ++n) {
            eventImagesArray[n].resetPosition();
            jMLEventArray[n] = eventImagesArray[n].getNext();
        }
        do {
            JMLEvent jMLEvent3 = jMLEventArray[0];
            d = jMLEvent3.getT();
            n6 = 0;
            for (n5 = 1; n5 < n10; ++n5) {
                if (!(jMLEventArray[n5].getT() < d)) continue;
                jMLEvent3 = jMLEventArray[n5];
                d = jMLEvent3.getT();
                n6 = n5;
            }
            this.addEvent(jMLEvent3);
            jMLEventArray[n6] = eventImagesArray[n6].getNext();
            if (d > this.getLoopEndTime()) {
                n5 = jMLEvent3.getJuggler() - 1;
                if (!this.hasVDHandJMLTransition[n5][n4 = HandLink.index(jMLEvent3.getHand())] && d > 2.0 * this.getLoopEndTime() - this.getLoopStartTime()) {
                    blArray[n5][n4] = false;
                }
                block29: for (n3 = 0; n3 < jMLEvent3.getNumberOfTransitions(); ++n3) {
                    jMLTransition = jMLEvent3.getTransition(n3);
                    n2 = jMLTransition.getPath() - 1;
                    switch (jMLTransition.getType()) {
                        case 1: {
                            blArray3[n2] = false;
                            if (blArray2[n5][n4]) {
                                blArray4[n2] = true;
                            }
                            blArray[n5][n4] = false;
                            blArray2[n5][n4] = false;
                            continue block29;
                        }
                        case 2: {
                            blArray3[n2] = false;
                            blArray4[n2] = false;
                            continue block29;
                        }
                        case 3: {
                            blArray3[n2] = false;
                            blArray[n5][n4] = false;
                            blArray2[n5][n4] = false;
                            blArray4[n2] = false;
                            continue block29;
                        }
                        case 4: {
                            if (this.hasVDPathJMLTransition[n2]) continue block29;
                            blArray3[n2] = false;
                        }
                    }
                }
            }
            n8 = 0;
            for (n5 = 0; n5 < this.numjugglers; ++n5) {
                n8 |= blArray[n5][0];
                n8 |= blArray[n5][1];
                n8 |= blArray2[n5][0];
                n8 |= blArray2[n5][1];
            }
            for (n5 = 0; n5 < this.numpaths; ++n5) {
                n8 |= blArray3[n5];
                n8 |= blArray4[n5];
            }
        } while (n8 != 0);
    }

    public void findMasterEvents() throws JuggleExceptionInternal, JuggleExceptionUser {
        boolean bl = false;
        for (JMLEvent jMLEvent = this.eventlist; jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
            JMLEvent jMLEvent2;
            if (!jMLEvent.isMaster()) continue;
            JMLEvent jMLEvent3 = jMLEvent;
            double d = this.getLoopEndTime();
            if (jMLEvent.getT() >= this.getLoopStartTime() && jMLEvent.getT() < d) {
                d = jMLEvent.getT();
            }
            for (jMLEvent2 = this.eventlist; jMLEvent2 != null; jMLEvent2 = jMLEvent2.getNext()) {
                if (jMLEvent2.getMaster() != jMLEvent || !(jMLEvent2.getT() >= this.getLoopStartTime()) || !(jMLEvent2.getT() < d)) continue;
                jMLEvent3 = jMLEvent2;
                d = jMLEvent2.getT();
            }
            if (jMLEvent3 == jMLEvent) continue;
            bl = true;
            for (jMLEvent2 = this.eventlist; jMLEvent2 != null; jMLEvent2 = jMLEvent2.getNext()) {
                if (jMLEvent2.getMaster() != jMLEvent) continue;
                jMLEvent2.setMaster(jMLEvent3);
            }
            jMLEvent3.setMaster(null);
            jMLEvent.setMaster(jMLEvent3);
        }
        if (bl) {
            this.buildEventList();
        }
    }

    public void findPositions() throws JuggleExceptionInternal {
        this.jugglercurve = new SplineCurve[this.getNumberOfJugglers()];
        this.jugglerangle = new LineCurve[this.getNumberOfJugglers()];
        for (int i = 1; i <= this.getNumberOfJugglers(); ++i) {
            Coordinate[] coordinateArray;
            Coordinate[] coordinateArray2;
            double[] dArray;
            JMLPosition jMLPosition;
            int n = 0;
            for (jMLPosition = this.positionlist; jMLPosition != null; jMLPosition = jMLPosition.getNext()) {
                if (jMLPosition.getJuggler() != i) continue;
                ++n;
            }
            if (n == 0) {
                this.jugglercurve[i - 1] = new SplineCurve();
                this.jugglerangle[i - 1] = new LineCurve();
                dArray = new double[]{this.getLoopStartTime(), this.getLoopEndTime()};
                coordinateArray2 = new Coordinate[2];
                coordinateArray = new Coordinate[2];
                coordinateArray2[0] = new Coordinate();
                coordinateArray[0] = new Coordinate();
                if (this.getNumberOfJugglers() == 1) {
                    coordinateArray2[0].setCoordinate(0.0, 0.0, 100.0);
                    coordinateArray[0].setCoordinate(0.0, 0.0, 0.0);
                } else {
                    double d = 70.0;
                    double d2 = 360.0 / (double)this.getNumberOfJugglers();
                    if (d * Math.sin(Math.toRadians(0.5 * d2)) < 65.0) {
                        d = 65.0 / Math.sin(Math.toRadians(0.5 * d2));
                    }
                    coordinateArray2[0].setCoordinate(d * Math.cos(Math.toRadians(d2 * (double)(i - 1))), d * Math.sin(Math.toRadians(d2 * (double)(i - 1))), 100.0);
                    coordinateArray[0].setCoordinate(90.0 + d2 * (double)(i - 1), 0.0, 0.0);
                }
                coordinateArray2[1] = coordinateArray2[0];
                coordinateArray[1] = coordinateArray[0];
                this.jugglercurve[i - 1].setCurve(coordinateArray2, dArray);
                this.jugglercurve[i - 1].calcCurve();
                this.jugglerangle[i - 1].setCurve(coordinateArray, dArray);
                this.jugglerangle[i - 1].calcCurve();
                continue;
            }
            this.jugglercurve[i - 1] = new SplineCurve();
            this.jugglerangle[i - 1] = new LineCurve();
            dArray = new double[n + 1];
            coordinateArray2 = new Coordinate[n + 1];
            coordinateArray = new Coordinate[n + 1];
            int n2 = 0;
            for (jMLPosition = this.positionlist; jMLPosition != null; jMLPosition = jMLPosition.getNext()) {
                if (jMLPosition.getJuggler() != i) continue;
                dArray[n2] = jMLPosition.getT();
                coordinateArray2[n2] = jMLPosition.getCoordinate();
                coordinateArray[n2] = new Coordinate(jMLPosition.getAngle(), 0.0, 0.0);
                ++n2;
            }
            dArray[n] = dArray[0] + this.getLoopEndTime() - this.getLoopStartTime();
            coordinateArray2[n] = coordinateArray2[0];
            coordinateArray[n] = new Coordinate(coordinateArray[0]);
            for (n2 = 1; n2 <= n; ++n2) {
                while (coordinateArray[n2].x - coordinateArray[n2 - 1].x > 180.0) {
                    coordinateArray[n2].x -= 360.0;
                }
                while (coordinateArray[n2].x - coordinateArray[n2 - 1].x < -180.0) {
                    coordinateArray[n2].x += 360.0;
                }
            }
            this.jugglercurve[i - 1].setCurve(coordinateArray2, dArray);
            this.jugglercurve[i - 1].calcCurve();
            this.jugglerangle[i - 1].setCurve(coordinateArray, dArray);
            this.jugglerangle[i - 1].calcCurve();
        }
    }

    public void gotoGlobalCoordinates() {
        for (JMLEvent jMLEvent = this.eventlist; jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
            Coordinate coordinate = jMLEvent.getLocalCoordinate();
            int n = jMLEvent.getJuggler();
            double d = jMLEvent.getT();
            jMLEvent.setGlobalCoordinate(this.convertLocalToGlobal(coordinate, n, d));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void buildLinkLists() throws JuggleExceptionUser, JuggleExceptionInternal {
        this.pathlinks = new ArrayList<E>(this.getNumberOfPaths());
        for (var1_1 = 0; var1_1 < this.getNumberOfPaths(); ++var1_1) {
            this.pathlinks.add(new ArrayList<E>());
            var4_2 = this.eventlist;
            var5_5 = null;
            var6_6 = null;
            block6: do {
                var7_7 = null;
                while ((var7_7 = var4_2.getPathTransition(var1_1 + 1, 5)) == null) {
                    if ((var4_2 = var4_2.getNext()) != null) continue;
                    break block6;
                }
                if (var5_5 != null) {
                    var8_8 = new PathLink(var1_1 + 1, var5_5, var4_2);
                    switch (var7_7.getType()) {
                        case 1: 
                        case 4: {
                            if (var6_6.getType() == 1) {
                                var9_9 = JMLPattern.errorstrings.getString("Error_successive_throws");
                                var10_15 = new Object[]{new Integer(var1_1 + 1)};
                                throw new JuggleExceptionUser(MessageFormat.format(var9_9, var10_15));
                            }
                            if (var5_5.getJuggler() != var4_2.getJuggler()) {
                                var9_10 = JMLPattern.errorstrings.getString("Error_juggler_changed");
                                var10_16 = new Object[]{new Integer(var1_1 + 1)};
                                throw new JuggleExceptionUser(MessageFormat.format(var9_10, var10_16));
                            }
                            if (var5_5.getHand() != var4_2.getHand()) {
                                var9_11 = JMLPattern.errorstrings.getString("Error_hand_changed");
                                var10_17 = new Object[]{new Integer(var1_1 + 1)};
                                throw new JuggleExceptionUser(MessageFormat.format(var9_11, var10_17));
                            }
                            var8_8.setInHand(var4_2.getJuggler(), var4_2.getHand());
                            break;
                        }
                        case 2: {
                            if (var6_6.getType() != 1) {
                                var9_12 = JMLPattern.errorstrings.getString("Error_successive_catches");
                                var10_18 = new Object[]{new Integer(var1_1 + 1)};
                                throw new JuggleExceptionUser(MessageFormat.format(var9_12, var10_18));
                            }
                            var8_8.setThrow(var6_6.getThrowType(), var6_6.getMod());
                            break;
                        }
                        case 3: {
                            if (var6_6.getType() != 1) {
                                var9_13 = JMLPattern.errorstrings.getString("Error_successive_catches");
                                var10_19 = new Object[]{new Integer(var1_1 + 1)};
                                throw new JuggleExceptionUser(MessageFormat.format(var9_13, var10_19));
                            }
                            var8_8.setThrow(var6_6.getThrowType(), var6_6.getMod());
                        }
                    }
                    this.pathlinks.get(var1_1).add((PathLink)var8_8);
                    if (var6_6 != null) {
                        var6_6.setOutgoingPathLink((PathLink)var8_8);
                    }
                    var7_7.setIncomingPathLink((PathLink)var8_8);
                }
                var5_5 = var4_2;
                var6_6 = var7_7;
            } while ((var4_2 = var4_2.getNext()) != null);
            if (this.pathlinks.get(var1_1).size() != 0) continue;
            throw new JuggleExceptionInternal("No event found for path " + (var1_1 + 1));
        }
        this.handlinks = new ArrayList<E>();
        for (var1_1 = 0; var1_1 < this.getNumberOfJugglers(); ++var1_1) {
            this.handlinks.add(new ArrayList<E>());
            block9: for (var2_21 = 0; var2_21 < 2; ++var2_21) {
                var4_4 = var2_21 == 0 ? 1 : 2;
                this.handlinks.get(var1_1).add(new ArrayList<E>());
                var5_5 = this.eventlist;
                var6_6 = null;
                var7_7 = null;
                var8_8 = null;
                do lbl-1000:
                // 3 sources

                {
                    block22: {
                        if (var5_5.getJuggler() == var1_1 + 1 && var5_5.getHand() == var4_4) break block22;
                        if ((var5_5 = var5_5.getNext()) != null) ** GOTO lbl-1000
                        continue block9;
                    }
                    var7_7 = null;
                    if (var5_5.getJuggler() == var1_1 + 1 && var5_5.getHand() == var4_4) {
                        for (var3_22 = 0; var3_22 < var5_5.getNumberOfTransitions(); ++var3_22) {
                            var9_14 = var5_5.getTransition(var3_22);
                            if (var9_14.getType() == 1) {
                                var10_20 = var9_14.getOutgoingPathLink();
                                if (var10_20 == null) continue;
                                var7_7 = new VelocityRef(var10_20.getPath(), true);
                                continue;
                            }
                            if (var9_14.getType() != 3 || (var10_20 = var9_14.getIncomingPathLink()) == null) continue;
                            var7_7 = new VelocityRef(var10_20.getPath(), false);
                        }
                    }
                    if (var6_6 != null) {
                        var9_14 = new HandLink(var1_1, var4_4, (JMLEvent)var6_6, var5_5);
                        var9_14.setStartVelocityRef((VelocityRef)var8_8);
                        var9_14.setEndVelocityRef((VelocityRef)var7_7);
                        this.handlinks.get(var1_1).get(var2_21).add((HandLink)var9_14);
                    }
                    var6_6 = var5_5;
                    var8_8 = var7_7;
                } while ((var5_5 = var5_5.getNext()) != null);
            }
        }
    }

    protected void layoutHandPaths() throws JuggleExceptionInternal {
        for (int i = 0; i < this.getNumberOfJugglers(); ++i) {
            for (int j = 0; j < 2; ++j) {
                Object object;
                Object object2;
                Coordinate[] coordinateArray;
                Coordinate[] coordinateArray2;
                HandLink handLink;
                int n;
                HandLink handLink2;
                int n2;
                if (this.hasVDHandJMLTransition[i][j]) {
                    n2 = 0;
                    handLink2 = null;
                    for (n = 0; n < this.handlinks.get(i).get(j).size(); ++n) {
                        handLink = this.handlinks.get(i).get(j).get(n);
                        if (handLink.getStartVelocityRef() != null) {
                            handLink2 = handLink;
                            n2 = 1;
                        }
                        if (handLink.getEndVelocityRef() != null && handLink2 != null) {
                            coordinateArray2 = new Coordinate[n2 + 1];
                            double[] dArray = new double[n2 + 1];
                            coordinateArray = new SplineCurve();
                            for (int k = 0; k < n2; ++k) {
                                object2 = this.handlinks.get(i).get(j).get(n - n2 + 1 + k);
                                coordinateArray2[k] = ((HandLink)object2).getStartEvent().getGlobalCoordinate();
                                dArray[k] = ((HandLink)object2).getStartEvent().getT();
                                ((HandLink)object2).setHandCurve((Curve)coordinateArray);
                            }
                            coordinateArray2[n2] = handLink.getEndEvent().getGlobalCoordinate();
                            dArray[n2] = handLink.getEndEvent().getT();
                            object = handLink2.getStartVelocityRef().getVelocity();
                            object2 = handLink.getEndVelocityRef().getVelocity();
                            coordinateArray.setCurve(coordinateArray2, dArray, (Coordinate)object, (Coordinate)object2);
                            coordinateArray.calcCurve();
                            handLink2 = null;
                        }
                        ++n2;
                    }
                    continue;
                }
                handLink2 = null;
                for (n2 = 0; n2 < this.handlinks.get(i).get(j).size() && !((handLink2 = this.handlinks.get(i).get(j).get(n2)).getEndEvent().getT() > this.getLoopStartTime()); ++n2) {
                }
                for (n = 0; n < 2; ++n) {
                    handLink = handLink2;
                    coordinateArray2 = handLink.getStartEvent();
                    int n3 = 1;
                    while (!handLink2.getEndEvent().isDelayOf((JMLEvent)coordinateArray2)) {
                        handLink2 = this.handlinks.get(i).get(j).get(++n2);
                        ++n3;
                    }
                    coordinateArray = new Coordinate[n3 + 1];
                    object = new double[n3 + 1];
                    object2 = new SplineCurve();
                    for (int k = 0; k < n3; ++k) {
                        HandLink handLink3 = this.handlinks.get(i).get(j).get(n2 - n3 + 1 + k);
                        coordinateArray[k] = handLink3.getStartEvent().getGlobalCoordinate();
                        object[k] = handLink3.getStartEvent().getT();
                        handLink3.setHandCurve((Curve)object2);
                    }
                    coordinateArray[n3] = handLink2.getEndEvent().getGlobalCoordinate();
                    object[n3] = handLink2.getEndEvent().getT();
                    ((Curve)object2).setCurve(coordinateArray, (double[])object, null, null);
                    ((Curve)object2).calcCurve();
                    if (n != 0) continue;
                    handLink2 = this.handlinks.get(i).get(j).get(++n2);
                }
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public int getNumberOfJugglers() {
        return this.numjugglers;
    }

    public int getNumberOfPaths() {
        return this.numpaths;
    }

    public int getNumberOfProps() {
        return this.props.size();
    }

    public Prop getProp(int n) {
        return this.getPropDef(n).getProp();
    }

    public PropDef getPropDef(int n) {
        return this.props.get(n - 1);
    }

    public int getPropAssignment(int n) {
        return this.propassignment[n - 1];
    }

    public int getNumberOfSymmetries() {
        return this.symmetries.size();
    }

    public JMLSymmetry getSymmetry(int n) {
        return this.symmetries.get(n);
    }

    public double getLoopStartTime() {
        return 0.0;
    }

    public double getLoopEndTime() {
        for (int i = 0; i < this.getNumberOfSymmetries(); ++i) {
            if (this.getSymmetry(i).getType() != 1) continue;
            return this.getSymmetry(i).getDelay();
        }
        return -1.0;
    }

    public void getPathCoordinate(int n, double d, Coordinate coordinate) throws JuggleExceptionInternal {
        for (PathLink pathLink : this.pathlinks.get(n - 1)) {
            if (!(d >= pathLink.getStartEvent().getT()) || !(d <= pathLink.getEndEvent().getT())) continue;
            if (pathLink.isInHand()) {
                int n2 = pathLink.getHoldingJuggler();
                int n3 = pathLink.getHoldingHand();
                this.getHandCoordinate(n2, n3, d, coordinate);
                return;
            }
            pathLink.getPath().getCoordinate(d, coordinate);
            return;
        }
        throw new JuggleExceptionInternal("time t=" + d + " is out of path range");
    }

    public boolean isHandHoldingPath(int n, int n2, double d, int n3) {
        for (PathLink pathLink : this.pathlinks.get(n3 - 1)) {
            if (!pathLink.isInHand() || pathLink.getHoldingJuggler() != n || pathLink.getHoldingHand() != n2 || !(d >= pathLink.getStartEvent().getT()) || !(d <= pathLink.getEndEvent().getT())) continue;
            return true;
        }
        return false;
    }

    public double getPathOrientation(int n, double d, Coordinate coordinate) {
        coordinate.x = 0.0;
        coordinate.y = 0.0;
        coordinate.z = 1.0;
        return 3.0 * d;
    }

    public void getJugglerPosition(int n, double d, Coordinate coordinate) {
        Curve curve = this.jugglercurve[n - 1];
        while (d < curve.getStartTime()) {
            d += this.getLoopEndTime() - this.getLoopStartTime();
        }
        while (d > curve.getEndTime()) {
            d -= this.getLoopEndTime() - this.getLoopStartTime();
        }
        curve.getCoordinate(d, coordinate);
    }

    public double getJugglerAngle(int n, double d) {
        Curve curve = this.jugglerangle[n - 1];
        while (d < curve.getStartTime()) {
            d += this.getLoopEndTime() - this.getLoopStartTime();
        }
        while (d > curve.getEndTime()) {
            d -= this.getLoopEndTime() - this.getLoopStartTime();
        }
        Coordinate coordinate = new Coordinate();
        curve.getCoordinate(d, coordinate);
        return coordinate.x;
    }

    public Coordinate convertLocalToGlobal(Coordinate coordinate, int n, double d) {
        Coordinate coordinate2 = new Coordinate();
        this.getJugglerPosition(n, d, coordinate2);
        double d2 = Math.toRadians(this.getJugglerAngle(n, d));
        coordinate.y += 30.0;
        Coordinate coordinate3 = new Coordinate(coordinate2.x + coordinate.x * Math.cos(d2) - coordinate.y * Math.sin(d2), coordinate2.y + coordinate.x * Math.sin(d2) + coordinate.y * Math.cos(d2), coordinate2.z + coordinate.z);
        return coordinate3;
    }

    public Coordinate convertGlobalToLocal(Coordinate coordinate, int n, double d) {
        Coordinate coordinate2 = new Coordinate();
        this.getJugglerPosition(n, d, coordinate2);
        double d2 = Math.toRadians(this.getJugglerAngle(n, d));
        Coordinate coordinate3 = Coordinate.sub(coordinate, coordinate2);
        Coordinate coordinate4 = new Coordinate(coordinate3.x * Math.cos(d2) + coordinate3.y * Math.sin(d2), -coordinate3.x * Math.sin(d2) + coordinate3.y * Math.cos(d2), coordinate3.z);
        coordinate4.y -= 30.0;
        return coordinate4;
    }

    public void getHandCoordinate(int n, int n2, double d, Coordinate coordinate) throws JuggleExceptionInternal {
        int n3 = n2 == 1 ? 0 : 1;
        for (HandLink handLink : this.handlinks.get(n - 1).get(n3)) {
            if (!(d >= handLink.getStartEvent().getT()) || !(d < handLink.getEndEvent().getT())) continue;
            Curve curve = handLink.getHandCurve();
            if (curve == null) {
                throw new JuggleExceptionInternal("getHandCoordinate() null pointer");
            }
            handLink.getHandCurve().getCoordinate(d, coordinate);
            return;
        }
        throw new JuggleExceptionInternal("time t=" + d + " (j=" + n + ",h=" + n3 + ") is out of handpath range");
    }

    public double getPathCatchVolume(int n, double d, double d2) {
        int n2;
        PathLink pathLink = null;
        PathLink pathLink2 = null;
        boolean bl = false;
        boolean bl2 = false;
        for (n2 = 0; !(n2 >= this.pathlinks.get(n - 1).size() || d >= (pathLink = this.pathlinks.get(n - 1).get(n2)).getStartEvent().getT() && d <= pathLink.getEndEvent().getT()); ++n2) {
        }
        if (n2 == this.pathlinks.get(n - 1).size()) {
            return 0.0;
        }
        while (true) {
            if (!(pathLink2 = this.pathlinks.get(n - 1).get(n2)).isInHand()) {
                bl = true;
            }
            if (pathLink2.isInHand() && bl) {
                bl2 = true;
                break;
            }
            if (d2 >= pathLink2.getStartEvent().getT() && d2 <= pathLink2.getEndEvent().getT()) break;
            if (++n2 != this.pathlinks.get(n - 1).size()) continue;
            n2 = 0;
        }
        if (bl2) {
            return 1.0;
        }
        return 0.0;
    }

    public double getPathBounceVolume(int n, double d, double d2) {
        int n2;
        PathLink pathLink = null;
        for (n2 = 0; !(n2 >= this.pathlinks.get(n - 1).size() || d >= (pathLink = this.pathlinks.get(n - 1).get(n2)).getStartEvent().getT() && d <= pathLink.getEndEvent().getT()); ++n2) {
        }
        if (n2 == this.pathlinks.get(n - 1).size()) {
            return 0.0;
        }
        while (true) {
            BouncePath bouncePath;
            double d3;
            Path path;
            if ((path = (pathLink = this.pathlinks.get(n - 1).get(n2)).getPath()) instanceof BouncePath && (d3 = (bouncePath = (BouncePath)path).getBounceVolume(d, d2)) > 0.0) {
                return d3;
            }
            if (d2 >= pathLink.getStartEvent().getT() && d2 <= pathLink.getEndEvent().getT()) break;
            if (++n2 != this.pathlinks.get(n - 1).size()) continue;
            n2 = 0;
        }
        return 0.0;
    }

    public Coordinate getPathMax(int n) {
        Coordinate coordinate = null;
        double d = this.getLoopStartTime();
        double d2 = this.getLoopEndTime();
        for (int i = 0; i < this.pathlinks.get(n - 1).size(); ++i) {
            PathLink pathLink = this.pathlinks.get(n - 1).get(i);
            coordinate = pathLink.isInHand() ? Coordinate.max(coordinate, this.getHandMax(pathLink.getHoldingJuggler(), pathLink.getHoldingHand())) : Coordinate.max(coordinate, pathLink.getPath().getMax(d, d2));
        }
        return coordinate;
    }

    public Coordinate getPathMin(int n) {
        Coordinate coordinate = null;
        double d = this.getLoopStartTime();
        double d2 = this.getLoopEndTime();
        for (int i = 0; i < this.pathlinks.get(n - 1).size(); ++i) {
            PathLink pathLink = this.pathlinks.get(n - 1).get(i);
            coordinate = pathLink.isInHand() ? Coordinate.min(coordinate, this.getHandMin(pathLink.getHoldingJuggler(), pathLink.getHoldingHand())) : Coordinate.min(coordinate, pathLink.getPath().getMin(d, d2));
        }
        return coordinate;
    }

    public Coordinate getHandMax(int n, int n2) {
        Coordinate coordinate = null;
        double d = this.getLoopStartTime();
        double d2 = this.getLoopEndTime();
        int n3 = n2 == 1 ? 0 : 1;
        for (int i = 0; i < this.handlinks.get(n - 1).get(n3).size(); ++i) {
            HandLink handLink = this.handlinks.get(n - 1).get(n3).get(i);
            Curve curve = handLink.getHandCurve();
            if (curve == null) continue;
            coordinate = Coordinate.max(coordinate, curve.getMax(d, d2));
        }
        return coordinate;
    }

    public Coordinate getHandMin(int n, int n2) {
        Coordinate coordinate = null;
        double d = this.getLoopStartTime();
        double d2 = this.getLoopEndTime();
        int n3 = n2 == 1 ? 0 : 1;
        for (int i = 0; i < this.handlinks.get(n - 1).get(n3).size(); ++i) {
            HandLink handLink = this.handlinks.get(n - 1).get(n3).get(i);
            Curve curve = handLink.getHandCurve();
            if (curve == null) continue;
            coordinate = Coordinate.min(coordinate, curve.getMin(d, d2));
        }
        return coordinate;
    }

    public Coordinate getJugglerMax(int n) {
        return this.jugglercurve[n - 1].getMax();
    }

    public Coordinate getJugglerMin(int n) {
        return this.jugglercurve[n - 1].getMin();
    }

    public Permutation getPathPermutation() {
        for (int i = 0; i < this.getNumberOfSymmetries(); ++i) {
            if (this.getSymmetry(i).getType() != 1) continue;
            return this.getSymmetry(i).getPathPerm();
        }
        return null;
    }

    public int getPeriod() {
        return JMLPattern.getPeriod(this.getPathPermutation(), this.propassignment);
    }

    public static int getPeriod(Permutation permutation, int[] nArray) {
        int n;
        int n2 = 1;
        int n3 = permutation.getSize();
        boolean[] blArray = new boolean[n3];
        for (n = 0; n < n3; ++n) {
            blArray[n] = true;
        }
        for (n = 0; n < n3; ++n) {
            int n4;
            if (!blArray[n]) continue;
            int[] nArray2 = permutation.getCycle(n + 1);
            for (int i = 0; i < nArray2.length; ++i) {
                blArray[nArray2[i] - 1] = false;
                nArray2[i] = nArray[nArray2[i] - 1];
            }
            for (n4 = 1; n4 < nArray2.length; ++n4) {
                if (nArray2.length % n4 != 0) continue;
                boolean bl = true;
                for (int i = 0; i < nArray2.length; ++i) {
                    if (nArray2[i] == nArray2[(i + n4) % nArray2.length]) continue;
                    bl = false;
                    break;
                }
                if (bl) break;
            }
            n2 = Permutation.lcm(n2, n4);
        }
        return n2;
    }

    public boolean isBouncePattern() {
        for (int i = 1; i <= this.getNumberOfPaths(); ++i) {
            for (PathLink pathLink : this.pathlinks.get(i - 1)) {
                if (!(pathLink.getPath() instanceof BouncePath)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isLaidout() {
        return this.laidout;
    }

    protected void printEventList() {
        PrintWriter printWriter = new PrintWriter(System.out);
        for (JMLEvent jMLEvent = this.eventlist; jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
            if (jMLEvent.isMaster()) {
                System.out.println("  Master event:");
            } else {
                System.out.println("  Slave event; master at t=" + jMLEvent.getMaster().getT());
            }
            try {
                jMLEvent.writeJML(printWriter);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            printWriter.flush();
        }
    }

    protected void readJML(JMLNode jMLNode) throws JuggleExceptionUser {
        String string = jMLNode.getNodeType();
        if (string.equalsIgnoreCase("jml")) {
            this.loadingversion = jMLNode.getAttributes().getAttribute("version");
            if (this.loadingversion == null) {
                this.loadingversion = "1.0";
            }
        } else if (!string.equalsIgnoreCase("pattern")) {
            Object object;
            if (string.equalsIgnoreCase("title")) {
                this.setTitle(jMLNode.getNodeValue());
            } else if (string.equalsIgnoreCase("prop")) {
                object = new PropDef();
                ((PropDef)object).readJML(jMLNode, this.loadingversion);
                this.addProp((PropDef)object);
            } else if (string.equalsIgnoreCase("setup")) {
                object = jMLNode.getAttributes();
                String string2 = ((JMLAttributes)object).getAttribute("jugglers");
                String string3 = ((JMLAttributes)object).getAttribute("paths");
                String string4 = ((JMLAttributes)object).getAttribute("props");
                try {
                    if (string2 != null) {
                        this.setNumberOfJugglers(Integer.valueOf(string2));
                    } else {
                        this.setNumberOfJugglers(1);
                    }
                    this.setNumberOfPaths(Integer.valueOf(string3));
                }
                catch (Exception exception) {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_setup_tag"));
                }
                int[] nArray = new int[this.numpaths];
                if (string4 != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                    if (stringTokenizer.countTokens() != this.numpaths) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_prop_assignments"));
                    }
                    try {
                        for (int i = 0; i < this.numpaths; ++i) {
                            nArray[i] = Integer.valueOf(stringTokenizer.nextToken());
                            if (nArray[i] >= 1 && nArray[i] <= this.getNumberOfProps()) continue;
                            throw new JuggleExceptionUser(errorstrings.getString("Error_prop_number"));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_prop_format"));
                    }
                } else {
                    for (int i = 0; i < this.numpaths; ++i) {
                        nArray[i] = 1;
                    }
                }
                this.setPropAssignments(nArray);
            } else if (string.equalsIgnoreCase("symmetry")) {
                object = new JMLSymmetry();
                ((JMLSymmetry)object).readJML(jMLNode, this.numjugglers, this.numpaths, this.loadingversion);
                this.addSymmetry((JMLSymmetry)object);
            } else {
                if (string.equalsIgnoreCase("event")) {
                    JMLEvent jMLEvent = new JMLEvent();
                    jMLEvent.readJML(jMLNode, this.loadingversion, this.getNumberOfJugglers(), this.getNumberOfPaths());
                    this.addEvent(jMLEvent);
                    return;
                }
                if (string.equalsIgnoreCase("position")) {
                    JMLPosition jMLPosition = new JMLPosition();
                    jMLPosition.readJML(jMLNode, this.loadingversion);
                    this.addPosition(jMLPosition);
                    return;
                }
                String string5 = errorstrings.getString("Error_unknown_tag");
                Object[] objectArray = new Object[]{string};
                throw new JuggleExceptionUser(MessageFormat.format(string5, objectArray));
            }
        }
        for (int i = 0; i < jMLNode.getNumberOfChildren(); ++i) {
            this.readJML(jMLNode.getChildNode(i));
        }
    }

    public void writeJML(Writer writer, boolean bl) throws IOException {
        int n;
        int n2;
        PrintWriter printWriter = new PrintWriter(writer);
        for (n2 = 0; n2 < JMLDefs.jmlprefix.length; ++n2) {
            printWriter.println(JMLDefs.jmlprefix[n2]);
        }
        printWriter.println("<jml version=\"" + this.version + "\">");
        printWriter.println("<pattern>");
        if (bl) {
            printWriter.println("<title>" + JMLNode.xmlescape(this.title) + "</title>");
        }
        for (n2 = 0; n2 < this.props.size(); ++n2) {
            this.props.get(n2).writeJML(printWriter);
        }
        String string = "<setup jugglers=\"" + this.getNumberOfJugglers() + "\" paths=\"" + this.getNumberOfPaths() + "\" props=\"" + this.getPropAssignment(1);
        for (n = 2; n <= this.getNumberOfPaths(); ++n) {
            string = string + "," + this.getPropAssignment(n);
        }
        printWriter.println(string + "\"/>");
        for (n = 0; n < this.symmetries.size(); ++n) {
            this.symmetries.get(n).writeJML(printWriter);
        }
        for (JMLPosition jMLPosition = this.positionlist; jMLPosition != null; jMLPosition = jMLPosition.getNext()) {
            jMLPosition.writeJML(printWriter);
        }
        for (JMLEvent jMLEvent = this.eventlist; jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
            if (!jMLEvent.isMaster()) continue;
            jMLEvent.writeJML(printWriter);
        }
        printWriter.println("</pattern>");
        printWriter.println("</jml>");
        for (int i = 0; i < JMLDefs.jmlsuffix.length; ++i) {
            printWriter.println(JMLDefs.jmlsuffix[i]);
        }
        printWriter.flush();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.writeJML(stringWriter, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public Object clone() {
        try {
            return new JMLPattern(new StringReader(this.toString()));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

