/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.util.JuggleExceptionInternal;

public class JMLNode {
    protected String nodeType;
    protected String nodeValue;
    protected JMLNode parentNode;
    protected ArrayList<JMLNode> childNodes;
    protected JMLNode previousSibling;
    protected JMLNode nextSibling;
    protected JMLAttributes attributes;

    public JMLNode(String string) {
        this.nodeType = string;
        this.childNodes = new ArrayList();
        this.attributes = new JMLAttributes(this);
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getNodeValue() {
        return this.nodeValue;
    }

    public void setNodeValue(String string) {
        this.nodeValue = string;
    }

    public JMLNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(JMLNode jMLNode) {
        this.parentNode = jMLNode;
    }

    public int getNumberOfChildren() {
        return this.childNodes.size();
    }

    public JMLNode getChildNode(int n) {
        return this.childNodes.get(n);
    }

    public JMLNode getFirstChild() {
        return this.childNodes.get(0);
    }

    public JMLNode getLastChild() {
        int n = this.childNodes.size();
        if (n > 0) {
            return this.childNodes.get(n - 1);
        }
        return null;
    }

    public JMLNode getPreviousSibling() {
        return this.previousSibling;
    }

    public void setPreviousSibling(JMLNode jMLNode) {
        this.previousSibling = jMLNode;
    }

    public JMLNode getNextSibling() {
        return this.nextSibling;
    }

    public void setNextSibling(JMLNode jMLNode) {
        this.nextSibling = jMLNode;
    }

    public void addAttribute(String string, String string2) {
        this.attributes.addAttribute(string, string2);
    }

    public JMLAttributes getAttributes() {
        return this.attributes;
    }

    public void insertBefore(JMLNode jMLNode, JMLNode jMLNode2) {
        if (jMLNode2 != null) {
            int n = this.childNodes.indexOf(jMLNode2);
            this.childNodes.add(n, jMLNode);
            jMLNode.setParentNode(this);
            JMLNode jMLNode3 = jMLNode2.getPreviousSibling();
            if (jMLNode3 != null) {
                jMLNode3.setNextSibling(jMLNode);
            }
            jMLNode.setPreviousSibling(jMLNode3);
            jMLNode.setNextSibling(jMLNode2);
            jMLNode2.setPreviousSibling(jMLNode);
        } else {
            this.appendChild(jMLNode);
        }
    }

    public void replaceChild(JMLNode jMLNode, JMLNode jMLNode2) throws JuggleExceptionInternal {
        if (!this.childNodes.contains(jMLNode2)) {
            throw new JuggleExceptionInternal("Node to replace doesn't exist");
        }
        int n = this.childNodes.indexOf(jMLNode2);
        JMLNode jMLNode3 = jMLNode2.getPreviousSibling();
        JMLNode jMLNode4 = jMLNode2.getNextSibling();
        this.childNodes.set(n, jMLNode);
        jMLNode.setPreviousSibling(jMLNode3);
        jMLNode.setNextSibling(jMLNode4);
        jMLNode.setParentNode(this);
    }

    public void removeChild(JMLNode jMLNode) throws JuggleExceptionInternal {
        if (this.childNodes.remove(jMLNode)) {
            JMLNode jMLNode2 = jMLNode.getPreviousSibling();
            JMLNode jMLNode3 = jMLNode.getNextSibling();
            if (jMLNode2 != null) {
                jMLNode2.setNextSibling(jMLNode3);
            }
            if (jMLNode3 != null) {
                jMLNode3.setPreviousSibling(jMLNode2);
            }
        } else {
            throw new JuggleExceptionInternal("Node to remove doesn't exist");
        }
    }

    public void appendChild(JMLNode jMLNode) {
        JMLNode jMLNode2 = null;
        if (this.childNodes.size() != 0) {
            jMLNode2 = this.childNodes.get(this.childNodes.size() - 1);
            jMLNode2.setNextSibling(jMLNode);
        }
        this.childNodes.add(jMLNode);
        jMLNode.setPreviousSibling(jMLNode2);
        jMLNode.setNextSibling(null);
        jMLNode.setParentNode(this);
    }

    public boolean hasChildNodes() {
        return this.childNodes.size() != 0;
    }

    public void writeNode(PrintWriter printWriter, int n) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<" + this.nodeType);
        for (n2 = 0; n2 < this.attributes.getNumberOfAttributes(); ++n2) {
            stringBuffer.append(" " + this.attributes.getAttributeName(n2));
            stringBuffer.append("=\"" + JMLNode.xmlescape(this.attributes.getAttributeValue(n2)) + "\"");
        }
        if (this.getNumberOfChildren() == 0) {
            if (this.nodeValue == null) {
                stringBuffer.append("/>");
            } else {
                stringBuffer.append(">" + JMLNode.xmlescape(this.nodeValue) + "</" + this.nodeType + ">");
            }
            printWriter.println(stringBuffer.toString());
            stringBuffer = new StringBuffer();
        } else {
            stringBuffer.append('>');
            printWriter.println(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            if (this.nodeValue != null) {
                stringBuffer.append(JMLNode.xmlescape(this.nodeValue));
                printWriter.println(stringBuffer.toString());
                stringBuffer = new StringBuffer();
            }
            printWriter.flush();
            for (n2 = 0; n2 < this.getNumberOfChildren(); ++n2) {
                this.getChildNode(n2).writeNode(printWriter, n + 1);
            }
            stringBuffer.append("</" + this.nodeType + ">");
            printWriter.println(stringBuffer.toString());
        }
        printWriter.flush();
    }

    public static String xmlescape(String string) {
        String string2 = string.replace("&", "&amp;");
        string2 = string2.replace("<", "&lt;");
        string2 = string2.replace(">", "&gt;");
        string2 = string2.replace("'", "&apos;");
        string2 = string2.replace("\"", "&quot;");
        return string2;
    }
}

