/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.ResourceBundle;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLTransition;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;

public class JMLEvent {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected double x;
    protected double y;
    protected double z;
    protected double gx;
    protected double gy;
    protected double gz;
    protected boolean globaldirty = true;
    protected double t;
    protected int juggler;
    protected int hand;
    protected ArrayList<JMLTransition> transitions = new ArrayList();
    protected int[][][] eventarray;
    protected int delay;
    protected int delayunits;
    protected Permutation pathpermfrommaster;
    protected JMLEvent master;
    public boolean calcpos = false;
    protected JMLEvent prev;
    protected JMLEvent next;

    public Coordinate getLocalCoordinate() {
        return new Coordinate(this.x, this.y, this.z);
    }

    public void setLocalCoordinate(Coordinate coordinate) {
        this.x = coordinate.x;
        this.y = coordinate.y;
        this.z = coordinate.z;
        this.globaldirty = true;
    }

    public Coordinate getGlobalCoordinate() {
        return this.globaldirty ? null : new Coordinate(this.gx, this.gy, this.gz);
    }

    public void setGlobalCoordinate(Coordinate coordinate) {
        this.gx = coordinate.x;
        this.gy = coordinate.y;
        this.gz = coordinate.z;
        this.globaldirty = false;
    }

    public double getT() {
        return this.t;
    }

    public void setT(double d) {
        this.t = d;
    }

    public int getHand() {
        return this.hand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setHand(String string) throws JuggleExceptionUser {
        int n = string.indexOf(":");
        if (n == -1) {
            this.juggler = 1;
            if (string.equalsIgnoreCase("left")) {
                this.hand = 1;
                return;
            } else {
                if (!string.equalsIgnoreCase("right")) throw new JuggleExceptionUser(errorstrings.getString("Error_hand_name") + " '" + string + "'");
                this.hand = 2;
            }
            return;
        } else {
            this.juggler = Integer.valueOf(string.substring(0, n));
            String string2 = string.substring(n + 1);
            if (string2.equalsIgnoreCase("left")) {
                this.hand = 1;
                return;
            } else {
                if (!string2.equalsIgnoreCase("right")) throw new JuggleExceptionUser(errorstrings.getString("Error_hand_name") + " '" + string + "'");
                this.hand = 2;
            }
        }
    }

    public void setHand(int n, int n2) {
        this.juggler = n;
        this.hand = n2;
    }

    public int getJuggler() {
        return this.juggler;
    }

    public int getNumberOfTransitions() {
        return this.transitions.size();
    }

    public JMLTransition getTransition(int n) {
        return this.transitions.get(n);
    }

    public void addTransition(JMLTransition jMLTransition) {
        this.transitions.add(jMLTransition);
    }

    public void removeTransition(int n) {
        this.transitions.remove(n);
    }

    public void removeTransition(JMLTransition jMLTransition) {
        for (int i = 0; i < this.getNumberOfTransitions(); ++i) {
            if (this.getTransition(i) != jMLTransition) continue;
            this.removeTransition(i);
            return;
        }
    }

    public boolean isMaster() {
        return this.master == null;
    }

    public JMLEvent getMaster() {
        return this.master;
    }

    public void setMaster(JMLEvent jMLEvent) {
        this.master = jMLEvent;
    }

    public JMLEvent getPrevious() {
        return this.prev;
    }

    public void setPrevious(JMLEvent jMLEvent) {
        this.prev = jMLEvent;
    }

    public JMLEvent getNext() {
        return this.next;
    }

    public void setNext(JMLEvent jMLEvent) {
        this.next = jMLEvent;
    }

    public Permutation getPathPermFromMaster() {
        return this.pathpermfrommaster;
    }

    public void setPathPermFromMaster(Permutation permutation) {
        this.pathpermfrommaster = permutation;
    }

    public boolean isDelayOf(JMLEvent jMLEvent) {
        JMLEvent jMLEvent2;
        JMLEvent jMLEvent3 = this.getMaster() == null ? this : this.getMaster();
        JMLEvent jMLEvent4 = jMLEvent2 = jMLEvent.getMaster() == null ? jMLEvent : jMLEvent.getMaster();
        if (jMLEvent3 != jMLEvent2) {
            return false;
        }
        if (this.getJuggler() != jMLEvent.getJuggler() || this.getHand() != jMLEvent.getHand()) {
            return false;
        }
        int n = this.delay - jMLEvent.delay;
        if (n < 0) {
            n = -n;
        }
        return n % this.delayunits == 0;
    }

    public JMLTransition getPathTransition(int n, int n2) {
        for (JMLTransition jMLTransition : this.transitions) {
            if (jMLTransition.getPath() != n || n2 != 5 && n2 != jMLTransition.getType()) continue;
            return jMLTransition;
        }
        return null;
    }

    public JMLEvent duplicate(int n, int n2) {
        JMLEvent jMLEvent = new JMLEvent();
        jMLEvent.setLocalCoordinate(this.getLocalCoordinate());
        jMLEvent.setT(this.getT());
        jMLEvent.setHand(this.getJuggler(), this.getHand());
        jMLEvent.delay = n;
        jMLEvent.delayunits = n2;
        jMLEvent.calcpos = this.calcpos;
        for (int i = 0; i < this.getNumberOfTransitions(); ++i) {
            JMLTransition jMLTransition = this.getTransition(i).duplicate();
            jMLEvent.addTransition(jMLTransition);
        }
        jMLEvent.setMaster(this.isMaster() ? this : this.master);
        return jMLEvent;
    }

    public void readJML(JMLNode jMLNode, String string, int n, int n2) throws JuggleExceptionUser {
        int n3;
        JMLAttributes jMLAttributes = jMLNode.getAttributes();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        String string2 = null;
        try {
            for (n3 = 0; n3 < jMLAttributes.getNumberOfAttributes(); ++n3) {
                if (jMLAttributes.getAttributeName(n3).equalsIgnoreCase("x")) {
                    d = Double.valueOf(jMLAttributes.getAttributeValue(n3));
                    continue;
                }
                if (jMLAttributes.getAttributeName(n3).equalsIgnoreCase("y")) {
                    d2 = Double.valueOf(jMLAttributes.getAttributeValue(n3));
                    continue;
                }
                if (jMLAttributes.getAttributeName(n3).equalsIgnoreCase("z")) {
                    d3 = Double.valueOf(jMLAttributes.getAttributeValue(n3));
                    continue;
                }
                if (jMLAttributes.getAttributeName(n3).equalsIgnoreCase("t")) {
                    d4 = Double.valueOf(jMLAttributes.getAttributeValue(n3));
                    continue;
                }
                if (!jMLAttributes.getAttributeName(n3).equalsIgnoreCase("hand")) continue;
                string2 = jMLAttributes.getAttributeValue(n3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_event_coordinate"));
        }
        if (string.equals("1.0")) {
            double d5 = d2;
            d2 = d3;
            d3 = d5;
        }
        this.setLocalCoordinate(new Coordinate(d, d2, d3));
        this.setT(d4);
        if (string2 == null) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_unspecified_hand"));
        }
        this.setHand(string2);
        if (this.juggler > n || this.juggler < 1) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_juggler_out_of_range"));
        }
        for (n3 = 0; n3 < jMLNode.getNumberOfChildren(); ++n3) {
            int n4;
            JMLNode jMLNode2 = jMLNode.getChildNode(n3);
            String string3 = jMLNode2.getNodeType();
            jMLAttributes = jMLNode2.getAttributes();
            String string4 = null;
            String string5 = null;
            String string6 = null;
            for (n4 = 0; n4 < jMLAttributes.getNumberOfAttributes(); ++n4) {
                String string7 = jMLAttributes.getAttributeValue(n4);
                if (jMLAttributes.getAttributeName(n4).equalsIgnoreCase("path")) {
                    string4 = string7;
                    continue;
                }
                if (jMLAttributes.getAttributeName(n4).equalsIgnoreCase("type")) {
                    string5 = string7;
                    continue;
                }
                if (!jMLAttributes.getAttributeName(n4).equalsIgnoreCase("mod")) continue;
                string6 = string7;
            }
            if (string4 == null) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_no_path"));
            }
            n4 = Integer.valueOf(string4);
            if (n4 > n2 || n4 < 1) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_path_out_of_range"));
            }
            if (string3.equalsIgnoreCase("throw")) {
                this.addTransition(new JMLTransition(1, n4, string5, string6));
            } else if (string3.equalsIgnoreCase("catch")) {
                this.addTransition(new JMLTransition(2, n4, null, null));
            } else if (string3.equalsIgnoreCase("softcatch")) {
                this.addTransition(new JMLTransition(3, n4, null, null));
            } else if (string3.equalsIgnoreCase("holding")) {
                this.addTransition(new JMLTransition(4, n4, null, null));
            }
            if (jMLNode2.getNumberOfChildren() == 0) continue;
            throw new JuggleExceptionUser(errorstrings.getString("Error_event_subtag"));
        }
    }

    public void writeJML(PrintWriter printWriter) throws IOException {
        Coordinate coordinate = this.getLocalCoordinate();
        printWriter.println("<event x=\"" + JLFunc.toStringTruncated(coordinate.x, 4) + "\" y=\"" + JLFunc.toStringTruncated(coordinate.y, 4) + "\" z=\"" + JLFunc.toStringTruncated(coordinate.z, 4) + "\" t=\"" + JLFunc.toStringTruncated(this.getT(), 4) + "\" hand=\"" + Integer.toString(this.getJuggler()) + ":" + (this.getHand() == 1 ? "left" : "right") + "\">");
        for (int i = 0; i < this.getNumberOfTransitions(); ++i) {
            this.getTransition(i).writeJML(printWriter);
        }
        printWriter.println("</event>");
    }
}

