/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import jugglinglab.jml.HandLink;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;

public class EventImages {
    protected JMLPattern pat = null;
    protected int numjugglers;
    protected int numpaths;
    protected double looptime;
    protected Permutation loopperm = null;
    protected JMLEvent ev = null;
    protected int evjuggler;
    protected int evhand;
    protected int evtransitions;
    protected double evtime;
    protected Permutation[][][] ea = null;
    protected int numentries;
    protected int[] transitiontype = null;
    protected int currentloop;
    protected int currentj;
    protected int currenth;
    protected int currententry;

    public EventImages(JMLPattern jMLPattern, JMLEvent jMLEvent) throws JuggleExceptionUser {
        this.pat = jMLPattern;
        this.ev = jMLEvent;
        this.calcarray();
        this.resetPosition();
        jMLEvent.delay = 0;
        jMLEvent.delayunits = this.numentries;
    }

    public JMLEvent getNext() {
        do {
            if (++this.currenth != 2) continue;
            this.currenth = 0;
            if (++this.currentj != this.numjugglers) continue;
            this.currentj = 0;
            if (++this.currententry != this.numentries) continue;
            this.currententry = 0;
            ++this.currentloop;
        } while (this.ea[this.currentj][this.currenth][this.currententry] == null);
        return this.makeEvent();
    }

    public JMLEvent getPrevious() {
        do {
            if (this.currenth-- != 0) continue;
            this.currenth = 1;
            if (this.currentj-- != 0) continue;
            this.currentj = this.numjugglers - 1;
            if (this.currententry-- != 0) continue;
            this.currententry = this.numentries - 1;
            --this.currentloop;
        } while (this.ea[this.currentj][this.currenth][this.currententry] == null);
        return this.makeEvent();
    }

    protected JMLEvent makeEvent() {
        Object object;
        JMLEvent jMLEvent = this.ev.duplicate(this.currententry + this.numentries * this.currentloop, this.numentries);
        jMLEvent.setHand(this.currentj + 1, this.currenth == 0 ? 1 : 2);
        if (this.currenth != this.evhand) {
            object = jMLEvent.getLocalCoordinate();
            ((Coordinate)object).x = -((Coordinate)object).x;
            jMLEvent.setLocalCoordinate((Coordinate)object);
        }
        object = this.ea[this.currentj][this.currenth][this.currententry];
        Permutation permutation = this.loopperm;
        int n = this.currentloop;
        if (n < 0) {
            permutation = permutation.getInverse();
            n = -n;
        }
        while (n > 0) {
            object = permutation.apply((Permutation)object);
            --n;
        }
        for (int i = 0; i < this.evtransitions; ++i) {
            JMLTransition jMLTransition = jMLEvent.getTransition(i);
            int n2 = this.ev.getTransition(i).getPath();
            jMLTransition.setPath(((Permutation)object).getMapping(n2));
        }
        jMLEvent.setPathPermFromMaster((Permutation)object);
        double d = this.evtime + (double)this.currentloop * this.looptime + (double)this.currententry * (this.looptime / (double)this.numentries);
        jMLEvent.setT(d);
        return jMLEvent;
    }

    public void resetPosition() {
        this.currentloop = 0;
        this.currentj = this.evjuggler;
        this.currenth = this.evhand;
        this.currententry = 0;
    }

    public boolean hasJMLTransitionForHand(int n, int n2) {
        for (int i = 0; i < this.numentries; ++i) {
            if (this.ea[n - 1][HandLink.index(n2)][i] == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasVDJMLTransitionForHand(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.numentries && this.ea[n - 1][HandLink.index(n2)][n3] == null; ++n3) {
        }
        if (n3 == this.numentries) {
            return false;
        }
        for (int i = 0; i < this.evtransitions; ++i) {
            if (this.transitiontype[i] != 1 && this.transitiontype[i] != 3) continue;
            return true;
        }
        return false;
    }

    public boolean hasJMLTransitionForPath(int n) {
        int[] nArray = this.loopperm.getCycle(n);
        for (int i = 0; i < this.numjugglers; ++i) {
            for (int j = 0; j < this.numentries; ++j) {
                for (int k = 0; k < 2; ++k) {
                    for (int i2 = 0; i2 < this.evtransitions; ++i2) {
                        if (this.ea[i][k][j] == null) continue;
                        int n2 = this.ea[i][k][j].getMapping(this.ev.getTransition(i2).getPath());
                        for (int i3 = 0; i3 < nArray.length; ++i3) {
                            if (n2 != nArray[i3]) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean hasVDJMLTransitionForPath(int n) {
        int[] nArray = this.loopperm.getCycle(n);
        for (int i = 0; i < this.evtransitions; ++i) {
            if (this.transitiontype[i] != 1 && this.transitiontype[i] != 3) continue;
            for (int j = 0; j < this.numjugglers; ++j) {
                for (int k = 0; k < this.numentries; ++k) {
                    for (int i2 = 0; i2 < 2; ++i2) {
                        if (this.ea[j][i2][k] == null) continue;
                        int n2 = this.ea[j][i2][k].getMapping(this.ev.getTransition(i).getPath());
                        for (int i3 = 0; i3 < nArray.length; ++i3) {
                            if (n2 != nArray[i3]) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    protected void calcarray() throws JuggleExceptionUser {
        Object object;
        int n;
        this.numjugglers = this.pat.getNumberOfJugglers();
        this.numpaths = this.pat.getNumberOfPaths();
        this.looptime = this.pat.getLoopEndTime() - this.pat.getLoopStartTime();
        this.loopperm = this.pat.getPathPermutation();
        this.evjuggler = this.ev.getJuggler() - 1;
        this.evhand = HandLink.index(this.ev.getHand());
        this.evtransitions = this.ev.getNumberOfTransitions();
        this.evtime = this.ev.getT();
        int n2 = this.pat.getNumberOfSymmetries() - 1;
        JMLSymmetry[] jMLSymmetryArray = new JMLSymmetry[n2];
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        Permutation permutation = null;
        this.numentries = 1;
        int n3 = 0;
        block5: for (n = 0; n <= n2; ++n) {
            object = this.pat.getSymmetry(n);
            switch (((JMLSymmetry)object).getType()) {
                case 1: {
                    permutation = ((JMLSymmetry)object).getPathPerm().getInverse();
                    continue block5;
                }
                case 2: {
                    jMLSymmetryArray[n3] = object;
                    nArray[n3] = ((JMLSymmetry)object).getJugglerPerm().getOrder();
                    nArray2[n3] = 0;
                    ++n3;
                    continue block5;
                }
                case 3: {
                    jMLSymmetryArray[n3] = object;
                    nArray[n3] = ((JMLSymmetry)object).getJugglerPerm().getOrder();
                    this.numentries = Permutation.lcm(this.numentries, nArray[n3]);
                    nArray2[n3] = -1;
                    ++n3;
                }
            }
        }
        for (n = 0; n < n2; ++n) {
            if (nArray2[n] != -1) continue;
            nArray2[n] = this.numentries / nArray[n];
        }
        this.ea = new Permutation[this.numjugglers][2][this.numentries];
        this.transitiontype = new int[this.evtransitions];
        Permutation permutation2 = new Permutation(this.numpaths, false);
        this.ev.setPathPermFromMaster(permutation2);
        this.ea[this.evjuggler][this.evhand][0] = permutation2;
        for (n3 = 0; n3 < this.evtransitions; ++n3) {
            object = this.ev.getTransition(n3);
            this.transitiontype[n3] = ((JMLTransition)object).getType();
        }
        do {
            n3 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < this.numjugglers; ++j) {
                    for (int k = 0; k < 2; ++k) {
                        for (int i2 = 0; i2 < this.numentries; ++i2) {
                            int n4;
                            int n5 = jMLSymmetryArray[i].getJugglerPerm().getMapping(j + 1);
                            if (n5 == 0) continue;
                            int n6 = n4 = n5 < 0 ? 1 - k : k;
                            if (n5 < 0) {
                                n5 = -n5;
                            }
                            --n5;
                            Permutation permutation3 = this.ea[j][k][i2];
                            if (permutation3 == null) continue;
                            permutation3 = jMLSymmetryArray[i].getPathPerm().apply(permutation3);
                            int n7 = i2 + nArray2[i];
                            if (n7 >= this.numentries) {
                                permutation3 = permutation.apply(permutation3);
                                n7 -= this.numentries;
                            }
                            if (this.ea[n5][n4][n7] != null) {
                                if (permutation3.equals(this.ea[n5][n4][n7])) continue;
                                throw new JuggleExceptionUser("Symmetries inconsistent");
                            }
                            this.ea[n5][n4][n7] = permutation3;
                            n3 = 1;
                        }
                    }
                }
            }
        } while (n3 != 0);
    }
}

