/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.generator;

import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import jugglinglab.JugglingLab;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.generator.SiteswapTransitioner;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public abstract class Transitioner {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    public static final String[] builtinTransitioners = new String[]{"Siteswap"};

    public static Transitioner newTransitioner(String string) {
        if (string.equalsIgnoreCase("siteswap")) {
            return new SiteswapTransitioner();
        }
        return null;
    }

    public void initTransitioner(String string) throws JuggleExceptionUser, JuggleExceptionInternal {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        this.initTransitioner(stringArray);
    }

    public abstract String getNotationName();

    public abstract JPanel getTransitionerControl();

    public abstract void resetTransitionerControl();

    public abstract void initTransitioner() throws JuggleExceptionUser, JuggleExceptionInternal;

    public abstract void initTransitioner(String[] var1) throws JuggleExceptionUser, JuggleExceptionInternal;

    public abstract int runTransitioner(GeneratorTarget var1) throws JuggleExceptionUser, JuggleExceptionInternal;

    public abstract int runTransitioner(GeneratorTarget var1, int var2, double var3) throws JuggleExceptionUser, JuggleExceptionInternal;
}

