/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.generator;

import java.text.MessageFormat;
import jugglinglab.JugglingLab;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.generator.SiteswapTransitionerControl;
import jugglinglab.generator.Transitioner;
import jugglinglab.notation.MHNThrow;
import jugglinglab.notation.SiteswapPattern;
import jugglinglab.util.JuggleExceptionDone;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionInterrupted;
import jugglinglab.util.JuggleExceptionUser;

public class SiteswapTransitioner
extends Transitioner {
    protected static final int loop_counter_max = 20000;
    protected int n;
    protected int jugglers;
    protected int indexes;
    protected int l_min;
    protected int l_max;
    protected int target_occupancy;
    protected int max_occupancy;
    protected boolean mp_allow_simulcatches;
    protected boolean mp_allow_clusters;
    protected boolean no_limits;
    protected String pattern_from;
    protected String pattern_to;
    protected SiteswapPattern siteswap_from;
    protected SiteswapPattern siteswap_to;
    protected int[][][] state_from;
    protected int[][][] state_to;
    protected String return_trans;
    protected int[][][][] state;
    protected int[][][] state_target;
    protected int l_target;
    protected int l_return;
    protected MHNThrow[][][][] th;
    protected int[][][] throws_left;
    protected boolean find_all;
    protected String[][] out;
    protected boolean[] should_print;
    protected boolean[][] async_hand_right;
    protected SiteswapPattern siteswap_prev;
    protected int target_max_filled_index;
    protected int max_num;
    protected double max_time;
    protected long max_time_millis;
    protected long start_time_millis;
    protected int loop_counter;
    protected SiteswapTransitionerControl control;
    protected GeneratorTarget target;
    protected static final int trans_max_patterns = 1000;
    protected static final double trans_max_time = 15.0;

    @Override
    public String getNotationName() {
        return "Siteswap";
    }

    @Override
    public SiteswapTransitionerControl getTransitionerControl() {
        if (this.control == null) {
            this.control = new SiteswapTransitionerControl();
        }
        return this.control;
    }

    @Override
    public void resetTransitionerControl() {
        if (this.control != null) {
            this.control.resetControl();
        }
    }

    @Override
    public void initTransitioner() throws JuggleExceptionUser, JuggleExceptionInternal {
        if (this.control == null) {
            this.initTransitioner("5 771");
        } else {
            this.initTransitioner(this.control.getParams());
        }
    }

    @Override
    public void initTransitioner(String[] stringArray) throws JuggleExceptionUser, JuggleExceptionInternal {
        this.configTransitioner(stringArray);
        this.allocateWorkspace();
    }

    @Override
    public int runTransitioner(GeneratorTarget generatorTarget) throws JuggleExceptionUser, JuggleExceptionInternal {
        return this.runTransitioner(generatorTarget, -1, -1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int runTransitioner(GeneratorTarget generatorTarget, int n, double d) throws JuggleExceptionUser, JuggleExceptionInternal {
        int n2;
        this.max_num = n;
        this.max_time = d;
        if (this.max_time > 0.0) {
            this.max_time_millis = (long)(1000.0 * d);
            this.start_time_millis = System.currentTimeMillis();
            this.loop_counter = 0;
        }
        generatorTarget.setPrefixSuffix("(" + this.pattern_from + "^2)", "(" + this.pattern_to + "^2)" + this.findReturnTrans());
        int n3 = 0;
        this.target = generatorTarget;
        if (this.l_min == 0) {
            this.target.writePattern("", "siteswap", "");
            n3 = 1;
        } else {
            this.siteswap_prev = this.siteswap_from;
            for (n2 = this.l_min; n2 <= this.l_max || n3 == 0; n3 += this.findTrans(this.state_from, this.state_to, n2, true), ++n2) {
            }
        }
        if (n3 == 1) {
            this.target.setStatus(guistrings.getString("Generator_patterns_1"));
        } else {
            String string = guistrings.getString("Generator_patterns_ne1");
            Object[] objectArray = new Object[]{new Integer(n3)};
            this.target.setStatus(MessageFormat.format(string, objectArray));
        }
        n2 = n3;
        return n2;
    }

    protected void configTransitioner(String[] stringArray) throws JuggleExceptionUser, JuggleExceptionInternal {
        int n;
        int n2;
        if (stringArray.length < 2) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_trans_too_few_args"));
        }
        if (stringArray[0].equals("-")) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_trans_from_pattern"));
        }
        if (stringArray[1].equals("-")) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_trans_to_pattern"));
        }
        this.target_occupancy = 1;
        this.mp_allow_simulcatches = false;
        this.mp_allow_clusters = true;
        this.no_limits = false;
        this.target = null;
        for (n2 = 2; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].equals("-mf")) {
                this.mp_allow_simulcatches = true;
                continue;
            }
            if (stringArray[n2].equals("-mc")) {
                this.mp_allow_clusters = false;
                continue;
            }
            if (stringArray[n2].equals("-m")) {
                if (n2 >= stringArray.length - 1 || stringArray[n2 + 1].charAt(0) == '-') continue;
                try {
                    this.target_occupancy = Integer.parseInt(stringArray[n2 + 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    String string = errorstrings.getString("Error_number_format");
                    String string2 = guistrings.getString("simultaneous_throws");
                    Object[] objectArray = new Object[]{string2};
                    throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
                }
                ++n2;
                continue;
            }
            if (stringArray[n2].equals("-limits")) {
                this.no_limits = true;
                continue;
            }
            String string = errorstrings.getString("Error_unrecognized_option");
            Object[] objectArray = new Object[]{stringArray[n2]};
            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
        }
        this.pattern_from = stringArray[0];
        this.pattern_to = stringArray[1];
        this.siteswap_from = new SiteswapPattern();
        this.siteswap_to = new SiteswapPattern();
        try {
            this.siteswap_from.fromString(this.pattern_from);
        }
        catch (JuggleExceptionUser juggleExceptionUser) {
            String string = errorstrings.getString("Error_trans_in_from_pattern");
            Object[] objectArray = new Object[]{juggleExceptionUser.getMessage()};
            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
        }
        try {
            this.siteswap_to.fromString(this.pattern_to);
        }
        catch (JuggleExceptionUser juggleExceptionUser) {
            String string = errorstrings.getString("Error_trans_in_to_pattern");
            Object[] objectArray = new Object[]{juggleExceptionUser.getMessage()};
            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
        }
        n2 = this.siteswap_from.getNumberOfPaths();
        int n3 = this.siteswap_to.getNumberOfPaths();
        if (n2 != n3) {
            String string = errorstrings.getString("Error_trans_unequal_objects");
            Object[] objectArray = new Object[]{n2, n3};
            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
        }
        this.n = n2;
        int n4 = this.siteswap_from.getNumberOfJugglers();
        if (n4 != (n = this.siteswap_to.getNumberOfJugglers())) {
            String string = errorstrings.getString("Error_trans_unequal_jugglers");
            Object[] objectArray = new Object[]{n4, n};
            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
        }
        this.jugglers = n4;
        this.indexes = Math.max(this.siteswap_from.getIndexes(), this.siteswap_to.getIndexes());
        this.max_occupancy = Math.max(this.target_occupancy, Math.max(this.siteswap_from.getMaxOccupancy(), this.siteswap_to.getMaxOccupancy()));
        this.state_from = this.siteswap_from.getStartingState(this.indexes);
        this.state_to = this.siteswap_to.getStartingState(this.indexes);
        this.l_min = this.findMinLength(this.state_from, this.state_to);
        this.l_max = this.findMaxLength(this.state_from, this.state_to);
        this.l_return = this.findMinLength(this.state_to, this.state_from);
    }

    protected void allocateWorkspace() {
        int n = Math.max(this.l_max, this.l_return);
        this.state = new int[n + 1][this.jugglers][2][this.indexes];
        this.state_target = new int[this.jugglers][2][this.indexes];
        this.th = new MHNThrow[this.jugglers][2][n][this.max_occupancy];
        this.throws_left = new int[n + 1][this.jugglers][2];
        this.out = new String[this.jugglers][n];
        this.should_print = new boolean[n + 1];
        this.async_hand_right = new boolean[this.jugglers][n + 1];
    }

    protected String findReturnTrans() throws JuggleExceptionUser, JuggleExceptionInternal {
        int n;
        if (this.l_return == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.target = new GeneratorTarget(stringBuffer);
        this.siteswap_prev = this.siteswap_to;
        while ((n = this.findTrans(this.state_to, this.state_from, this.l_return, false)) == 0) {
            ++this.l_return;
            this.allocateWorkspace();
        }
        if (n != 1) {
            throw new JuggleExceptionInternal("Too many transitions in findReturnTrans()");
        }
        String string = stringBuffer.toString().replaceAll("\n", "").replaceAll("R$", "").replaceAll("\\<(R\\|)+R\\>$", "");
        return string;
    }

    protected int findTrans(int[][][] nArray, int[][][] nArray2, int n, boolean bl) throws JuggleExceptionUser, JuggleExceptionInternal {
        int n2;
        this.l_target = n;
        for (n2 = 0; n2 < this.jugglers; ++n2) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < this.indexes; ++j) {
                    this.state[0][n2][i][j] = nArray[n2][i][j];
                    this.state_target[n2][i][j] = nArray2[n2][i][j];
                }
            }
        }
        this.target_max_filled_index = this.getMaxFilledIndex(this.state_target);
        this.startBeat(0);
        this.find_all = bl;
        n2 = this.recurse(0, 0, 0);
        return n2;
    }

    protected int recurse(int n, int n2, int n3) throws JuggleExceptionUser, JuggleExceptionInternal {
        int n4;
        if (Thread.interrupted()) {
            throw new JuggleExceptionInterrupted();
        }
        if (this.max_time > 0.0 && ++this.loop_counter > 20000) {
            this.loop_counter = 0;
            if (System.currentTimeMillis() - this.start_time_millis > this.max_time_millis) {
                String string = guistrings.getString("Generator_timeout");
                Object[] objectArray = new Object[]{new Integer((int)this.max_time)};
                throw new JuggleExceptionDone(MessageFormat.format(string, objectArray));
            }
        }
        while (this.throws_left[n][n2][n3] == 0) {
            if (n3 == 1) {
                n3 = 0;
                ++n2;
            } else {
                n3 = 1;
            }
            if (n2 != this.jugglers) continue;
            if (++n < this.l_target) {
                this.startBeat(n);
                n3 = 0;
                n2 = 0;
                continue;
            }
            if (this.statesEqual(this.state[n], this.state_target)) {
                this.outputPattern();
                return 1;
            }
            return 0;
        }
        MHNThrow mHNThrow = new MHNThrow();
        mHNThrow.juggler = n2 + 1;
        mHNThrow.hand = n3;
        mHNThrow.index = n;
        mHNThrow.slot = 0;
        while (this.th[n2][n3][n][mHNThrow.slot] != null) {
            ++mHNThrow.slot;
        }
        int n5 = n + 1;
        int n6 = Math.min(n + Math.min(this.indexes, 35), this.l_target + this.target_max_filled_index);
        int n7 = n4 = Math.min(Math.max(this.l_target, n5), n6);
        int n8 = 0;
        do {
            for (int i = 0; i < this.jugglers; ++i) {
                for (int j = 0; j < 2; ++j) {
                    int n9 = this.state[n + 1][i][j][n7 - n - 1];
                    int n10 = n7 - this.l_target;
                    if (n10 >= 0 && n10 < this.indexes ? n9 >= this.state_target[i][j][n10] : n9 >= this.target_occupancy) continue;
                    mHNThrow.targetjuggler = i + 1;
                    mHNThrow.targethand = j;
                    mHNThrow.targetindex = n7;
                    mHNThrow.targetslot = n9;
                    if (!this.isThrowValid(n, mHNThrow)) continue;
                    this.addThrow(n, mHNThrow);
                    this.removeThrow(n, mHNThrow);
                    if (!this.find_all && (n8 += this.recurse(n, n2, n3)) > 0) {
                        return n8;
                    }
                    if (this.max_num <= 0 || n8 < this.max_num) continue;
                    String string = guistrings.getString("Generator_spacelimit");
                    Object[] objectArray = new Object[]{new Integer(this.max_num)};
                    throw new JuggleExceptionDone(MessageFormat.format(string, objectArray));
                }
            }
            if (++n7 <= n6) continue;
            n7 = n5;
        } while (n7 != n4);
        return n8;
    }

    protected boolean isThrowValid(int n, MHNThrow mHNThrow) {
        int n2;
        MHNThrow[][][][] mHNThrowArray;
        int n3;
        int[][][] nArray;
        int n4 = mHNThrow.juggler - 1;
        int n5 = mHNThrow.hand;
        int n6 = mHNThrow.index;
        int n7 = mHNThrow.targetjuggler - 1;
        int n8 = mHNThrow.targethand;
        int n9 = mHNThrow.targetindex;
        if (n9 - n6 > 35) {
            return false;
        }
        int[][][] nArray2 = nArray = n + 1 == this.l_target ? this.state_target : this.state[n + 1];
        if (nArray[n4][n5][0] > 0 && (n7 != n4 || n8 != n5 || n9 != n6 + 1)) {
            return false;
        }
        if (n > 0 && this.state[n - 1][n4][n5][0] > 0 && n7 == n4 && n8 == n5 && n9 == n6 + 1) {
            return false;
        }
        for (n3 = 0; n3 < this.max_occupancy && (mHNThrowArray = this.th[n4][n5][n][n3]) != null; ++n3) {
            if (MHNThrow.compareThrows(mHNThrow, (MHNThrow)mHNThrowArray) != 1) continue;
            return false;
        }
        if (this.max_occupancy > 1 && !this.mp_allow_clusters) {
            for (n3 = 0; n3 < this.max_occupancy && (mHNThrowArray = this.th[n4][n5][n][n3]) != null; ++n3) {
                if (MHNThrow.compareThrows(mHNThrow, (MHNThrow)mHNThrowArray) != 0) continue;
                return false;
            }
        }
        if (this.target_occupancy > 1 && !this.mp_allow_simulcatches && this.th[n4][n5][n][0] != null) {
            int n10;
            int n11;
            n3 = 0;
            for (int i = 0; i < this.jugglers; ++i) {
                for (n2 = 0; n2 < 2; ++n2) {
                    for (n11 = 0; n11 < n; ++n11) {
                        MHNThrow mHNThrow2;
                        for (n10 = 0; n10 < this.max_occupancy && (mHNThrow2 = this.th[i][n2][n11][n10]) != null; ++n10) {
                            if (mHNThrow2.targetjuggler != mHNThrow.juggler || mHNThrow2.targethand != mHNThrow.hand || mHNThrow2.targetindex != n || mHNThrow2.isHold()) continue;
                            ++n3;
                        }
                    }
                }
            }
            mHNThrowArray = this.siteswap_prev.getThrows();
            n2 = this.siteswap_prev.getPeriod();
            n11 = this.siteswap_prev.getMaxOccupancy();
            for (n10 = 0; n10 < this.jugglers; ++n10) {
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        MHNThrow mHNThrow3;
                        for (int k = 0; k < n11 && (mHNThrow3 = mHNThrowArray[n10][i][j][k]) != null; ++k) {
                            boolean bl;
                            int n12 = mHNThrow3.targetindex - (n + n2);
                            boolean bl2 = bl = n12 >= 0 && n12 % n2 == 0;
                            if (!bl || mHNThrow3.targetjuggler != mHNThrow.juggler || mHNThrow3.targethand != mHNThrow.hand || mHNThrow3.isHold()) continue;
                            ++n3;
                        }
                    }
                }
            }
            if (n3 > 1) {
                return false;
            }
        }
        if ((n9 - n6 != 1 || n7 != n4 || n8 != n5) && n9 - n - 2 >= 0) {
            n3 = this.state[n + 1][n7][n8][n9 - n - 2];
            int n13 = this.target_occupancy - 1;
            n2 = n9 - this.l_target;
            if (n2 >= 0 && n2 < this.indexes) {
                n13 = this.state_target[n7][n8][n2] - 1;
            }
            if (mHNThrow.targetslot > n13 - n3) {
                return false;
            }
        }
        return true;
    }

    protected void addThrow(int n, MHNThrow mHNThrow) {
        int n2 = mHNThrow.juggler - 1;
        int n3 = mHNThrow.hand;
        int n4 = mHNThrow.index;
        int n5 = mHNThrow.slot;
        int n6 = mHNThrow.targetjuggler - 1;
        int n7 = mHNThrow.targethand;
        int n8 = mHNThrow.targetindex;
        this.th[n2][n3][n4][n5] = mHNThrow;
        int[] nArray = this.throws_left[n][n2];
        int n9 = n3;
        nArray[n9] = nArray[n9] - 1;
        for (int i = n + 1; i <= this.l_target && i <= n8; ++i) {
            int[] nArray2 = this.state[i][n6][n7];
            int n10 = n8 - i;
            nArray2[n10] = nArray2[n10] + 1;
        }
    }

    protected void removeThrow(int n, MHNThrow mHNThrow) {
        int n2 = mHNThrow.juggler - 1;
        int n3 = mHNThrow.hand;
        int n4 = mHNThrow.index;
        int n5 = mHNThrow.slot;
        int n6 = mHNThrow.targetjuggler - 1;
        int n7 = mHNThrow.targethand;
        int n8 = mHNThrow.targetindex;
        this.th[n2][n3][n4][n5] = null;
        int[] nArray = this.throws_left[n][n2];
        int n9 = n3;
        nArray[n9] = nArray[n9] + 1;
        for (int i = n + 1; i <= this.l_target && i <= n8; ++i) {
            int[] nArray2 = this.state[i][n6][n7];
            int n10 = n8 - i;
            nArray2[n10] = nArray2[n10] - 1;
        }
    }

    protected void outputPattern() throws JuggleExceptionInternal {
        int n;
        int n2;
        if (this.target == null) {
            return;
        }
        for (int i = 0; i < this.l_target; ++i) {
            this.outputBeat(i);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.jugglers > 1) {
            stringBuffer.append('<');
        }
        for (n2 = 0; n2 < this.jugglers; ++n2) {
            for (n = 0; n < this.l_target; ++n) {
                stringBuffer.append(this.out[n2][n]);
            }
            if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '/') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            if (n2 >= this.jugglers - 1) continue;
            stringBuffer.append('|');
        }
        if (this.jugglers > 1) {
            stringBuffer.append('>');
        }
        n2 = 0;
        for (n = 0; n < this.jugglers; ++n) {
            if (this.async_hand_right[n][this.l_target]) continue;
            n2 = 1;
            break;
        }
        if (n2 != 0) {
            if (this.jugglers > 1) {
                stringBuffer.append('<');
            }
            for (n = 0; n < this.jugglers; ++n) {
                stringBuffer.append('R');
                if (n >= this.jugglers - 1) continue;
                stringBuffer.append('|');
            }
            if (this.jugglers > 1) {
                stringBuffer.append('>');
            }
        }
        this.target.writePattern(stringBuffer.toString(), "siteswap", stringBuffer.toString().trim());
    }

    protected void outputBeat(int n) {
        int n2;
        if (!this.should_print[n]) {
            this.should_print[n + 1] = true;
            for (int i = 0; i < this.jugglers; ++i) {
                this.async_hand_right[i][n + 1] = !this.async_hand_right[i][n];
                this.out[i][n] = "";
            }
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (n2 = 0; n2 < this.jugglers; ++n2) {
            if (this.th[n2][0][n][0] != null && this.th[n2][1][n][0] != null) {
                bl = true;
            }
            if (this.state[n + 1][n2][0][0] <= 0 && this.state[n + 1][n2][1][0] <= 0) continue;
            bl2 = true;
        }
        n2 = bl && !bl2 ? 1 : 0;
        this.should_print[n + 1] = n2 == 0;
        for (int i = 0; i < this.jugglers; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl3 = !this.async_hand_right[i][n];
            int n3 = 0;
            if (this.th[i][0][n][0] != null) {
                ++n3;
            }
            if (this.th[i][1][n][0] != null) {
                ++n3;
            }
            switch (n3) {
                case 0: {
                    if (n == 0 && this.siteswap_prev.hasHandsSpecifier()) {
                        stringBuffer.append('R');
                    }
                    stringBuffer.append('0');
                    if (n2 == 0) break;
                    stringBuffer.append('0');
                    break;
                }
                case 1: {
                    boolean bl4;
                    if (this.th[i][0][n][0] != null) {
                        if (!this.async_hand_right[i][n]) {
                            stringBuffer.append('R');
                            bl3 = false;
                        } else if (n == 0 && this.siteswap_prev.hasHandsSpecifier()) {
                            stringBuffer.append('R');
                        }
                        bl4 = this.outputMultiThrow(n, i, 0, stringBuffer);
                    } else {
                        if (this.async_hand_right[i][n]) {
                            stringBuffer.append('L');
                            bl3 = true;
                        } else if (n == 0 && this.siteswap_prev.hasHandsSpecifier()) {
                            stringBuffer.append('R');
                        }
                        bl4 = this.outputMultiThrow(n, i, 1, stringBuffer);
                    }
                    if (bl4) {
                        stringBuffer.append('/');
                    }
                    if (n2 == 0) break;
                    stringBuffer.append('0');
                    break;
                }
                case 2: {
                    if (n == 0 && this.siteswap_prev.hasHandsSpecifier()) {
                        stringBuffer.append('R');
                    }
                    stringBuffer.append('(');
                    this.outputMultiThrow(n, i, 1, stringBuffer);
                    stringBuffer.append(',');
                    this.outputMultiThrow(n, i, 0, stringBuffer);
                    stringBuffer.append(')');
                    if (n2 != 0 && n != this.l_target - 1) break;
                    stringBuffer.append('!');
                }
            }
            this.async_hand_right[i][n + 1] = bl3;
            this.out[i][n] = stringBuffer.toString();
        }
    }

    protected boolean outputMultiThrow(int n, int n2, int n3, StringBuffer stringBuffer) {
        MHNThrow mHNThrow;
        int n4;
        boolean bl = false;
        int n5 = 0;
        for (n4 = 0; n4 < this.max_occupancy; ++n4) {
            if (this.th[n2][n3][n][n4] == null) continue;
            ++n5;
        }
        if (n5 == 0) {
            return false;
        }
        if (n5 > 1) {
            stringBuffer.append('[');
        }
        for (n4 = 0; n4 < this.max_occupancy && (mHNThrow = this.th[n2][n3][n][n4]) != null; ++n4) {
            boolean bl2;
            int n6 = mHNThrow.targetindex - mHNThrow.index;
            boolean bl3 = mHNThrow.hand == mHNThrow.targethand ^ n6 % 2 == 0;
            boolean bl4 = bl2 = mHNThrow.targetjuggler != mHNThrow.juggler;
            if (n6 < 36) {
                stringBuffer.append(Character.toLowerCase(Character.forDigit(n6, 36)));
            } else {
                stringBuffer.append('?');
            }
            if (bl3) {
                stringBuffer.append('x');
            }
            if (bl2) {
                boolean bl5;
                stringBuffer.append('p');
                if (this.jugglers > 2) {
                    stringBuffer.append(mHNThrow.targetjuggler);
                }
                boolean bl6 = bl5 = n4 + 1 < this.max_occupancy && this.th[n2][n3][n][n4 + 1] != null;
                if (bl5) {
                    stringBuffer.append('/');
                }
                bl = true;
                continue;
            }
            bl = false;
        }
        if (n5 > 1) {
            stringBuffer.append(']');
            bl = false;
        }
        return bl;
    }

    protected void startBeat(int n) {
        int n2;
        if (n == 0) {
            this.should_print[0] = true;
            for (n2 = 0; n2 < this.jugglers; ++n2) {
                this.async_hand_right[n2][0] = true;
            }
        }
        for (n2 = 0; n2 < this.jugglers; ++n2) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < this.indexes - 1; ++j) {
                    this.state[n + 1][n2][i][j] = this.state[n][n2][i][j + 1];
                }
                this.state[n + 1][n2][i][this.indexes - 1] = 0;
                this.throws_left[n][n2][i] = this.state[n][n2][i][0];
            }
        }
    }

    protected boolean statesEqual(int[][][] nArray, int[][][] nArray2) {
        for (int i = 0; i < this.jugglers; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < this.indexes; ++k) {
                    if (nArray[i][j][k] == nArray2[i][j][k]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void printState(int[][][] nArray) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < this.indexes; ++n3) {
            for (n2 = 0; n2 < this.jugglers; ++n2) {
                for (n = 0; n < 2; ++n) {
                    if (nArray[n2][n][n3] == 0) continue;
                    n4 = n3;
                }
            }
        }
        for (n3 = 0; n3 <= n4; ++n3) {
            for (n2 = 0; n2 < this.jugglers; ++n2) {
                for (n = 0; n < 2; ++n) {
                    System.out.println("  s[" + n2 + "][" + n + "][" + n3 + "] = " + nArray[n2][n][n3]);
                }
            }
        }
    }

    protected int findMinLength(int[][][] nArray, int[][][] nArray2) {
        int n = 0;
        while (true) {
            boolean bl = true;
            for (int i = 0; i < this.jugglers; ++i) {
                for (int j = 0; j < 2; ++j) {
                    for (int k = 0; k < this.indexes - n; ++k) {
                        if (nArray[i][j][k + n] <= nArray2[i][j][k]) continue;
                        bl = false;
                    }
                }
            }
            if (bl) {
                return n;
            }
            ++n;
        }
    }

    protected int findMaxLength(int[][][] nArray, int[][][] nArray2) {
        int n = 0;
        for (int i = 0; i < this.indexes; ++i) {
            for (int j = 0; j < this.jugglers; ++j) {
                for (int k = 0; k < 2; ++k) {
                    if (nArray[j][k][i] <= 0) continue;
                    n = i + 1;
                }
            }
        }
        return n;
    }

    protected int getMaxFilledIndex(int[][][] nArray) {
        for (int i = this.indexes - 1; i >= 0; --i) {
            for (int j = 0; j < this.jugglers; ++j) {
                for (int k = 0; k < 2; ++k) {
                    if (nArray[j][k][i] <= 0) continue;
                    return i;
                }
            }
        }
        return 0;
    }

    protected void printThrowSet() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.l_target; ++i) {
            for (int j = 0; j < this.jugglers; ++j) {
                for (int k = 0; k < 2; ++k) {
                    for (int i2 = 0; i2 < this.max_occupancy; ++i2) {
                        MHNThrow mHNThrow = this.th[j][k][i][i2];
                        if (mHNThrow == null) continue;
                        for (int i3 = 0; i3 < i; ++i3) {
                            stringBuffer.append(".  ");
                        }
                        stringBuffer.append(mHNThrow.toString() + '\n');
                    }
                }
            }
        }
        System.out.println(stringBuffer.toString());
    }

    public static void runTransitionerCLI(String[] stringArray, GeneratorTarget generatorTarget) {
        if (stringArray.length < 2) {
            String string = guistrings.getString("Version");
            Object[] objectArray = new Object[]{"1.4.1"};
            String string2 = "Juggling Lab " + MessageFormat.format(string, objectArray).toLowerCase() + "\n";
            string = guistrings.getString("Copyright_message");
            Object[] objectArray2 = new Object[]{"2021"};
            string2 = string2 + MessageFormat.format(string, objectArray2) + "\n\n";
            string2 = string2 + guistrings.getString("GPL_message") + "\n\n";
            String string3 = guistrings.getString("Transitioner_intro");
            if (JugglingLab.isWindows) {
                string3 = string3.replaceAll("'", "\"");
            }
            string2 = string2 + string3;
            System.out.println(string2);
            return;
        }
        if (generatorTarget == null) {
            return;
        }
        try {
            SiteswapTransitioner siteswapTransitioner = new SiteswapTransitioner();
            siteswapTransitioner.initTransitioner(stringArray);
            if (siteswapTransitioner.no_limits) {
                siteswapTransitioner.runTransitioner(generatorTarget);
            } else {
                siteswapTransitioner.runTransitioner(generatorTarget, 1000, 15.0);
            }
        }
        catch (JuggleExceptionDone juggleExceptionDone) {
            System.out.println(juggleExceptionDone.getMessage());
        }
        catch (Exception exception) {
            System.out.println(errorstrings.getString("Error") + ": " + exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        SiteswapTransitioner.runTransitionerCLI(stringArray, new GeneratorTarget(System.out));
    }
}

