/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.generator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JPanel;
import jugglinglab.generator.Generator;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.generator.SiteswapGeneratorControl;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionDone;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionInterrupted;
import jugglinglab.util.JuggleExceptionUser;

public class SiteswapGenerator
extends Generator {
    protected static final int ASYNC = 0;
    protected static final int SYNC = 1;
    private static final int MP_EMPTY = 0;
    private static final int MP_THROW = 1;
    private static final int MP_LOWER_BOUND = 2;
    private static final int TYPE = 0;
    private static final int FROM = 1;
    private static final int VALUE = 2;
    private static final int CHARS_PER_THROW = 50;
    protected static final int[][] async_rhythm_repunit = new int[][]{{1}};
    protected static final int[][] sync_rhythm_repunit = new int[][]{{1, 0}, {1, 0}};
    private static final int loop_counter_max = 20000;
    protected int n;
    protected int jugglers;
    protected int ht;
    protected int l_min;
    protected int l_max;
    protected ArrayList<Pattern> exclude;
    protected ArrayList<Pattern> include;
    protected int numflag;
    protected int groundflag;
    protected int rotflag;
    protected int fullflag;
    protected int mpflag;
    protected int multiplex;
    protected int delaytime;
    protected int hands;
    protected int max_occupancy;
    protected int leader_person;
    protected int[][] rhythm_repunit;
    protected int rhythm_period;
    protected int[] holdthrow;
    protected int[] person_number;
    protected int[][] ground_state;
    protected int ground_state_length;
    protected boolean mp_clustered;
    protected boolean lameflag;
    protected boolean sequenceflag;
    protected boolean connected_patterns;
    protected boolean juggler_permutations;
    protected int mode;
    protected int slot_size;
    protected int[][][] state;
    protected int l_target;
    protected int[][][] rhythm;
    protected int[][] throws_left;
    protected int[][] holes;
    protected int[][][] throw_to;
    protected int[][][] throw_value;
    protected int[][][][] mp_filter;
    protected boolean pattern_printx;
    protected int[] scratch1;
    protected int[] scratch2;
    protected char[] output;
    protected boolean[] connections;
    protected boolean[] perm_scratch1;
    protected boolean[] perm_scratch2;
    protected char[] starting_seq;
    protected char[] ending_seq;
    protected int starting_seq_length;
    protected int ending_seq_length;
    protected int max_num;
    protected double max_time;
    protected long max_time_millis;
    protected long start_time_millis;
    protected int loop_counter;
    protected SiteswapGeneratorControl control;
    protected GeneratorTarget target;

    @Override
    public String getNotationName() {
        return "Siteswap";
    }

    @Override
    public String getStartupMessage() {
        return "Welcome to the J2 Siteswap Generator";
    }

    @Override
    public JPanel getGeneratorControl() {
        if (this.control == null) {
            this.control = new SiteswapGeneratorControl();
        }
        return this.control;
    }

    @Override
    public void resetGeneratorControl() {
        if (this.control != null) {
            this.control.resetControl();
        }
    }

    @Override
    public void initGenerator() throws JuggleExceptionUser {
        if (this.control == null) {
            this.initGenerator("5 7 5");
        } else {
            this.initGenerator(this.control.getParams());
        }
    }

    @Override
    public void initGenerator(String[] stringArray) throws JuggleExceptionUser {
        this.configGenerator(stringArray);
        this.allocateWorkspace();
    }

    @Override
    public int runGenerator(GeneratorTarget generatorTarget) throws JuggleExceptionUser, JuggleExceptionInternal {
        return this.runGenerator(generatorTarget, -1, -1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int runGenerator(GeneratorTarget generatorTarget, int n, double d) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (this.groundflag == 1 && this.ground_state_length > this.ht) {
            return 0;
        }
        this.max_num = n;
        this.max_time = d;
        if (this.max_time > 0.0) {
            this.max_time_millis = (long)(1000.0 * d);
            this.start_time_millis = System.currentTimeMillis();
            this.loop_counter = 0;
        }
        this.target = generatorTarget;
        int n2 = 0;
        this.l_target = this.l_min;
        while (this.l_target <= this.l_max) {
            n2 += this.findPatterns(0, 0, 0);
            this.l_target += this.rhythm_period;
        }
        if (this.numflag != 0) {
            if (n2 == 1) {
                this.target.setStatus(guistrings.getString("Generator_patterns_1"));
            } else {
                String string = guistrings.getString("Generator_patterns_ne1");
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.target.setStatus(MessageFormat.format(string, objectArray));
            }
        }
        int n3 = n2;
        return n3;
    }

    protected void configGenerator(String[] stringArray) throws JuggleExceptionUser {
        Object object;
        int n;
        if (stringArray.length < 3) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_generator_insufficient_input"));
        }
        this.max_occupancy = 0;
        this.leader_person = 1;
        this.numflag = 0;
        this.groundflag = 0;
        this.rotflag = 0;
        this.mpflag = 1;
        this.fullflag = 1;
        this.mp_clustered = true;
        this.multiplex = 1;
        this.delaytime = 0;
        this.lameflag = false;
        this.connected_patterns = false;
        this.juggler_permutations = false;
        this.sequenceflag = true;
        this.mode = 0;
        this.jugglers = 1;
        this.target = null;
        this.exclude = new ArrayList();
        this.include = new ArrayList();
        boolean bl = false;
        for (n = 3; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-n")) {
                this.numflag = 1;
                continue;
            }
            if (stringArray[n].equals("-no")) {
                this.numflag = 2;
                continue;
            }
            if (stringArray[n].equals("-g")) {
                this.groundflag = 1;
                continue;
            }
            if (stringArray[n].equals("-ng")) {
                this.groundflag = 2;
                continue;
            }
            if (stringArray[n].equals("-f")) {
                this.fullflag = 0;
                continue;
            }
            if (stringArray[n].equals("-prime")) {
                this.fullflag = 2;
                continue;
            }
            if (stringArray[n].equals("-rot")) {
                this.rotflag = 1;
                continue;
            }
            if (stringArray[n].equals("-jp")) {
                this.juggler_permutations = true;
                continue;
            }
            if (stringArray[n].equals("-lame")) {
                this.lameflag = true;
                continue;
            }
            if (stringArray[n].equals("-se")) {
                this.sequenceflag = false;
                continue;
            }
            if (stringArray[n].equals("-s")) {
                this.mode = 1;
                continue;
            }
            if (stringArray[n].equals("-cp")) {
                this.connected_patterns = true;
                continue;
            }
            if (stringArray[n].equals("-mf")) {
                this.mpflag = 0;
                continue;
            }
            if (stringArray[n].equals("-mc")) {
                this.mp_clustered = false;
                continue;
            }
            if (stringArray[n].equals("-mt")) {
                bl = true;
                continue;
            }
            if (stringArray[n].equals("-m")) {
                if (n >= stringArray.length - 1 || stringArray[n + 1].charAt(0) == '-') continue;
                try {
                    this.multiplex = Integer.parseInt(stringArray[n + 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    String string = errorstrings.getString("Error_number_format");
                    String string2 = guistrings.getString("simultaneous_throws");
                    Object[] objectArray = new Object[]{string2};
                    throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
                }
                ++n;
                continue;
            }
            if (stringArray[n].equals("-j")) {
                if (n >= stringArray.length - 1 || stringArray[n + 1].charAt(0) == '-') continue;
                try {
                    this.jugglers = Integer.parseInt(stringArray[n + 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    String string = errorstrings.getString("Error_number_format");
                    String string3 = guistrings.getString("Jugglers");
                    Object[] objectArray = new Object[]{string3};
                    throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
                }
                ++n;
                continue;
            }
            if (stringArray[n].equals("-d")) {
                if (n >= stringArray.length - 1 || stringArray[n + 1].charAt(0) == '-') continue;
                try {
                    this.delaytime = Integer.parseInt(stringArray[n + 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    String string = errorstrings.getString("Error_number_format");
                    String string4 = guistrings.getString("Passing_communication_delay");
                    Object[] objectArray = new Object[]{string4};
                    throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
                }
                this.groundflag = 1;
                ++n;
                continue;
            }
            if (stringArray[n].equals("-l")) {
                if (n >= stringArray.length - 1 || stringArray[n + 1].charAt(0) == '-') continue;
                try {
                    this.leader_person = Integer.parseInt(stringArray[n + 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    String string = errorstrings.getString("Error_number_format");
                    String string5 = guistrings.getString("Error_passing_leader_number");
                    Object[] objectArray = new Object[]{string5};
                    throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
                }
                ++n;
                continue;
            }
            if (stringArray[n].equals("-x")) {
                ++n;
                while (n < stringArray.length && stringArray[n].charAt(0) != '-') {
                    try {
                        object = SiteswapGenerator.makeStandardRegex(stringArray[n]);
                        if (((String)object).indexOf("^") < 0) {
                            object = ".*" + (String)object + ".*";
                        }
                        this.exclude.add(Pattern.compile((String)object));
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_excluded_throws"));
                    }
                    ++n;
                }
                --n;
                continue;
            }
            if (stringArray[n].equals("-i")) {
                ++n;
                while (n < stringArray.length && stringArray[n].charAt(0) != '-') {
                    try {
                        object = SiteswapGenerator.makeStandardRegex(stringArray[n]);
                        if (((String)object).indexOf("^") < 0) {
                            object = ".*" + (String)object;
                        }
                        if (((String)object).indexOf("$") < 0) {
                            object = (String)object + ".*";
                        }
                        this.include.add(Pattern.compile((String)object));
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_included_throws"));
                    }
                    ++n;
                }
                --n;
                continue;
            }
            object = errorstrings.getString("Error_unrecognized_option");
            Object[] objectArray = new Object[]{stringArray[n]};
            throw new JuggleExceptionUser(MessageFormat.format((String)object, objectArray));
        }
        this.configMode();
        try {
            this.n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            object = errorstrings.getString("Error_number_format");
            String string = guistrings.getString("balls");
            Object[] objectArray = new Object[]{string};
            throw new JuggleExceptionUser(MessageFormat.format((String)object, objectArray));
        }
        try {
            this.ht = stringArray[1].equals("-") ? -1 : Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            object = errorstrings.getString("Error_number_format");
            String string = guistrings.getString("max._throw");
            Object[] objectArray = new Object[]{string};
            throw new JuggleExceptionUser(MessageFormat.format((String)object, objectArray));
        }
        try {
            if (stringArray[2].equals("-")) {
                this.l_min = this.rhythm_period;
                this.l_max = -1;
            } else {
                n = stringArray[2].indexOf(45);
                if (n == 0) {
                    this.l_min = this.rhythm_period;
                    this.l_max = Integer.parseInt(stringArray[2].substring(1));
                } else if (n == stringArray[2].length() - 1) {
                    this.l_min = Integer.parseInt(stringArray[2].substring(0, n));
                    this.l_max = -1;
                } else if (n > 0) {
                    this.l_min = Integer.parseInt(stringArray[2].substring(0, n));
                    this.l_max = Integer.parseInt(stringArray[2].substring(n + 1));
                } else {
                    this.l_min = this.l_max = Integer.parseInt(stringArray[2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            object = errorstrings.getString("Error_number_format");
            String string = guistrings.getString("period");
            Object[] objectArray = new Object[]{string};
            throw new JuggleExceptionUser(MessageFormat.format((String)object, objectArray));
        }
        if (this.n < 1) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_generator_too_few_balls"));
        }
        if (this.l_max == -1) {
            if (this.fullflag != 2) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_generator_must_be_prime_mode"));
            }
            if (this.ht == -1) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_generator_underspecified"));
            }
            this.l_max = JLFunc.binomial(this.ht * this.hands, this.n);
            this.l_max -= this.l_max % this.rhythm_period;
        }
        if (this.ht == -1) {
            this.ht = this.n * this.l_max;
        }
        if (this.ht < 1) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_generator_height_too_small"));
        }
        if (this.l_min < 1 || this.l_max < 1 || this.l_min > this.l_max) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_generator_period_problem"));
        }
        this.output = new char[this.l_max * 50];
        if (this.jugglers > 1 && !this.juggler_permutations && this.groundflag != 0) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_juggler_permutations"));
        }
        if (this.l_min % this.rhythm_period != 0 || this.l_max % this.rhythm_period != 0) {
            String string = errorstrings.getString("Error_period_multiple");
            object = new Object[]{new Integer(this.rhythm_period)};
            throw new JuggleExceptionUser(MessageFormat.format(string, (Object[])object));
        }
        this.findGround();
        this.slot_size = Math.max(this.ht, this.l_max);
        this.slot_size += this.rhythm_period - this.slot_size % this.rhythm_period;
        for (n = 0; n < this.hands; ++n) {
            for (int i = 0; i < this.rhythm_period; ++i) {
                this.max_occupancy = Math.max(this.max_occupancy, this.rhythm_repunit[n][i]);
            }
        }
        this.max_occupancy *= this.multiplex;
        if (this.max_occupancy == 1) {
            this.mpflag = 0;
        }
        if (bl) {
            String string = null;
            if (this.jugglers == 1) {
                if (this.mode == 0) {
                    string = ".*\\[[^2]*\\].*";
                } else if (this.mode == 1) {
                    string = ".*\\[([^2\\]]*2x)*[^2\\]]*\\].*";
                }
            } else if (this.mode == 0) {
                string = ".*\\[([^2\\]]*(2p|.p2|2p.))*[^2\\]]*\\].*";
            } else if (this.mode == 1) {
                string = ".*\\[([^2\\]]*(2p|.p2|2p.|2x|2xp|.xp2|2xp.))*[^2\\]]*\\].*";
            }
            if (string != null) {
                this.include.add(Pattern.compile(string));
            }
        }
    }

    protected void configMode() {
        switch (this.mode) {
            case 0: {
                this.rhythm_repunit = new int[this.jugglers][1];
                this.holdthrow = new int[this.jugglers];
                this.person_number = new int[this.jugglers];
                this.hands = this.jugglers;
                this.rhythm_period = 1;
                this.pattern_printx = false;
                for (int i = 0; i < this.hands; ++i) {
                    this.rhythm_repunit[i][0] = async_rhythm_repunit[0][0];
                    this.holdthrow[i] = 2;
                    this.person_number[i] = i + 1;
                }
                break;
            }
            case 1: {
                this.rhythm_repunit = new int[2 * this.jugglers][2];
                this.holdthrow = new int[2 * this.jugglers];
                this.person_number = new int[2 * this.jugglers];
                this.hands = 2 * this.jugglers;
                this.rhythm_period = 2;
                this.pattern_printx = true;
                for (int i = 0; i < this.hands; ++i) {
                    for (int j = 0; j < this.rhythm_period; ++j) {
                        this.rhythm_repunit[i][j] = sync_rhythm_repunit[i % 2][j];
                    }
                    this.holdthrow[i] = 2;
                    this.person_number[i] = i / 2 + 1;
                }
                break;
            }
        }
    }

    protected void allocateWorkspace() {
        this.state = new int[this.l_max + 1][this.hands][this.ground_state_length];
        this.holes = new int[this.hands][this.l_max + this.ht];
        this.throw_to = new int[this.slot_size][this.hands][this.max_occupancy];
        this.throw_value = new int[this.slot_size][this.hands][this.max_occupancy];
        this.rhythm = new int[this.slot_size + 1][this.hands][this.ht];
        for (int i = 0; i < this.slot_size + 1; ++i) {
            for (int j = 0; j < this.hands; ++j) {
                for (int k = 0; k < this.ht; ++k) {
                    this.rhythm[i][j][k] = this.multiplex * this.rhythm_repunit[j][(k + i) % this.rhythm_period];
                }
            }
        }
        if (this.mpflag != 0) {
            this.mp_filter = new int[this.l_max + 1][this.hands][this.slot_size][3];
        }
        this.throws_left = new int[this.l_max][this.hands];
        if (this.jugglers > 1) {
            this.scratch1 = new int[this.hands];
            this.scratch2 = new int[this.hands];
        }
        if (this.connected_patterns) {
            this.connections = new boolean[this.jugglers];
        }
        if (this.jugglers > 1 && !this.juggler_permutations) {
            this.perm_scratch1 = new boolean[this.l_max];
            this.perm_scratch2 = new boolean[this.l_max];
        }
    }

    protected int findPatterns(int n, int n2, int n3) throws JuggleExceptionUser, JuggleExceptionInternal {
        int n4;
        int n5;
        if (Thread.interrupted()) {
            throw new JuggleExceptionInterrupted();
        }
        if (n == this.n || this.groundflag == 1) {
            int n6;
            int n7;
            int n8;
            if (this.groundflag == 1) {
                for (n8 = 0; n8 < this.hands; ++n8) {
                    for (n7 = 0; n7 < this.ht; ++n7) {
                        this.state[0][n8][n7] = this.ground_state[n8][n7];
                    }
                }
            } else if (this.groundflag == 2 && this.compareStates(this.state[0], this.ground_state) == 0) {
                return 0;
            }
            for (n8 = 0; n8 < this.hands; ++n8) {
                for (n7 = 0; n7 < this.ht; ++n7) {
                    n6 = this.state[0][n8][n7];
                    if (this.mpflag != 0 && n6 == 0) {
                        this.mp_filter[0][n8][n7][0] = 0;
                        continue;
                    }
                    if (this.mpflag != 0) {
                        this.mp_filter[0][n8][n7][2] = n7 + 1;
                        this.mp_filter[0][n8][n7][1] = n8;
                        this.mp_filter[0][n8][n7][0] = 2;
                    }
                    int n9 = n7;
                    int n10 = 0;
                    while ((n9 += this.l_target) < this.ht) {
                        n10 = this.state[0][n8][n9];
                        if (n10 > n6) {
                            return 0;
                        }
                        if (this.mpflag == 0 || n10 == 0) continue;
                        if (n10 < n6 && n7 > this.holdthrow[n8]) {
                            return 0;
                        }
                        this.mp_filter[0][n8][n7][2] = n9 + 1;
                    }
                }
                if (this.mpflag == 0) continue;
                while (n7 < this.slot_size) {
                    this.mp_filter[0][n8][n7][0] = 0;
                    ++n7;
                }
            }
            if (this.numflag != 2 && this.sequenceflag) {
                this.findStartEnd();
            }
            for (n8 = 0; n8 < this.hands; ++n8) {
                for (n7 = 0; n7 < this.l_target + this.ht; ++n7) {
                    n6 = n7 < this.l_target ? this.multiplex * this.rhythm_repunit[n8][n7 % this.rhythm_period] : this.state[0][n8][n7 - this.l_target];
                    if (n7 < this.ht) {
                        n6 -= this.state[0][n8][n7];
                    }
                    this.holes[n8][n7] = n6;
                }
            }
            this.startBeat(0);
            return this.findCycles(0, 1, 0, 0);
        }
        if (n == 0) {
            for (n5 = 0; n5 < this.hands; ++n5) {
                for (n4 = 0; n4 < this.ht; ++n4) {
                    this.state[0][n5][n4] = 0;
                }
            }
        }
        n5 = 0;
        n4 = n3;
        for (int i = n2; i < this.ht; ++i) {
            while (n4 < this.hands) {
                if (this.state[0][n4][i] < this.rhythm[0][n4][i]) {
                    int[] nArray = this.state[0][n4];
                    int n11 = i;
                    nArray[n11] = nArray[n11] + 1;
                    if (i < this.l_target || this.state[0][n4][i] <= this.state[0][n4][i - this.l_target]) {
                        n5 += this.findPatterns(n + 1, i, n4);
                    }
                    int[] nArray2 = this.state[0][n4];
                    int n12 = i;
                    nArray2[n12] = nArray2[n12] - 1;
                }
                ++n4;
            }
            n4 = 0;
        }
        return n5;
    }

    protected int findCycles(int n, int n2, int n3, int n4) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (Thread.interrupted()) {
            throw new JuggleExceptionInterrupted();
        }
        if (this.max_time > 0.0 && this.loop_counter++ > 20000) {
            this.loop_counter = 0;
            if (System.currentTimeMillis() - this.start_time_millis > this.max_time_millis) {
                String string = guistrings.getString("Generator_timeout");
                Object[] objectArray = new Object[]{new Integer((int)this.max_time)};
                throw new JuggleExceptionDone(MessageFormat.format(string, objectArray));
            }
        }
        int n5 = 0;
        while (this.throws_left[n][n5] == 0) {
            if (++n5 < this.hands) continue;
            int n6 = this.outputBeat(n, this.output, n4);
            if (!this.areThrowsValid(n, n6)) {
                return 0;
            }
            if (this.mpflag != 0 && !this.isMultiplexingValid(n)) {
                return 0;
            }
            this.calculateState(n + 1);
            if (!this.isStateValid(n + 1)) {
                return 0;
            }
            if (++n < this.l_target) {
                this.startBeat(n);
                return this.findCycles(n, 1, 0, n6);
            }
            if (this.compareStates(this.state[0], this.state[this.l_target]) == 0 && this.isPatternValid(n6)) {
                if (this.numflag != 2) {
                    this.outputPattern(n6);
                }
                return 1;
            }
            return 0;
        }
        int[] nArray = this.throws_left[n];
        int n7 = n5;
        nArray[n7] = nArray[n7] - 1;
        int n8 = this.throws_left[n][n5];
        int n9 = n3;
        int n10 = 0;
        for (int i = n2; i <= this.ht; ++i) {
            int n11 = n + i;
            while (n9 < this.hands) {
                if (this.holes[n9][n11] != 0) {
                    int[] nArray2 = this.holes[n9];
                    int n12 = n11;
                    nArray2[n12] = nArray2[n12] - 1;
                    this.throw_to[n][n5][n8] = n9;
                    this.throw_value[n][n5][n8] = i;
                    n10 = n8 != 0 ? (n10 += this.findCycles(n, i, n9, n4)) : (n10 += this.findCycles(n, 1, 0, n4));
                    int[] nArray3 = this.holes[n9];
                    int n13 = n11;
                    nArray3[n13] = nArray3[n13] + 1;
                    if (this.max_num >= 0 && n10 >= this.max_num) {
                        String string = guistrings.getString("Generator_spacelimit");
                        Object[] objectArray = new Object[]{new Integer(this.max_num)};
                        throw new JuggleExceptionDone(MessageFormat.format(string, objectArray));
                    }
                }
                ++n9;
            }
            n9 = 0;
        }
        int[] nArray4 = this.throws_left[n];
        int n14 = n5;
        nArray4[n14] = nArray4[n14] + 1;
        return n10;
    }

    protected void calculateState(int n) {
        int n2;
        int n3;
        if (n == 0) {
            return;
        }
        for (n3 = 0; n3 < this.hands; ++n3) {
            for (n2 = 0; n2 < this.ht - 1; ++n2) {
                this.state[n][n3][n2] = this.state[n - 1][n3][n2 + 1];
            }
            this.state[n][n3][this.ht - 1] = 0;
        }
        for (n3 = 0; n3 < this.hands; ++n3) {
            int n4;
            for (n2 = 0; n2 < this.max_occupancy && (n4 = this.throw_value[n - 1][n3][n2]) != 0; ++n2) {
                int[] nArray = this.state[n][this.throw_to[n - 1][n3][n2]];
                int n5 = n4 - 1;
                nArray[n5] = nArray[n5] + 1;
            }
        }
    }

    protected boolean isStateValid(int n) {
        int n2;
        if (this.ht > this.l_target) {
            for (n2 = 0; n2 < this.hands; ++n2) {
                for (int i = 0; i < this.l_target; ++i) {
                    for (int j = i; j < this.ht - this.l_target; j += this.l_target) {
                        if (this.state[n][n2][j + this.l_target] <= this.state[n][n2][j]) continue;
                        return false;
                    }
                }
            }
        }
        if (n % this.rhythm_period == 0) {
            n2 = this.compareStates(this.state[0], this.state[n]);
            if (this.fullflag != 0 && n != this.l_target && n2 == 0) {
                return false;
            }
            if (this.rotflag == 0 && n2 == 1) {
                return false;
            }
        }
        if (this.fullflag == 2) {
            for (n2 = 1; n2 < n; ++n2) {
                if ((n - n2) % this.rhythm_period != 0 || this.compareStates(this.state[n2], this.state[n]) != 0) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isMultiplexingValid(int n) {
        int n2;
        int n3;
        for (n3 = 0; n3 < this.hands; ++n3) {
            for (n2 = 0; n2 < this.slot_size - 1; ++n2) {
                this.mp_filter[n + 1][n3][n2][0] = this.mp_filter[n][n3][n2 + 1][0];
                this.mp_filter[n + 1][n3][n2][1] = this.mp_filter[n][n3][n2 + 1][1];
                this.mp_filter[n + 1][n3][n2][2] = this.mp_filter[n][n3][n2 + 1][2];
            }
            this.mp_filter[n + 1][n3][this.slot_size - 1][0] = 0;
            if (this.addThrowMPFilter(this.mp_filter[n + 1][n3][this.l_target - 1], n3, this.mp_filter[n][n3][0][0], this.mp_filter[n][n3][0][2], this.mp_filter[n][n3][0][1]) == 0) continue;
            return false;
        }
        for (n3 = 0; n3 < this.hands; ++n3) {
            int n4;
            for (n2 = 0; n2 < this.max_occupancy && (n4 = this.throw_value[n][n3][n2]) != 0; ++n2) {
                if (this.addThrowMPFilter(this.mp_filter[n + 1][this.throw_to[n][n3][n2]][n4 - 1], this.throw_to[n][n3][n2], 1, n4, n3) == 0) continue;
                return false;
            }
        }
        return true;
    }

    protected void startBeat(int n) {
        for (int i = 0; i < this.hands; ++i) {
            this.throws_left[n][i] = this.state[n][i][0];
            for (int j = 0; j < this.max_occupancy; ++j) {
                this.throw_to[n][i][j] = i;
                this.throw_value[n][i][j] = 0;
            }
        }
    }

    protected boolean areThrowsValid(int n, int n2) {
        int n3;
        for (Pattern pattern : this.exclude) {
            if (!pattern.matcher(new String(this.output, 0, n2)).matches()) continue;
            return false;
        }
        if (!this.mp_clustered) {
            for (int i = 0; i < this.hands; ++i) {
                if (this.rhythm[n][i][0] == 0) continue;
                for (int j = 0; j < this.max_occupancy && this.throw_value[n][i][j] != 0; ++j) {
                    for (n3 = 0; n3 < j; ++n3) {
                        if (this.throw_value[n][i][j] != this.throw_value[n][i][n3] || this.throw_to[n][i][j] != this.throw_to[n][i][n3]) continue;
                        return false;
                    }
                }
            }
        }
        if (this.jugglers > 1 && n < this.delaytime) {
            int n4;
            int n5;
            int n6 = 0;
            for (n5 = 0; n5 < this.hands; ++n5) {
                if (this.rhythm[n][n5][0] == 0) continue;
                ++n6;
                if (this.state[n][n5][0] == 1 || this.person_number[n5] == this.leader_person) continue;
                return false;
            }
            n5 = this.n;
            for (n3 = 0; n3 < this.ht && n5 != 0; ++n3) {
                for (n4 = 0; n4 < this.hands && n5 != 0; ++n4) {
                    if (this.rhythm[n + 1][n4][n3] == 0 || --n5 >= n6) continue;
                    this.scratch1[n5] = n4;
                    this.scratch2[n5] = n3 + 1;
                }
            }
            if (n5 != 0) {
                return false;
            }
            for (n3 = 0; n3 < this.hands; ++n3) {
                if (this.state[n][n3][0] == 0 || this.person_number[n3] == this.leader_person) continue;
                n4 = 0;
                for (int i = 0; i < n6; ++i) {
                    if (this.scratch1[i] != this.throw_to[n][n3][0] || this.scratch2[i] != this.throw_value[n][n3][0]) continue;
                    this.scratch2[i] = 0;
                    n4 = 1;
                    break;
                }
                if (n4 != 0) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isPatternValid(int n) {
        int n2;
        int n3;
        int n4;
        for (Pattern pattern : this.include) {
            if (pattern.matcher(new String(this.output, 0, n)).matches()) continue;
            return false;
        }
        if (this.mode == 0 && this.lameflag && this.max_occupancy == 1) {
            for (int i = 0; i < this.l_target - 1; ++i) {
                for (int j = 0; j < this.hands; ++j) {
                    if (this.throw_value[i][j][0] != 1 || this.person_number[this.throw_to[i][j][0]] != this.person_number[j] || this.throw_value[i + 1][j][0] != 1 || this.person_number[this.throw_to[i + 1][j][0]] != this.person_number[j]) continue;
                    return false;
                }
            }
        }
        if (this.fullflag == 0 && this.rotflag == 0) {
            for (int i = 1; i < this.l_target; ++i) {
                if (i % this.rhythm_period != 0 || this.compareStates(this.state[0], this.state[i]) != 0 || this.compareRotations(0, i) >= 0) continue;
                return false;
            }
        }
        if (this.connected_patterns) {
            int n5;
            for (n5 = 0; n5 < this.jugglers; ++n5) {
                this.connections[n5] = false;
            }
            this.connections[0] = true;
            n5 = 1;
            while (n5 != 0) {
                n5 = 0;
                for (int i = 0; i < this.l_target; ++i) {
                    for (n4 = 0; n4 < this.hands; ++n4) {
                        if (this.connections[this.person_number[n4] - 1]) continue;
                        for (n3 = 0; n3 < this.max_occupancy && this.throw_value[i][n4][n3] > 0; ++n3) {
                            n2 = this.person_number[this.throw_to[i][n4][n3]];
                            if (!this.connections[n2 - 1]) continue;
                            this.connections[this.person_number[n4] - 1] = true;
                            n5 = 1;
                        }
                    }
                }
            }
            for (int i = 0; i < this.jugglers; ++i) {
                if (this.connections[i]) continue;
                return false;
            }
        }
        if (this.jugglers > 1 && !this.juggler_permutations) {
            block10: for (int i = 1; i <= this.jugglers - 1; ++i) {
                int n6;
                for (n6 = 0; n6 < this.l_target; ++n6) {
                    this.perm_scratch2[n6] = false;
                    this.perm_scratch1[n6] = false;
                }
                for (n6 = 0; n6 < this.l_target; ++n6) {
                    n4 = -1;
                    n3 = -1;
                    n2 = 0;
                    int n7 = 0;
                    for (int j = 0; j < this.l_target; ++j) {
                        int n8;
                        int n9;
                        int n10;
                        if (!this.perm_scratch1[j]) {
                            n10 = 0;
                            for (n9 = 0; n9 < this.hands; ++n9) {
                                if (this.person_number[n9] != i) continue;
                                for (n8 = 0; n8 < this.max_occupancy && this.throw_value[j][n9][n8] > 0; ++n8) {
                                    n10 += 4 * this.throw_value[j][n9][n8] * (2 * this.max_occupancy) * (2 * this.max_occupancy);
                                    if (this.throw_to[j][n9][n8] == n9) continue;
                                    n10 += 2 * (2 * this.max_occupancy);
                                    if (this.person_number[this.throw_to[j][n9][n8]] == i) continue;
                                    ++n10;
                                }
                            }
                            if (n10 > n4) {
                                n4 = n10;
                                n2 = j;
                            }
                        }
                        if (this.perm_scratch2[j]) continue;
                        n10 = 0;
                        for (n9 = 0; n9 < this.hands; ++n9) {
                            if (this.person_number[n9] != i + 1) continue;
                            for (n8 = 0; n8 < this.max_occupancy && this.throw_value[j][n9][n8] > 0; ++n8) {
                                n10 += 4 * this.throw_value[j][n9][n8] * (2 * this.max_occupancy) * (2 * this.max_occupancy);
                                if (this.throw_to[j][n9][n8] == n9) continue;
                                n10 += 2 * (2 * this.max_occupancy);
                                if (this.person_number[this.throw_to[j][n9][n8]] == i + 1) continue;
                                ++n10;
                            }
                        }
                        if (n10 <= n3) continue;
                        n3 = n10;
                        n7 = j;
                    }
                    if (n3 > n4) {
                        return false;
                    }
                    if (n3 < n4) continue block10;
                    this.perm_scratch2[n7] = true;
                    this.perm_scratch1[n2] = true;
                }
            }
        }
        return true;
    }

    protected int compareRotations(int n, int n2) {
        int n3 = 0;
        while (n3 < this.l_target) {
            int n4 = this.compareLoops((n + n3) % this.l_target, (n2 + n3) % this.l_target);
            if (n4 > 0) {
                return 1;
            }
            if (n4 < 0) {
                return -1;
            }
            ++n3;
            while (n3 < this.l_target && this.compareStates(this.state[n], this.state[(n + n3) % this.l_target]) != 0) {
                ++n3;
            }
        }
        return 0;
    }

    protected int compareLoops(int n, int n2) {
        int[][] nArray = this.state[n];
        int n3 = 0;
        int n4 = 0;
        while (true) {
            ++n4;
            if (n3 == 0) {
                n3 = this.compareThrows(n, n2);
            }
            if (n4 % this.rhythm_period == 0) {
                int n5 = this.compareStates(this.state[n + 1], nArray);
                int n6 = this.compareStates(this.state[n2 + 1], nArray);
                if (n5 == 0) {
                    if (n6 == 0) {
                        return n3;
                    }
                    return -1;
                }
                if (n6 == 0) {
                    return 1;
                }
            }
            ++n;
            ++n2;
        }
    }

    protected int compareThrows(int n, int n2) {
        int[][] nArray = this.throw_value[n];
        int[][] nArray2 = this.throw_to[n];
        int[][] nArray3 = this.throw_value[n2];
        int[][] nArray4 = this.throw_to[n2];
        int[][] nArray5 = this.rhythm[n];
        for (int i = 0; i < this.hands; ++i) {
            for (int j = 0; j < nArray5[i][0]; ++j) {
                if (nArray[i][j] > nArray3[i][j]) {
                    return 1;
                }
                if (nArray[i][j] < nArray3[i][j]) {
                    return -1;
                }
                if (nArray2[i][j] > nArray4[i][j]) {
                    return 1;
                }
                if (nArray2[i][j] >= nArray4[i][j]) continue;
                return -1;
            }
        }
        return 0;
    }

    protected int compareStates(int[][] nArray, int[][] nArray2) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.hands; ++n2) {
            for (n = 0; n < this.ht; ++n) {
                if (nArray[n2][n] > n3) {
                    n3 = nArray[n2][n];
                }
                if (nArray2[n2][n] <= n4) continue;
                n4 = nArray2[n2][n];
            }
        }
        if (n3 > n4) {
            return 1;
        }
        if (n3 < n4) {
            return -1;
        }
        for (n2 = this.ht - 1; n2 >= 0; --n2) {
            for (n = this.hands - 1; n >= 0; --n) {
                n3 = nArray[n][n2];
                n4 = nArray2[n][n2];
                if (n3 > n4) {
                    return 1;
                }
                if (n3 >= n4) continue;
                return -1;
            }
        }
        return 0;
    }

    protected static char convertNumber(int n) {
        return Character.toLowerCase(Character.forDigit(n, 36));
    }

    protected int outputBeat(int n, char[] cArray, int n2) {
        int n3;
        boolean bl = true;
        for (n3 = 0; n3 < this.rhythm[n].length; ++n3) {
            if (this.rhythm[n][n3][0] == 0) continue;
            bl = false;
            break;
        }
        if (bl) {
            return n2;
        }
        int n4 = n3 = n2 > 0 ? 1 : 0;
        if (this.jugglers > 1) {
            cArray[n2++] = 60;
            n3 = 0;
        }
        for (int i = 1; i <= this.jugglers; ++i) {
            int n5;
            int n6;
            int n7 = 0;
            while (this.person_number[n7] != i) {
                ++n7;
            }
            for (n6 = n7; n6 < this.hands && this.person_number[n6] == i; ++n6) {
            }
            int n8 = 0;
            for (n5 = n7; n5 < n6; ++n5) {
                if (this.rhythm[n][n5][0] == 0) continue;
                ++n8;
            }
            if (n8 > 0) {
                n5 = 0;
                if (n8 > 1) {
                    cArray[n2++] = 40;
                    n3 = 0;
                    n5 = 1;
                }
                for (int j = n7; j < n6; ++j) {
                    if (this.rhythm[n][j][0] == 0) continue;
                    boolean bl2 = false;
                    if (this.max_occupancy > 1 && this.throw_value[n][j][1] > 0) {
                        cArray[n2++] = 91;
                        n3 = 0;
                        bl2 = true;
                    }
                    boolean bl3 = false;
                    for (int k = 0; k < this.max_occupancy && this.throw_value[n][j][k] > 0; ++k) {
                        bl3 = true;
                        if (this.throw_value[n][j][k] == 33 && n3 != 0) {
                            cArray[n2++] = 32;
                        }
                        cArray[n2++] = SiteswapGenerator.convertNumber(this.throw_value[n][j][k]);
                        n3 = 1;
                        if (this.hands > 1) {
                            int n9 = this.person_number[this.throw_to[n][j][k]];
                            if (this.pattern_printx) {
                                int n10 = this.throw_to[n][j][k] - 1;
                                int n11 = 0;
                                while (n10 >= 0 && this.person_number[n10] == n9) {
                                    --n10;
                                    ++n11;
                                }
                                if (n11 != j - n7) {
                                    cArray[n2++] = 120;
                                }
                            }
                            if (n9 != i) {
                                cArray[n2++] = 112;
                                if (this.jugglers > 2) {
                                    cArray[n2++] = SiteswapGenerator.convertNumber(n9);
                                }
                            }
                        }
                        if (!bl2 || this.jugglers <= 1 || k == this.max_occupancy - 1 || this.throw_value[n][j][k + 1] <= 0) continue;
                        cArray[n2++] = 47;
                        n3 = 0;
                    }
                    if (!bl3) {
                        cArray[n2++] = 48;
                        n3 = 1;
                    }
                    if (bl2) {
                        cArray[n2++] = 93;
                        n3 = 0;
                    }
                    if (j >= n6 - 1 || n5 == 0) continue;
                    cArray[n2++] = 44;
                    n3 = 0;
                }
                if (n5 != 0) {
                    cArray[n2++] = 41;
                    n3 = 0;
                }
            }
            if (i >= this.jugglers) continue;
            cArray[n2++] = 124;
            n3 = 0;
        }
        if (this.jugglers > 1) {
            cArray[n2++] = 62;
        }
        return n2;
    }

    protected void outputPattern(int n) throws JuggleExceptionInternal {
        int n2;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(this.hands * (2 * this.ground_state_length + this.l_target) * 50 + 10);
        StringBuffer stringBuffer2 = new StringBuffer(this.hands * (2 * this.ground_state_length + this.l_target) * 50 + 10);
        if (this.groundflag != 1) {
            if (this.sequenceflag) {
                if (this.mode == 0) {
                    for (n2 = this.n - this.starting_seq_length; n2 > 0; --n2) {
                        stringBuffer.append(" ");
                    }
                }
                stringBuffer.append(this.starting_seq, 0, this.starting_seq_length);
                stringBuffer.append("  ");
            } else {
                boolean bl2 = bl = this.compareStates(this.ground_state, this.state[0]) != 0;
                if (bl) {
                    stringBuffer.append("* ");
                } else {
                    stringBuffer.append("  ");
                }
            }
        }
        stringBuffer.append(this.output, 0, n);
        stringBuffer2.append(this.output, 0, n);
        if (this.groundflag != 1) {
            if (this.sequenceflag) {
                stringBuffer.append("  ");
                stringBuffer.append(this.ending_seq, 0, this.ending_seq_length);
                if (this.mode == 0) {
                    for (n2 = this.n - this.ending_seq_length; n2 > 0; --n2) {
                        stringBuffer.append(" ");
                    }
                }
            } else if (bl) {
                stringBuffer.append(" *");
            } else {
                stringBuffer.append("  ");
            }
        }
        this.target.writePattern(stringBuffer.toString(), "siteswap", stringBuffer2.toString().trim());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int addThrowMPFilter(int[] nArray, int n, int n2, int n3, int n4) {
        switch (n2) {
            case 0: {
                return 0;
            }
            case 2: {
                if (nArray[0] != 0) return 0;
                nArray[0] = 2;
                nArray[2] = n3;
                nArray[1] = n4;
                return 0;
            }
            case 1: {
                if (n4 == n && n3 == this.holdthrow[n]) {
                    return 0;
                }
                switch (nArray[0]) {
                    case 0: {
                        nArray[0] = 1;
                        nArray[2] = n3;
                        nArray[1] = n4;
                        return 0;
                    }
                    case 2: {
                        if (nArray[2] > n3 && nArray[2] > this.holdthrow[n]) return 1;
                        nArray[0] = 1;
                        nArray[2] = n3;
                        nArray[1] = n4;
                        return 0;
                    }
                    case 1: {
                        if (nArray[1] != n4 || nArray[2] != n3) return 1;
                        return 0;
                    }
                }
                return 1;
            }
        }
        return 1;
    }

    protected void findStartEnd() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        while (true) {
            block1: for (n4 = 0; n4 < this.hands; ++n4) {
                for (n3 = 0; n3 < this.ht; ++n3) {
                    this.state[1][n4][n3] = n3 + n5 < this.ground_state_length ? this.ground_state[n4][n3 + n5] : 0;
                    if (this.state[1][n4][n3] > this.state[0][n4][n3]) {
                        n5 += this.rhythm_period;
                        continue block1;
                    }
                    this.state[1][n4][n3] = this.state[0][n4][n3] - this.state[1][n4][n3];
                }
            }
            break;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            block4: for (n3 = 0; n3 < this.hands; ++n3) {
                for (n2 = 0; n2 < this.max_occupancy; ++n2) {
                    this.throw_value[n4][n3][n2] = 0;
                    this.throw_to[n4][n3][n2] = n3;
                }
                if (n4 >= this.ground_state_length || this.ground_state[n3][n4] == 0) continue;
                for (n2 = 0; n2 < this.ht; ++n2) {
                    for (n = 0; n < this.hands; ++n) {
                        if (this.state[1][n][n2] <= 0) continue;
                        int[] nArray = this.state[1][n];
                        int n6 = n2;
                        nArray[n6] = nArray[n6] - 1;
                        this.throw_value[n4][n3][0] = n2 + n5 - n4;
                        this.throw_to[n4][n3][0] = n;
                        continue block4;
                    }
                }
            }
        }
        this.starting_seq = new char[this.hands * n5 * 50];
        this.starting_seq_length = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            this.starting_seq_length = this.outputBeat(n4, this.starting_seq, this.starting_seq_length);
        }
        n4 = 0;
        while (true) {
            block10: for (n3 = 0; n3 < this.hands; ++n3) {
                for (n2 = 0; n2 < this.ground_state_length; ++n2) {
                    this.state[1][n3][n2] = n2 + n4 < this.ht ? this.state[0][n3][n2 + n4] : 0;
                    if (this.state[1][n3][n2] > this.ground_state[n3][n2]) {
                        n4 += this.rhythm_period;
                        continue block10;
                    }
                    this.state[1][n3][n2] = this.ground_state[n3][n2] - this.state[1][n3][n2];
                }
            }
            break;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < this.hands; ++n2) {
                for (n = 0; n < this.max_occupancy; ++n) {
                    this.throw_value[n3][n2][n] = 0;
                    this.throw_to[n3][n2][n] = n2;
                }
                if (n3 >= this.ht) continue;
                block15: for (n = 0; n < this.state[0][n2][n3]; ++n) {
                    for (int i = 0; i < this.ground_state_length; ++i) {
                        for (int j = 0; j < this.hands; ++j) {
                            if (this.state[1][j][i] <= 0) continue;
                            int[] nArray = this.state[1][j];
                            int n7 = i;
                            nArray[n7] = nArray[n7] - 1;
                            this.throw_value[n3][n2][n] = i + n4 - n3;
                            this.throw_to[n3][n2][n] = j;
                            continue block15;
                        }
                    }
                }
            }
        }
        this.ending_seq = new char[this.hands * n4 * 50];
        this.ending_seq_length = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            this.ending_seq_length = this.outputBeat(n3, this.ending_seq, this.ending_seq_length);
        }
    }

    protected void findGround() {
        int n;
        int n2 = this.n;
        int n3 = 0;
        while (n2 != 0) {
            for (n = 0; n < this.hands && n2 != 0; ++n) {
                if (this.rhythm_repunit[n][n3 % this.rhythm_period] == 0 || --n2 != 0) continue;
                this.ground_state_length = n3 + 1;
            }
            ++n3;
        }
        if (this.ground_state_length < this.ht) {
            this.ground_state_length = this.ht;
        }
        this.ground_state = new int[this.hands][this.ground_state_length];
        for (n3 = 0; n3 < this.hands; ++n3) {
            for (n = 0; n < this.ground_state_length; ++n) {
                this.ground_state[n3][n] = 0;
            }
        }
        n2 = this.n;
        n3 = 0;
        while (n2 != 0) {
            for (n = 0; n < this.hands && n2 != 0; ++n) {
                if (this.rhythm_repunit[n][n3 % this.rhythm_period] == 0) continue;
                this.ground_state[n][n3] = 1;
                --n2;
            }
            ++n3;
        }
    }

    protected void printState(int[][] nArray) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.ground_state_length; ++n2) {
            for (n = 0; n < this.hands; ++n) {
                if (nArray[n][n2] == 0) continue;
                n3 = n2;
            }
        }
        for (n2 = 0; n2 <= n3; ++n2) {
            for (n = 0; n < this.hands; ++n) {
                System.out.println("  s[" + n + "][" + n2 + "] = " + nArray[n][n2]);
            }
        }
    }

    protected static String makeStandardRegex(String string) {
        String string2 = Pattern.compile("\\\\\\[").matcher(string).replaceAll("@");
        string2 = Pattern.compile("\\[").matcher(string2).replaceAll("\\\\[");
        string2 = Pattern.compile("@").matcher(string2).replaceAll("[");
        string2 = Pattern.compile("\\\\\\]").matcher(string2).replaceAll("@");
        string2 = Pattern.compile("\\]").matcher(string2).replaceAll("\\\\]");
        string2 = Pattern.compile("@").matcher(string2).replaceAll("]");
        string2 = Pattern.compile("\\\\\\(").matcher(string2).replaceAll("@");
        string2 = Pattern.compile("\\(").matcher(string2).replaceAll("\\\\(");
        string2 = Pattern.compile("@").matcher(string2).replaceAll("(");
        string2 = Pattern.compile("\\\\\\)").matcher(string2).replaceAll("@");
        string2 = Pattern.compile("\\)").matcher(string2).replaceAll("\\\\)");
        string2 = Pattern.compile("@").matcher(string2).replaceAll(")");
        string2 = Pattern.compile("\\\\\\|").matcher(string2).replaceAll("@");
        string2 = Pattern.compile("\\|").matcher(string2).replaceAll("\\\\|");
        string2 = Pattern.compile("@").matcher(string2).replaceAll("|");
        return string2;
    }

    public static void runGeneratorCLI(String[] stringArray, GeneratorTarget generatorTarget) {
        if (stringArray.length < 3) {
            String string = guistrings.getString("Version");
            Object[] objectArray = new Object[]{"1.4.1"};
            String string2 = "Juggling Lab " + MessageFormat.format(string, objectArray).toLowerCase() + "\n";
            string = guistrings.getString("Copyright_message");
            Object[] objectArray2 = new Object[]{"2021"};
            string2 = string2 + MessageFormat.format(string, objectArray2) + "\n\n";
            string2 = string2 + guistrings.getString("GPL_message") + "\n\n";
            string2 = string2 + guistrings.getString("Generator_intro");
            System.out.println(string2);
            return;
        }
        if (generatorTarget == null) {
            return;
        }
        try {
            SiteswapGenerator siteswapGenerator = new SiteswapGenerator();
            siteswapGenerator.initGenerator(stringArray);
            siteswapGenerator.runGenerator(generatorTarget);
        }
        catch (Exception exception) {
            System.out.println(errorstrings.getString("Error") + ": " + exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        SiteswapGenerator.runGeneratorCLI(stringArray, new GeneratorTarget(System.out));
    }
}

